/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.execution.warnings.WarningCollector;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.assertions.PlanAssert;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import java.util.Map;
import org.testng.annotations.Test;

public class TestStatsCalculator {
    private final LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)TestingSession.testSessionBuilder().setCatalog("local").setSchema("tiny").setSystemProperty("task_concurrency", "1").build());

    public TestStatsCalculator() {
        this.queryRunner.createCatalog((String)this.queryRunner.getDefaultSession().getCatalog().get(), (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
    }

    @Test
    public void testStatsCalculatorUsesLayout() {
        this.assertPlan("SELECT orderstatus FROM orders WHERE orderstatus = 'P'", PlanMatchPattern.anyTree(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]).withOutputRowCount(363.0)));
        this.assertPlan("SELECT orderstatus FROM orders WHERE orderkey = 42", PlanMatchPattern.anyTree(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]).withOutputRowCount(15000.0)));
    }

    private void assertPlan(String sql, PlanMatchPattern pattern) {
        this.assertPlan(sql, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, pattern);
    }

    private void assertPlan(String sql, LogicalPlanner.Stage stage, PlanMatchPattern pattern) {
        this.queryRunner.inTransaction(transactionSession -> {
            Plan actualPlan = this.queryRunner.createPlan(transactionSession, sql, stage, WarningCollector.NOOP);
            PlanAssert.assertPlan(transactionSession, this.queryRunner.getMetadata(), this.queryRunner.getFunctionManager(), this.queryRunner.getStatsCalculator(), actualPlan, pattern);
            return null;
        });
    }
}

