/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.execution.ManagedQueryExecution;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryState;
import io.trino.execution.QueryStats;
import io.trino.execution.StateMachine;
import io.trino.operator.RetryPolicy;
import io.trino.server.BasicQueryInfo;
import io.trino.server.BasicQueryStats;
import io.trino.server.DynamicFilterService;
import io.trino.spi.ErrorCode;
import io.trino.spi.QueryId;
import io.trino.testing.TestingSession;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;

public class MockManagedQueryExecution
implements ManagedQueryExecution {
    private final List<StateMachine.StateChangeListener<QueryState>> listeners = new ArrayList<StateMachine.StateChangeListener<QueryState>>();
    private final Session session;
    private DataSize memoryUsage;
    private Duration cpuUsage;
    private QueryState state = QueryState.QUEUED;
    private Throwable failureCause;

    private MockManagedQueryExecution(String queryId, int priority, DataSize memoryUsage, Duration cpuUsage) {
        Objects.requireNonNull(queryId, "queryId is null");
        this.session = TestingSession.testSessionBuilder().setQueryId(QueryId.valueOf((String)queryId)).setSystemProperty("query_priority", String.valueOf(priority)).build();
        this.memoryUsage = Objects.requireNonNull(memoryUsage, "memoryUsage is null");
        this.cpuUsage = Objects.requireNonNull(cpuUsage, "cpuUsage is null");
    }

    public void consumeCpuTimeMillis(long cpuTimeDeltaMillis) {
        Preconditions.checkState((this.state == QueryState.RUNNING ? 1 : 0) != 0, (Object)"cannot consume CPU in a non-running state");
        long newCpuTime = this.cpuUsage.toMillis() + cpuTimeDeltaMillis;
        this.cpuUsage = new Duration((double)newCpuTime, TimeUnit.MILLISECONDS);
    }

    public void setMemoryUsage(DataSize memoryUsage) {
        Preconditions.checkState((this.state == QueryState.RUNNING ? 1 : 0) != 0, (Object)"cannot set memory usage in a non-running state");
        this.memoryUsage = memoryUsage;
    }

    public void complete() {
        this.memoryUsage = DataSize.ofBytes((long)0L);
        this.state = QueryState.FINISHED;
        this.fireStateChange();
    }

    public Throwable getThrowable() {
        return this.failureCause;
    }

    public Session getSession() {
        return this.session;
    }

    public Optional<ErrorCode> getErrorCode() {
        return Optional.empty();
    }

    public BasicQueryInfo getBasicQueryInfo() {
        return new BasicQueryInfo(new QueryId("test"), this.session.toSessionRepresentation(), Optional.empty(), this.state, !this.state.isDone(), URI.create("http://test"), "SELECT 1", Optional.empty(), Optional.empty(), new BasicQueryStats(new DateTime(1L), new DateTime(2L), new Duration(3.0, TimeUnit.NANOSECONDS), new Duration(4.0, TimeUnit.NANOSECONDS), new Duration(5.0, TimeUnit.NANOSECONDS), 99, 6, 7, 8, 9, DataSize.ofBytes((long)14L), 15L, DataSize.ofBytes((long)13L), 16.0, 17.0, this.memoryUsage, this.memoryUsage, DataSize.ofBytes((long)19L), DataSize.ofBytes((long)20L), this.cpuUsage, new Duration(21.0, TimeUnit.NANOSECONDS), new Duration(22.0, TimeUnit.NANOSECONDS), new Duration(23.0, TimeUnit.NANOSECONDS), false, (Set)ImmutableSet.of(), OptionalDouble.empty()), null, null, Optional.empty(), RetryPolicy.NONE);
    }

    public QueryInfo getFullQueryInfo() {
        return new QueryInfo(new QueryId("test"), this.session.toSessionRepresentation(), this.state, URI.create("http://test"), (List)ImmutableList.of(), "SELECT 1", Optional.empty(), new QueryStats(new DateTime(1L), new DateTime(2L), new DateTime(3L), new DateTime(4L), new Duration(6.0, TimeUnit.NANOSECONDS), new Duration(5.0, TimeUnit.NANOSECONDS), new Duration(31.0, TimeUnit.NANOSECONDS), new Duration(41.0, TimeUnit.NANOSECONDS), new Duration(7.0, TimeUnit.NANOSECONDS), new Duration(8.0, TimeUnit.NANOSECONDS), new Duration(100.0, TimeUnit.NANOSECONDS), new Duration(200.0, TimeUnit.NANOSECONDS), 9, 10, 11, 0, 12, 13, 15, 30, 16, 17.0, 0.0, DataSize.ofBytes((long)18L), DataSize.ofBytes((long)19L), DataSize.ofBytes((long)20L), DataSize.ofBytes((long)21L), DataSize.ofBytes((long)22L), DataSize.ofBytes((long)23L), DataSize.ofBytes((long)24L), DataSize.ofBytes((long)25L), DataSize.ofBytes((long)26L), !this.state.isDone(), new Duration(20.0, TimeUnit.NANOSECONDS), new Duration(21.0, TimeUnit.NANOSECONDS), new Duration(22.0, TimeUnit.NANOSECONDS), new Duration(0.0, TimeUnit.NANOSECONDS), new Duration(23.0, TimeUnit.NANOSECONDS), false, (Set)ImmutableSet.of(), DataSize.ofBytes((long)241L), DataSize.ofBytes((long)0L), 251L, 0L, new Duration(24.0, TimeUnit.NANOSECONDS), new Duration(0.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)242L), DataSize.ofBytes((long)0L), 252L, 0L, DataSize.ofBytes((long)25L), DataSize.ofBytes((long)0L), 26L, 0L, DataSize.ofBytes((long)27L), DataSize.ofBytes((long)0L), 28L, 0L, new Duration(221.0, TimeUnit.NANOSECONDS), new Duration(222.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)29L), DataSize.ofBytes((long)0L), 30L, 0L, new Duration(223.0, TimeUnit.NANOSECONDS), new Duration(224.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)31L), DataSize.ofBytes((long)0L), (List)ImmutableList.of(), DynamicFilterService.DynamicFiltersStats.EMPTY, (List)ImmutableList.of()), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of(), (Set)ImmutableSet.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Set)ImmutableSet.of(), Optional.empty(), false, "", Optional.empty(), null, null, (List)ImmutableList.of(), (Set)ImmutableSet.of(), Optional.empty(), (List)ImmutableList.of(), (List)ImmutableList.of(), this.state.isDone(), Optional.empty(), Optional.empty(), RetryPolicy.NONE);
    }

    public DataSize getUserMemoryReservation() {
        return this.memoryUsage;
    }

    public DataSize getTotalMemoryReservation() {
        return this.memoryUsage;
    }

    public Duration getTotalCpuTime() {
        return this.cpuUsage;
    }

    public QueryState getState() {
        return this.state;
    }

    public void startWaitingForResources() {
        this.state = QueryState.RUNNING;
        this.fireStateChange();
    }

    public void fail(Throwable cause) {
        this.memoryUsage = DataSize.ofBytes((long)0L);
        this.state = QueryState.FAILED;
        this.failureCause = cause;
        this.fireStateChange();
    }

    public boolean isDone() {
        return this.getState().isDone();
    }

    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.listeners.add(stateChangeListener);
    }

    private void fireStateChange() {
        for (StateMachine.StateChangeListener<QueryState> listener : this.listeners) {
            listener.stateChanged((Object)this.state);
        }
    }

    public static class MockManagedQueryExecutionBuilder {
        private DataSize memoryUsage = DataSize.ofBytes((long)0L);
        private Duration cpuUsage = new Duration(0.0, TimeUnit.MILLISECONDS);
        private int priority = 1;
        private String queryId = "query_id";

        public MockManagedQueryExecutionBuilder withInitialMemoryUsage(DataSize memoryUsage) {
            this.memoryUsage = memoryUsage;
            return this;
        }

        public MockManagedQueryExecutionBuilder withInitialCpuUsageMillis(long cpuUsageMillis) {
            this.cpuUsage = new Duration((double)cpuUsageMillis, TimeUnit.MILLISECONDS);
            return this;
        }

        public MockManagedQueryExecutionBuilder withPriority(int priority) {
            this.priority = priority;
            return this;
        }

        public MockManagedQueryExecutionBuilder withQueryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public MockManagedQueryExecution build() {
            return new MockManagedQueryExecution(this.queryId, this.priority, this.memoryUsage, this.cpuUsage);
        }
    }
}

