/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.Threads;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.connector.CatalogName;
import io.trino.connector.CatalogServiceProvider;
import io.trino.connector.MockConnectorFactory;
import io.trino.eventlistener.EventListenerManager;
import io.trino.execution.CallTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.CatalogProcedures;
import io.trino.metadata.Metadata;
import io.trino.metadata.ProcedureRegistry;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.security.DenyAllAccessControl;
import io.trino.spi.block.MethodHandleUtil;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.security.AccessDeniedException;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.tree.Call;
import io.trino.sql.tree.QualifiedName;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingEventListenerManager;
import io.trino.testing.TestingSession;
import io.trino.transaction.TransactionManager;
import java.lang.invoke.MethodHandle;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestCallTask {
    private ExecutorService executor;
    private static boolean invoked;
    private LocalQueryRunner queryRunner;

    @BeforeClass
    public void init() {
        this.queryRunner = LocalQueryRunner.builder((Session)SessionTestUtils.TEST_SESSION).build();
        this.queryRunner.createCatalog("test", (ConnectorFactory)MockConnectorFactory.create(), (Map)ImmutableMap.of());
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"call-task-test-%s"));
    }

    @AfterClass(alwaysRun=true)
    public void close() {
        if (this.queryRunner != null) {
            this.queryRunner.close();
        }
        this.executor.shutdownNow();
        this.executor = null;
    }

    @BeforeMethod
    public void cleanup() {
        invoked = false;
    }

    @Test
    public void testExecute() {
        this.executeCallTask(MethodHandleUtil.methodHandle(TestCallTask.class, (String)"testingMethod", (Class[])new Class[0]), transactionManager -> new AllowAllAccessControl());
        Assertions.assertThat((boolean)invoked).isTrue();
    }

    @Test
    public void testExecuteNoPermission() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.executeCallTask(MethodHandleUtil.methodHandle(TestCallTask.class, (String)"testingMethod", (Class[])new Class[0]), transactionManager -> new DenyAllAccessControl())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot execute procedure test.test.testing_procedure");
        Assertions.assertThat((boolean)invoked).isFalse();
    }

    @Test
    public void testExecuteNoPermissionOnInsert() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.executeCallTask(MethodHandleUtil.methodHandle(TestingProcedure.class, (String)"testingMethod", (Class[])new Class[]{ConnectorAccessControl.class}), transactionManager -> {
            TestingAccessControlManager accessControl = new TestingAccessControlManager(transactionManager, (EventListenerManager)TestingEventListenerManager.emptyEventListenerManager());
            accessControl.loadSystemAccessControl("allow-all", (Map)ImmutableMap.of());
            accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"testing_table", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.INSERT_TABLE)});
            return accessControl;
        })).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot insert into table test.test.testing_table");
    }

    private void executeCallTask(MethodHandle methodHandle, Function<TransactionManager, AccessControl> accessControlProvider) {
        TransactionManager transactionManager = this.queryRunner.getTransactionManager();
        ProcedureRegistry procedureRegistry = TestCallTask.createProcedureRegistry(new Procedure("test", "testing_procedure", (List)ImmutableList.of(), methodHandle));
        AccessControl accessControl = accessControlProvider.apply(transactionManager);
        PlannerContext plannerContext = TestingPlannerContext.plannerContextBuilder().withTransactionManager(transactionManager).build();
        new CallTask(transactionManager, plannerContext, accessControl, procedureRegistry).execute(new Call(QualifiedName.of((String)"testing_procedure"), (List)ImmutableList.of()), this.stateMachine(transactionManager, plannerContext.getMetadata(), accessControl), (List)ImmutableList.of(), WarningCollector.NOOP);
    }

    private static ProcedureRegistry createProcedureRegistry(Procedure procedure) {
        CatalogName catalogName = new CatalogName("test");
        return new ProcedureRegistry(CatalogServiceProvider.singleton((CatalogName)catalogName, (Object)new CatalogProcedures((Collection)ImmutableList.of((Object)procedure))));
    }

    private QueryStateMachine stateMachine(TransactionManager transactionManager, Metadata metadata, AccessControl accessControl) {
        return QueryStateMachine.begin(Optional.empty(), (String)"CALL testing_procedure()", Optional.empty(), (Session)TestingSession.testSessionBuilder().setCatalog("test").setSchema("test").build(), (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)transactionManager, (AccessControl)accessControl, (Executor)this.executor, (Metadata)metadata, (WarningCollector)WarningCollector.NOOP, Optional.empty());
    }

    public static void testingMethod() {
        invoked = true;
    }

    public static class TestingProcedure {
        public static void testingMethod(ConnectorAccessControl connectorAccessControl) {
            connectorAccessControl.checkCanInsertIntoTable(null, new SchemaTableName("test", "testing_table"));
        }
    }
}

