/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.execution.DynamicFiltersCollector;
import io.trino.spi.predicate.Domain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.plan.DynamicFilterId;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDynamicFiltersCollector {
    @Test
    public void testDynamicFiltersCollector() {
        DynamicFilterId filter = new DynamicFilterId("filter");
        DynamicFiltersCollector collector = new DynamicFiltersCollector(() -> {});
        DynamicFiltersCollector.VersionedDynamicFilterDomains domains = collector.acknowledgeAndGetNewDomains(0L);
        Assert.assertEquals((long)domains.getVersion(), (long)0L);
        Assert.assertEquals((Map)domains.getDynamicFilterDomains(), (Map)ImmutableMap.of());
        Domain initialDomain = Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L));
        collector.updateDomains((Map)ImmutableMap.of((Object)filter, (Object)initialDomain));
        domains = collector.acknowledgeAndGetNewDomains(0L);
        Assert.assertEquals((long)domains.getVersion(), (long)1L);
        Assert.assertEquals((Map)domains.getDynamicFilterDomains(), (Map)ImmutableMap.of((Object)filter, (Object)initialDomain));
        domains = collector.acknowledgeAndGetNewDomains(0L);
        Assert.assertEquals((long)domains.getVersion(), (long)1L);
        Assert.assertEquals((Map)domains.getDynamicFilterDomains(), (Map)ImmutableMap.of((Object)filter, (Object)initialDomain));
        collector.updateDomains((Map)ImmutableMap.of((Object)filter, (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)2L))));
        collector.updateDomains((Map)ImmutableMap.of((Object)filter, (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)3L, (Object)4L))));
        domains = collector.acknowledgeAndGetNewDomains(1L);
        Assert.assertEquals((long)domains.getVersion(), (long)3L);
        Assert.assertEquals((Map)domains.getDynamicFilterDomains(), (Map)ImmutableMap.of((Object)filter, (Object)Domain.none((Type)BigintType.BIGINT)));
        DynamicFilterId filter2 = new DynamicFilterId("filter2");
        collector.updateDomains((Map)ImmutableMap.of((Object)filter2, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)));
        domains = collector.acknowledgeAndGetNewDomains(3L);
        Assert.assertEquals((long)domains.getVersion(), (long)4L);
        Assert.assertEquals((Map)domains.getDynamicFilterDomains(), (Map)ImmutableMap.of((Object)filter2, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)));
    }
}

