/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import io.airlift.concurrent.Threads;
import io.airlift.slice.SizeOf;
import io.airlift.testing.Assertions;
import io.trino.Session;
import io.trino.client.NodeVersion;
import io.trino.connector.CatalogName;
import io.trino.execution.MockRemoteTaskFactory;
import io.trino.execution.NodeTaskMap;
import io.trino.execution.PartitionedSplitsInfo;
import io.trino.execution.RemoteTask;
import io.trino.execution.StageId;
import io.trino.execution.TaskId;
import io.trino.execution.scheduler.NetworkLocation;
import io.trino.execution.scheduler.NetworkTopology;
import io.trino.execution.scheduler.NodeScheduler;
import io.trino.execution.scheduler.NodeSchedulerConfig;
import io.trino.execution.scheduler.NodeSelector;
import io.trino.execution.scheduler.NodeSelectorFactory;
import io.trino.execution.scheduler.SplitPlacementResult;
import io.trino.execution.scheduler.TopologyAwareNodeSelectorConfig;
import io.trino.execution.scheduler.TopologyAwareNodeSelectorFactory;
import io.trino.execution.scheduler.UniformNodeSelector;
import io.trino.execution.scheduler.UniformNodeSelectorFactory;
import io.trino.metadata.InMemoryNodeManager;
import io.trino.metadata.InternalNode;
import io.trino.metadata.InternalNodeManager;
import io.trino.metadata.Split;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.HostAddress;
import io.trino.spi.SplitWeight;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.util.FinalizerService;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jol.info.ClassLayout;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestNodeScheduler {
    private static final CatalogName CONNECTOR_ID = new CatalogName("connector_id");
    private FinalizerService finalizerService;
    private NodeTaskMap nodeTaskMap;
    private InMemoryNodeManager nodeManager;
    private NodeSchedulerConfig nodeSchedulerConfig;
    private NodeScheduler nodeScheduler;
    private NodeSelector nodeSelector;
    private Map<InternalNode, RemoteTask> taskMap;
    private ExecutorService remoteTaskExecutor;
    private ScheduledExecutorService remoteTaskScheduledExecutor;
    private Session session;

    @BeforeMethod
    public void setUp() {
        this.session = TestingSession.testSessionBuilder().build();
        this.finalizerService = new FinalizerService();
        this.nodeTaskMap = new NodeTaskMap(this.finalizerService);
        this.nodeManager = new InMemoryNodeManager();
        this.nodeSchedulerConfig = new NodeSchedulerConfig().setMaxSplitsPerNode(20).setIncludeCoordinator(false).setMaxPendingSplitsPerTask(10);
        this.nodeScheduler = new NodeScheduler((NodeSelectorFactory)new UniformNodeSelectorFactory((InternalNodeManager)this.nodeManager, this.nodeSchedulerConfig, this.nodeTaskMap));
        this.taskMap = new HashMap<InternalNode, RemoteTask>();
        this.nodeSelector = this.nodeScheduler.createNodeSelector(this.session, Optional.of(CONNECTOR_ID));
        this.remoteTaskExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"remoteTaskExecutor-%s"));
        this.remoteTaskScheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"remoteTaskScheduledExecutor-%s"));
        this.finalizerService.start();
    }

    private void setUpNodes() {
        ImmutableList.Builder nodeBuilder = ImmutableList.builder();
        nodeBuilder.add((Object)new InternalNode("other1", URI.create("http://10.0.0.1:11"), NodeVersion.UNKNOWN, false));
        nodeBuilder.add((Object)new InternalNode("other2", URI.create("http://10.0.0.1:12"), NodeVersion.UNKNOWN, false));
        nodeBuilder.add((Object)new InternalNode("other3", URI.create("http://10.0.0.1:13"), NodeVersion.UNKNOWN, false));
        ImmutableList nodes = nodeBuilder.build();
        this.nodeManager.addNode(CONNECTOR_ID, (Iterable)nodes);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.remoteTaskExecutor.shutdown();
        this.remoteTaskExecutor = null;
        this.remoteTaskScheduledExecutor.shutdown();
        this.remoteTaskScheduledExecutor = null;
        this.nodeSchedulerConfig = null;
        this.nodeScheduler = null;
        this.nodeSelector = null;
        this.finalizerService.destroy();
        this.finalizerService = null;
    }

    @Test
    public void testAssignmentWhenNoNodes() {
        HashSet<Split> splits = new HashSet<Split>();
        splits.add(new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitRemote()));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values()))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE).hasMessageMatching("No nodes available to run query");
    }

    @Test
    public void testScheduleLocal() {
        this.setUpNodes();
        Split split = new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitLocallyAccessible());
        ImmutableSet splits = ImmutableSet.of((Object)split);
        Map.Entry assignment = (Map.Entry)Iterables.getOnlyElement((Iterable)this.nodeSelector.computeAssignments((Set)splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments().entries());
        Assert.assertEquals((Object)((InternalNode)assignment.getKey()).getHostAndPort(), split.getAddresses().get(0));
        Assert.assertEquals(assignment.getValue(), (Object)split);
    }

    @Test(timeOut=60000L)
    public void testTopologyAwareScheduling() {
        int i;
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        ImmutableList.Builder nodeBuilder = ImmutableList.builder();
        nodeBuilder.add((Object)new InternalNode("node1", URI.create("http://host1.rack1:11"), NodeVersion.UNKNOWN, false));
        nodeBuilder.add((Object)new InternalNode("node2", URI.create("http://host2.rack1:12"), NodeVersion.UNKNOWN, false));
        nodeBuilder.add((Object)new InternalNode("node3", URI.create("http://host3.rack2:13"), NodeVersion.UNKNOWN, false));
        ImmutableList nodes = nodeBuilder.build();
        nodeManager.addNode(CONNECTOR_ID, (Iterable)nodes);
        HashMap<InternalNode, MockRemoteTaskFactory.MockRemoteTask> taskMap = new HashMap<InternalNode, MockRemoteTaskFactory.MockRemoteTask>();
        NodeSchedulerConfig nodeSchedulerConfig = new NodeSchedulerConfig().setMaxSplitsPerNode(25).setIncludeCoordinator(false).setMaxPendingSplitsPerTask(20);
        TestNetworkTopology topology = new TestNetworkTopology();
        TopologyAwareNodeSelectorFactory nodeSelectorFactory = new TopologyAwareNodeSelectorFactory((NetworkTopology)topology, (InternalNodeManager)nodeManager, nodeSchedulerConfig, nodeTaskMap, TestNodeScheduler.getNetworkTopologyConfig());
        NodeScheduler nodeScheduler = new NodeScheduler((NodeSelectorFactory)nodeSelectorFactory);
        NodeSelector nodeSelector = nodeScheduler.createNodeSelector(this.session, Optional.of(CONNECTOR_ID));
        ImmutableSet.Builder nonRackLocalBuilder = ImmutableSet.builder();
        for (int i2 = 0; i2 < 108; ++i2) {
            nonRackLocalBuilder.add((Object)new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitRemote(HostAddress.fromParts((String)"data.other_rack", (int)1))));
        }
        ImmutableSet nonRackLocalSplits = nonRackLocalBuilder.build();
        Multimap assignments = nodeSelector.computeAssignments((Set)nonRackLocalSplits, (List)ImmutableList.copyOf(taskMap.values())).getAssignments();
        MockRemoteTaskFactory remoteTaskFactory = new MockRemoteTaskFactory(this.remoteTaskExecutor, this.remoteTaskScheduledExecutor);
        int task = 0;
        for (InternalNode node : assignments.keySet()) {
            TaskId taskId = new TaskId(new StageId("test", 1), task, 0);
            ++task;
            MockRemoteTaskFactory.MockRemoteTask remoteTask = remoteTaskFactory.createTableScanTask(taskId, node, (List<Split>)ImmutableList.copyOf((Collection)assignments.get((Object)node)), nodeTaskMap.createPartitionedSplitCountTracker(node, taskId));
            remoteTask.startSplits(25);
            nodeTaskMap.addTask(node, (RemoteTask)remoteTask);
            taskMap.put(node, remoteTask);
        }
        nonRackLocalSplits = Sets.difference((Set)nonRackLocalSplits, new HashSet(assignments.values()));
        assignments = nodeSelector.computeAssignments((Set)nonRackLocalSplits, (List)ImmutableList.copyOf(taskMap.values())).getAssignments();
        for (InternalNode node : assignments.keySet()) {
            RemoteTask remoteTask = (RemoteTask)taskMap.get(node);
            remoteTask.addSplits((Multimap)ImmutableMultimap.builder().putAll((Object)new PlanNodeId("sourceId"), (Iterable)assignments.get((Object)node)).build());
        }
        nonRackLocalSplits = Sets.difference((Set)nonRackLocalSplits, new HashSet(assignments.values()));
        Assert.assertEquals((int)nonRackLocalSplits.size(), (int)3);
        ImmutableSet.Builder rackLocalSplits = ImmutableSet.builder();
        HostAddress dataHost1 = HostAddress.fromParts((String)"data.rack1", (int)1);
        HostAddress dataHost2 = HostAddress.fromParts((String)"data.rack2", (int)1);
        for (i = 0; i < 12; ++i) {
            rackLocalSplits.add((Object)new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitRemote(dataHost1)));
        }
        for (i = 0; i < 6; ++i) {
            rackLocalSplits.add((Object)new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitRemote(dataHost2)));
        }
        assignments = nodeSelector.computeAssignments((Set)rackLocalSplits.build(), (List)ImmutableList.copyOf(taskMap.values())).getAssignments();
        for (Object node : assignments.keySet()) {
            RemoteTask remoteTask = (RemoteTask)taskMap.get(node);
            remoteTask.addSplits((Multimap)ImmutableMultimap.builder().putAll((Object)new PlanNodeId("sourceId"), (Iterable)assignments.get(node)).build());
        }
        Sets.SetView unassigned = Sets.difference((Set)rackLocalSplits.build(), new HashSet(assignments.values()));
        assignments = nodeSelector.computeAssignments((Set)unassigned, (List)ImmutableList.copyOf(taskMap.values())).getAssignments();
        for (InternalNode node : assignments.keySet()) {
            RemoteTask remoteTask = (RemoteTask)taskMap.get(node);
            remoteTask.addSplits((Multimap)ImmutableMultimap.builder().putAll((Object)new PlanNodeId("sourceId"), (Iterable)assignments.get((Object)node)).build());
        }
        unassigned = Sets.difference((Set)unassigned, new HashSet(assignments.values()));
        Assert.assertEquals((int)unassigned.size(), (int)3);
        int rack1 = 0;
        int rack2 = 0;
        block15: for (Split split : unassigned) {
            String rack;
            switch (rack = (String)topology.locate((HostAddress)split.getAddresses().get(0)).getSegments().get(0)) {
                case "rack1": {
                    ++rack1;
                    continue block15;
                }
                case "rack2": {
                    ++rack2;
                    continue block15;
                }
            }
            throw new AssertionError((Object)("Unexpected rack: " + rack));
        }
        Assert.assertEquals((int)rack1, (int)2);
        Assert.assertEquals((int)rack2, (int)1);
        ImmutableSet.Builder localSplits = ImmutableSet.builder();
        localSplits.add((Object)new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitRemote(HostAddress.fromParts((String)"host1.rack1", (int)1))));
        localSplits.add((Object)new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitRemote(HostAddress.fromParts((String)"host2.rack1", (int)1))));
        localSplits.add((Object)new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitRemote(HostAddress.fromParts((String)"host3.rack2", (int)1))));
        assignments = nodeSelector.computeAssignments((Set)localSplits.build(), (List)ImmutableList.copyOf(taskMap.values())).getAssignments();
        Assert.assertEquals((int)assignments.size(), (int)3);
        Assert.assertEquals((int)assignments.keySet().size(), (int)3);
    }

    @Test
    public void testScheduleRemote() {
        this.setUpNodes();
        HashSet<Split> splits = new HashSet<Split>();
        splits.add(new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitRemote()));
        Multimap assignments = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        Assert.assertEquals((int)assignments.size(), (int)1);
    }

    @Test
    public void testBasicAssignment() {
        this.setUpNodes();
        HashSet<Split> splits = new HashSet<Split>();
        for (int i = 0; i < 3; ++i) {
            splits.add(new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitRemote()));
        }
        Multimap assignments = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        Assert.assertEquals((int)assignments.entries().size(), (int)3);
        for (InternalNode node : this.nodeManager.getActiveConnectorNodes(CONNECTOR_ID)) {
            Assert.assertTrue((boolean)assignments.keySet().contains(node));
        }
    }

    @Test
    public void testMaxSplitsPerNode() {
        this.setUpNodes();
        InternalNode newNode = new InternalNode("other4", URI.create("http://10.0.0.1:14"), NodeVersion.UNKNOWN, false);
        this.nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{newNode});
        ImmutableList.Builder initialSplits = ImmutableList.builder();
        for (int i = 0; i < 10; ++i) {
            initialSplits.add((Object)new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitRemote()));
        }
        MockRemoteTaskFactory remoteTaskFactory = new MockRemoteTaskFactory(this.remoteTaskExecutor, this.remoteTaskScheduledExecutor);
        TaskId taskId1 = new TaskId(new StageId("test", 1), 1, 0);
        MockRemoteTaskFactory.MockRemoteTask remoteTask1 = remoteTaskFactory.createTableScanTask(taskId1, newNode, (List<Split>)initialSplits.build(), this.nodeTaskMap.createPartitionedSplitCountTracker(newNode, taskId1));
        this.nodeTaskMap.addTask(newNode, (RemoteTask)remoteTask1);
        TaskId taskId2 = new TaskId(new StageId("test", 1), 2, 0);
        MockRemoteTaskFactory.MockRemoteTask remoteTask2 = remoteTaskFactory.createTableScanTask(taskId2, newNode, (List<Split>)initialSplits.build(), this.nodeTaskMap.createPartitionedSplitCountTracker(newNode, taskId2));
        this.nodeTaskMap.addTask(newNode, (RemoteTask)remoteTask2);
        HashSet<Split> splits = new HashSet<Split>();
        for (int i = 0; i < 5; ++i) {
            splits.add(new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitRemote()));
        }
        Multimap assignments = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        Assert.assertFalse((boolean)assignments.keySet().contains(newNode));
        remoteTask1.abort();
        remoteTask2.abort();
        Assert.assertEquals((Object)this.nodeTaskMap.getPartitionedSplitsOnNode(newNode), (Object)PartitionedSplitsInfo.forZeroSplits());
    }

    @Test
    public void testBasicAssignmentMaxUnacknowledgedSplitsPerTask() {
        this.nodeSelector = this.nodeScheduler.createNodeSelector(TestNodeScheduler.sessionWithMaxUnacknowledgedSplitsPerTask(1), Optional.of(CONNECTOR_ID));
        this.setUpNodes();
        int nodeCount = this.nodeManager.getActiveConnectorNodes(CONNECTOR_ID).size();
        int splitCount = nodeCount + 1;
        HashSet<Split> splits = new HashSet<Split>();
        for (int i = 0; i < splitCount; ++i) {
            splits.add(new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitRemote()));
        }
        Multimap assignments = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        Assert.assertEquals((int)assignments.entries().size(), (int)nodeCount);
        for (InternalNode node : this.nodeManager.getActiveConnectorNodes(CONNECTOR_ID)) {
            Assert.assertTrue((boolean)assignments.keySet().contains(node));
        }
    }

    @Test
    public void testMaxSplitsPerNodePerTask() {
        this.setUpNodes();
        InternalNode newNode = new InternalNode("other4", URI.create("http://10.0.0.1:14"), NodeVersion.UNKNOWN, false);
        this.nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{newNode});
        ImmutableList.Builder initialSplits = ImmutableList.builder();
        for (int i = 0; i < 20; ++i) {
            initialSplits.add((Object)new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitRemote()));
        }
        ArrayList<MockRemoteTaskFactory.MockRemoteTask> tasks = new ArrayList<MockRemoteTaskFactory.MockRemoteTask>();
        MockRemoteTaskFactory remoteTaskFactory = new MockRemoteTaskFactory(this.remoteTaskExecutor, this.remoteTaskScheduledExecutor);
        for (InternalNode node : this.nodeManager.getActiveConnectorNodes(CONNECTOR_ID)) {
            TaskId taskId = new TaskId(new StageId("test", 1), 1, 0);
            MockRemoteTaskFactory.MockRemoteTask remoteTask = remoteTaskFactory.createTableScanTask(taskId, node, (List<Split>)initialSplits.build(), this.nodeTaskMap.createPartitionedSplitCountTracker(node, taskId));
            this.nodeTaskMap.addTask(node, (RemoteTask)remoteTask);
            tasks.add(remoteTask);
        }
        TaskId taskId = new TaskId(new StageId("test", 1), 2, 0);
        MockRemoteTaskFactory.MockRemoteTask newRemoteTask = remoteTaskFactory.createTableScanTask(taskId, newNode, (List<Split>)initialSplits.build(), this.nodeTaskMap.createPartitionedSplitCountTracker(newNode, taskId));
        this.taskMap.put(newNode, newRemoteTask);
        this.nodeTaskMap.addTask(newNode, (RemoteTask)newRemoteTask);
        tasks.add(newRemoteTask);
        HashSet<Split> splits = new HashSet<Split>();
        for (int i = 0; i < 5; ++i) {
            splits.add(new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitRemote()));
        }
        Multimap assignments = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        Assert.assertEquals((int)assignments.keySet().size(), (int)3);
        Assert.assertFalse((boolean)assignments.keySet().contains(newNode));
        for (RemoteTask remoteTask : tasks) {
            remoteTask.abort();
        }
        Assert.assertEquals((Object)this.nodeTaskMap.getPartitionedSplitsOnNode(newNode), (Object)PartitionedSplitsInfo.forZeroSplits());
    }

    @Test
    public void testTaskCompletion() throws Exception {
        this.setUpNodes();
        MockRemoteTaskFactory remoteTaskFactory = new MockRemoteTaskFactory(this.remoteTaskExecutor, this.remoteTaskScheduledExecutor);
        InternalNode chosenNode = (InternalNode)Iterables.get((Iterable)this.nodeManager.getActiveConnectorNodes(CONNECTOR_ID), (int)0);
        TaskId taskId = new TaskId(new StageId("test", 1), 1, 0);
        MockRemoteTaskFactory.MockRemoteTask remoteTask = remoteTaskFactory.createTableScanTask(taskId, chosenNode, (List<Split>)ImmutableList.of((Object)new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitRemote())), this.nodeTaskMap.createPartitionedSplitCountTracker(chosenNode, taskId));
        this.nodeTaskMap.addTask(chosenNode, (RemoteTask)remoteTask);
        Assert.assertEquals((int)this.nodeTaskMap.getPartitionedSplitsOnNode(chosenNode).getCount(), (int)1);
        remoteTask.abort();
        TimeUnit.MILLISECONDS.sleep(100L);
        Assert.assertEquals((Object)this.nodeTaskMap.getPartitionedSplitsOnNode(chosenNode), (Object)PartitionedSplitsInfo.forZeroSplits());
        remoteTask.abort();
        Assert.assertEquals((Object)this.nodeTaskMap.getPartitionedSplitsOnNode(chosenNode), (Object)PartitionedSplitsInfo.forZeroSplits());
    }

    @Test
    public void testSplitCount() {
        this.setUpNodes();
        MockRemoteTaskFactory remoteTaskFactory = new MockRemoteTaskFactory(this.remoteTaskExecutor, this.remoteTaskScheduledExecutor);
        InternalNode chosenNode = (InternalNode)Iterables.get((Iterable)this.nodeManager.getActiveConnectorNodes(CONNECTOR_ID), (int)0);
        TaskId taskId1 = new TaskId(new StageId("test", 1), 1, 0);
        MockRemoteTaskFactory.MockRemoteTask remoteTask1 = remoteTaskFactory.createTableScanTask(taskId1, chosenNode, (List<Split>)ImmutableList.of((Object)new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitRemote()), (Object)new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitRemote())), this.nodeTaskMap.createPartitionedSplitCountTracker(chosenNode, taskId1));
        TaskId taskId2 = new TaskId(new StageId("test", 1), 2, 0);
        MockRemoteTaskFactory.MockRemoteTask remoteTask2 = remoteTaskFactory.createTableScanTask(taskId2, chosenNode, (List<Split>)ImmutableList.of((Object)new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitRemote())), this.nodeTaskMap.createPartitionedSplitCountTracker(chosenNode, taskId2));
        this.nodeTaskMap.addTask(chosenNode, (RemoteTask)remoteTask1);
        this.nodeTaskMap.addTask(chosenNode, (RemoteTask)remoteTask2);
        Assert.assertEquals((int)this.nodeTaskMap.getPartitionedSplitsOnNode(chosenNode).getCount(), (int)3);
        remoteTask1.abort();
        Assert.assertEquals((int)this.nodeTaskMap.getPartitionedSplitsOnNode(chosenNode).getCount(), (int)1);
        remoteTask2.abort();
        Assert.assertEquals((Object)this.nodeTaskMap.getPartitionedSplitsOnNode(chosenNode), (Object)PartitionedSplitsInfo.forZeroSplits());
    }

    @Test
    public void testPrioritizedAssignmentOfLocalSplit() {
        InternalNode node = new InternalNode("node1", URI.create("http://10.0.0.1:11"), NodeVersion.UNKNOWN, false);
        this.nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{node});
        LinkedHashSet<Split> splits = new LinkedHashSet<Split>();
        for (int i = 0; i < 20; ++i) {
            splits.add(new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitRemote()));
        }
        Multimap initialAssignment = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        Assert.assertEquals((int)initialAssignment.size(), (int)20);
        Assert.assertEquals((int)initialAssignment.keySet().size(), (int)1);
        Assert.assertTrue((boolean)initialAssignment.keySet().contains(node));
        splits.add(new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitLocal()));
        splits.add(new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitRemote()));
        Multimap finalAssignment = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        Assert.assertEquals((int)finalAssignment.size(), (int)20);
        Assert.assertEquals((int)finalAssignment.keySet().size(), (int)1);
        Assert.assertTrue((boolean)finalAssignment.keySet().contains(node));
        long countLocalSplits = finalAssignment.values().stream().map(Split::getConnectorSplit).filter(TestSplitLocal.class::isInstance).count();
        Assert.assertEquals((long)countLocalSplits, (long)1L);
    }

    @Test
    public void testAssignmentWhenMixedSplits() {
        int i;
        InternalNode node = new InternalNode("node1", URI.create("http://10.0.0.1:11"), NodeVersion.UNKNOWN, false);
        this.nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{node});
        LinkedHashSet<Split> splits = new LinkedHashSet<Split>();
        for (i = 0; i < 10; ++i) {
            splits.add(new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitLocal()));
        }
        for (i = 0; i < 10; ++i) {
            splits.add(new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitRemote()));
        }
        Multimap initialAssignment = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        Assert.assertEquals((int)initialAssignment.size(), (int)20);
        Assert.assertEquals((int)initialAssignment.keySet().size(), (int)1);
        Assert.assertTrue((boolean)initialAssignment.keySet().contains(node));
        splits.add(new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitLocal()));
        splits.add(new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitRemote()));
        Multimap finalAssignment = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        Assert.assertEquals((int)finalAssignment.size(), (int)20);
        Assert.assertEquals((int)finalAssignment.keySet().size(), (int)1);
        Assert.assertTrue((boolean)finalAssignment.keySet().contains(node));
        long countLocalSplits = finalAssignment.values().stream().map(Split::getConnectorSplit).filter(TestSplitLocal.class::isInstance).count();
        Assert.assertEquals((long)countLocalSplits, (long)11L);
    }

    @Test
    public void testOptimizedLocalScheduling() {
        InternalNode node1 = new InternalNode("node1", URI.create("http://10.0.0.1:11"), NodeVersion.UNKNOWN, false);
        this.nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{node1});
        InternalNode node2 = new InternalNode("node2", URI.create("http://10.0.0.1:12"), NodeVersion.UNKNOWN, false);
        this.nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{node2});
        LinkedHashSet<Split> splits = new LinkedHashSet<Split>();
        for (int i = 0; i < 20; ++i) {
            splits.add(new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitLocal()));
        }
        Multimap assignments1 = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        Assert.assertEquals((int)assignments1.size(), (int)20);
        Assert.assertEquals((int)assignments1.keySet().size(), (int)2);
        Assert.assertTrue((boolean)assignments1.keySet().contains(node1));
        Assert.assertTrue((boolean)assignments1.keySet().contains(node2));
        for (int i = 0; i < 19; ++i) {
            splits.add(new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitRemote(HostAddress.fromString((String)"10.0.0.1:12"))));
        }
        Multimap assignments2 = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        Assert.assertEquals((int)assignments2.size(), (int)39);
        Assert.assertEquals((int)assignments2.keySet().size(), (int)2);
        Assert.assertTrue((boolean)assignments2.keySet().contains(node1));
        Assert.assertTrue((boolean)assignments2.keySet().contains(node2));
        long node1Splits = assignments2.values().stream().map(Split::getConnectorSplit).filter(TestSplitLocal.class::isInstance).count();
        Assert.assertEquals((long)node1Splits, (long)20L);
        long node2Splits = assignments2.values().stream().map(Split::getConnectorSplit).filter(TestSplitRemote.class::isInstance).count();
        Assert.assertEquals((long)node2Splits, (long)19L);
        splits.add(new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitLocal()));
        splits.add(new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitRemote(HostAddress.fromString((String)"10.0.0.1:12"))));
        Multimap assignments3 = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        Assert.assertEquals((int)assignments3.size(), (int)40);
        Assert.assertEquals((int)assignments3.keySet().size(), (int)2);
        Assert.assertTrue((boolean)assignments3.keySet().contains(node1));
        Assert.assertTrue((boolean)assignments3.keySet().contains(node2));
        node1Splits = assignments3.values().stream().map(Split::getConnectorSplit).filter(TestSplitLocal.class::isInstance).count();
        Assert.assertEquals((long)node1Splits, (long)20L);
        node2Splits = assignments3.values().stream().map(Split::getConnectorSplit).filter(TestSplitRemote.class::isInstance).count();
        Assert.assertEquals((long)node2Splits, (long)20L);
    }

    @Test
    public void testEquateDistribution() {
        InternalNode node1 = new InternalNode("node1", URI.create("http://10.0.0.1:11"), NodeVersion.UNKNOWN, false);
        this.nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{node1});
        InternalNode node2 = new InternalNode("node2", URI.create("http://10.0.0.1:12"), NodeVersion.UNKNOWN, false);
        this.nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{node2});
        InternalNode node3 = new InternalNode("node3", URI.create("http://10.0.0.1:13"), NodeVersion.UNKNOWN, false);
        this.nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{node3});
        InternalNode node4 = new InternalNode("node4", URI.create("http://10.0.0.1:14"), NodeVersion.UNKNOWN, false);
        this.nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{node4});
        LinkedHashSet<Split> splits = new LinkedHashSet<Split>();
        for (int i = 0; i < 20; ++i) {
            splits.add(new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitLocal()));
        }
        Multimap assignment = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        Assert.assertEquals((int)assignment.size(), (int)20);
        Assert.assertEquals((int)assignment.keySet().size(), (int)4);
        Assert.assertEquals((int)assignment.get((Object)node1).size(), (int)8);
        Assert.assertEquals((int)assignment.get((Object)node2).size(), (int)4);
        Assert.assertEquals((int)assignment.get((Object)node3).size(), (int)4);
        Assert.assertEquals((int)assignment.get((Object)node4).size(), (int)4);
    }

    @DataProvider
    public static Object[][] equateDistributionTestParameters() {
        return new Object[][]{{5, 10, 0.0}, {5, 20, 0.055}, {10, 50, 0.0}, {10, 100, 0.045}, {10, 200, 0.09}, {50, 550, 0.045}, {50, 600, 0.047}, {50, 700, 0.045}, {100, 550, 0.036}, {100, 600, 0.054}, {100, 1000, 0.039}, {100, 1500, 0.045}};
    }

    @Test(dataProvider="equateDistributionTestParameters")
    public void testEquateDistributionConsistentHashing(int numberOfNodes, int numberOfSplits, double misassignedSplitsRatio) {
        ImmutableList.Builder nodesBuilder = ImmutableList.builder();
        for (int i = 0; i < numberOfNodes; ++i) {
            InternalNode node = new InternalNode("node" + i, URI.create("http://10.0.0.1:" + (i + 10)), NodeVersion.UNKNOWN, false);
            nodesBuilder.add((Object)node);
            this.nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{node});
        }
        ImmutableList nodes = nodesBuilder.build();
        LinkedHashSet<Split> splits = new LinkedHashSet<Split>();
        Random random = new Random(0L);
        ImmutableSetMultimap.Builder originalAssignmentBuilder = ImmutableSetMultimap.builder();
        for (int i = 0; i < numberOfSplits; ++i) {
            InternalNode node = (InternalNode)nodes.get(Hashing.consistentHash((long)random.nextInt(), (int)nodes.size()));
            Split split = new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitLocal(node.getHostAndPort()));
            splits.add(split);
            originalAssignmentBuilder.put((Object)node, (Object)split);
        }
        ImmutableSetMultimap originalNodeAssignment = originalAssignmentBuilder.build().inverse();
        Multimap assignment = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        ImmutableSetMultimap nodeAssignment = ImmutableSetMultimap.copyOf((Multimap)assignment).inverse();
        int misassignedSplits = 0;
        for (Split split : splits) {
            if (((InternalNode)Iterables.getOnlyElement((Iterable)originalNodeAssignment.get((Object)split))).equals(Iterables.getOnlyElement((Iterable)nodeAssignment.get((Object)split)))) continue;
            ++misassignedSplits;
        }
        Assertions.assertLessThanOrEqual((Comparable)Double.valueOf((double)misassignedSplits / (double)numberOfSplits), (Comparable)Double.valueOf(misassignedSplitsRatio));
    }

    @Test
    public void testRedistributeSplit() {
        InternalNode node1 = new InternalNode("node1", URI.create("http://10.0.0.1:11"), NodeVersion.UNKNOWN, false);
        this.nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{node1});
        InternalNode node2 = new InternalNode("node2", URI.create("http://10.0.0.1:12"), NodeVersion.UNKNOWN, false);
        this.nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{node2});
        HashMultimap assignment = HashMultimap.create();
        LinkedHashSet<Split> splitsAssignedToNode1 = new LinkedHashSet<Split>();
        for (int i = 0; i < 6; ++i) {
            splitsAssignedToNode1.add(new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitLocal()));
            splitsAssignedToNode1.add(new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitRemote()));
        }
        for (Split split : splitsAssignedToNode1) {
            assignment.put((Object)node1, (Object)split);
        }
        LinkedHashSet<Split> splitsAssignedToNode2 = new LinkedHashSet<Split>();
        for (int i = 0; i < 10; ++i) {
            splitsAssignedToNode2.add(new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitRemote()));
        }
        for (Split split : splitsAssignedToNode2) {
            assignment.put((Object)node2, (Object)split);
        }
        Assert.assertEquals((int)assignment.get((Object)node1).size(), (int)12);
        Assert.assertEquals((int)assignment.get((Object)node2).size(), (int)10);
        ImmutableSetMultimap.Builder nodesByHost = ImmutableSetMultimap.builder();
        try {
            nodesByHost.put((Object)node1.getInternalAddress(), (Object)node1);
            nodesByHost.put((Object)node2.getInternalAddress(), (Object)node2);
        }
        catch (UnknownHostException e) {
            System.out.println("Could not convert the address");
        }
        UniformNodeSelector.redistributeSplit((Multimap)assignment, (InternalNode)node1, (InternalNode)node2, (SetMultimap)nodesByHost.build());
        Assert.assertEquals((int)assignment.get((Object)node1).size(), (int)11);
        Assert.assertEquals((int)assignment.get((Object)node2).size(), (int)11);
        Sets.SetView redistributedSplit = Sets.difference(new HashSet(assignment.get((Object)node2)), splitsAssignedToNode2);
        Assert.assertEquals((int)redistributedSplit.size(), (int)1);
        Assert.assertTrue((boolean)(((Split)redistributedSplit.iterator().next()).getConnectorSplit() instanceof TestSplitRemote));
    }

    @Test
    public void testEmptyAssignmentWithFullNodes() {
        InternalNode node1 = new InternalNode("node1", URI.create("http://10.0.0.1:11"), NodeVersion.UNKNOWN, false);
        this.nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{node1});
        InternalNode node2 = new InternalNode("node2", URI.create("http://10.0.0.1:12"), NodeVersion.UNKNOWN, false);
        this.nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{node2});
        LinkedHashSet<Split> splits = new LinkedHashSet<Split>();
        for (int i = 0; i < 70; ++i) {
            splits.add(new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitLocal()));
        }
        Multimap assignments1 = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        Assert.assertEquals((int)assignments1.size(), (int)40);
        Assert.assertEquals((int)assignments1.keySet().size(), (int)2);
        Assert.assertEquals((int)assignments1.get((Object)node1).size(), (int)20);
        Assert.assertEquals((int)assignments1.get((Object)node2).size(), (int)20);
        MockRemoteTaskFactory remoteTaskFactory = new MockRemoteTaskFactory(this.remoteTaskExecutor, this.remoteTaskScheduledExecutor);
        int task = 0;
        for (InternalNode node : assignments1.keySet()) {
            TaskId taskId = new TaskId(new StageId("test", 1), task, 0);
            ++task;
            MockRemoteTaskFactory.MockRemoteTask remoteTask = remoteTaskFactory.createTableScanTask(taskId, node, (List<Split>)ImmutableList.copyOf((Collection)assignments1.get((Object)node)), this.nodeTaskMap.createPartitionedSplitCountTracker(node, taskId));
            remoteTask.startSplits(20);
            this.nodeTaskMap.addTask(node, (RemoteTask)remoteTask);
            this.taskMap.put(node, remoteTask);
        }
        Sets.SetView unassignedSplits = Sets.difference(splits, new HashSet(assignments1.values()));
        Assert.assertEquals((int)unassignedSplits.size(), (int)30);
        Multimap assignments2 = this.nodeSelector.computeAssignments((Set)unassignedSplits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        for (InternalNode node : assignments2.keySet()) {
            RemoteTask remoteTask = this.taskMap.get(node);
            remoteTask.addSplits((Multimap)ImmutableMultimap.builder().putAll((Object)new PlanNodeId("sourceId"), (Iterable)assignments2.get((Object)node)).build());
        }
        unassignedSplits = Sets.difference((Set)unassignedSplits, new HashSet(assignments2.values()));
        Assert.assertEquals((int)unassignedSplits.size(), (int)10);
        Multimap assignments3 = this.nodeSelector.computeAssignments((Set)unassignedSplits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        Assert.assertTrue((boolean)assignments3.isEmpty());
    }

    @Test
    public void testMaxUnacknowledgedSplitsPerTask() {
        int maxUnacknowledgedSplitsPerTask = 5;
        this.nodeSelector = this.nodeScheduler.createNodeSelector(TestNodeScheduler.sessionWithMaxUnacknowledgedSplitsPerTask(maxUnacknowledgedSplitsPerTask), Optional.of(CONNECTOR_ID));
        this.setUpNodes();
        ImmutableList.Builder initialSplits = ImmutableList.builder();
        for (int i = 0; i < maxUnacknowledgedSplitsPerTask; ++i) {
            initialSplits.add((Object)new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitRemote()));
        }
        ArrayList<InternalNode> nodes = new ArrayList<InternalNode>();
        ArrayList<MockRemoteTaskFactory.MockRemoteTask> tasks = new ArrayList<MockRemoteTaskFactory.MockRemoteTask>();
        MockRemoteTaskFactory remoteTaskFactory = new MockRemoteTaskFactory(this.remoteTaskExecutor, this.remoteTaskScheduledExecutor);
        int counter = 1;
        for (InternalNode node : this.nodeManager.getActiveConnectorNodes(CONNECTOR_ID)) {
            TaskId taskId = new TaskId(new StageId("test", 1), counter, 0);
            ++counter;
            MockRemoteTaskFactory.MockRemoteTask remoteTask = remoteTaskFactory.createTableScanTask(taskId, node, (List<Split>)initialSplits.build(), this.nodeTaskMap.createPartitionedSplitCountTracker(node, taskId));
            this.nodeTaskMap.addTask(node, (RemoteTask)remoteTask);
            remoteTask.setMaxUnacknowledgedSplits(maxUnacknowledgedSplitsPerTask);
            remoteTask.setUnacknowledgedSplits(maxUnacknowledgedSplitsPerTask);
            nodes.add(node);
            tasks.add(remoteTask);
        }
        HashSet<Split> splits = new HashSet<Split>();
        for (int i = 0; i < nodes.size(); ++i) {
            splits.add(new Split(CONNECTOR_ID, (ConnectorSplit)new TestSplitRemote()));
        }
        SplitPlacementResult splitPlacements = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(tasks));
        Assert.assertEquals((int)splitPlacements.getAssignments().size(), (int)0);
        MockRemoteTaskFactory.MockRemoteTask taskOne = (MockRemoteTaskFactory.MockRemoteTask)tasks.get(0);
        taskOne.finishSplits(1);
        taskOne.setUnacknowledgedSplits(taskOne.getUnacknowledgedPartitionedSplitCount() - 1);
        Assert.assertTrue((boolean)splitPlacements.getBlocked().isDone());
        splitPlacements = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(tasks));
        Assert.assertEquals((int)splitPlacements.getAssignments().size(), (int)1);
        Assert.assertTrue((boolean)splitPlacements.getAssignments().keySet().contains(nodes.get(0)));
        taskOne.clearSplits();
        tasks.forEach(task -> task.setUnacknowledgedSplits(maxUnacknowledgedSplitsPerTask - 1));
        splitPlacements = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(tasks));
        Assert.assertEquals((int)splitPlacements.getAssignments().size(), (int)nodes.size());
        Assert.assertTrue((boolean)splitPlacements.getAssignments().keySet().containsAll(nodes));
    }

    private static Session sessionWithMaxUnacknowledgedSplitsPerTask(int maxUnacknowledgedSplitsPerTask) {
        return TestingSession.testSessionBuilder().setSystemProperty("max_unacknowledged_splits_per_task", Integer.toString(maxUnacknowledgedSplitsPerTask)).build();
    }

    private static TopologyAwareNodeSelectorConfig getNetworkTopologyConfig() {
        return new TopologyAwareNodeSelectorConfig().setLocationSegmentNames((List)ImmutableList.of((Object)"rack", (Object)"machine"));
    }

    private static class TestNetworkTopology
    implements NetworkTopology {
        private TestNetworkTopology() {
        }

        public NetworkLocation locate(HostAddress address) {
            ArrayList parts = new ArrayList(ImmutableList.copyOf((Iterable)Splitter.on((String)".").split((CharSequence)address.getHostText())));
            Collections.reverse(parts);
            return new NetworkLocation(parts);
        }
    }

    private static class TestSplitRemote
    implements ConnectorSplit {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(TestSplitRemote.class).instanceSize();
        private final List<HostAddress> hosts;
        private final SplitWeight splitWeight;

        TestSplitRemote() {
            this(HostAddress.fromString((String)String.format("10.%s.%s.%s:%s", ThreadLocalRandom.current().nextInt(0, 255), ThreadLocalRandom.current().nextInt(0, 255), ThreadLocalRandom.current().nextInt(0, 255), ThreadLocalRandom.current().nextInt(15, 5000))));
        }

        TestSplitRemote(HostAddress host) {
            this(host, SplitWeight.standard());
        }

        TestSplitRemote(HostAddress host, SplitWeight splitWeight) {
            this.hosts = ImmutableList.of((Object)Objects.requireNonNull(host, "host is null"));
            this.splitWeight = Objects.requireNonNull(splitWeight, "splitWeight is null");
        }

        public boolean isRemotelyAccessible() {
            return true;
        }

        public List<HostAddress> getAddresses() {
            return this.hosts;
        }

        public Object getInfo() {
            return this;
        }

        public SplitWeight getSplitWeight() {
            return this.splitWeight;
        }

        public long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf(this.hosts, HostAddress::getRetainedSizeInBytes) + this.splitWeight.getRetainedSizeInBytes();
        }
    }

    private static class TestSplitLocallyAccessible
    implements ConnectorSplit {
        private TestSplitLocallyAccessible() {
        }

        public boolean isRemotelyAccessible() {
            return false;
        }

        public List<HostAddress> getAddresses() {
            return ImmutableList.of((Object)HostAddress.fromString((String)"10.0.0.1:11"));
        }

        public Object getInfo() {
            return this;
        }

        public long getRetainedSizeInBytes() {
            return 0L;
        }
    }

    private static class TestSplitLocal
    implements ConnectorSplit {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(TestSplitLocal.class).instanceSize();
        private final HostAddress address;
        private final SplitWeight splitWeight;

        private TestSplitLocal() {
            this(HostAddress.fromString((String)"10.0.0.1:11"));
        }

        private TestSplitLocal(HostAddress address) {
            this(address, SplitWeight.standard());
        }

        private TestSplitLocal(HostAddress address, SplitWeight splitWeight) {
            this.address = Objects.requireNonNull(address, "address is null");
            this.splitWeight = Objects.requireNonNull(splitWeight, "splitWeight is null");
        }

        public boolean isRemotelyAccessible() {
            return true;
        }

        public List<HostAddress> getAddresses() {
            return ImmutableList.of((Object)this.address);
        }

        public Object getInfo() {
            return this;
        }

        public SplitWeight getSplitWeight() {
            return this.splitWeight;
        }

        public long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + this.address.getRetainedSizeInBytes() + this.splitWeight.getRetainedSizeInBytes();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("address", (Object)this.address).toString();
        }
    }
}

