/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.execution.QueryManagerConfig;
import io.trino.operator.RetryPolicy;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestQueryManagerConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((QueryManagerConfig)ConfigAssertions.recordDefaults(QueryManagerConfig.class)).setMinQueryExpireAge(new Duration(15.0, TimeUnit.MINUTES)).setMaxQueryHistory(100).setMaxQueryLength(1000000).setMaxStageCount(150).setStageCountWarningThreshold(50).setClientTimeout(new Duration(5.0, TimeUnit.MINUTES)).setScheduleSplitBatchSize(1000).setMinScheduleSplitBatchSize(100).setMaxConcurrentQueries(1000).setMaxQueuedQueries(5000).setHashPartitionCount(100).setQueryManagerExecutorPoolSize(5).setRemoteTaskMinErrorDuration(new Duration(5.0, TimeUnit.MINUTES)).setRemoteTaskMaxErrorDuration(new Duration(5.0, TimeUnit.MINUTES)).setRemoteTaskMaxCallbackThreads(1000).setQueryExecutionPolicy("phased").setQueryMaxRunTime(new Duration(100.0, TimeUnit.DAYS)).setQueryMaxExecutionTime(new Duration(100.0, TimeUnit.DAYS)).setQueryMaxPlanningTime(new Duration(10.0, TimeUnit.MINUTES)).setQueryMaxCpuTime(new Duration(1.0E9, TimeUnit.DAYS)).setQueryMaxScanPhysicalBytes(null).setRequiredWorkers(1).setRequiredWorkersMaxWait(new Duration(5.0, TimeUnit.MINUTES)).setRetryPolicy(RetryPolicy.NONE).setQueryRetryAttempts(4).setTaskRetryAttemptsOverall(Integer.MAX_VALUE).setTaskRetryAttemptsPerTask(4).setRetryInitialDelay(new Duration(10.0, TimeUnit.SECONDS)).setRetryMaxDelay(new Duration(1.0, TimeUnit.MINUTES)).setRetryDelayScaleFactor(2.0).setMaxTasksWaitingForNodePerStage(5).setFaultTolerantExecutionTargetTaskInputSize(DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setFaultTolerantExecutionMinTaskSplitCount(16).setFaultTolerantExecutionTargetTaskSplitCount(64).setFaultTolerantExecutionMaxTaskSplitCount(256).setFaultTolerantExecutionTaskDescriptorStorageMaxMemory(DataSize.ofBytes((long)Math.round((double)QueryManagerConfig.AVAILABLE_HEAP_MEMORY * 0.15))).setFaultTolerantExecutionPartitionCount(50).setFaultTolerantPreserveInputPartitionsInWriteStage(true));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"query.client.timeout", (Object)"10s").put((Object)"query.min-expire-age", (Object)"30s").put((Object)"query.max-history", (Object)"10").put((Object)"query.max-length", (Object)"10000").put((Object)"query.max-stage-count", (Object)"12345").put((Object)"query.stage-count-warning-threshold", (Object)"12300").put((Object)"query.schedule-split-batch-size", (Object)"99").put((Object)"query.min-schedule-split-batch-size", (Object)"9").put((Object)"query.max-concurrent-queries", (Object)"10").put((Object)"query.max-queued-queries", (Object)"15").put((Object)"query.hash-partition-count", (Object)"16").put((Object)"query.manager-executor-pool-size", (Object)"11").put((Object)"query.remote-task.min-error-duration", (Object)"30s").put((Object)"query.remote-task.max-error-duration", (Object)"60s").put((Object)"query.remote-task.max-callback-threads", (Object)"10").put((Object)"query.execution-policy", (Object)"legacy-phased").put((Object)"query.max-run-time", (Object)"2h").put((Object)"query.max-execution-time", (Object)"3h").put((Object)"query.max-planning-time", (Object)"1h").put((Object)"query.max-cpu-time", (Object)"2d").put((Object)"query.max-scan-physical-bytes", (Object)"1kB").put((Object)"query-manager.required-workers", (Object)"333").put((Object)"query-manager.required-workers-max-wait", (Object)"33m").put((Object)"retry-policy", (Object)"QUERY").put((Object)"query-retry-attempts", (Object)"0").put((Object)"task-retry-attempts-overall", (Object)"17").put((Object)"task-retry-attempts-per-task", (Object)"9").put((Object)"retry-initial-delay", (Object)"1m").put((Object)"retry-max-delay", (Object)"1h").put((Object)"retry-delay-scale-factor", (Object)"2.3").put((Object)"max-tasks-waiting-for-node-per-stage", (Object)"3").put((Object)"fault-tolerant-execution-target-task-input-size", (Object)"222MB").put((Object)"fault-tolerant-execution-min-task-split-count", (Object)"2").put((Object)"fault-tolerant-execution-target-task-split-count", (Object)"3").put((Object)"fault-tolerant-execution-max-task-split-count", (Object)"22").put((Object)"fault-tolerant-execution-task-descriptor-storage-max-memory", (Object)"3GB").put((Object)"fault-tolerant-execution-partition-count", (Object)"123").put((Object)"fault-tolerant-execution-preserve-input-partitions-in-write-stage", (Object)"false").buildOrThrow();
        QueryManagerConfig expected = new QueryManagerConfig().setMinQueryExpireAge(new Duration(30.0, TimeUnit.SECONDS)).setMaxQueryHistory(10).setMaxQueryLength(10000).setMaxStageCount(12345).setStageCountWarningThreshold(12300).setClientTimeout(new Duration(10.0, TimeUnit.SECONDS)).setScheduleSplitBatchSize(99).setMinScheduleSplitBatchSize(9).setMaxConcurrentQueries(10).setMaxQueuedQueries(15).setHashPartitionCount(16).setQueryManagerExecutorPoolSize(11).setRemoteTaskMinErrorDuration(new Duration(60.0, TimeUnit.SECONDS)).setRemoteTaskMaxErrorDuration(new Duration(60.0, TimeUnit.SECONDS)).setRemoteTaskMaxCallbackThreads(10).setQueryExecutionPolicy("legacy-phased").setQueryMaxRunTime(new Duration(2.0, TimeUnit.HOURS)).setQueryMaxExecutionTime(new Duration(3.0, TimeUnit.HOURS)).setQueryMaxPlanningTime(new Duration(1.0, TimeUnit.HOURS)).setQueryMaxCpuTime(new Duration(2.0, TimeUnit.DAYS)).setQueryMaxScanPhysicalBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setRequiredWorkers(333).setRequiredWorkersMaxWait(new Duration(33.0, TimeUnit.MINUTES)).setRetryPolicy(RetryPolicy.QUERY).setQueryRetryAttempts(0).setTaskRetryAttemptsOverall(17).setTaskRetryAttemptsPerTask(9).setRetryInitialDelay(new Duration(1.0, TimeUnit.MINUTES)).setRetryMaxDelay(new Duration(1.0, TimeUnit.HOURS)).setRetryDelayScaleFactor(2.3).setMaxTasksWaitingForNodePerStage(3).setFaultTolerantExecutionTargetTaskInputSize(DataSize.of((long)222L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setFaultTolerantExecutionMinTaskSplitCount(2).setFaultTolerantExecutionTargetTaskSplitCount(3).setFaultTolerantExecutionMaxTaskSplitCount(22).setFaultTolerantExecutionTaskDescriptorStorageMaxMemory(DataSize.of((long)3L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setFaultTolerantExecutionPartitionCount(123).setFaultTolerantPreserveInputPartitionsInWriteStage(false);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

