/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.trino.execution.BaseDataDefinitionTaskTest;
import io.trino.execution.RenameMaterializedViewTask;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.RenameMaterializedView;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestRenameMaterializedViewTask
extends BaseDataDefinitionTaskTest {
    @Test
    public void testRenameExistingMaterializedView() {
        QualifiedObjectName materializedViewName = TestRenameMaterializedViewTask.qualifiedObjectName("existing_materialized_view");
        QualifiedObjectName newMaterializedViewName = TestRenameMaterializedViewTask.qualifiedObjectName("existing_materialized_view_new");
        this.metadata.createMaterializedView(this.testSession, materializedViewName, this.someMaterializedView(), false, false);
        MoreFutures.getFutureValue(this.executeRenameMaterializedView(TestRenameMaterializedViewTask.asQualifiedName(materializedViewName), TestRenameMaterializedViewTask.asQualifiedName(newMaterializedViewName)));
        Assertions.assertThat((boolean)this.metadata.isMaterializedView(this.testSession, materializedViewName)).isFalse();
        Assertions.assertThat((boolean)this.metadata.isMaterializedView(this.testSession, newMaterializedViewName)).isTrue();
    }

    @Test
    public void testRenameNotExistingMaterializedView() {
        QualifiedName materializedViewName = TestRenameMaterializedViewTask.qualifiedName("not_existing_materialized_view");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameMaterializedView(materializedViewName, TestRenameMaterializedViewTask.qualifiedName("not_existing_materialized_view_new")))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND).hasMessage("Materialized View '%s' does not exist", new Object[]{materializedViewName});
    }

    @Test
    public void testRenameNotExistingMaterializedViewIfExists() {
        QualifiedName materializedViewName = TestRenameMaterializedViewTask.qualifiedName("not_existing_materialized_view");
        MoreFutures.getFutureValue(this.executeRenameMaterializedView(materializedViewName, TestRenameMaterializedViewTask.qualifiedName("not_existing_materialized_view_new"), true));
    }

    @Test
    public void testRenameMaterializedViewOnTable() {
        QualifiedObjectName tableName = TestRenameMaterializedViewTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "catalog", TestRenameMaterializedViewTask.someTable(tableName), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameMaterializedView(TestRenameMaterializedViewTask.asQualifiedName(tableName), TestRenameMaterializedViewTask.qualifiedName("existing_table_new")))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND).hasMessage("Materialized View '%s' does not exist, but a table with that name exists. Did you mean ALTER TABLE %s RENAME TO ...?", new Object[]{tableName, tableName});
    }

    @Test
    public void testRenameMaterializedViewOnTableIfExists() {
        QualifiedObjectName tableName = TestRenameMaterializedViewTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "catalog", TestRenameMaterializedViewTask.someTable(tableName), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameMaterializedView(TestRenameMaterializedViewTask.asQualifiedName(tableName), TestRenameMaterializedViewTask.qualifiedName("existing_table_new"), true))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND).hasMessage("Materialized View '%s' does not exist, but a table with that name exists. Did you mean ALTER TABLE %s RENAME TO ...?", new Object[]{tableName, tableName});
    }

    @Test
    public void testRenameMaterializedViewTargetTableExists() {
        QualifiedObjectName materializedViewName = TestRenameMaterializedViewTask.qualifiedObjectName("existing_materialized_view");
        this.metadata.createMaterializedView(this.testSession, materializedViewName, this.someMaterializedView(), false, false);
        QualifiedObjectName tableName = TestRenameMaterializedViewTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "catalog", TestRenameMaterializedViewTask.someTable(tableName), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameMaterializedView(TestRenameMaterializedViewTask.asQualifiedName(materializedViewName), TestRenameMaterializedViewTask.asQualifiedName(tableName)))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TABLE_ALREADY_EXISTS).hasMessage("Target materialized view '%s' does not exist, but a table with that name exists.", new Object[]{tableName});
    }

    @Test
    public void testRenameMaterializedViewOnView() {
        QualifiedName viewName = TestRenameMaterializedViewTask.qualifiedName("existing_view");
        this.metadata.createView(this.testSession, QualifiedObjectName.valueOf((String)viewName.toString()), TestRenameMaterializedViewTask.someView(), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameMaterializedView(viewName, TestRenameMaterializedViewTask.qualifiedName("existing_view_new")))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND).hasMessage("Materialized View '%s' does not exist, but a view with that name exists. Did you mean ALTER VIEW catalog.schema.existing_view RENAME TO ...?", new Object[]{viewName});
    }

    @Test
    public void testRenameMaterializedViewOnViewIfExists() {
        QualifiedName viewName = TestRenameMaterializedViewTask.qualifiedName("existing_view");
        this.metadata.createView(this.testSession, QualifiedObjectName.valueOf((String)viewName.toString()), TestRenameMaterializedViewTask.someView(), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameMaterializedView(viewName, TestRenameMaterializedViewTask.qualifiedName("existing_view_new"), true))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND).hasMessage("Materialized View '%s' does not exist, but a view with that name exists. Did you mean ALTER VIEW catalog.schema.existing_view RENAME TO ...?", new Object[]{viewName});
    }

    @Test
    public void testRenameMaterializedViewTargetViewExists() {
        QualifiedObjectName materializedViewName = TestRenameMaterializedViewTask.qualifiedObjectName("existing_materialized_view");
        this.metadata.createMaterializedView(this.testSession, materializedViewName, this.someMaterializedView(), false, false);
        QualifiedName viewName = TestRenameMaterializedViewTask.qualifiedName("existing_view");
        this.metadata.createView(this.testSession, QualifiedObjectName.valueOf((String)viewName.toString()), TestRenameMaterializedViewTask.someView(), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameMaterializedView(TestRenameMaterializedViewTask.asQualifiedName(materializedViewName), viewName))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TABLE_ALREADY_EXISTS).hasMessage("Target materialized view '%s' does not exist, but a view with that name exists.", new Object[]{viewName});
    }

    private ListenableFuture<Void> executeRenameMaterializedView(QualifiedName source, QualifiedName target) {
        return this.executeRenameMaterializedView(source, target, false);
    }

    private ListenableFuture<Void> executeRenameMaterializedView(QualifiedName source, QualifiedName target, boolean exists) {
        return new RenameMaterializedViewTask((Metadata)this.metadata, (AccessControl)new AllowAllAccessControl()).execute(new RenameMaterializedView(source, target, exists), this.queryStateMachine, (List)ImmutableList.of(), WarningCollector.NOOP);
    }
}

