/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.trino.execution.BaseDataDefinitionTaskTest;
import io.trino.execution.RenameViewTask;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.RenameView;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestRenameViewTask
extends BaseDataDefinitionTaskTest {
    @Test
    public void testRenameExistingView() {
        QualifiedObjectName viewName = TestRenameViewTask.qualifiedObjectName("existing_view");
        QualifiedObjectName newViewName = TestRenameViewTask.qualifiedObjectName("existing_view_new");
        this.metadata.createView(this.testSession, viewName, TestRenameViewTask.someView(), false);
        MoreFutures.getFutureValue(this.executeRenameView(TestRenameViewTask.asQualifiedName(viewName), TestRenameViewTask.asQualifiedName(newViewName)));
        Assertions.assertThat((boolean)this.metadata.isView(this.testSession, viewName)).isFalse();
        Assertions.assertThat((boolean)this.metadata.isView(this.testSession, newViewName)).isTrue();
    }

    @Test
    public void testRenameNotExistingView() {
        QualifiedName viewName = TestRenameViewTask.qualifiedName("not_existing_view");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameView(viewName, TestRenameViewTask.qualifiedName("not_existing_view_new")))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND).hasMessage("View '%s' does not exist", new Object[]{viewName});
    }

    @Test
    public void testRenameViewOnTable() {
        QualifiedObjectName tableName = TestRenameViewTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "catalog", TestRenameViewTask.someTable(tableName), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameView(TestRenameViewTask.asQualifiedName(tableName), TestRenameViewTask.qualifiedName("existing_table_new")))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND).hasMessage("View '%s' does not exist, but a table with that name exists. Did you mean ALTER TABLE %s RENAME TO ...?", new Object[]{tableName, tableName});
    }

    @Test
    public void testRenameViewOnMaterializedView() {
        QualifiedName viewName = TestRenameViewTask.qualifiedName("existing_materialized_view");
        this.metadata.createMaterializedView(this.testSession, QualifiedObjectName.valueOf((String)viewName.toString()), this.someMaterializedView(), false, false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameView(viewName, TestRenameViewTask.qualifiedName("existing_materialized_view_new")))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND).hasMessage("View '%s' does not exist, but a materialized view with that name exists. Did you mean ALTER MATERIALIZED VIEW catalog.schema.existing_materialized_view RENAME TO ...?", new Object[]{viewName});
    }

    @Test
    public void testRenameViewTargetTableExists() {
        QualifiedName viewName = TestRenameViewTask.qualifiedName("existing_view");
        this.metadata.createView(this.testSession, QualifiedObjectName.valueOf((String)viewName.toString()), TestRenameViewTask.someView(), false);
        QualifiedObjectName tableName = TestRenameViewTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "catalog", TestRenameViewTask.someTable(tableName), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameView(viewName, TestRenameViewTask.asQualifiedName(tableName)))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TABLE_ALREADY_EXISTS).hasMessage("Target view '%s' does not exist, but a table with that name exists.", new Object[]{tableName});
    }

    @Test
    public void testRenameViewTargetMaterializedViewExists() {
        QualifiedName viewName = TestRenameViewTask.qualifiedName("existing_view");
        this.metadata.createView(this.testSession, QualifiedObjectName.valueOf((String)viewName.toString()), TestRenameViewTask.someView(), false);
        QualifiedObjectName materializedViewName = TestRenameViewTask.qualifiedObjectName("existing_materialized_view");
        this.metadata.createMaterializedView(this.testSession, materializedViewName, this.someMaterializedView(), false, false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameView(viewName, TestRenameViewTask.asQualifiedName(materializedViewName)))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR).hasMessage("Target view '%s' does not exist, but a materialized view with that name exists.", new Object[]{materializedViewName});
    }

    @Test
    public void testRenameViewTargetViewExists() {
        QualifiedName viewName = TestRenameViewTask.qualifiedName("existing_view");
        this.metadata.createView(this.testSession, QualifiedObjectName.valueOf((String)viewName.toString()), TestRenameViewTask.someView(), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameView(viewName, viewName))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR).hasMessage("Target view '%s' already exists", new Object[]{viewName});
    }

    private ListenableFuture<Void> executeRenameView(QualifiedName source, QualifiedName target) {
        return new RenameViewTask((Metadata)this.metadata, (AccessControl)new AllowAllAccessControl()).execute(new RenameView(source, target), this.queryStateMachine, (List)ImmutableList.of(), WarningCollector.NOOP);
    }
}

