/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.block.BlockAssertions;
import io.trino.execution.buffer.BufferInfo;
import io.trino.execution.buffer.BufferResult;
import io.trino.execution.buffer.BufferState;
import io.trino.execution.buffer.OutputBuffer;
import io.trino.execution.buffer.OutputBufferInfo;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.execution.buffer.PageBufferInfo;
import io.trino.execution.buffer.PagesSerde;
import io.trino.execution.buffer.TestingPagesSerdeFactory;
import io.trino.operator.PageAssertions;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;

public final class BufferTestUtils {
    private static final PagesSerde PAGES_SERDE = TestingPagesSerdeFactory.testingPagesSerde();
    static final Duration NO_WAIT = new Duration(0.0, TimeUnit.MILLISECONDS);
    static final Duration MAX_WAIT = new Duration(1.0, TimeUnit.SECONDS);
    private static final DataSize BUFFERED_PAGE_SIZE = DataSize.ofBytes((long)BufferTestUtils.serializePage(BufferTestUtils.createPage(42)).getRetainedSize());

    private BufferTestUtils() {
    }

    static BufferResult getFuture(ListenableFuture<BufferResult> future, Duration maxWait) {
        Optional bufferResult = MoreFutures.tryGetFutureValue(future, (int)((int)maxWait.toMillis()), (TimeUnit)TimeUnit.MILLISECONDS);
        Preconditions.checkArgument((boolean)bufferResult.isPresent(), (Object)"bufferResult is empty");
        return (BufferResult)bufferResult.get();
    }

    static void assertBufferResultEquals(List<? extends Type> types, BufferResult actual, BufferResult expected) {
        Assert.assertEquals((int)actual.getSerializedPages().size(), (int)expected.getSerializedPages().size(), (String)"page count");
        Assert.assertEquals((long)actual.getToken(), (long)expected.getToken(), (String)"token");
        for (int i = 0; i < actual.getSerializedPages().size(); ++i) {
            Page actualPage = PAGES_SERDE.deserialize((Slice)actual.getSerializedPages().get(i));
            Page expectedPage = PAGES_SERDE.deserialize((Slice)expected.getSerializedPages().get(i));
            Assert.assertEquals((int)actualPage.getChannelCount(), (int)expectedPage.getChannelCount());
            PageAssertions.assertPageEquals(types, actualPage, expectedPage);
        }
        Assert.assertEquals((boolean)actual.isBufferComplete(), (boolean)expected.isBufferComplete(), (String)"buffer complete");
    }

    static BufferResult createBufferResult(String bufferId, long token, List<Page> pages) {
        Preconditions.checkArgument((!pages.isEmpty() ? 1 : 0) != 0, (Object)"pages is empty");
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)pages.size());
        try (PagesSerde.PagesSerdeContext context = PAGES_SERDE.newContext();){
            for (Page p : pages) {
                builder.add((Object)PAGES_SERDE.serialize(context, p));
            }
        }
        return new BufferResult(bufferId, token, token + (long)pages.size(), false, (List)builder.build());
    }

    public static Page createPage(int i) {
        return new Page(new Block[]{BlockAssertions.createLongsBlock(i)});
    }

    static Slice serializePage(Page page) {
        try (PagesSerde.PagesSerdeContext context = PAGES_SERDE.newContext();){
            Slice slice = PAGES_SERDE.serialize(context, page);
            return slice;
        }
    }

    static DataSize sizeOfPages(int count) {
        return DataSize.ofBytes((long)(BUFFERED_PAGE_SIZE.toBytes() * (long)count));
    }

    static BufferResult getBufferResult(OutputBuffer buffer, OutputBuffers.OutputBufferId bufferId, long sequenceId, DataSize maxSize, Duration maxWait) {
        ListenableFuture future = buffer.get(bufferId, sequenceId, maxSize);
        return BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, maxWait);
    }

    static void acknowledgeBufferResult(OutputBuffer buffer, OutputBuffers.OutputBufferId bufferId, long sequenceId) {
        buffer.acknowledge(bufferId, sequenceId);
    }

    static ListenableFuture<Void> enqueuePage(OutputBuffer buffer, Page page) {
        buffer.enqueue((List)ImmutableList.of((Object)BufferTestUtils.serializePage(page)));
        ListenableFuture future = buffer.isFull();
        Assert.assertFalse((boolean)future.isDone());
        return future;
    }

    static ListenableFuture<Void> enqueuePage(OutputBuffer buffer, Page page, int partition) {
        buffer.enqueue(partition, (List)ImmutableList.of((Object)BufferTestUtils.serializePage(page)));
        ListenableFuture future = buffer.isFull();
        Assert.assertFalse((boolean)future.isDone());
        return future;
    }

    public static void addPage(OutputBuffer buffer, Page page) {
        buffer.enqueue((List)ImmutableList.of((Object)BufferTestUtils.serializePage(page)));
        Assert.assertTrue((boolean)buffer.isFull().isDone(), (String)"Expected add page to not block");
    }

    public static void addPage(OutputBuffer buffer, Page page, int partition) {
        buffer.enqueue(partition, (List)ImmutableList.of((Object)BufferTestUtils.serializePage(page)));
        Assert.assertTrue((boolean)buffer.isFull().isDone(), (String)"Expected add page to not block");
    }

    static void assertQueueState(OutputBuffer buffer, OutputBuffers.OutputBufferId bufferId, int bufferedPages, int pagesSent) {
        Assert.assertEquals((Object)BufferTestUtils.getBufferInfo(buffer, bufferId), (Object)new BufferInfo(bufferId, false, bufferedPages, (long)pagesSent, new PageBufferInfo(bufferId.getId(), (long)bufferedPages, BufferTestUtils.sizeOfPages(bufferedPages).toBytes(), (long)(bufferedPages + pagesSent), (long)(bufferedPages + pagesSent))));
    }

    static void assertQueueState(OutputBuffer buffer, int unassignedPages, OutputBuffers.OutputBufferId bufferId, int bufferedPages, int pagesSent) {
        OutputBufferInfo outputBufferInfo = buffer.getInfo();
        long assignedPages = outputBufferInfo.getBuffers().stream().mapToInt(BufferInfo::getBufferedPages).sum();
        Assert.assertEquals((long)(outputBufferInfo.getTotalBufferedPages() - assignedPages), (long)unassignedPages, (String)"unassignedPages");
        BufferInfo bufferInfo = outputBufferInfo.getBuffers().stream().filter(info -> info.getBufferId().equals((Object)bufferId)).findAny().orElse(null);
        Assert.assertEquals((Object)bufferInfo, (Object)new BufferInfo(bufferId, false, bufferedPages, (long)pagesSent, new PageBufferInfo(bufferId.getId(), (long)bufferedPages, BufferTestUtils.sizeOfPages(bufferedPages).toBytes(), (long)(bufferedPages + pagesSent), (long)(bufferedPages + pagesSent))));
    }

    static void assertQueueClosed(OutputBuffer buffer, OutputBuffers.OutputBufferId bufferId, int pagesSent) {
        BufferInfo bufferInfo = BufferTestUtils.getBufferInfo(buffer, bufferId);
        Assert.assertEquals((int)bufferInfo.getBufferedPages(), (int)0);
        Assert.assertEquals((long)bufferInfo.getPagesSent(), (long)pagesSent);
        Assert.assertEquals((boolean)bufferInfo.isFinished(), (boolean)true);
    }

    static void assertQueueClosed(OutputBuffer buffer, int unassignedPages, OutputBuffers.OutputBufferId bufferId, int pagesSent) {
        OutputBufferInfo outputBufferInfo = buffer.getInfo();
        long assignedPages = outputBufferInfo.getBuffers().stream().mapToInt(BufferInfo::getBufferedPages).sum();
        Assert.assertEquals((long)(outputBufferInfo.getTotalBufferedPages() - assignedPages), (long)unassignedPages, (String)"unassignedPages");
        BufferInfo bufferInfo = outputBufferInfo.getBuffers().stream().filter(info -> info.getBufferId().equals((Object)bufferId)).findAny().orElse(null);
        Assert.assertEquals((int)bufferInfo.getBufferedPages(), (int)0);
        Assert.assertEquals((long)bufferInfo.getPagesSent(), (long)pagesSent);
        Assert.assertEquals((boolean)bufferInfo.isFinished(), (boolean)true);
    }

    static void assertFinished(OutputBuffer buffer) {
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.FINISHED);
        for (BufferInfo bufferInfo : buffer.getInfo().getBuffers()) {
            Assert.assertTrue((boolean)bufferInfo.isFinished());
            Assert.assertEquals((int)bufferInfo.getBufferedPages(), (int)0);
        }
    }

    static void assertFutureIsDone(Future<?> future) {
        MoreFutures.tryGetFutureValue(future, (int)5, (TimeUnit)TimeUnit.SECONDS);
        Assert.assertTrue((boolean)future.isDone());
    }

    private static BufferInfo getBufferInfo(OutputBuffer buffer, OutputBuffers.OutputBufferId bufferId) {
        for (BufferInfo bufferInfo : buffer.getInfo().getBuffers()) {
            if (!bufferInfo.getBufferId().equals((Object)bufferId)) continue;
            return bufferInfo;
        }
        return null;
    }
}

