/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import io.airlift.compress.Compressor;
import io.airlift.compress.Decompressor;
import io.airlift.compress.lz4.Lz4Compressor;
import io.airlift.compress.lz4.Lz4Decompressor;
import io.airlift.slice.Slice;
import io.trino.execution.buffer.PagesSerde;
import io.trino.execution.buffer.PagesSerdeFactory;
import io.trino.metadata.BlockEncodingManager;
import io.trino.metadata.InternalBlockEncodingSerde;
import io.trino.spi.Page;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spiller.SpillCipher;
import io.trino.type.InternalTypeManager;
import java.util.Optional;

public class TestingPagesSerdeFactory
extends PagesSerdeFactory {
    private static final InternalBlockEncodingSerde BLOCK_ENCODING_SERDE = new InternalBlockEncodingSerde(new BlockEncodingManager(), InternalTypeManager.TESTING_TYPE_MANAGER);

    public TestingPagesSerdeFactory() {
        super((BlockEncodingSerde)BLOCK_ENCODING_SERDE, true);
    }

    public static PagesSerde testingPagesSerde() {
        return new SynchronizedPagesSerde((BlockEncodingSerde)BLOCK_ENCODING_SERDE, Optional.of(new Lz4Compressor()), Optional.of(new Lz4Decompressor()), Optional.empty());
    }

    private static class SynchronizedPagesSerde
    extends PagesSerde {
        public SynchronizedPagesSerde(BlockEncodingSerde blockEncodingSerde, Optional<Compressor> compressor, Optional<Decompressor> decompressor, Optional<SpillCipher> spillCipher) {
            super(blockEncodingSerde, compressor, decompressor, spillCipher);
        }

        public synchronized Slice serialize(PagesSerde.PagesSerdeContext context, Page page) {
            return super.serialize(context, page);
        }

        public synchronized Page deserialize(Slice serializedPage) {
            return super.deserialize(serializedPage);
        }

        public synchronized Page deserialize(PagesSerde.PagesSerdeContext context, Slice page) {
            return super.deserialize(context, page);
        }
    }
}

