/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.client.NodeVersion;
import io.trino.connector.CatalogName;
import io.trino.execution.scheduler.BinPackingNodeAllocatorService;
import io.trino.execution.scheduler.PartitionMemoryEstimator;
import io.trino.memory.MemoryInfo;
import io.trino.metadata.InMemoryNodeManager;
import io.trino.metadata.InternalNode;
import io.trino.metadata.InternalNodeManager;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.memory.MemoryPoolInfo;
import io.trino.testing.TestingSession;
import java.net.URI;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestExponentialGrowthPartitionMemoryEstimator {
    @Test
    public void testEstimator() throws Exception {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        nodeManager.addNode(new CatalogName("catalog"), new InternalNode[]{new InternalNode("a-node", URI.create("local://blah"), NodeVersion.UNKNOWN, false)});
        BinPackingNodeAllocatorService nodeAllocatorService = new BinPackingNodeAllocatorService((InternalNodeManager)nodeManager, () -> ImmutableMap.of((Object)new InternalNode("a-node", URI.create("local://blah"), NodeVersion.UNKNOWN, false).getNodeIdentifier(), Optional.of(this.buildWorkerMemoryInfo(DataSize.ofBytes((long)0L)))), false, Duration.of(1L, ChronoUnit.MINUTES), DataSize.ofBytes((long)0L), Ticker.systemTicker());
        nodeAllocatorService.refreshNodePoolMemoryInfos();
        PartitionMemoryEstimator estimator = nodeAllocatorService.createPartitionMemoryEstimator();
        Session session = TestingSession.testSessionBuilder().build();
        Assertions.assertThat((Object)estimator.getInitialMemoryRequirements(session, DataSize.of((long)107L, (DataSize.Unit)DataSize.Unit.MEGABYTE))).isEqualTo((Object)new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)107L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false));
        Assertions.assertThat((Object)estimator.getNextRetryMemoryRequirements(session, new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false), DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.MEGABYTE), StandardErrorCode.CORRUPT_PAGE.toErrorCode())).isEqualTo((Object)new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false));
        Assertions.assertThat((Object)estimator.getNextRetryMemoryRequirements(session, new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false), DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.MEGABYTE), StandardErrorCode.CLUSTER_OUT_OF_MEMORY.toErrorCode())).isEqualTo((Object)new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)150L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false));
        Assertions.assertThat((Object)estimator.getNextRetryMemoryRequirements(session, new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false), DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.MEGABYTE), StandardErrorCode.EXCEEDED_LOCAL_MEMORY_LIMIT.toErrorCode())).isEqualTo((Object)new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)150L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false));
        Assertions.assertThat((Object)estimator.getNextRetryMemoryRequirements(session, new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false), DataSize.of((long)70L, (DataSize.Unit)DataSize.Unit.MEGABYTE), StandardErrorCode.CORRUPT_PAGE.toErrorCode())).isEqualTo((Object)new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)70L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false));
        Assertions.assertThat((Object)estimator.getNextRetryMemoryRequirements(session, new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false), DataSize.of((long)70L, (DataSize.Unit)DataSize.Unit.MEGABYTE), StandardErrorCode.EXCEEDED_LOCAL_MEMORY_LIMIT.toErrorCode())).isEqualTo((Object)new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)210L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false));
        estimator.registerPartitionFinished(session, new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false), DataSize.of((long)1000L, (DataSize.Unit)DataSize.Unit.MEGABYTE), true, Optional.empty());
        estimator.registerPartitionFinished(session, new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false), DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE), true, Optional.empty());
        estimator.registerPartitionFinished(session, new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false), DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE), true, Optional.empty());
        estimator.registerPartitionFinished(session, new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false), DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE), true, Optional.empty());
        estimator.registerPartitionFinished(session, new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false), DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE), true, Optional.empty());
        estimator.registerPartitionFinished(session, new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false), DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE), true, Optional.empty());
        estimator.registerPartitionFinished(session, new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false), DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE), true, Optional.empty());
        estimator.registerPartitionFinished(session, new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false), DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE), true, Optional.empty());
        estimator.registerPartitionFinished(session, new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false), DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE), true, Optional.empty());
        estimator.registerPartitionFinished(session, new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false), DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE), true, Optional.empty());
        estimator.registerPartitionFinished(session, new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false), DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE), true, Optional.empty());
        Assertions.assertThat((Object)estimator.getInitialMemoryRequirements(session, DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE))).isEqualTo((Object)new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false));
        Assertions.assertThat((Object)estimator.getInitialMemoryRequirements(session, DataSize.of((long)500L, (DataSize.Unit)DataSize.Unit.MEGABYTE))).isEqualTo((Object)new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)500L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false));
        Assertions.assertThat((Object)estimator.getNextRetryMemoryRequirements(session, new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false), DataSize.of((long)70L, (DataSize.Unit)DataSize.Unit.MEGABYTE), StandardErrorCode.EXCEEDED_LOCAL_MEMORY_LIMIT.toErrorCode())).isEqualTo((Object)new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false));
        estimator.registerPartitionFinished(session, new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false), DataSize.of((long)200L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false, Optional.of(StandardErrorCode.EXCEEDED_LOCAL_MEMORY_LIMIT.toErrorCode()));
        estimator.registerPartitionFinished(session, new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false), DataSize.of((long)200L, (DataSize.Unit)DataSize.Unit.MEGABYTE), true, Optional.of(StandardErrorCode.CLUSTER_OUT_OF_MEMORY.toErrorCode()));
        Assertions.assertThat((Object)estimator.getInitialMemoryRequirements(session, DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE))).isEqualTo((Object)new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)600L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false));
        estimator.registerPartitionFinished(session, new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false), DataSize.of((long)200L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false, Optional.of(StandardErrorCode.EXCEEDED_LOCAL_MEMORY_LIMIT.toErrorCode()));
        estimator.registerPartitionFinished(session, new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false), DataSize.of((long)200L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false, Optional.of(StandardErrorCode.EXCEEDED_LOCAL_MEMORY_LIMIT.toErrorCode()));
        estimator.registerPartitionFinished(session, new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false), DataSize.of((long)200L, (DataSize.Unit)DataSize.Unit.MEGABYTE), true, Optional.of(StandardErrorCode.CLUSTER_OUT_OF_MEMORY.toErrorCode()));
        Assertions.assertThat((Object)estimator.getInitialMemoryRequirements(session, DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE))).isEqualTo((Object)new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)900L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false));
        estimator.registerPartitionFinished(session, new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false), DataSize.of((long)500L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false, Optional.of(StandardErrorCode.ADMINISTRATIVELY_PREEMPTED.toErrorCode()));
        estimator.registerPartitionFinished(session, new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false), DataSize.of((long)500L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false, Optional.of(StandardErrorCode.ADMINISTRATIVELY_PREEMPTED.toErrorCode()));
        estimator.registerPartitionFinished(session, new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false), DataSize.of((long)500L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false, Optional.of(StandardErrorCode.ADMINISTRATIVELY_PREEMPTED.toErrorCode()));
        estimator.registerPartitionFinished(session, new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false), DataSize.of((long)500L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false, Optional.of(StandardErrorCode.ADMINISTRATIVELY_PREEMPTED.toErrorCode()));
        estimator.registerPartitionFinished(session, new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false), DataSize.of((long)500L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false, Optional.of(StandardErrorCode.ADMINISTRATIVELY_PREEMPTED.toErrorCode()));
        Assertions.assertThat((Object)estimator.getInitialMemoryRequirements(session, DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE))).isEqualTo((Object)new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)900L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false));
    }

    private MemoryInfo buildWorkerMemoryInfo(DataSize usedMemory) {
        return new MemoryInfo(4, new MemoryPoolInfo(DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.GIGABYTE).toBytes(), usedMemory.toBytes(), 0L, (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of()));
    }
}

