/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.client.NodeVersion;
import io.trino.connector.CatalogName;
import io.trino.execution.scheduler.FixedCountNodeAllocatorService;
import io.trino.execution.scheduler.NodeAllocator;
import io.trino.execution.scheduler.NodeRequirements;
import io.trino.execution.scheduler.NodeScheduler;
import io.trino.execution.scheduler.NodeSelectorFactory;
import io.trino.execution.scheduler.TestingNodeSelectorFactory;
import io.trino.metadata.InternalNode;
import io.trino.spi.HostAddress;
import io.trino.testing.TestingSession;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestFixedCountNodeAllocator {
    private static final Session SESSION = TestingSession.testSessionBuilder().build();
    private static final HostAddress NODE_1_ADDRESS = HostAddress.fromParts((String)"127.0.0.1", (int)8080);
    private static final HostAddress NODE_2_ADDRESS = HostAddress.fromParts((String)"127.0.0.1", (int)8081);
    private static final HostAddress NODE_3_ADDRESS = HostAddress.fromParts((String)"127.0.0.1", (int)8082);
    private static final InternalNode NODE_1 = new InternalNode("node-1", URI.create("local://" + NODE_1_ADDRESS), NodeVersion.UNKNOWN, false);
    private static final InternalNode NODE_2 = new InternalNode("node-2", URI.create("local://" + NODE_2_ADDRESS), NodeVersion.UNKNOWN, false);
    private static final InternalNode NODE_3 = new InternalNode("node-3", URI.create("local://" + NODE_3_ADDRESS), NodeVersion.UNKNOWN, false);
    private static final CatalogName CATALOG_1 = new CatalogName("catalog1");
    private static final CatalogName CATALOG_2 = new CatalogName("catalog2");
    private static final DataSize MEMORY_REQUIREMENTS = DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
    private FixedCountNodeAllocatorService nodeAllocatorService;

    private void setupNodeAllocatorService(TestingNodeSelectorFactory.TestingNodeSupplier testingNodeSupplier) {
        this.shutdownNodeAllocatorService();
        this.nodeAllocatorService = new FixedCountNodeAllocatorService(new NodeScheduler((NodeSelectorFactory)new TestingNodeSelectorFactory(NODE_1, testingNodeSupplier)));
    }

    @AfterMethod(alwaysRun=true)
    public void shutdownNodeAllocatorService() {
        if (this.nodeAllocatorService != null) {
            this.nodeAllocatorService.stop();
        }
        this.nodeAllocatorService = null;
    }

    @Test
    public void testSingleNode() throws Exception {
        NodeAllocator.NodeLease acquire2;
        NodeAllocator.NodeLease acquire1;
        TestingNodeSelectorFactory.TestingNodeSupplier nodeSupplier = TestingNodeSelectorFactory.TestingNodeSupplier.create((Map<InternalNode, List<CatalogName>>)ImmutableMap.of((Object)NODE_1, (Object)ImmutableList.of()));
        this.setupNodeAllocatorService(nodeSupplier);
        try (NodeAllocator nodeAllocator = this.nodeAllocatorService.getNodeAllocator(SESSION, 1);){
            acquire1 = nodeAllocator.acquire(new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertTrue((boolean)acquire1.getNode().isDone());
            Assert.assertEquals((Object)acquire1.getNode().get(), (Object)NODE_1);
            acquire2 = nodeAllocator.acquire(new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertFalse((boolean)acquire2.getNode().isDone());
            acquire1.release();
            Assert.assertTrue((boolean)acquire2.getNode().isDone());
            Assert.assertEquals((Object)acquire2.getNode().get(), (Object)NODE_1);
        }
        nodeAllocator = this.nodeAllocatorService.getNodeAllocator(SESSION, 2);
        try {
            acquire1 = nodeAllocator.acquire(new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertTrue((boolean)acquire1.getNode().isDone());
            Assert.assertEquals((Object)acquire1.getNode().get(), (Object)NODE_1);
            acquire2 = nodeAllocator.acquire(new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertTrue((boolean)acquire2.getNode().isDone());
            Assert.assertEquals((Object)acquire2.getNode().get(), (Object)NODE_1);
            NodeAllocator.NodeLease acquire3 = nodeAllocator.acquire(new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertFalse((boolean)acquire3.getNode().isDone());
            NodeAllocator.NodeLease acquire4 = nodeAllocator.acquire(new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertFalse((boolean)acquire4.getNode().isDone());
            acquire2.release();
            Assert.assertTrue((boolean)acquire3.getNode().isDone());
            Assert.assertEquals((Object)acquire3.getNode().get(), (Object)NODE_1);
            acquire3.release();
            Assert.assertTrue((boolean)acquire4.getNode().isDone());
            Assert.assertEquals((Object)acquire4.getNode().get(), (Object)NODE_1);
        }
        finally {
            if (nodeAllocator != null) {
                nodeAllocator.close();
            }
        }
    }

    @Test
    public void testMultipleNodes() throws Exception {
        NodeAllocator.NodeLease acquire5;
        NodeAllocator.NodeLease acquire4;
        NodeAllocator.NodeLease acquire3;
        NodeAllocator.NodeLease acquire2;
        NodeAllocator.NodeLease acquire1;
        TestingNodeSelectorFactory.TestingNodeSupplier nodeSupplier = TestingNodeSelectorFactory.TestingNodeSupplier.create((Map<InternalNode, List<CatalogName>>)ImmutableMap.of((Object)NODE_1, (Object)ImmutableList.of(), (Object)NODE_2, (Object)ImmutableList.of()));
        this.setupNodeAllocatorService(nodeSupplier);
        try (NodeAllocator nodeAllocator = this.nodeAllocatorService.getNodeAllocator(SESSION, 1);){
            acquire1 = nodeAllocator.acquire(new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertTrue((boolean)acquire1.getNode().isDone());
            Assert.assertEquals((Object)acquire1.getNode().get(), (Object)NODE_1);
            acquire2 = nodeAllocator.acquire(new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertTrue((boolean)acquire2.getNode().isDone());
            Assert.assertEquals((Object)acquire2.getNode().get(), (Object)NODE_2);
            acquire3 = nodeAllocator.acquire(new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertFalse((boolean)acquire3.getNode().isDone());
            acquire4 = nodeAllocator.acquire(new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertFalse((boolean)acquire4.getNode().isDone());
            acquire5 = nodeAllocator.acquire(new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertFalse((boolean)acquire5.getNode().isDone());
            acquire2.release();
            Assert.assertTrue((boolean)acquire3.getNode().isDone());
            Assert.assertEquals((Object)acquire3.getNode().get(), (Object)NODE_2);
            acquire1.release();
            Assert.assertTrue((boolean)acquire4.getNode().isDone());
            Assert.assertEquals((Object)acquire4.getNode().get(), (Object)NODE_1);
            acquire4.release();
            Assert.assertTrue((boolean)acquire5.getNode().isDone());
            Assert.assertEquals((Object)acquire5.getNode().get(), (Object)NODE_1);
        }
        nodeAllocator = this.nodeAllocatorService.getNodeAllocator(SESSION, 2);
        try {
            acquire1 = nodeAllocator.acquire(new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertTrue((boolean)acquire1.getNode().isDone());
            Assert.assertEquals((Object)acquire1.getNode().get(), (Object)NODE_1);
            acquire2 = nodeAllocator.acquire(new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertTrue((boolean)acquire2.getNode().isDone());
            Assert.assertEquals((Object)acquire2.getNode().get(), (Object)NODE_2);
            acquire3 = nodeAllocator.acquire(new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertTrue((boolean)acquire3.getNode().isDone());
            Assert.assertEquals((Object)acquire3.getNode().get(), (Object)NODE_1);
            acquire4 = nodeAllocator.acquire(new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertTrue((boolean)acquire4.getNode().isDone());
            Assert.assertEquals((Object)acquire4.getNode().get(), (Object)NODE_2);
            acquire5 = nodeAllocator.acquire(new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertFalse((boolean)acquire5.getNode().isDone());
            NodeAllocator.NodeLease acquire6 = nodeAllocator.acquire(new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertFalse((boolean)acquire6.getNode().isDone());
            acquire4.release();
            Assert.assertTrue((boolean)acquire5.getNode().isDone());
            Assert.assertEquals((Object)acquire5.getNode().get(), (Object)NODE_2);
            acquire3.release();
            Assert.assertTrue((boolean)acquire6.getNode().isDone());
            Assert.assertEquals((Object)acquire6.getNode().get(), (Object)NODE_1);
            NodeAllocator.NodeLease acquire7 = nodeAllocator.acquire(new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertFalse((boolean)acquire7.getNode().isDone());
            acquire6.release();
            Assert.assertTrue((boolean)acquire7.getNode().isDone());
            Assert.assertEquals((Object)acquire7.getNode().get(), (Object)NODE_1);
            acquire7.release();
            acquire5.release();
            acquire2.release();
            NodeAllocator.NodeLease acquire8 = nodeAllocator.acquire(new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertTrue((boolean)acquire8.getNode().isDone());
            Assert.assertEquals((Object)acquire8.getNode().get(), (Object)NODE_2);
        }
        finally {
            if (nodeAllocator != null) {
                nodeAllocator.close();
            }
        }
    }

    @Test
    public void testCatalogRequirement() throws Exception {
        TestingNodeSelectorFactory.TestingNodeSupplier nodeSupplier = TestingNodeSelectorFactory.TestingNodeSupplier.create((Map<InternalNode, List<CatalogName>>)ImmutableMap.of((Object)NODE_1, (Object)ImmutableList.of((Object)CATALOG_1), (Object)NODE_2, (Object)ImmutableList.of((Object)CATALOG_2), (Object)NODE_3, (Object)ImmutableList.of((Object)CATALOG_1, (Object)CATALOG_2)));
        this.setupNodeAllocatorService(nodeSupplier);
        try (NodeAllocator nodeAllocator = this.nodeAllocatorService.getNodeAllocator(SESSION, 1);){
            NodeAllocator.NodeLease catalog1acquire1 = nodeAllocator.acquire(new NodeRequirements(Optional.of(CATALOG_1), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertTrue((boolean)catalog1acquire1.getNode().isDone());
            Assert.assertEquals((Object)catalog1acquire1.getNode().get(), (Object)NODE_1);
            NodeAllocator.NodeLease catalog1acquire2 = nodeAllocator.acquire(new NodeRequirements(Optional.of(CATALOG_1), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertTrue((boolean)catalog1acquire2.getNode().isDone());
            Assert.assertEquals((Object)catalog1acquire2.getNode().get(), (Object)NODE_3);
            NodeAllocator.NodeLease catalog1acquire3 = nodeAllocator.acquire(new NodeRequirements(Optional.of(CATALOG_1), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertFalse((boolean)catalog1acquire3.getNode().isDone());
            NodeAllocator.NodeLease catalog2acquire1 = nodeAllocator.acquire(new NodeRequirements(Optional.of(CATALOG_2), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertTrue((boolean)catalog2acquire1.getNode().isDone());
            Assert.assertEquals((Object)catalog2acquire1.getNode().get(), (Object)NODE_2);
            NodeAllocator.NodeLease catalog2acquire2 = nodeAllocator.acquire(new NodeRequirements(Optional.of(CATALOG_2), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertFalse((boolean)catalog2acquire2.getNode().isDone());
            catalog2acquire1.release();
            Assert.assertFalse((boolean)catalog1acquire3.getNode().isDone());
            Assert.assertTrue((boolean)catalog2acquire2.getNode().isDone());
            Assert.assertEquals((Object)catalog2acquire2.getNode().get(), (Object)NODE_2);
            catalog1acquire1.release();
            Assert.assertTrue((boolean)catalog1acquire3.getNode().isDone());
            Assert.assertEquals((Object)catalog1acquire3.getNode().get(), (Object)NODE_1);
            NodeAllocator.NodeLease catalog1acquire4 = nodeAllocator.acquire(new NodeRequirements(Optional.of(CATALOG_1), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertFalse((boolean)catalog1acquire4.getNode().isDone());
            NodeAllocator.NodeLease catalog2acquire4 = nodeAllocator.acquire(new NodeRequirements(Optional.of(CATALOG_2), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertFalse((boolean)catalog2acquire4.getNode().isDone());
            catalog1acquire2.release();
            Assert.assertFalse((boolean)catalog2acquire4.getNode().isDone());
            Assert.assertTrue((boolean)catalog1acquire4.getNode().isDone());
            Assert.assertEquals((Object)catalog1acquire4.getNode().get(), (Object)NODE_3);
            catalog1acquire4.release();
            Assert.assertTrue((boolean)catalog2acquire4.getNode().isDone());
            Assert.assertEquals((Object)catalog2acquire4.getNode().get(), (Object)NODE_3);
        }
    }

    @Test
    public void testReleaseBeforeAcquired() throws Exception {
        TestingNodeSelectorFactory.TestingNodeSupplier nodeSupplier = TestingNodeSelectorFactory.TestingNodeSupplier.create((Map<InternalNode, List<CatalogName>>)ImmutableMap.of((Object)NODE_1, (Object)ImmutableList.of()));
        this.setupNodeAllocatorService(nodeSupplier);
        try (NodeAllocator nodeAllocator = this.nodeAllocatorService.getNodeAllocator(SESSION, 1);){
            NodeAllocator.NodeLease acquire1 = nodeAllocator.acquire(new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertTrue((boolean)acquire1.getNode().isDone());
            Assert.assertEquals((Object)acquire1.getNode().get(), (Object)NODE_1);
            NodeAllocator.NodeLease acquire2 = nodeAllocator.acquire(new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertFalse((boolean)acquire2.getNode().isDone());
            NodeAllocator.NodeLease acquire3 = nodeAllocator.acquire(new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertFalse((boolean)acquire3.getNode().isDone());
            acquire2.release();
            acquire1.release();
            Assert.assertTrue((boolean)acquire3.getNode().isDone());
            Assert.assertEquals((Object)acquire3.getNode().get(), (Object)NODE_1);
        }
    }

    @Test
    public void testAddNode() throws Exception {
        TestingNodeSelectorFactory.TestingNodeSupplier nodeSupplier = TestingNodeSelectorFactory.TestingNodeSupplier.create((Map<InternalNode, List<CatalogName>>)ImmutableMap.of((Object)NODE_1, (Object)ImmutableList.of()));
        this.setupNodeAllocatorService(nodeSupplier);
        try (NodeAllocator nodeAllocator = this.nodeAllocatorService.getNodeAllocator(SESSION, 1);){
            NodeAllocator.NodeLease acquire1 = nodeAllocator.acquire(new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertTrue((boolean)acquire1.getNode().isDone());
            Assert.assertEquals((Object)acquire1.getNode().get(), (Object)NODE_1);
            NodeAllocator.NodeLease acquire2 = nodeAllocator.acquire(new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertFalse((boolean)acquire2.getNode().isDone());
            nodeSupplier.addNode(NODE_2, (List<CatalogName>)ImmutableList.of());
            this.nodeAllocatorService.updateNodes();
            Assert.assertEquals((Object)acquire2.getNode().get(10L, TimeUnit.SECONDS), (Object)NODE_2);
        }
    }

    @Test
    public void testRemoveNode() throws Exception {
        TestingNodeSelectorFactory.TestingNodeSupplier nodeSupplier = TestingNodeSelectorFactory.TestingNodeSupplier.create((Map<InternalNode, List<CatalogName>>)ImmutableMap.of((Object)NODE_1, (Object)ImmutableList.of()));
        this.setupNodeAllocatorService(nodeSupplier);
        try (NodeAllocator nodeAllocator = this.nodeAllocatorService.getNodeAllocator(SESSION, 1);){
            NodeAllocator.NodeLease acquire1 = nodeAllocator.acquire(new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertTrue((boolean)acquire1.getNode().isDone());
            Assert.assertEquals((Object)acquire1.getNode().get(), (Object)NODE_1);
            NodeAllocator.NodeLease acquire2 = nodeAllocator.acquire(new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertFalse((boolean)acquire2.getNode().isDone());
            nodeSupplier.removeNode(NODE_1);
            nodeSupplier.addNode(NODE_2, (List<CatalogName>)ImmutableList.of());
            this.nodeAllocatorService.updateNodes();
            Assert.assertEquals((Object)acquire2.getNode().get(10L, TimeUnit.SECONDS), (Object)NODE_2);
            NodeAllocator.NodeLease acquire3 = nodeAllocator.acquire(new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), MEMORY_REQUIREMENTS));
            Assert.assertFalse((boolean)acquire3.getNode().isDone());
            acquire1.release();
            Assert.assertFalse((boolean)acquire3.getNode().isDone());
        }
    }

    @Test
    public void testAddressRequirement() throws Exception {
        TestingNodeSelectorFactory.TestingNodeSupplier nodeSupplier = TestingNodeSelectorFactory.TestingNodeSupplier.create((Map<InternalNode, List<CatalogName>>)ImmutableMap.of((Object)NODE_1, (Object)ImmutableList.of(), (Object)NODE_2, (Object)ImmutableList.of()));
        this.setupNodeAllocatorService(nodeSupplier);
        try (NodeAllocator nodeAllocator = this.nodeAllocatorService.getNodeAllocator(SESSION, 1);){
            NodeAllocator.NodeLease acquire1 = nodeAllocator.acquire(new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of((Object)NODE_2_ADDRESS), MEMORY_REQUIREMENTS));
            Assert.assertTrue((boolean)acquire1.getNode().isDone());
            Assert.assertEquals((Object)acquire1.getNode().get(), (Object)NODE_2);
            NodeAllocator.NodeLease acquire2 = nodeAllocator.acquire(new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of((Object)NODE_2_ADDRESS), MEMORY_REQUIREMENTS));
            Assert.assertFalse((boolean)acquire2.getNode().isDone());
            acquire1.release();
            Assert.assertTrue((boolean)acquire2.getNode().isDone());
            Assert.assertEquals((Object)acquire2.getNode().get(), (Object)NODE_2);
            NodeAllocator.NodeLease acquire3 = nodeAllocator.acquire(new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of((Object)NODE_3_ADDRESS), MEMORY_REQUIREMENTS));
            Assert.assertTrue((boolean)acquire3.getNode().isDone());
            Assertions.assertThatThrownBy(() -> acquire3.getNode().get()).hasMessageContaining("No nodes available to run query");
            nodeSupplier.addNode(NODE_3, (List<CatalogName>)ImmutableList.of());
            this.nodeAllocatorService.updateNodes();
            NodeAllocator.NodeLease acquire4 = nodeAllocator.acquire(new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of((Object)NODE_3_ADDRESS), MEMORY_REQUIREMENTS));
            Assert.assertTrue((boolean)acquire4.getNode().isDone());
            Assert.assertEquals((Object)acquire4.getNode().get(), (Object)NODE_3);
            NodeAllocator.NodeLease acquire5 = nodeAllocator.acquire(new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of((Object)NODE_3_ADDRESS), MEMORY_REQUIREMENTS));
            Assert.assertFalse((boolean)acquire5.getNode().isDone());
            nodeSupplier.removeNode(NODE_3);
            this.nodeAllocatorService.updateNodes();
            Assert.assertTrue((boolean)acquire5.getNode().isDone());
            Assertions.assertThatThrownBy(() -> acquire5.getNode().get()).hasMessageContaining("No nodes available to run query");
        }
    }
}

