/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import io.trino.spi.exchange.Exchange;
import io.trino.spi.exchange.ExchangeSinkHandle;
import io.trino.spi.exchange.ExchangeSinkInstanceHandle;
import io.trino.spi.exchange.ExchangeSourceHandle;
import io.trino.spi.exchange.ExchangeSourceSplitter;
import io.trino.spi.exchange.ExchangeSourceStatistics;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openjdk.jol.info.ClassLayout;

public class TestingExchange
implements Exchange {
    private final boolean splitPartitionsEnabled;
    private final Set<TestingExchangeSinkHandle> finishedSinks = Sets.newConcurrentHashSet();
    private final Set<TestingExchangeSinkHandle> allSinks = Sets.newConcurrentHashSet();
    private final AtomicBoolean noMoreSinks = new AtomicBoolean();
    private final CompletableFuture<List<ExchangeSourceHandle>> sourceHandles = new CompletableFuture();

    public TestingExchange(boolean splitPartitionsEnabled) {
        this.splitPartitionsEnabled = splitPartitionsEnabled;
    }

    public ExchangeSinkHandle addSink(int taskPartitionId) {
        TestingExchangeSinkHandle sinkHandle = new TestingExchangeSinkHandle(taskPartitionId);
        this.allSinks.add(sinkHandle);
        return sinkHandle;
    }

    public void noMoreSinks() {
        this.noMoreSinks.set(true);
    }

    public boolean isNoMoreSinks() {
        return this.noMoreSinks.get();
    }

    public ExchangeSinkInstanceHandle instantiateSink(ExchangeSinkHandle sinkHandle, int taskAttemptId) {
        return new TestingExchangeSinkInstanceHandle((TestingExchangeSinkHandle)sinkHandle, taskAttemptId);
    }

    public void sinkFinished(ExchangeSinkInstanceHandle handle) {
        this.finishedSinks.add(((TestingExchangeSinkInstanceHandle)handle).getSinkHandle());
    }

    public Set<TestingExchangeSinkHandle> getFinishedSinkHandles() {
        return ImmutableSet.copyOf(this.finishedSinks);
    }

    public CompletableFuture<List<ExchangeSourceHandle>> getSourceHandles() {
        return this.sourceHandles;
    }

    public void setSourceHandles(List<ExchangeSourceHandle> handles) {
        this.sourceHandles.complete((List<ExchangeSourceHandle>)ImmutableList.copyOf(handles));
    }

    public ExchangeSourceSplitter split(ExchangeSourceHandle handle, long targetSizeInBytes) {
        List<ExchangeSourceHandle> splitHandles = this.splitIntoList(handle, targetSizeInBytes);
        final Iterator<ExchangeSourceHandle> iterator = splitHandles.iterator();
        return new ExchangeSourceSplitter(){

            public CompletableFuture<Void> isBlocked() {
                return CompletableFuture.completedFuture(null);
            }

            public Optional<ExchangeSourceHandle> getNext() {
                if (iterator.hasNext()) {
                    return Optional.of((ExchangeSourceHandle)iterator.next());
                }
                return Optional.empty();
            }

            public void close() {
            }
        };
    }

    private List<ExchangeSourceHandle> splitIntoList(ExchangeSourceHandle handle, long targetSizeInBytes) {
        if (!this.splitPartitionsEnabled) {
            return ImmutableList.of((Object)handle);
        }
        Preconditions.checkArgument((targetSizeInBytes > 0L ? 1 : 0) != 0, (String)"targetSizeInBytes must be positive: %s", (long)targetSizeInBytes);
        TestingExchangeSourceHandle testingExchangeSourceHandle = (TestingExchangeSourceHandle)handle;
        long currentSize = testingExchangeSourceHandle.getSizeInBytes();
        int fullPartitions = Math.toIntExact(currentSize / targetSizeInBytes);
        long remainder = currentSize % targetSizeInBytes;
        ImmutableList.Builder result = ImmutableList.builder();
        if (fullPartitions > 0) {
            result.addAll(Iterators.limit((Iterator)Iterators.cycle((Object[])new TestingExchangeSourceHandle[]{new TestingExchangeSourceHandle(testingExchangeSourceHandle.getPartitionId(), targetSizeInBytes)}), (int)fullPartitions));
        }
        if (remainder > 0L) {
            result.add((Object)new TestingExchangeSourceHandle(testingExchangeSourceHandle.getPartitionId(), remainder));
        }
        return result.build();
    }

    public ExchangeSourceStatistics getExchangeSourceStatistics(ExchangeSourceHandle handle) {
        return new ExchangeSourceStatistics(((TestingExchangeSourceHandle)handle).getSizeInBytes());
    }

    public void close() {
    }

    public static class TestingExchangeSinkHandle
    implements ExchangeSinkHandle {
        private final int taskPartitionId;

        public TestingExchangeSinkHandle(int taskPartitionId) {
            this.taskPartitionId = taskPartitionId;
        }

        public int getTaskPartitionId() {
            return this.taskPartitionId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestingExchangeSinkHandle sinkHandle = (TestingExchangeSinkHandle)o;
            return this.taskPartitionId == sinkHandle.taskPartitionId;
        }

        public int hashCode() {
            return Objects.hash(this.taskPartitionId);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("taskPartitionId", this.taskPartitionId).toString();
        }
    }

    public static class TestingExchangeSourceHandle
    implements ExchangeSourceHandle {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(TestingExchangeSourceHandle.class).instanceSize();
        private final int partitionId;
        private final long sizeInBytes;

        public TestingExchangeSourceHandle(int partitionId, long sizeInBytes) {
            this.partitionId = partitionId;
            this.sizeInBytes = sizeInBytes;
        }

        public int getPartitionId() {
            return this.partitionId;
        }

        public long getRetainedSizeInBytes() {
            return INSTANCE_SIZE;
        }

        public long getSizeInBytes() {
            return this.sizeInBytes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestingExchangeSourceHandle that = (TestingExchangeSourceHandle)o;
            return this.partitionId == that.partitionId && this.sizeInBytes == that.sizeInBytes;
        }

        public int hashCode() {
            return Objects.hash(this.partitionId, this.sizeInBytes);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("partitionId", this.partitionId).add("sizeInBytes", this.sizeInBytes).toString();
        }
    }

    public static class TestingExchangeSinkInstanceHandle
    implements ExchangeSinkInstanceHandle {
        private final TestingExchangeSinkHandle sinkHandle;
        private final int attemptId;

        public TestingExchangeSinkInstanceHandle(TestingExchangeSinkHandle sinkHandle, int attemptId) {
            this.sinkHandle = Objects.requireNonNull(sinkHandle, "sinkHandle is null");
            this.attemptId = attemptId;
        }

        public TestingExchangeSinkHandle getSinkHandle() {
            return this.sinkHandle;
        }

        public int getAttemptId() {
            return this.attemptId;
        }
    }
}

