/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.trino.connector.CatalogName;
import io.trino.metadata.Split;
import io.trino.split.SplitSource;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;

public class TestingSplitSource
implements SplitSource {
    private final CatalogName catalogName;
    private final ListenableFuture<List<Split>> splitsFuture;
    private int finishDelayRemainingIterations;
    private Iterator<Split> splits;

    public TestingSplitSource(CatalogName catalogName, List<Split> splits) {
        this(catalogName, splits, 0);
    }

    public TestingSplitSource(CatalogName catalogName, List<Split> splits, int finishDelayIterations) {
        this(catalogName, (ListenableFuture<List<Split>>)Futures.immediateFuture((Object)ImmutableList.copyOf((Collection)Objects.requireNonNull(splits, "splits is null"))), finishDelayIterations);
    }

    public TestingSplitSource(CatalogName catalogName, ListenableFuture<List<Split>> splitsFuture, int finishDelayIterations) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.splitsFuture = Objects.requireNonNull(splitsFuture, "splitsFuture is null");
        this.finishDelayRemainingIterations = finishDelayIterations;
    }

    public CatalogName getCatalogName() {
        return this.catalogName;
    }

    public ListenableFuture<SplitSource.SplitBatch> getNextBatch(int maxSize) {
        if (this.isFinished()) {
            return Futures.immediateFuture((Object)new SplitSource.SplitBatch((List)ImmutableList.of(), true));
        }
        if (this.splits == null) {
            return Futures.transform(this.splitsFuture, splits -> {
                Preconditions.checkState((this.splits == null ? 1 : 0) != 0, (Object)"splits should be null");
                this.splits = splits.iterator();
                return this.populateSplitBatch(maxSize);
            }, (Executor)MoreExecutors.directExecutor());
        }
        Preconditions.checkState((boolean)this.splitsFuture.isDone(), (Object)"splitsFuture should be completed");
        return Futures.immediateFuture((Object)this.populateSplitBatch(maxSize));
    }

    public void close() {
    }

    public boolean isFinished() {
        return this.splits != null && !this.splits.hasNext() && this.finishDelayRemainingIterations-- <= 0;
    }

    public Optional<List<Object>> getTableExecuteSplitsInfo() {
        return Optional.empty();
    }

    private SplitSource.SplitBatch populateSplitBatch(int maxSize) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (int i = 0; i < maxSize && this.splits.hasNext(); ++i) {
            result.add((Object)this.splits.next());
        }
        return new SplitSource.SplitBatch((List)result.build(), this.isFinished());
    }
}

