/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import io.trino.execution.RemoteTask;
import io.trino.execution.TaskId;
import io.trino.execution.scheduler.TaskLifecycleListener;
import io.trino.sql.planner.plan.PlanFragmentId;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;

public class TestingTaskLifecycleListener
implements TaskLifecycleListener {
    @GuardedBy(value="this")
    private final Multimap<PlanFragmentId, TaskId> tasks = ArrayListMultimap.create();
    private final Set<PlanFragmentId> noMoreTasks = Sets.newConcurrentHashSet();

    public synchronized void taskCreated(PlanFragmentId fragmentId, RemoteTask task) {
        this.tasks.put((Object)fragmentId, (Object)task.getTaskId());
    }

    public synchronized Multimap<PlanFragmentId, TaskId> getTasks() {
        return ImmutableListMultimap.copyOf(this.tasks);
    }

    public void noMoreTasks(PlanFragmentId fragmentId) {
        this.noMoreTasks.add(fragmentId);
    }

    public Set<PlanFragmentId> getNoMoreTasks() {
        return ImmutableSet.copyOf(this.noMoreTasks);
    }
}

