/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.execution.scheduler.BucketNodeMap;
import io.trino.execution.scheduler.NodeRequirements;
import io.trino.execution.scheduler.TaskDescriptor;
import io.trino.execution.scheduler.TaskSource;
import io.trino.execution.scheduler.TaskSourceFactory;
import io.trino.metadata.Split;
import io.trino.spi.exchange.Exchange;
import io.trino.spi.exchange.ExchangeSourceHandle;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.RemoteSourceNode;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.LongConsumer;

public class TestingTaskSourceFactory
implements TaskSourceFactory {
    private final Optional<CatalogName> catalog;
    private final ListenableFuture<List<Split>> splitsFuture;
    private final int tasksPerBatch;

    public TestingTaskSourceFactory(Optional<CatalogName> catalog, List<Split> splits, int tasksPerBatch) {
        this(catalog, (ListenableFuture<List<Split>>)Futures.immediateFuture((Object)ImmutableList.copyOf((Collection)Objects.requireNonNull(splits, "splits is null"))), tasksPerBatch);
    }

    public TestingTaskSourceFactory(Optional<CatalogName> catalog, ListenableFuture<List<Split>> splitsFuture, int tasksPerBatch) {
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.splitsFuture = Objects.requireNonNull(splitsFuture, "splitsFuture is null");
        this.tasksPerBatch = tasksPerBatch;
    }

    public TaskSource create(Session session, PlanFragment fragment, Map<PlanFragmentId, Exchange> sourceExchanges, Multimap<PlanFragmentId, ExchangeSourceHandle> exchangeSourceHandles, LongConsumer getSplitTimeRecorder, Optional<int[]> bucketToPartitionMap, Optional<BucketNodeMap> bucketNodeMap) {
        List partitionedSources = fragment.getPartitionedSources();
        Preconditions.checkArgument((partitionedSources.size() == 1 ? 1 : 0) != 0, (Object)"single partitioned source is expected");
        return new TestingTaskSource(this.catalog, this.splitsFuture, this.tasksPerBatch, (PlanNodeId)Iterables.getOnlyElement((Iterable)partitionedSources), TestingTaskSourceFactory.getHandlesForRemoteSources(fragment.getRemoteSourceNodes(), exchangeSourceHandles));
    }

    private static ListMultimap<PlanNodeId, ExchangeSourceHandle> getHandlesForRemoteSources(List<RemoteSourceNode> remoteSources, Multimap<PlanFragmentId, ExchangeSourceHandle> exchangeSourceHandles) {
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        for (RemoteSourceNode remoteSource : remoteSources) {
            Preconditions.checkArgument((remoteSource.getExchangeType() == ExchangeNode.Type.REPLICATE ? 1 : 0) != 0, (String)"expected exchange type to be REPLICATE, got: %s", (Object)remoteSource.getExchangeType());
            for (PlanFragmentId fragmentId : remoteSource.getSourceFragmentIds()) {
                Collection handles = Objects.requireNonNull(exchangeSourceHandles.get((Object)fragmentId), () -> "exchange source handle is missing for fragment: " + fragmentId);
                Preconditions.checkArgument((handles.size() == 1 ? 1 : 0) != 0, (String)"single exchange source handle is expected, got: %s", (Object)handles);
                result.putAll((Object)remoteSource.getId(), (Iterable)handles);
            }
        }
        return result.build();
    }

    public static class TestingTaskSource
    implements TaskSource {
        private final Optional<CatalogName> catalogRequirement;
        private final ListenableFuture<List<Split>> splitsFuture;
        private final int tasksPerBatch;
        private final PlanNodeId tableScanPlanNodeId;
        private final ListMultimap<PlanNodeId, ExchangeSourceHandle> exchangeSourceHandles;
        private final AtomicInteger nextPartitionId = new AtomicInteger();
        private Iterator<Split> splits;

        public TestingTaskSource(Optional<CatalogName> catalogRequirement, ListenableFuture<List<Split>> splitsFuture, int tasksPerBatch, PlanNodeId tableScanPlanNodeId, ListMultimap<PlanNodeId, ExchangeSourceHandle> exchangeSourceHandles) {
            this.catalogRequirement = Objects.requireNonNull(catalogRequirement, "catalogRequirement is null");
            this.splitsFuture = Objects.requireNonNull(splitsFuture, "splitsFuture is null");
            this.tasksPerBatch = tasksPerBatch;
            this.tableScanPlanNodeId = Objects.requireNonNull(tableScanPlanNodeId, "tableScanPlanNodeId is null");
            this.exchangeSourceHandles = ImmutableListMultimap.copyOf((Multimap)((Multimap)Objects.requireNonNull(exchangeSourceHandles, "exchangeSourceHandles is null")));
        }

        public ListenableFuture<List<TaskDescriptor>> getMoreTasks() {
            Preconditions.checkState((!this.isFinished() ? 1 : 0) != 0, (Object)"already finished");
            if (this.splits == null) {
                return Futures.transform(this.splitsFuture, loadedSplits -> {
                    Preconditions.checkState((this.splits == null ? 1 : 0) != 0, (Object)"splits should be null");
                    this.splits = loadedSplits.iterator();
                    return this.getTasksBatch();
                }, (Executor)MoreExecutors.directExecutor());
            }
            Preconditions.checkState((boolean)this.splitsFuture.isDone(), (Object)"splitsFuture should be completed");
            return Futures.immediateFuture(this.getTasksBatch());
        }

        public boolean isFinished() {
            return this.splits != null && !this.splits.hasNext();
        }

        public void close() {
        }

        private List<TaskDescriptor> getTasksBatch() {
            ImmutableList.Builder result = ImmutableList.builder();
            for (int i = 0; i < this.tasksPerBatch && !this.isFinished(); ++i) {
                Split split = this.splits.next();
                TaskDescriptor task = new TaskDescriptor(this.nextPartitionId.getAndIncrement(), (ListMultimap)ImmutableListMultimap.of((Object)this.tableScanPlanNodeId, (Object)split), this.exchangeSourceHandles, new NodeRequirements(this.catalogRequirement, (Set)ImmutableSet.copyOf((Collection)split.getAddresses()), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE)));
                result.add((Object)task);
            }
            return result.build();
        }
    }
}

