/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.policy;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.execution.scheduler.policy.LegacyPhasedExecutionSchedule;
import io.trino.execution.scheduler.policy.PlanUtils;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.plan.JoinNode;
import java.util.Collection;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLegacyPhasedExecutionSchedule {
    @Test
    public void testExchange() {
        PlanFragment aFragment = PlanUtils.createTableScanPlanFragment("a");
        PlanFragment bFragment = PlanUtils.createTableScanPlanFragment("b");
        PlanFragment cFragment = PlanUtils.createTableScanPlanFragment("c");
        PlanFragment exchangeFragment = PlanUtils.createExchangePlanFragment("exchange", aFragment, bFragment, cFragment);
        List phases = LegacyPhasedExecutionSchedule.extractPhases((Collection)ImmutableList.of((Object)aFragment, (Object)bFragment, (Object)cFragment, (Object)exchangeFragment));
        Assert.assertEquals((Collection)phases, (Collection)ImmutableList.of((Object)ImmutableSet.of((Object)exchangeFragment.getId()), (Object)ImmutableSet.of((Object)aFragment.getId()), (Object)ImmutableSet.of((Object)bFragment.getId()), (Object)ImmutableSet.of((Object)cFragment.getId())));
    }

    @Test
    public void testUnion() {
        PlanFragment aFragment = PlanUtils.createTableScanPlanFragment("a");
        PlanFragment bFragment = PlanUtils.createTableScanPlanFragment("b");
        PlanFragment cFragment = PlanUtils.createTableScanPlanFragment("c");
        PlanFragment unionFragment = PlanUtils.createUnionPlanFragment("union", aFragment, bFragment, cFragment);
        List phases = LegacyPhasedExecutionSchedule.extractPhases((Collection)ImmutableList.of((Object)aFragment, (Object)bFragment, (Object)cFragment, (Object)unionFragment));
        Assert.assertEquals((Collection)phases, (Collection)ImmutableList.of((Object)ImmutableSet.of((Object)unionFragment.getId()), (Object)ImmutableSet.of((Object)aFragment.getId()), (Object)ImmutableSet.of((Object)bFragment.getId()), (Object)ImmutableSet.of((Object)cFragment.getId())));
    }

    @Test
    public void testJoin() {
        PlanFragment buildFragment = PlanUtils.createTableScanPlanFragment("build");
        PlanFragment probeFragment = PlanUtils.createTableScanPlanFragment("probe");
        PlanFragment joinFragment = PlanUtils.createJoinPlanFragment(JoinNode.Type.INNER, "join", buildFragment, probeFragment);
        List phases = LegacyPhasedExecutionSchedule.extractPhases((Collection)ImmutableList.of((Object)joinFragment, (Object)buildFragment, (Object)probeFragment));
        Assert.assertEquals((Collection)phases, (Collection)ImmutableList.of((Object)ImmutableSet.of((Object)joinFragment.getId()), (Object)ImmutableSet.of((Object)buildFragment.getId()), (Object)ImmutableSet.of((Object)probeFragment.getId())));
    }

    @Test
    public void testRightJoin() {
        PlanFragment buildFragment = PlanUtils.createTableScanPlanFragment("build");
        PlanFragment probeFragment = PlanUtils.createTableScanPlanFragment("probe");
        PlanFragment joinFragment = PlanUtils.createJoinPlanFragment(JoinNode.Type.RIGHT, "join", buildFragment, probeFragment);
        List phases = LegacyPhasedExecutionSchedule.extractPhases((Collection)ImmutableList.of((Object)joinFragment, (Object)buildFragment, (Object)probeFragment));
        Assert.assertEquals((Collection)phases, (Collection)ImmutableList.of((Object)ImmutableSet.of((Object)joinFragment.getId()), (Object)ImmutableSet.of((Object)buildFragment.getId()), (Object)ImmutableSet.of((Object)probeFragment.getId())));
    }

    @Test
    public void testBroadcastJoin() {
        PlanFragment buildFragment = PlanUtils.createTableScanPlanFragment("build");
        PlanFragment joinFragment = PlanUtils.createBroadcastJoinPlanFragment("join", buildFragment);
        List phases = LegacyPhasedExecutionSchedule.extractPhases((Collection)ImmutableList.of((Object)joinFragment, (Object)buildFragment));
        Assert.assertEquals((Collection)phases, (Collection)ImmutableList.of((Object)ImmutableSet.of((Object)joinFragment.getId(), (Object)buildFragment.getId())));
    }

    @Test
    public void testJoinWithDeepSources() {
        PlanFragment buildSourceFragment = PlanUtils.createTableScanPlanFragment("buildSource");
        PlanFragment buildMiddleFragment = PlanUtils.createExchangePlanFragment("buildMiddle", buildSourceFragment);
        PlanFragment buildTopFragment = PlanUtils.createExchangePlanFragment("buildTop", buildMiddleFragment);
        PlanFragment probeSourceFragment = PlanUtils.createTableScanPlanFragment("probeSource");
        PlanFragment probeMiddleFragment = PlanUtils.createExchangePlanFragment("probeMiddle", probeSourceFragment);
        PlanFragment probeTopFragment = PlanUtils.createExchangePlanFragment("probeTop", probeMiddleFragment);
        PlanFragment joinFragment = PlanUtils.createJoinPlanFragment(JoinNode.Type.INNER, "join", buildTopFragment, probeTopFragment);
        List phases = LegacyPhasedExecutionSchedule.extractPhases((Collection)ImmutableList.of((Object)joinFragment, (Object)buildTopFragment, (Object)buildMiddleFragment, (Object)buildSourceFragment, (Object)probeTopFragment, (Object)probeMiddleFragment, (Object)probeSourceFragment));
        Assert.assertEquals((Collection)phases, (Collection)ImmutableList.of((Object)ImmutableSet.of((Object)joinFragment.getId()), (Object)ImmutableSet.of((Object)buildTopFragment.getId()), (Object)ImmutableSet.of((Object)buildMiddleFragment.getId()), (Object)ImmutableSet.of((Object)buildSourceFragment.getId()), (Object)ImmutableSet.of((Object)probeTopFragment.getId()), (Object)ImmutableSet.of((Object)probeMiddleFragment.getId()), (Object)ImmutableSet.of((Object)probeSourceFragment.getId())));
    }
}

