/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import io.trino.jmh.Benchmarks;
import io.trino.operator.CyclingGroupByHash;
import io.trino.operator.GroupByHash;
import io.trino.operator.GroupedTopNBuilder;
import io.trino.operator.GroupedTopNRankBuilder;
import io.trino.operator.PageWithPositionComparator;
import io.trino.operator.PageWithPositionEqualsAndHash;
import io.trino.operator.SimplePageWithPositionComparator;
import io.trino.operator.SimplePageWithPositionEqualsAndHash;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.tpch.LineItem;
import io.trino.tpch.LineItemGenerator;
import io.trino.type.BlockTypeOperators;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.RunnerException;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=4)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
public class BenchmarkGroupedTopNRankBuilder {
    private static final int EXTENDED_PRICE = 0;
    private static final int DISCOUNT = 1;
    private static final int STATUS = 2;
    private static final int QUANTITY = 3;

    @Benchmark
    public List<Page> topN(BenchmarkData data) {
        data.getTopNBuilder().processPage(data.getPage()).process();
        return ImmutableList.copyOf((Iterator)data.getTopNBuilder().buildResult());
    }

    public static void main(String[] args) throws RunnerException {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkGroupedTopNRankBuilder().topN(data);
        Benchmarks.benchmark(BenchmarkGroupedTopNRankBuilder.class).run();
    }

    private static Page createInputPage(int positions, List<Type> types) {
        PageBuilder pageBuilder = new PageBuilder(types);
        LineItemGenerator lineItemGenerator = new LineItemGenerator(1.0, 1, 1);
        Iterator iterator = lineItemGenerator.iterator();
        for (int i = 0; i < positions; ++i) {
            pageBuilder.declarePosition();
            LineItem lineItem = (LineItem)iterator.next();
            DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(0), lineItem.getExtendedPrice());
            DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(1), lineItem.getDiscount());
            VarcharType.VARCHAR.writeString(pageBuilder.getBlockBuilder(2), lineItem.getStatus());
            BigintType.BIGINT.writeLong(pageBuilder.getBlockBuilder(3), lineItem.getQuantity());
        }
        return pageBuilder.build();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"1", "10", "100"})
        private String topN = "1";
        @Param(value={"10000", "1000000"})
        private String positions = "1";
        @Param(value={"1", "10000", "1000000"})
        private String groupCount = "1";
        private Page page;
        private GroupedTopNRankBuilder topNBuilder;

        @Setup(value=Level.Invocation)
        public void setup() {
            ImmutableList types = ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT);
            TypeOperators typeOperators = new TypeOperators();
            BlockTypeOperators blockTypeOperators = new BlockTypeOperators(typeOperators);
            SimplePageWithPositionComparator comparator = new SimplePageWithPositionComparator((List)types, (List)ImmutableList.of((Object)0, (Object)2), (List)ImmutableList.of((Object)SortOrder.DESC_NULLS_LAST, (Object)SortOrder.ASC_NULLS_FIRST), typeOperators);
            SimplePageWithPositionEqualsAndHash equalsAndHash = new SimplePageWithPositionEqualsAndHash((List)types, (List)ImmutableList.of((Object)0, (Object)2), blockTypeOperators);
            this.page = BenchmarkGroupedTopNRankBuilder.createInputPage(Integer.valueOf(this.positions), (List<Type>)types);
            this.topNBuilder = new GroupedTopNRankBuilder((List)types, (PageWithPositionComparator)comparator, (PageWithPositionEqualsAndHash)equalsAndHash, Integer.valueOf(this.topN).intValue(), true, (GroupByHash)new CyclingGroupByHash(Integer.valueOf(this.groupCount)));
        }

        public GroupedTopNBuilder getTopNBuilder() {
            return this.topNBuilder;
        }

        public Page getPage() {
            return this.page;
        }
    }
}

