/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import io.trino.RowPagesBuilder;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.block.BlockAssertions;
import io.trino.jmh.Benchmarks;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.DriverContext;
import io.trino.operator.HashAggregationOperator;
import io.trino.operator.Operator;
import io.trino.operator.OperatorFactory;
import io.trino.operator.StreamingAggregationOperator;
import io.trino.operator.TaskContext;
import io.trino.operator.aggregation.TestingAggregationFunction;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.spiller.SpillerFactory;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.gen.JoinCompiler;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.tree.QualifiedName;
import io.trino.testing.TestingTaskContext;
import io.trino.type.BlockTypeOperators;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.RunnerException;
import org.testng.Assert;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=3)
@Warmup(iterations=10)
@Measurement(iterations=10, time=2, timeUnit=TimeUnit.SECONDS)
public class BenchmarkHashAndStreamingAggregationOperators {
    private static final TypeOperators TYPE_OPERATORS = new TypeOperators();
    private static final BlockTypeOperators BLOCK_TYPE_OPERATORS = new BlockTypeOperators(TYPE_OPERATORS);
    private static final JoinCompiler JOIN_COMPILER = new JoinCompiler(TYPE_OPERATORS);
    private static final TestingFunctionResolution FUNCTION_RESOLUTION = new TestingFunctionResolution();
    private static final TestingAggregationFunction LONG_SUM = FUNCTION_RESOLUTION.getAggregateFunction(QualifiedName.of((String)"sum"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
    private static final TestingAggregationFunction COUNT = FUNCTION_RESOLUTION.getAggregateFunction(QualifiedName.of((String)"count"), (List<TypeSignatureProvider>)ImmutableList.of());

    @Benchmark
    public List<Page> benchmark(Context context) {
        DriverContext driverContext = context.createTaskContext().addPipelineContext(0, true, true, false).addDriverContext();
        Operator operator = context.getOperatorFactory().createOperator(driverContext);
        Iterator<Page> input = context.getPages().iterator();
        ImmutableList.Builder outputPages = ImmutableList.builder();
        boolean finishing = false;
        for (int loops = 0; !operator.isFinished() && loops < 1000000; ++loops) {
            Page outputPage;
            if (operator.needsInput()) {
                if (input.hasNext()) {
                    Page inputPage = input.next();
                    operator.addInput(inputPage);
                } else if (!finishing) {
                    operator.finish();
                    finishing = true;
                }
            }
            if ((outputPage = operator.getOutput()) == null) continue;
            outputPages.add((Object)outputPage);
        }
        return outputPages.build();
    }

    @Test
    public void verifyStreaming() {
        this.verify(1, "streaming", "bigint");
        this.verify(10, "streaming", "varchar");
        this.verify(1000, "streaming", "mixed");
    }

    @Test
    public void verifyHash() {
        this.verify(1, "hash", "bigint");
        this.verify(10, "hash", "varchar");
        this.verify(1000, "hash", "mixed");
    }

    private void verify(int rowsPerGroup, String operatorType, String groupByTypes) {
        Context context = new Context();
        context.operatorType = operatorType;
        context.rowsPerGroup = rowsPerGroup;
        context.groupByTypes = groupByTypes;
        context.setup();
        Assert.assertEquals((int)140, (int)context.getPages().size());
        for (int i = 0; i < 140; ++i) {
            Assert.assertEquals((int)10000, (int)context.getPages().get(i).getPositionCount());
        }
        List<Page> outputPages = this.benchmark(context);
        Assert.assertEquals((int)(1400000 / rowsPerGroup), (int)outputPages.stream().mapToInt(Page::getPositionCount).sum());
        context.cleanup();
    }

    public static void main(String[] args) throws RunnerException {
        Benchmarks.benchmark(BenchmarkHashAndStreamingAggregationOperators.class).run();
    }

    @State(value=Scope.Thread)
    public static class Context {
        public static final int TOTAL_PAGES = 140;
        public static final int ROWS_PER_PAGE = 10000;
        @Param(value={"1", "10", "1000"})
        public int rowsPerGroup;
        @Param(value={"streaming", "hash"})
        public String operatorType;
        @Param(value={"bigint", "varchar", "mixed"})
        public String groupByTypes;
        private ExecutorService executor;
        private ScheduledExecutorService scheduledExecutor;
        private OperatorFactory operatorFactory;
        private List<Page> pages;

        @Setup
        public void setup() {
            int sumChannel;
            ImmutableList hashChannels;
            ImmutableList hashTypes;
            this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
            this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
            int groupsPerPage = 10000 / this.rowsPerGroup;
            boolean hashAggregation = this.operatorType.equalsIgnoreCase("hash");
            switch (this.groupByTypes) {
                case "bigint": {
                    hashTypes = ImmutableList.of((Object)BigintType.BIGINT);
                    hashChannels = ImmutableList.of((Object)0);
                    sumChannel = 1;
                    break;
                }
                case "varchar": {
                    hashTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
                    hashChannels = ImmutableList.of((Object)0);
                    sumChannel = 1;
                    break;
                }
                case "mixed": {
                    hashTypes = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE);
                    hashChannels = ImmutableList.of((Object)0, (Object)1, (Object)2);
                    sumChannel = 3;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            RowPagesBuilder pagesBuilder = RowPagesBuilder.rowPagesBuilder(hashAggregation, (List<Integer>)hashChannels, (Iterable<Type>)ImmutableList.builder().addAll((Iterable)hashTypes).add((Object)BigintType.BIGINT).build());
            for (int i = 0; i < 140; ++i) {
                ImmutableList blocks;
                BlockBuilder bigintBlockBuilder = BigintType.BIGINT.createBlockBuilder(null, 10000);
                BlockBuilder varcharBlockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 10000);
                BlockBuilder doubleBlockBuilder = DoubleType.DOUBLE.createBlockBuilder(null, 10000);
                block31: for (int j = 0; j < groupsPerPage; ++j) {
                    long groupKey = i * groupsPerPage + j;
                    switch (this.groupByTypes) {
                        case "bigint": {
                            Context.repeatToBigintBlock(groupKey, this.rowsPerGroup, bigintBlockBuilder);
                            continue block31;
                        }
                        case "varchar": {
                            Context.repeatToStringBlock(Long.toString(groupKey), this.rowsPerGroup, varcharBlockBuilder);
                            continue block31;
                        }
                        case "mixed": {
                            Context.repeatToBigintBlock(groupKey, this.rowsPerGroup, bigintBlockBuilder);
                            Context.repeatToStringBlock(Long.toString(groupKey), this.rowsPerGroup, varcharBlockBuilder);
                            Context.repeatToDoubleBlock(groupKey, this.rowsPerGroup, doubleBlockBuilder);
                            continue block31;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
                switch (this.groupByTypes) {
                    case "bigint": {
                        blocks = ImmutableList.of((Object)bigintBlockBuilder.build());
                        break;
                    }
                    case "varchar": {
                        blocks = ImmutableList.of((Object)varcharBlockBuilder.build());
                        break;
                    }
                    case "mixed": {
                        blocks = ImmutableList.of((Object)bigintBlockBuilder.build(), (Object)varcharBlockBuilder.build(), (Object)doubleBlockBuilder.build());
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                pagesBuilder.addBlocksPage((Iterable<Block>)ImmutableList.builder().addAll((Iterable)blocks).add((Object)BlockAssertions.createLongSequenceBlock(0, 10000)).build());
            }
            this.pages = pagesBuilder.build();
            this.operatorFactory = hashAggregation ? this.createHashAggregationOperatorFactory(pagesBuilder.getHashChannel(), (List<Type>)hashTypes, (List<Integer>)hashChannels, sumChannel) : this.createStreamingAggregationOperatorFactory((List<Type>)hashTypes, (List<Integer>)hashChannels, sumChannel);
        }

        @TearDown
        public void cleanup() {
            this.executor.shutdownNow();
            this.scheduledExecutor.shutdownNow();
        }

        private OperatorFactory createStreamingAggregationOperatorFactory(List<Type> hashTypes, List<Integer> hashChannels, int sumChannel) {
            return StreamingAggregationOperator.createOperatorFactory((int)0, (PlanNodeId)new PlanNodeId("test"), hashTypes, hashTypes, hashChannels, (List)ImmutableList.of((Object)COUNT.createAggregatorFactory(AggregationNode.Step.SINGLE, (List<Integer>)ImmutableList.of((Object)0), OptionalInt.empty()), (Object)LONG_SUM.createAggregatorFactory(AggregationNode.Step.SINGLE, (List<Integer>)ImmutableList.of((Object)sumChannel), OptionalInt.empty())), (JoinCompiler)JOIN_COMPILER);
        }

        private OperatorFactory createHashAggregationOperatorFactory(Optional<Integer> hashChannel, List<Type> hashTypes, List<Integer> hashChannels, int sumChannel) {
            SpillerFactory spillerFactory = (types, localSpillContext, aggregatedMemoryContext) -> null;
            return new HashAggregationOperator.HashAggregationOperatorFactory(0, new PlanNodeId("test"), hashTypes, hashChannels, (List)ImmutableList.of(), AggregationNode.Step.SINGLE, false, (List)ImmutableList.of((Object)COUNT.createAggregatorFactory(AggregationNode.Step.SINGLE, (List<Integer>)ImmutableList.of((Object)0), OptionalInt.empty()), (Object)LONG_SUM.createAggregatorFactory(AggregationNode.Step.SINGLE, (List<Integer>)ImmutableList.of((Object)sumChannel), OptionalInt.empty())), hashChannel, Optional.empty(), 100000, Optional.of(DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), false, DataSize.succinctBytes((long)8L), DataSize.succinctBytes((long)Integer.MAX_VALUE), spillerFactory, JOIN_COMPILER, BLOCK_TYPE_OPERATORS, Optional.empty());
        }

        private static void repeatToBigintBlock(long value, int count, BlockBuilder blockBuilder) {
            for (int i = 0; i < count; ++i) {
                BigintType.BIGINT.writeLong(blockBuilder, value);
            }
        }

        private static void repeatToStringBlock(String value, int count, BlockBuilder blockBuilder) {
            for (int i = 0; i < count; ++i) {
                VarcharType.VARCHAR.writeString(blockBuilder, value);
            }
        }

        private static void repeatToDoubleBlock(double value, int count, BlockBuilder blockBuilder) {
            for (int i = 0; i < count; ++i) {
                DoubleType.DOUBLE.writeDouble(blockBuilder, value);
            }
        }

        public TaskContext createTaskContext() {
            return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION, (DataSize)DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        }

        public OperatorFactory getOperatorFactory() {
            return this.operatorFactory;
        }

        public List<Page> getPages() {
            return this.pages;
        }
    }
}

