/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesScalarFunctionImplementation;
import io.trino.operator.scalar.ScalarFunctionImplementation;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import java.util.function.LongUnaryOperator;

public final class GenericLongFunction
extends SqlScalarFunction {
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(GenericLongFunction.class, (String)"apply", (Class[])new Class[]{LongUnaryOperator.class, Long.TYPE});
    private final LongUnaryOperator longUnaryOperator;

    GenericLongFunction(String suffix, LongUnaryOperator longUnaryOperator) {
        super(FunctionMetadata.scalarBuilder().signature(Signature.builder().name("generic_long_" + Objects.requireNonNull(suffix, "suffix is null")).returnType((Type)BigintType.BIGINT).argumentType((Type)BigintType.BIGINT).build()).hidden().description("generic long function for test").build());
        this.longUnaryOperator = longUnaryOperator;
    }

    protected ScalarFunctionImplementation specialize(BoundSignature boundSignature) {
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(this.longUnaryOperator);
        return new ChoicesScalarFunctionImplementation(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle);
    }

    public static long apply(LongUnaryOperator longUnaryOperator, long value) {
        return longUnaryOperator.applyAsLong(value);
    }
}

