/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.trino.SessionTestUtils;
import io.trino.metadata.AggregationFunctionMetadata;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.FunctionDependencies;
import io.trino.metadata.FunctionId;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlAggregationFunction;
import io.trino.operator.ParametricImplementationsGroup;
import io.trino.operator.TestAnnotationEngine;
import io.trino.operator.aggregation.AggregationFromAnnotationsParser;
import io.trino.operator.aggregation.AggregationFunctionAdapter;
import io.trino.operator.aggregation.AggregationImplementation;
import io.trino.operator.aggregation.ParametricAggregation;
import io.trino.operator.aggregation.state.LongState;
import io.trino.operator.aggregation.state.NullableDoubleState;
import io.trino.operator.aggregation.state.NullableLongState;
import io.trino.operator.aggregation.state.TriStateBooleanState;
import io.trino.operator.aggregation.state.VarianceState;
import io.trino.operator.annotations.LiteralImplementationDependency;
import io.trino.operator.annotations.OperatorImplementationDependency;
import io.trino.operator.annotations.TypeImplementationDependency;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.Convention;
import io.trino.spi.function.Description;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.function.TypeParameterSpecialization;
import io.trino.spi.function.TypeParameters;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarcharType;
import io.trino.type.Constraint;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAnnotationEngineForAggregates
extends TestAnnotationEngine {
    private static final MetadataManager METADATA = MetadataManager.createTestMetadataManager();
    private static final FunctionManager FUNCTION_MANAGER = FunctionManager.createTestingFunctionManager();
    private static final FunctionDependencies NO_FUNCTION_DEPENDENCIES = new FunctionDependencies((arg_0, arg_1) -> ((FunctionManager)FUNCTION_MANAGER).getScalarFunctionInvoker(arg_0, arg_1), (Map)ImmutableMap.of(), (Collection)ImmutableSet.of());

    @Test
    public void testSimpleExactAggregationParse() {
        Signature expectedSignature = Signature.builder().name("simple_exact_aggregate").returnType((Type)DoubleType.DOUBLE).argumentType((Type)DoubleType.DOUBLE).build();
        ParametricAggregation aggregation = (ParametricAggregation)Iterables.getOnlyElement((Iterable)AggregationFromAnnotationsParser.parseFunctionDefinitions(ExactAggregationFunction.class));
        Assert.assertEquals((String)aggregation.getFunctionMetadata().getDescription(), (String)"Simple exact aggregate description");
        Assert.assertTrue((boolean)aggregation.getFunctionMetadata().isDeterministic());
        Assert.assertEquals((Object)aggregation.getFunctionMetadata().getSignature(), (Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        this.assertImplementationCount(implementations, 1, 0, 0);
        AggregationImplementation implementation = (AggregationImplementation)Iterables.getOnlyElement(implementations.getExactImplementations().values());
        Assert.assertEquals((Object)implementation.getDefinitionClass(), ExactAggregationFunction.class);
        this.assertDependencyCount(implementation, 0, 0, 0);
        Assert.assertFalse((boolean)implementation.hasSpecializedTypeParameters());
        Assert.assertEquals((Collection)implementation.getInputParameterKinds(), (Collection)ImmutableList.of((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL));
        BoundSignature boundSignature = new BoundSignature(expectedSignature.getName(), (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)DoubleType.DOUBLE));
        AggregationFunctionMetadata aggregationMetadata = aggregation.getAggregationMetadata();
        Assert.assertFalse((boolean)aggregationMetadata.isOrderSensitive());
        Assert.assertFalse((boolean)aggregationMetadata.getIntermediateTypes().isEmpty());
        aggregation.specialize(boundSignature, NO_FUNCTION_DEPENDENCIES);
    }

    @Test
    public void testInputParameterOrderEnforced() {
        Assertions.assertThatThrownBy(() -> AggregationFromAnnotationsParser.parseFunctionDefinitions(InputParametersWrongOrder.class)).hasMessage("Expected input function non-dependency parameters to begin with state types [NullableDoubleState]: public static void io.trino.operator.TestAnnotationEngineForAggregates$InputParametersWrongOrder.input(double,io.trino.operator.aggregation.state.NullableDoubleState)");
    }

    @Test
    public void testOutputParameterOrderEnforced() {
        Assertions.assertThatThrownBy(() -> AggregationFromAnnotationsParser.parseFunctionDefinitions(OutputParametersWrongOrder.class)).hasMessage("Expected output function non-dependency parameters to be [NullableDoubleState, BlockBuilder]: public static void io.trino.operator.TestAnnotationEngineForAggregates$OutputParametersWrongOrder.output(io.trino.spi.block.BlockBuilder,io.trino.operator.aggregation.state.NullableDoubleState)");
    }

    @Test
    public void testNotAnnotatedAggregateStateAggregationParse() {
        ParametricAggregation aggregation = (ParametricAggregation)Iterables.getOnlyElement((Iterable)AggregationFromAnnotationsParser.parseFunctionDefinitions(NotAnnotatedAggregateStateAggregationFunction.class));
        AggregationImplementation implementation = (AggregationImplementation)Iterables.getOnlyElement(aggregation.getImplementations().getExactImplementations().values());
        Assert.assertEquals((Collection)implementation.getInputParameterKinds(), (Collection)ImmutableList.of((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL));
        BoundSignature boundSignature = new BoundSignature(aggregation.getFunctionMetadata().getSignature().getName(), (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)DoubleType.DOUBLE));
        AggregationFunctionMetadata aggregationMetadata = aggregation.getAggregationMetadata();
        Assert.assertFalse((boolean)aggregationMetadata.isOrderSensitive());
        Assert.assertFalse((boolean)aggregationMetadata.getIntermediateTypes().isEmpty());
        aggregation.specialize(boundSignature, NO_FUNCTION_DEPENDENCIES);
    }

    @Test
    public void testNotDecomposableAggregationParse() {
        Signature expectedSignature = Signature.builder().name("custom_decomposable_aggregate").returnType((Type)DoubleType.DOUBLE).argumentType((Type)DoubleType.DOUBLE).build();
        ParametricAggregation aggregation = (ParametricAggregation)Iterables.getOnlyElement((Iterable)AggregationFromAnnotationsParser.parseFunctionDefinitions(NotDecomposableAggregationFunction.class));
        Assert.assertEquals((String)aggregation.getFunctionMetadata().getDescription(), (String)"Aggregate with Decomposable=false");
        Assert.assertTrue((boolean)aggregation.getFunctionMetadata().isDeterministic());
        Assert.assertEquals((Object)aggregation.getFunctionMetadata().getSignature(), (Object)expectedSignature);
        BoundSignature boundSignature = new BoundSignature(aggregation.getFunctionMetadata().getSignature().getName(), (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)DoubleType.DOUBLE));
        AggregationFunctionMetadata aggregationMetadata = aggregation.getAggregationMetadata();
        Assert.assertFalse((boolean)aggregationMetadata.isOrderSensitive());
        Assert.assertTrue((boolean)aggregationMetadata.getIntermediateTypes().isEmpty());
        aggregation.specialize(boundSignature, NO_FUNCTION_DEPENDENCIES);
    }

    @Test
    public void testSimpleGenericAggregationFunctionParse() {
        Signature expectedSignature = Signature.builder().name("simple_generic_implementations").typeVariable("T").returnType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentType(new TypeSignature("T", new TypeSignatureParameter[0])).build();
        ParametricAggregation aggregation = (ParametricAggregation)Iterables.getOnlyElement((Iterable)AggregationFromAnnotationsParser.parseFunctionDefinitions(GenericAggregationFunction.class));
        Assert.assertEquals((String)aggregation.getFunctionMetadata().getDescription(), (String)"Simple aggregate with two generic implementations");
        Assert.assertTrue((boolean)aggregation.getFunctionMetadata().isDeterministic());
        Assert.assertEquals((Object)aggregation.getFunctionMetadata().getSignature(), (Object)expectedSignature);
        Assert.assertEquals((Collection)aggregation.getStateDetails(), (Collection)ImmutableList.of((Object)AggregationFromAnnotationsParser.toAccumulatorStateDetails(NullableLongState.class, (List)ImmutableList.of())));
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        this.assertImplementationCount(implementations, 0, 0, 2);
        AggregationImplementation implementationDouble = (AggregationImplementation)((ImmutableList)implementations.getGenericImplementations().stream().filter(impl -> impl.getInputFunction().type().equals((Object)MethodType.methodType(Void.TYPE, NullableLongState.class, Double.TYPE))).collect(ImmutableList.toImmutableList())).get(0);
        Assert.assertEquals((Object)implementationDouble.getDefinitionClass(), GenericAggregationFunction.class);
        this.assertDependencyCount(implementationDouble, 0, 0, 0);
        Assert.assertFalse((boolean)implementationDouble.hasSpecializedTypeParameters());
        Assert.assertEquals((Collection)implementationDouble.getInputParameterKinds(), (Collection)ImmutableList.of((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL));
        AggregationImplementation implementationLong = (AggregationImplementation)((ImmutableList)implementations.getGenericImplementations().stream().filter(impl -> impl.getInputFunction().type().equals((Object)MethodType.methodType(Void.TYPE, NullableLongState.class, Long.TYPE))).collect(ImmutableList.toImmutableList())).get(0);
        Assert.assertEquals((Object)implementationLong.getDefinitionClass(), GenericAggregationFunction.class);
        this.assertDependencyCount(implementationLong, 0, 0, 0);
        Assert.assertFalse((boolean)implementationLong.hasSpecializedTypeParameters());
        Assert.assertEquals((Collection)implementationLong.getInputParameterKinds(), (Collection)ImmutableList.of((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL));
        BoundSignature boundSignature = new BoundSignature(aggregation.getFunctionMetadata().getSignature().getName(), (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)DoubleType.DOUBLE));
        AggregationFunctionMetadata aggregationMetadata = aggregation.getAggregationMetadata();
        Assert.assertFalse((boolean)aggregationMetadata.isOrderSensitive());
        Assert.assertFalse((boolean)aggregationMetadata.getIntermediateTypes().isEmpty());
        aggregation.specialize(boundSignature, NO_FUNCTION_DEPENDENCIES);
    }

    @Test
    public void testSimpleBlockInputAggregationParse() {
        Signature expectedSignature = Signature.builder().name("block_input_aggregate").returnType((Type)DoubleType.DOUBLE).argumentType((Type)DoubleType.DOUBLE).build();
        ParametricAggregation aggregation = (ParametricAggregation)Iterables.getOnlyElement((Iterable)AggregationFromAnnotationsParser.parseFunctionDefinitions(BlockInputAggregationFunction.class));
        Assert.assertEquals((String)aggregation.getFunctionMetadata().getDescription(), (String)"Simple aggregate with @BlockPosition usage");
        Assert.assertTrue((boolean)aggregation.getFunctionMetadata().isDeterministic());
        Assert.assertEquals((Object)aggregation.getFunctionMetadata().getSignature(), (Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        this.assertImplementationCount(implementations, 1, 0, 0);
        AggregationImplementation implementation = (AggregationImplementation)Iterables.getOnlyElement(implementations.getExactImplementations().values());
        Assert.assertEquals((Object)implementation.getDefinitionClass(), BlockInputAggregationFunction.class);
        this.assertDependencyCount(implementation, 0, 0, 0);
        Assert.assertFalse((boolean)implementation.hasSpecializedTypeParameters());
        Assert.assertEquals((Collection)implementation.getInputParameterKinds(), (Collection)ImmutableList.of((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE, (Object)AggregationFunctionAdapter.AggregationParameterKind.BLOCK_INPUT_CHANNEL, (Object)AggregationFunctionAdapter.AggregationParameterKind.BLOCK_INDEX));
        BoundSignature boundSignature = new BoundSignature(aggregation.getFunctionMetadata().getSignature().getName(), (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)DoubleType.DOUBLE));
        AggregationFunctionMetadata aggregationMetadata = aggregation.getAggregationMetadata();
        Assert.assertFalse((boolean)aggregationMetadata.isOrderSensitive());
        Assert.assertFalse((boolean)aggregationMetadata.getIntermediateTypes().isEmpty());
        aggregation.specialize(boundSignature, NO_FUNCTION_DEPENDENCIES);
    }

    @Test(enabled=false)
    public void testSimpleImplicitSpecializedAggregationParse() {
        Signature expectedSignature = Signature.builder().name("implicit_specialized_aggregate").typeVariable("T").returnType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))).argumentType(new TypeSignature("T", new TypeSignatureParameter[0])).build();
        ParametricAggregation aggregation = (ParametricAggregation)Iterables.getOnlyElement((Iterable)AggregationFromAnnotationsParser.parseFunctionDefinitions(ImplicitSpecializedAggregationFunction.class));
        Assert.assertEquals((String)aggregation.getFunctionMetadata().getDescription(), (String)"Simple implicit specialized aggregate");
        Assert.assertTrue((boolean)aggregation.getFunctionMetadata().isDeterministic());
        Assert.assertEquals((Object)aggregation.getFunctionMetadata().getSignature(), (Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        this.assertImplementationCount(implementations, 0, 0, 2);
        AggregationImplementation implementation1 = (AggregationImplementation)implementations.getSpecializedImplementations().get(0);
        Assert.assertTrue((boolean)implementation1.hasSpecializedTypeParameters());
        Assert.assertFalse((boolean)implementation1.hasSpecializedTypeParameters());
        Assert.assertEquals((Collection)implementation1.getInputParameterKinds(), (Collection)ImmutableList.of((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL));
        AggregationImplementation implementation2 = (AggregationImplementation)implementations.getSpecializedImplementations().get(1);
        Assert.assertTrue((boolean)implementation2.hasSpecializedTypeParameters());
        Assert.assertFalse((boolean)implementation2.hasSpecializedTypeParameters());
        Assert.assertEquals((Collection)implementation2.getInputParameterKinds(), (Collection)ImmutableList.of((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL));
        BoundSignature boundSignature = new BoundSignature(aggregation.getFunctionMetadata().getSignature().getName(), (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)new ArrayType((Type)DoubleType.DOUBLE)));
        AggregationFunctionMetadata aggregationMetadata = aggregation.getAggregationMetadata();
        Assert.assertFalse((boolean)aggregationMetadata.isOrderSensitive());
        Assert.assertFalse((boolean)aggregationMetadata.getIntermediateTypes().isEmpty());
        aggregation.specialize(boundSignature, NO_FUNCTION_DEPENDENCIES);
    }

    @Test(enabled=false)
    public void testSimpleExplicitSpecializedAggregationParse() {
        Signature expectedSignature = Signature.builder().name("explicit_specialized_aggregate").typeVariable("T").returnType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))).build();
        ParametricAggregation aggregation = (ParametricAggregation)Iterables.getOnlyElement((Iterable)AggregationFromAnnotationsParser.parseFunctionDefinitions(ExplicitSpecializedAggregationFunction.class));
        Assert.assertEquals((String)aggregation.getFunctionMetadata().getDescription(), (String)"Simple explicit specialized aggregate");
        Assert.assertTrue((boolean)aggregation.getFunctionMetadata().isDeterministic());
        Assert.assertEquals((Object)aggregation.getFunctionMetadata().getSignature(), (Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        this.assertImplementationCount(implementations, 0, 1, 1);
        AggregationImplementation implementation1 = (AggregationImplementation)implementations.getSpecializedImplementations().get(0);
        Assert.assertTrue((boolean)implementation1.hasSpecializedTypeParameters());
        Assert.assertFalse((boolean)implementation1.hasSpecializedTypeParameters());
        Assert.assertEquals((Collection)implementation1.getInputParameterKinds(), (Collection)ImmutableList.of((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL));
        AggregationImplementation implementation2 = (AggregationImplementation)implementations.getSpecializedImplementations().get(1);
        Assert.assertTrue((boolean)implementation2.hasSpecializedTypeParameters());
        Assert.assertFalse((boolean)implementation2.hasSpecializedTypeParameters());
        Assert.assertEquals((Collection)implementation2.getInputParameterKinds(), (Collection)ImmutableList.of((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL));
        BoundSignature boundSignature = new BoundSignature(aggregation.getFunctionMetadata().getSignature().getName(), (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)new ArrayType((Type)DoubleType.DOUBLE)));
        AggregationFunctionMetadata aggregationMetadata = aggregation.getAggregationMetadata();
        Assert.assertFalse((boolean)aggregationMetadata.isOrderSensitive());
        Assert.assertFalse((boolean)aggregationMetadata.getIntermediateTypes().isEmpty());
        aggregation.specialize(boundSignature, NO_FUNCTION_DEPENDENCIES);
    }

    @Test
    public void testMultiOutputAggregationParse() {
        Signature expectedSignature1 = Signature.builder().name("multi_output_aggregate_1").returnType((Type)DoubleType.DOUBLE).argumentType((Type)DoubleType.DOUBLE).build();
        Signature expectedSignature2 = Signature.builder().name("multi_output_aggregate_2").returnType((Type)DoubleType.DOUBLE).argumentType((Type)DoubleType.DOUBLE).build();
        List aggregations = AggregationFromAnnotationsParser.parseFunctionDefinitions(MultiOutputAggregationFunction.class);
        Assert.assertEquals((int)aggregations.size(), (int)2);
        ParametricAggregation aggregation1 = (ParametricAggregation)((ImmutableList)aggregations.stream().filter(aggregate -> aggregate.getFunctionMetadata().getSignature().getName().equals("multi_output_aggregate_1")).collect(ImmutableList.toImmutableList())).get(0);
        Assert.assertEquals((Object)aggregation1.getFunctionMetadata().getSignature(), (Object)expectedSignature1);
        Assert.assertEquals((String)aggregation1.getFunctionMetadata().getDescription(), (String)"Simple multi output function aggregate specialized description");
        ParametricAggregation aggregation2 = (ParametricAggregation)((ImmutableList)aggregations.stream().filter(aggregate -> aggregate.getFunctionMetadata().getSignature().getName().equals("multi_output_aggregate_2")).collect(ImmutableList.toImmutableList())).get(0);
        Assert.assertEquals((Object)aggregation2.getFunctionMetadata().getSignature(), (Object)expectedSignature2);
        Assert.assertEquals((String)aggregation2.getFunctionMetadata().getDescription(), (String)"Simple multi output function aggregate generic description");
        ParametricImplementationsGroup implementations1 = aggregation1.getImplementations();
        this.assertImplementationCount(implementations1, 1, 0, 0);
        ParametricImplementationsGroup implementations2 = aggregation2.getImplementations();
        this.assertImplementationCount(implementations2, 1, 0, 0);
        AggregationImplementation implementation = (AggregationImplementation)Iterables.getOnlyElement(implementations1.getExactImplementations().values());
        Assert.assertEquals((Object)implementation.getDefinitionClass(), MultiOutputAggregationFunction.class);
        this.assertDependencyCount(implementation, 0, 0, 0);
        Assert.assertFalse((boolean)implementation.hasSpecializedTypeParameters());
        Assert.assertEquals((Collection)implementation.getInputParameterKinds(), (Collection)ImmutableList.of((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL));
        BoundSignature boundSignature = new BoundSignature(aggregation1.getFunctionMetadata().getSignature().getName(), (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)DoubleType.DOUBLE));
        AggregationFunctionMetadata aggregationMetadata = aggregation1.getAggregationMetadata();
        Assert.assertFalse((boolean)aggregationMetadata.isOrderSensitive());
        Assert.assertFalse((boolean)aggregationMetadata.getIntermediateTypes().isEmpty());
        aggregation1.specialize(boundSignature, NO_FUNCTION_DEPENDENCIES);
    }

    @Test
    public void testInjectOperatorAggregateParse() {
        Signature expectedSignature = Signature.builder().name("inject_operator_aggregate").returnType((Type)DoubleType.DOUBLE).argumentType((Type)DoubleType.DOUBLE).build();
        ParametricAggregation aggregation = (ParametricAggregation)Iterables.getOnlyElement((Iterable)AggregationFromAnnotationsParser.parseFunctionDefinitions(InjectOperatorAggregateFunction.class));
        Assert.assertEquals((String)aggregation.getFunctionMetadata().getDescription(), (String)"Simple aggregate with operator injected");
        Assert.assertTrue((boolean)aggregation.getFunctionMetadata().isDeterministic());
        Assert.assertEquals((Object)aggregation.getFunctionMetadata().getSignature(), (Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        AggregationImplementation implementation = (AggregationImplementation)Iterables.getOnlyElement(implementations.getExactImplementations().values());
        Assert.assertEquals((Object)implementation.getDefinitionClass(), InjectOperatorAggregateFunction.class);
        this.assertDependencyCount(implementation, 1, 1, 1);
        Assert.assertTrue((boolean)(implementation.getInputDependencies().get(0) instanceof OperatorImplementationDependency));
        Assert.assertTrue((boolean)(implementation.getCombineDependencies().get(0) instanceof OperatorImplementationDependency));
        Assert.assertTrue((boolean)(implementation.getOutputDependencies().get(0) instanceof OperatorImplementationDependency));
        Assert.assertFalse((boolean)implementation.hasSpecializedTypeParameters());
        Assert.assertEquals((Collection)implementation.getInputParameterKinds(), (Collection)ImmutableList.of((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL));
        BoundSignature boundSignature = new BoundSignature(aggregation.getFunctionMetadata().getSignature().getName(), (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)DoubleType.DOUBLE));
        TestAnnotationEngineForAggregates.specializeAggregationFunction(boundSignature, (SqlAggregationFunction)aggregation);
    }

    @Test
    public void testInjectTypeAggregateParse() {
        Signature expectedSignature = Signature.builder().name("inject_type_aggregate").typeVariable("T").returnType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentType(new TypeSignature("T", new TypeSignatureParameter[0])).build();
        ParametricAggregation aggregation = (ParametricAggregation)Iterables.getOnlyElement((Iterable)AggregationFromAnnotationsParser.parseFunctionDefinitions(InjectTypeAggregateFunction.class));
        Assert.assertEquals((String)aggregation.getFunctionMetadata().getDescription(), (String)"Simple aggregate with type injected");
        Assert.assertTrue((boolean)aggregation.getFunctionMetadata().isDeterministic());
        Assert.assertEquals((Object)aggregation.getFunctionMetadata().getSignature(), (Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        Assert.assertEquals((int)implementations.getGenericImplementations().size(), (int)1);
        AggregationImplementation implementation = (AggregationImplementation)implementations.getGenericImplementations().get(0);
        Assert.assertEquals((Object)implementation.getDefinitionClass(), InjectTypeAggregateFunction.class);
        this.assertDependencyCount(implementation, 1, 1, 1);
        Assert.assertTrue((boolean)(implementation.getInputDependencies().get(0) instanceof TypeImplementationDependency));
        Assert.assertTrue((boolean)(implementation.getCombineDependencies().get(0) instanceof TypeImplementationDependency));
        Assert.assertTrue((boolean)(implementation.getOutputDependencies().get(0) instanceof TypeImplementationDependency));
        Assert.assertFalse((boolean)implementation.hasSpecializedTypeParameters());
        Assert.assertEquals((Collection)implementation.getInputParameterKinds(), (Collection)ImmutableList.of((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL));
        BoundSignature boundSignature = new BoundSignature(aggregation.getFunctionMetadata().getSignature().getName(), (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)DoubleType.DOUBLE));
        TestAnnotationEngineForAggregates.specializeAggregationFunction(boundSignature, (SqlAggregationFunction)aggregation);
    }

    @Test
    public void testInjectLiteralAggregateParse() {
        Signature expectedSignature = Signature.builder().name("inject_literal_aggregate").returnType(new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})).argumentType(new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})).build();
        ParametricAggregation aggregation = (ParametricAggregation)Iterables.getOnlyElement((Iterable)AggregationFromAnnotationsParser.parseFunctionDefinitions(InjectLiteralAggregateFunction.class));
        Assert.assertEquals((String)aggregation.getFunctionMetadata().getDescription(), (String)"Simple aggregate with type literal");
        Assert.assertTrue((boolean)aggregation.getFunctionMetadata().isDeterministic());
        Assert.assertEquals((Object)aggregation.getFunctionMetadata().getSignature(), (Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        Assert.assertEquals((int)implementations.getGenericImplementations().size(), (int)1);
        AggregationImplementation implementation = (AggregationImplementation)implementations.getGenericImplementations().get(0);
        Assert.assertEquals((Object)implementation.getDefinitionClass(), InjectLiteralAggregateFunction.class);
        this.assertDependencyCount(implementation, 1, 1, 1);
        Assert.assertTrue((boolean)(implementation.getInputDependencies().get(0) instanceof LiteralImplementationDependency));
        Assert.assertTrue((boolean)(implementation.getCombineDependencies().get(0) instanceof LiteralImplementationDependency));
        Assert.assertTrue((boolean)(implementation.getOutputDependencies().get(0) instanceof LiteralImplementationDependency));
        Assert.assertFalse((boolean)implementation.hasSpecializedTypeParameters());
        Assert.assertEquals((Collection)implementation.getInputParameterKinds(), (Collection)ImmutableList.of((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL));
        BoundSignature boundSignature = new BoundSignature(aggregation.getFunctionMetadata().getSignature().getName(), (Type)VarcharType.createVarcharType((int)17), (List)ImmutableList.of((Object)VarcharType.createVarcharType((int)17)));
        AggregationFunctionMetadata aggregationMetadata = aggregation.getAggregationMetadata();
        Assert.assertFalse((boolean)aggregationMetadata.isOrderSensitive());
        Assert.assertFalse((boolean)aggregationMetadata.getIntermediateTypes().isEmpty());
        aggregation.specialize(boundSignature, NO_FUNCTION_DEPENDENCIES);
    }

    @Test
    public void testLongConstraintAggregateFunctionParse() {
        Signature expectedSignature = Signature.builder().name("parametric_aggregate_long_constraint").longVariable("z", "x + y").returnType(new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"z")})).argumentType(new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})).argumentType(new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"y")})).build();
        ParametricAggregation aggregation = (ParametricAggregation)Iterables.getOnlyElement((Iterable)AggregationFromAnnotationsParser.parseFunctionDefinitions(LongConstraintAggregateFunction.class));
        Assert.assertEquals((String)aggregation.getFunctionMetadata().getDescription(), (String)"Parametric aggregate with parametric type returned");
        Assert.assertTrue((boolean)aggregation.getFunctionMetadata().isDeterministic());
        Assert.assertEquals((Object)aggregation.getFunctionMetadata().getSignature(), (Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        Assert.assertEquals((int)implementations.getGenericImplementations().size(), (int)1);
        AggregationImplementation implementation = (AggregationImplementation)implementations.getGenericImplementations().get(0);
        Assert.assertEquals((Object)implementation.getDefinitionClass(), LongConstraintAggregateFunction.class);
        this.assertDependencyCount(implementation, 0, 0, 0);
        Assert.assertFalse((boolean)implementation.hasSpecializedTypeParameters());
        Assert.assertEquals((Collection)implementation.getInputParameterKinds(), (Collection)ImmutableList.of((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL));
        BoundSignature boundSignature = new BoundSignature(aggregation.getFunctionMetadata().getSignature().getName(), (Type)VarcharType.createVarcharType((int)30), (List)ImmutableList.of((Object)VarcharType.createVarcharType((int)17), (Object)VarcharType.createVarcharType((int)13)));
        AggregationFunctionMetadata aggregationMetadata = aggregation.getAggregationMetadata();
        Assert.assertFalse((boolean)aggregationMetadata.isOrderSensitive());
        Assert.assertFalse((boolean)aggregationMetadata.getIntermediateTypes().isEmpty());
        aggregation.specialize(boundSignature, NO_FUNCTION_DEPENDENCIES);
    }

    @Test
    public void testFixedTypeParameterInjectionAggregateFunctionParse() {
        Signature expectedSignature = Signature.builder().name("fixed_type_parameter_injection").returnType(DoubleType.DOUBLE.getTypeSignature()).argumentType(DoubleType.DOUBLE.getTypeSignature()).build();
        ParametricAggregation aggregation = (ParametricAggregation)Iterables.getOnlyElement((Iterable)AggregationFromAnnotationsParser.parseFunctionDefinitions(FixedTypeParameterInjectionAggregateFunction.class));
        Assert.assertEquals((String)aggregation.getFunctionMetadata().getDescription(), (String)"Simple aggregate with fixed parameter type injected");
        Assert.assertTrue((boolean)aggregation.getFunctionMetadata().isDeterministic());
        Assert.assertEquals((Object)aggregation.getFunctionMetadata().getSignature(), (Object)expectedSignature);
        Assert.assertEquals((Collection)aggregation.getStateDetails(), (Collection)ImmutableList.of((Object)AggregationFromAnnotationsParser.toAccumulatorStateDetails(NullableDoubleState.class, (List)ImmutableList.of())));
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        this.assertImplementationCount(implementations, 1, 0, 0);
        AggregationImplementation implementationDouble = (AggregationImplementation)implementations.getExactImplementations().get(expectedSignature);
        Assert.assertEquals((Object)implementationDouble.getDefinitionClass(), FixedTypeParameterInjectionAggregateFunction.class);
        this.assertDependencyCount(implementationDouble, 1, 1, 1);
        Assert.assertFalse((boolean)implementationDouble.hasSpecializedTypeParameters());
        Assert.assertEquals((Collection)implementationDouble.getInputParameterKinds(), (Collection)ImmutableList.of((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL));
    }

    @Test
    public void testPartiallyFixedTypeParameterInjectionAggregateFunctionParse() {
        Signature expectedSignature = Signature.builder().name("partially_fixed_type_parameter_injection").typeVariable("T1").typeVariable("T2").returnType((Type)DoubleType.DOUBLE).argumentType(new TypeSignature("T1", new TypeSignatureParameter[0])).argumentType(new TypeSignature("T2", new TypeSignatureParameter[0])).build();
        ParametricAggregation aggregation = (ParametricAggregation)Iterables.getOnlyElement((Iterable)AggregationFromAnnotationsParser.parseFunctionDefinitions(PartiallyFixedTypeParameterInjectionAggregateFunction.class));
        Assert.assertEquals((String)aggregation.getFunctionMetadata().getDescription(), (String)"Simple aggregate with fixed parameter type injected");
        Assert.assertTrue((boolean)aggregation.getFunctionMetadata().isDeterministic());
        Assert.assertEquals((Object)aggregation.getFunctionMetadata().getSignature(), (Object)expectedSignature);
        Assert.assertEquals((Collection)aggregation.getStateDetails(), (Collection)ImmutableList.of((Object)AggregationFromAnnotationsParser.toAccumulatorStateDetails(NullableDoubleState.class, (List)ImmutableList.of())));
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        this.assertImplementationCount(implementations, 0, 0, 1);
        AggregationImplementation implementationDouble = (AggregationImplementation)Iterables.getOnlyElement((Iterable)implementations.getGenericImplementations());
        Assert.assertEquals((Object)implementationDouble.getDefinitionClass(), PartiallyFixedTypeParameterInjectionAggregateFunction.class);
        this.assertDependencyCount(implementationDouble, 1, 1, 1);
        Assert.assertFalse((boolean)implementationDouble.hasSpecializedTypeParameters());
        Assert.assertEquals((Collection)implementationDouble.getInputParameterKinds(), (Collection)ImmutableList.of((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL));
        BoundSignature boundSignature = new BoundSignature(aggregation.getFunctionMetadata().getSignature().getName(), (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE));
        TestAnnotationEngineForAggregates.specializeAggregationFunction(boundSignature, (SqlAggregationFunction)aggregation);
    }

    @Test
    public void testAggregateFunctionGetCanonicalName() {
        List aggregationOutputFunctions = AggregationFromAnnotationsParser.parseFunctionDefinitions(AggregationOutputFunctionWithAlias.class);
        Assert.assertEquals((int)aggregationOutputFunctions.size(), (int)3);
        Assert.assertEquals((Set)((Set)aggregationOutputFunctions.stream().map(aggregateFunction -> aggregateFunction.getFunctionMetadata().getSignature().getName()).collect(ImmutableSet.toImmutableSet())), (Set)ImmutableSet.of((Object)"aggregation_output", (Object)"aggregation_output_alias_1", (Object)"aggregation_output_alias_2"));
        Assert.assertEquals((Set)((Set)aggregationOutputFunctions.stream().map(aggregateFunction -> aggregateFunction.getFunctionMetadata().getCanonicalName()).collect(ImmutableSet.toImmutableSet())), (Set)ImmutableSet.of((Object)"aggregation_output"));
        List aggregationFunctions = AggregationFromAnnotationsParser.parseFunctionDefinitions(AggregationFunctionWithAlias.class);
        Assert.assertEquals((int)aggregationFunctions.size(), (int)3);
        Assert.assertEquals((Set)((Set)aggregationFunctions.stream().map(aggregateFunction -> aggregateFunction.getFunctionMetadata().getSignature().getName()).collect(ImmutableSet.toImmutableSet())), (Set)ImmutableSet.of((Object)"aggregation", (Object)"aggregation_alias_1", (Object)"aggregation_alias_2"));
        Assert.assertEquals((Set)((Set)aggregationFunctions.stream().map(aggregateFunction -> aggregateFunction.getFunctionMetadata().getCanonicalName()).collect(ImmutableSet.toImmutableSet())), (Set)ImmutableSet.of((Object)"aggregation"));
    }

    private static void specializeAggregationFunction(BoundSignature boundSignature, SqlAggregationFunction aggregation) {
        FunctionMetadata functionMetadata = aggregation.getFunctionMetadata();
        FunctionBinding functionBinding = MetadataManager.toFunctionBinding((FunctionId)functionMetadata.getFunctionId(), (BoundSignature)boundSignature, (Signature)functionMetadata.getSignature());
        AggregationFunctionMetadata aggregationMetadata = aggregation.getAggregationMetadata();
        Assert.assertFalse((boolean)aggregationMetadata.isOrderSensitive());
        Assert.assertFalse((boolean)aggregationMetadata.getIntermediateTypes().isEmpty());
        ResolvedFunction resolvedFunction = METADATA.resolve(SessionTestUtils.TEST_SESSION, functionBinding, functionMetadata, aggregation.getFunctionDependencies(boundSignature));
        FunctionDependencies functionDependencies = new FunctionDependencies((arg_0, arg_1) -> ((FunctionManager)FUNCTION_MANAGER).getScalarFunctionInvoker(arg_0, arg_1), resolvedFunction.getTypeDependencies(), (Collection)resolvedFunction.getFunctionDependencies());
        aggregation.specialize(boundSignature, functionDependencies);
    }

    @AggregationFunction(value="aggregation", alias={"aggregation_alias_1", "aggregation_alias_2"})
    @Description(value="Aggregation function with alias")
    public static final class AggregationFunctionWithAlias {
        @InputFunction
        public static void input(@AggregationState TriStateBooleanState state, @SqlType(value="boolean") boolean value) {
        }

        @CombineFunction
        public static void combine(@AggregationState TriStateBooleanState state, @AggregationState TriStateBooleanState otherState) {
        }

        @OutputFunction(value="boolean")
        public static void output(@AggregationState TriStateBooleanState state, BlockBuilder out) {
        }
    }

    @AggregationFunction
    @Description(value="Aggregation output function with alias")
    public static final class AggregationOutputFunctionWithAlias {
        @InputFunction
        public static void input(@AggregationState VarianceState state, @SqlType(value="double") double value) {
        }

        @CombineFunction
        public static void combine(@AggregationState VarianceState state, @AggregationState VarianceState otherState) {
        }

        @AggregationFunction(value="aggregation_output", alias={"aggregation_output_alias_1", "aggregation_output_alias_2"})
        @OutputFunction(value="double")
        public static void output(@AggregationState VarianceState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="partially_fixed_type_parameter_injection")
    @Description(value="Simple aggregate with fixed parameter type injected")
    public static final class PartiallyFixedTypeParameterInjectionAggregateFunction {
        @InputFunction
        @TypeParameters(value={@TypeParameter(value="T1"), @TypeParameter(value="T2")})
        public static void input(@TypeParameter(value="ROW(ARRAY(T1),ROW(ROW(T2)),CHAR)") Type type, @AggregationState NullableDoubleState state, @SqlType(value="T1") double x, @SqlType(value="T2") double y) {
        }

        @CombineFunction
        @TypeParameters(value={@TypeParameter(value="T1"), @TypeParameter(value="T2")})
        public static void combine(@TypeParameter(value="ROW(ARRAY(T1),ROW(ROW(T2)),CHAR)") Type type, @AggregationState NullableDoubleState state, @AggregationState NullableDoubleState otherState) {
        }

        @OutputFunction(value="double")
        @TypeParameters(value={@TypeParameter(value="T1"), @TypeParameter(value="T2")})
        public static void output(@TypeParameter(value="ROW(ARRAY(T1),ROW(ROW(T2)),CHAR)") Type type, @AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="fixed_type_parameter_injection")
    @Description(value="Simple aggregate with fixed parameter type injected")
    public static final class FixedTypeParameterInjectionAggregateFunction {
        @InputFunction
        public static void input(@TypeParameter(value="ROW(ARRAY(BIGINT),ROW(ROW(CHAR)),BIGINT,MAP(BIGINT,CHAR))") Type type, @AggregationState NullableDoubleState state, @SqlType(value="double") double value) {
        }

        @CombineFunction
        public static void combine(@TypeParameter(value="ROW(ARRAY(BIGINT),ROW(ROW(CHAR)),BIGINT,MAP(BIGINT,CHAR))") Type type, @AggregationState NullableDoubleState state, @AggregationState NullableDoubleState otherState) {
        }

        @OutputFunction(value="double")
        public static void output(@TypeParameter(value="ROW(ARRAY(BIGINT),ROW(ROW(CHAR)),BIGINT,MAP(BIGINT,CHAR))") Type type, @AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="parametric_aggregate_long_constraint")
    @Description(value="Parametric aggregate with parametric type returned")
    public static final class LongConstraintAggregateFunction {
        @InputFunction
        @LiteralParameters(value={"x", "y", "z"})
        @Constraint(variable="z", expression="x + y")
        public static void input(@AggregationState LongState state, @SqlType(value="varchar(x)") Slice slice1, @SqlType(value="varchar(y)") Slice slice2) {
        }

        @CombineFunction
        public static void combine(@AggregationState LongState combine1, @AggregationState LongState combine2) {
        }

        @OutputFunction(value="varchar(z)")
        public static void output(@AggregationState LongState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="inject_literal_aggregate")
    @Description(value="Simple aggregate with type literal")
    public static final class InjectLiteralAggregateFunction {
        @InputFunction
        @LiteralParameters(value={"x"})
        public static void input(@LiteralParameter(value="x") Long varcharSize, @AggregationState LongState state, @SqlType(value="varchar(x)") Slice slice) {
        }

        @CombineFunction
        public static void combine(@LiteralParameter(value="x") Long varcharSize, @AggregationState LongState combine1, @AggregationState LongState combine2) {
        }

        @OutputFunction(value="varchar(x)")
        public static void output(@LiteralParameter(value="x") Long varcharSize, @AggregationState LongState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="inject_type_aggregate")
    @Description(value="Simple aggregate with type injected")
    public static final class InjectTypeAggregateFunction {
        @InputFunction
        @TypeParameter(value="T")
        public static void input(@TypeParameter(value="T") Type type, @AggregationState NullableDoubleState state, @SqlType(value="T") double value) {
        }

        @CombineFunction
        public static void combine(@TypeParameter(value="T") Type type, @AggregationState NullableDoubleState combine1, @AggregationState NullableDoubleState combine2) {
        }

        @OutputFunction(value="T")
        public static void output(@TypeParameter(value="T") Type type, @AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="inject_operator_aggregate")
    @Description(value="Simple aggregate with operator injected")
    public static final class InjectOperatorAggregateFunction {
        @InputFunction
        public static void input(@OperatorDependency(operator=OperatorType.LESS_THAN, argumentTypes={"double", "double"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle methodHandle, @AggregationState NullableDoubleState state, @SqlType(value="double") double value) {
        }

        @CombineFunction
        public static void combine(@OperatorDependency(operator=OperatorType.LESS_THAN, argumentTypes={"double", "double"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle methodHandle, @AggregationState NullableDoubleState combine1, @AggregationState NullableDoubleState combine2) {
        }

        @OutputFunction(value="double")
        public static void output(@OperatorDependency(operator=OperatorType.LESS_THAN, argumentTypes={"double", "double"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle methodHandle, @AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="multi_output_aggregate")
    @Description(value="Simple multi output function aggregate generic description")
    public static final class MultiOutputAggregationFunction {
        @InputFunction
        public static void input(@AggregationState NullableDoubleState state, @SqlType(value="double") double value) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableDoubleState combine1, @AggregationState NullableDoubleState combine2) {
        }

        @AggregationFunction(value="multi_output_aggregate_1")
        @Description(value="Simple multi output function aggregate specialized description")
        @OutputFunction(value="double")
        public static void output1(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }

        @AggregationFunction(value="multi_output_aggregate_2")
        @OutputFunction(value="double")
        public static void output2(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="explicit_specialized_aggregate")
    @Description(value="Simple explicit specialized aggregate")
    public static final class ExplicitSpecializedAggregationFunction {
        @InputFunction
        @TypeParameterSpecialization(name="T", nativeContainerType=double.class)
        @TypeParameter(value="T")
        public static void input(@AggregationState NullableDoubleState state, @SqlType(value="array(T)") Block arrayBlock) {
        }

        @InputFunction
        @TypeParameter(value="T")
        public static void input(@AggregationState NullableLongState state, @SqlType(value="array(T)") Block arrayBlock) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableLongState state, @AggregationState NullableLongState otherState) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableDoubleState state, @AggregationState NullableDoubleState otherState) {
        }

        @OutputFunction(value="T")
        public static void output(@AggregationState NullableLongState state, BlockBuilder out) {
        }

        @OutputFunction(value="T")
        public static void output(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="implicit_specialized_aggregate")
    @Description(value="Simple implicit specialized aggregate")
    public static final class ImplicitSpecializedAggregationFunction {
        @InputFunction
        @TypeParameter(value="T")
        public static void input(@AggregationState NullableDoubleState state, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="T") double additionalValue) {
        }

        @InputFunction
        @TypeParameter(value="T")
        public static void input(@AggregationState NullableLongState state, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="T") long additionalValue) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableLongState state, @AggregationState NullableLongState otherState) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableDoubleState state, @AggregationState NullableDoubleState otherState) {
        }

        @OutputFunction(value="T")
        public static void output(@AggregationState NullableLongState state, BlockBuilder out) {
        }

        @OutputFunction(value="T")
        public static void output(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="block_input_aggregate")
    @Description(value="Simple aggregate with @BlockPosition usage")
    public static final class BlockInputAggregationFunction {
        @InputFunction
        public static void input(@AggregationState NullableDoubleState state, @BlockPosition @SqlType(value="double") Block value, @BlockIndex int id) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableDoubleState combine1, @AggregationState NullableDoubleState combine2) {
        }

        @OutputFunction(value="double")
        public static void output(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="simple_generic_implementations")
    @Description(value="Simple aggregate with two generic implementations")
    public static final class GenericAggregationFunction {
        @InputFunction
        @TypeParameter(value="T")
        public static void input(@AggregationState NullableLongState state, @SqlType(value="T") double value) {
        }

        @InputFunction
        @TypeParameter(value="T")
        public static void input(@AggregationState NullableLongState state, @SqlType(value="T") long value) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableLongState state, @AggregationState NullableLongState otherState) {
        }

        @OutputFunction(value="T")
        public static void output(@AggregationState NullableLongState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="custom_decomposable_aggregate", decomposable=false)
    @Description(value="Aggregate with Decomposable=false")
    public static final class NotDecomposableAggregationFunction {
        @InputFunction
        public static void input(@AggregationState NullableDoubleState state, @SqlType(value="double") double value) {
        }

        @OutputFunction(value="double")
        public static void output(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="no_aggregation_state_aggregate")
    @Description(value="Aggregate with no @AggregationState annotations")
    public static final class NotAnnotatedAggregateStateAggregationFunction {
        @InputFunction
        public static void input(NullableDoubleState state, @SqlType(value="double") double value) {
        }

        @CombineFunction
        public static void combine(NullableDoubleState combine1, NullableDoubleState combine2) {
        }

        @OutputFunction(value="double")
        public static void output(NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="output_parameters_wrong_order")
    @Description(value="AggregationState must be the first output parameter")
    public static final class OutputParametersWrongOrder {
        @InputFunction
        public static void input(@AggregationState NullableDoubleState state, @SqlType(value="double") double value) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableDoubleState combine1, @AggregationState NullableDoubleState combine2) {
        }

        @OutputFunction(value="double")
        public static void output(BlockBuilder out, @AggregationState NullableDoubleState state) {
        }
    }

    @AggregationFunction(value="input_parameters_wrong_order")
    @Description(value="AggregationState must be the first input parameter")
    public static final class InputParametersWrongOrder {
        @InputFunction
        public static void input(@SqlType(value="double") double value, @AggregationState NullableDoubleState state) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableDoubleState combine1, @AggregationState NullableDoubleState combine2) {
        }

        @OutputFunction(value="double")
        public static void output(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="simple_exact_aggregate")
    @Description(value="Simple exact aggregate description")
    public static final class ExactAggregationFunction {
        @InputFunction
        public static void input(@AggregationState NullableDoubleState state, @SqlType(value="double") double value) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableDoubleState combine1, @AggregationState NullableDoubleState combine2) {
        }

        @OutputFunction(value="double")
        public static void output(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }
}

