/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionDependencies;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.Signature;
import io.trino.operator.TestAnnotationEngine;
import io.trino.operator.annotations.LiteralImplementationDependency;
import io.trino.operator.annotations.TypeImplementationDependency;
import io.trino.operator.scalar.ChoicesScalarFunctionImplementation;
import io.trino.operator.scalar.ParametricScalar;
import io.trino.operator.scalar.annotations.ParametricScalarImplementation;
import io.trino.operator.scalar.annotations.ScalarFromAnnotationsParser;
import io.trino.spi.block.Block;
import io.trino.spi.function.Description;
import io.trino.spi.function.IsNull;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.function.TypeParameters;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAnnotationEngineForScalars
extends TestAnnotationEngine {
    private static final FunctionManager FUNCTION_MANAGER = FunctionManager.createTestingFunctionManager();

    @Test
    public void testSingleImplementationScalarParse() {
        Signature expectedSignature = Signature.builder().name("single_implementation_parametric_scalar").returnType((Type)DoubleType.DOUBLE).argumentType((Type)DoubleType.DOUBLE).build();
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(SingleImplementationScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assert.assertEquals((Object)functionMetadata.getSignature(), (Object)expectedSignature);
        Assert.assertTrue((boolean)functionMetadata.isDeterministic());
        Assert.assertFalse((boolean)functionMetadata.isHidden());
        Assert.assertEquals((String)functionMetadata.getDescription(), (String)"Simple scalar with single implementation based on class");
        Assert.assertFalse((boolean)functionMetadata.getFunctionNullability().isArgumentNullable(0));
        this.assertImplementationCount(scalar, 1, 0, 0);
        BoundSignature boundSignature = new BoundSignature(expectedSignature.getName(), (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)DoubleType.DOUBLE));
        ChoicesScalarFunctionImplementation specialized = (ChoicesScalarFunctionImplementation)scalar.specialize(boundSignature, new FunctionDependencies((arg_0, arg_1) -> ((FunctionManager)FUNCTION_MANAGER).getScalarFunctionInvoker(arg_0, arg_1), (Map)ImmutableMap.of(), (Collection)ImmutableSet.of()));
        Assert.assertFalse((boolean)((ChoicesScalarFunctionImplementation.ScalarImplementationChoice)specialized.getChoices().get(0)).getInstanceFactory().isPresent());
    }

    @Test
    public void testHiddenScalarParse() {
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(HiddenScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assert.assertTrue((boolean)functionMetadata.isDeterministic());
        Assert.assertTrue((boolean)functionMetadata.isHidden());
    }

    @Test
    public void testNonDeterministicScalarParse() {
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(NonDeterministicScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assert.assertFalse((boolean)functionMetadata.isDeterministic());
        Assert.assertFalse((boolean)functionMetadata.isHidden());
    }

    @Test
    public void testWithNullablePrimitiveArgScalarParse() {
        Signature expectedSignature = Signature.builder().name("scalar_with_nullable").returnType((Type)DoubleType.DOUBLE).argumentType((Type)DoubleType.DOUBLE).argumentType((Type)DoubleType.DOUBLE).build();
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(WithNullablePrimitiveArgScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assert.assertEquals((Object)functionMetadata.getSignature(), (Object)expectedSignature);
        Assert.assertTrue((boolean)functionMetadata.isDeterministic());
        Assert.assertFalse((boolean)functionMetadata.isHidden());
        Assert.assertEquals((String)functionMetadata.getDescription(), (String)"Simple scalar with nullable primitive");
        Assert.assertFalse((boolean)functionMetadata.getFunctionNullability().isArgumentNullable(0));
        Assert.assertTrue((boolean)functionMetadata.getFunctionNullability().isArgumentNullable(1));
        BoundSignature boundSignature = new BoundSignature(expectedSignature.getName(), (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE));
        ChoicesScalarFunctionImplementation specialized = (ChoicesScalarFunctionImplementation)scalar.specialize(boundSignature, new FunctionDependencies((arg_0, arg_1) -> ((FunctionManager)FUNCTION_MANAGER).getScalarFunctionInvoker(arg_0, arg_1), (Map)ImmutableMap.of(), (Collection)ImmutableSet.of()));
        Assert.assertFalse((boolean)((ChoicesScalarFunctionImplementation.ScalarImplementationChoice)specialized.getChoices().get(0)).getInstanceFactory().isPresent());
    }

    @Test
    public void testWithNullableComplexArgScalarParse() {
        Signature expectedSignature = Signature.builder().name("scalar_with_nullable_complex").returnType((Type)DoubleType.DOUBLE).argumentType((Type)DoubleType.DOUBLE).argumentType((Type)DoubleType.DOUBLE).build();
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(WithNullableComplexArgScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assert.assertEquals((Object)functionMetadata.getSignature(), (Object)expectedSignature);
        Assert.assertTrue((boolean)functionMetadata.isDeterministic());
        Assert.assertFalse((boolean)functionMetadata.isHidden());
        Assert.assertEquals((String)functionMetadata.getDescription(), (String)"Simple scalar with nullable complex type");
        Assert.assertFalse((boolean)functionMetadata.getFunctionNullability().isArgumentNullable(0));
        Assert.assertTrue((boolean)functionMetadata.getFunctionNullability().isArgumentNullable(1));
        BoundSignature boundSignature = new BoundSignature(expectedSignature.getName(), (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE));
        ChoicesScalarFunctionImplementation specialized = (ChoicesScalarFunctionImplementation)scalar.specialize(boundSignature, new FunctionDependencies((arg_0, arg_1) -> ((FunctionManager)FUNCTION_MANAGER).getScalarFunctionInvoker(arg_0, arg_1), (Map)ImmutableMap.of(), (Collection)ImmutableSet.of()));
        Assert.assertFalse((boolean)((ChoicesScalarFunctionImplementation.ScalarImplementationChoice)specialized.getChoices().get(0)).getInstanceFactory().isPresent());
    }

    @Test
    public void testStaticMethodScalarParse() {
        Signature expectedSignature = Signature.builder().name("static_method_scalar").returnType((Type)DoubleType.DOUBLE).argumentType((Type)DoubleType.DOUBLE).build();
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinitions(StaticMethodScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assert.assertEquals((Object)functionMetadata.getSignature(), (Object)expectedSignature);
        Assert.assertTrue((boolean)functionMetadata.isDeterministic());
        Assert.assertFalse((boolean)functionMetadata.isHidden());
        Assert.assertEquals((String)functionMetadata.getDescription(), (String)"Simple scalar with single implementation based on method");
    }

    @Test
    public void testMultiScalarParse() {
        Signature expectedSignature1 = Signature.builder().name("static_method_scalar_1").returnType((Type)DoubleType.DOUBLE).argumentType((Type)DoubleType.DOUBLE).build();
        Signature expectedSignature2 = Signature.builder().name("static_method_scalar_2").returnType((Type)BigintType.BIGINT).argumentType((Type)BigintType.BIGINT).build();
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinitions(MultiScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)2);
        ParametricScalar scalar1 = (ParametricScalar)((ImmutableList)functions.stream().filter(function -> function.getFunctionMetadata().getSignature().equals((Object)expectedSignature1)).collect(ImmutableList.toImmutableList())).get(0);
        ParametricScalar scalar2 = (ParametricScalar)((ImmutableList)functions.stream().filter(function -> function.getFunctionMetadata().getSignature().equals((Object)expectedSignature2)).collect(ImmutableList.toImmutableList())).get(0);
        this.assertImplementationCount(scalar1, 1, 0, 0);
        this.assertImplementationCount(scalar2, 1, 0, 0);
        FunctionMetadata functionMetadata1 = scalar1.getFunctionMetadata();
        Assert.assertEquals((Object)functionMetadata1.getSignature(), (Object)expectedSignature1);
        Assert.assertTrue((boolean)functionMetadata1.isDeterministic());
        Assert.assertFalse((boolean)functionMetadata1.isHidden());
        Assert.assertEquals((String)functionMetadata1.getDescription(), (String)"Simple scalar with single implementation based on method 1");
        FunctionMetadata functionMetadata2 = scalar2.getFunctionMetadata();
        Assert.assertEquals((Object)functionMetadata2.getSignature(), (Object)expectedSignature2);
        Assert.assertFalse((boolean)functionMetadata2.isDeterministic());
        Assert.assertTrue((boolean)functionMetadata2.isHidden());
        Assert.assertEquals((String)functionMetadata2.getDescription(), (String)"Simple scalar with single implementation based on method 2");
    }

    @Test
    public void testParametricScalarParse() {
        Signature expectedSignature = Signature.builder().name("parametric_scalar").typeVariable("T").returnType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentType(new TypeSignature("T", new TypeSignatureParameter[0])).build();
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(ParametricScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        this.assertImplementationCount(scalar, 0, 2, 0);
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assert.assertEquals((Object)functionMetadata.getSignature(), (Object)expectedSignature);
        Assert.assertTrue((boolean)functionMetadata.isDeterministic());
        Assert.assertFalse((boolean)functionMetadata.isHidden());
        Assert.assertEquals((String)functionMetadata.getDescription(), (String)"Parametric scalar description");
    }

    @Test
    public void testComplexParametricScalarParse() {
        Signature expectedSignature = Signature.builder().name("with_exact_scalar").returnType((Type)BooleanType.BOOLEAN).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")}))).build();
        Signature exactSignature = Signature.builder().name("with_exact_scalar").returnType((Type)BooleanType.BOOLEAN).argumentType(TypeSignature.arrayType((TypeSignature)VarcharType.createVarcharType((int)17).getTypeSignature())).build();
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(ComplexParametricScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        this.assertImplementationCount(scalar.getImplementations(), 1, 0, 1);
        Assert.assertEquals((Object)Iterables.getOnlyElement(scalar.getImplementations().getExactImplementations().keySet()), (Object)exactSignature);
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assert.assertEquals((Object)functionMetadata.getSignature(), (Object)expectedSignature);
        Assert.assertTrue((boolean)functionMetadata.isDeterministic());
        Assert.assertFalse((boolean)functionMetadata.isHidden());
        Assert.assertEquals((String)functionMetadata.getDescription(), (String)"Parametric scalar with exact and generic implementations");
    }

    @Test
    public void testSimpleInjectionScalarParse() {
        Signature expectedSignature = Signature.builder().name("parametric_scalar_inject").returnType((Type)BigintType.BIGINT).argumentType(new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})).build();
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(SimpleInjectionScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        this.assertImplementationCount(scalar, 0, 0, 1);
        List parametricScalarImplementationChoices = ((ParametricScalarImplementation)scalar.getImplementations().getGenericImplementations().get(0)).getChoices();
        Assert.assertEquals((int)parametricScalarImplementationChoices.size(), (int)1);
        List dependencies = ((ParametricScalarImplementation.ParametricScalarImplementationChoice)parametricScalarImplementationChoices.get(0)).getDependencies();
        Assert.assertEquals((int)dependencies.size(), (int)1);
        Assert.assertTrue((boolean)(dependencies.get(0) instanceof LiteralImplementationDependency));
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assert.assertEquals((Object)functionMetadata.getSignature(), (Object)expectedSignature);
        Assert.assertTrue((boolean)functionMetadata.isDeterministic());
        Assert.assertFalse((boolean)functionMetadata.isHidden());
        Assert.assertEquals((String)functionMetadata.getDescription(), (String)"Parametric scalar with literal injected");
    }

    @Test
    public void testConstructorInjectionScalarParse() {
        Signature expectedSignature = Signature.builder().name("parametric_scalar_inject_constructor").typeVariable("T").returnType((Type)BigintType.BIGINT).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))).build();
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(ConstructorInjectionScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        this.assertImplementationCount(scalar, 2, 0, 1);
        List parametricScalarImplementationChoices = ((ParametricScalarImplementation)scalar.getImplementations().getGenericImplementations().get(0)).getChoices();
        Assert.assertEquals((int)parametricScalarImplementationChoices.size(), (int)1);
        List dependencies = ((ParametricScalarImplementation.ParametricScalarImplementationChoice)parametricScalarImplementationChoices.get(0)).getDependencies();
        Assert.assertEquals((int)dependencies.size(), (int)0);
        List constructorDependencies = ((ParametricScalarImplementation.ParametricScalarImplementationChoice)parametricScalarImplementationChoices.get(0)).getConstructorDependencies();
        Assert.assertEquals((int)constructorDependencies.size(), (int)1);
        Assert.assertTrue((boolean)(constructorDependencies.get(0) instanceof TypeImplementationDependency));
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assert.assertEquals((Object)functionMetadata.getSignature(), (Object)expectedSignature);
        Assert.assertTrue((boolean)functionMetadata.isDeterministic());
        Assert.assertFalse((boolean)functionMetadata.isHidden());
        Assert.assertEquals((String)functionMetadata.getDescription(), (String)"Parametric scalar with type injected though constructor");
    }

    @Test
    public void testFixedTypeParameterParse() {
        Signature expectedSignature = Signature.builder().name("fixed_type_parameter_scalar_function").returnType((Type)BigintType.BIGINT).argumentType((Type)BigintType.BIGINT).build();
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(FixedTypeParameterScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        this.assertImplementationCount(scalar, 1, 0, 0);
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assert.assertEquals((Object)functionMetadata.getSignature(), (Object)expectedSignature);
        Assert.assertTrue((boolean)functionMetadata.isDeterministic());
        Assert.assertFalse((boolean)functionMetadata.isHidden());
        Assert.assertEquals((String)functionMetadata.getDescription(), (String)"Parametric scalar that uses TypeParameter with fixed type");
    }

    @Test
    public void testPartiallyFixedTypeParameterParse() {
        Signature expectedSignature = Signature.builder().name("partially_fixed_type_parameter_scalar_function").typeVariable("T1").typeVariable("T2").returnType((Type)BigintType.BIGINT).argumentType((Type)BigintType.BIGINT).build();
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(PartiallyFixedTypeParameterScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        this.assertImplementationCount(scalar, 0, 0, 1);
        List parametricScalarImplementationChoices = ((ParametricScalarImplementation)scalar.getImplementations().getGenericImplementations().get(0)).getChoices();
        Assert.assertEquals((int)parametricScalarImplementationChoices.size(), (int)1);
        List dependencies = ((ParametricScalarImplementation.ParametricScalarImplementationChoice)parametricScalarImplementationChoices.get(0)).getDependencies();
        Assert.assertEquals((int)dependencies.size(), (int)1);
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assert.assertEquals((Object)functionMetadata.getSignature(), (Object)expectedSignature);
        Assert.assertTrue((boolean)functionMetadata.isDeterministic());
        Assert.assertFalse((boolean)functionMetadata.isHidden());
        Assert.assertEquals((String)functionMetadata.getDescription(), (String)"Parametric scalar that uses TypeParameter with partially fixed type");
    }

    @ScalarFunction(value="partially_fixed_type_parameter_scalar_function")
    @Description(value="Parametric scalar that uses TypeParameter with partially fixed type")
    public static final class PartiallyFixedTypeParameterScalarFunction {
        @SqlType(value="bigint")
        @TypeParameters(value={@TypeParameter(value="T1"), @TypeParameter(value="T2")})
        public static long fun(@TypeParameter(value="ROW(ARRAY(T1),ROW(ROW(T2)),CHAR)") Type type, @SqlType(value="bigint") long value) {
            return value;
        }
    }

    @ScalarFunction(value="fixed_type_parameter_scalar_function")
    @Description(value="Parametric scalar that uses TypeParameter with fixed type")
    public static final class FixedTypeParameterScalarFunction {
        @SqlType(value="bigint")
        public static long fun(@TypeParameter(value="ROW(ARRAY(BIGINT),ROW(ROW(CHAR)),BIGINT,MAP(BIGINT,CHAR))") Type type, @SqlType(value="bigint") long value) {
            return value;
        }
    }

    @ScalarFunction(value="parametric_scalar_inject_constructor")
    @Description(value="Parametric scalar with type injected though constructor")
    public static class ConstructorInjectionScalarFunction {
        @TypeParameter(value="T")
        public ConstructorInjectionScalarFunction(@TypeParameter(value="T") Type type) {
        }

        @SqlType(value="bigint")
        @TypeParameter(value="T")
        public long fun(@SqlType(value="array(T)") Block val) {
            return 17L;
        }

        @SqlType(value="bigint")
        public long funBigint(@SqlType(value="array(bigint)") Block val) {
            return 17L;
        }

        @SqlType(value="bigint")
        public long funDouble(@SqlType(value="array(double)") Block val) {
            return 17L;
        }
    }

    @ScalarFunction(value="parametric_scalar_inject")
    @Description(value="Parametric scalar with literal injected")
    public static final class SimpleInjectionScalarFunction {
        @SqlType(value="bigint")
        @LiteralParameters(value={"x"})
        public static long fun(@LiteralParameter(value="x") Long literalParam, @SqlType(value="varchar(x)") Slice val) {
            return literalParam;
        }
    }

    @ScalarFunction(value="with_exact_scalar")
    @Description(value="Parametric scalar with exact and generic implementations")
    public static final class ComplexParametricScalarFunction {
        @SqlType(value="boolean")
        @LiteralParameters(value={"x"})
        public static boolean fun1(@SqlType(value="array(varchar(x))") Block array) {
            return true;
        }

        @SqlType(value="boolean")
        public static boolean fun2(@SqlType(value="array(varchar(17))") Block array) {
            return true;
        }
    }

    @ScalarFunction(value="parametric_scalar")
    @Description(value="Parametric scalar description")
    public static final class ParametricScalarFunction {
        @SqlType(value="T")
        @TypeParameter(value="T")
        public static double fun(@SqlType(value="T") double v) {
            return v;
        }

        @SqlType(value="T")
        @TypeParameter(value="T")
        public static long fun(@SqlType(value="T") long v) {
            return v;
        }
    }

    public static final class MultiScalarFunction {
        @ScalarFunction(value="static_method_scalar_1")
        @Description(value="Simple scalar with single implementation based on method 1")
        @SqlType(value="double")
        public static double fun1(@SqlType(value="double") double v) {
            return v;
        }

        @ScalarFunction(value="static_method_scalar_2", hidden=true, deterministic=false)
        @Description(value="Simple scalar with single implementation based on method 2")
        @SqlType(value="bigint")
        public static long fun2(@SqlType(value="bigint") long v) {
            return v;
        }
    }

    public static final class StaticMethodScalarFunction {
        @ScalarFunction(value="static_method_scalar")
        @Description(value="Simple scalar with single implementation based on method")
        @SqlType(value="double")
        public static double fun(@SqlType(value="double") double v) {
            return v;
        }
    }

    @ScalarFunction(value="scalar_with_nullable_complex")
    @Description(value="Simple scalar with nullable complex type")
    public static final class WithNullableComplexArgScalarFunction {
        @SqlType(value="double")
        public static double fun(@SqlType(value="double") double v, @SqlNullable @SqlType(value="double") Double v2) {
            return v;
        }
    }

    @ScalarFunction(value="scalar_with_nullable")
    @Description(value="Simple scalar with nullable primitive")
    public static final class WithNullablePrimitiveArgScalarFunction {
        @SqlType(value="double")
        public static double fun(@SqlType(value="double") double v, @SqlType(value="double") double v2, @IsNull boolean v2isNull) {
            return v;
        }
    }

    @ScalarFunction(value="non_deterministic_scalar_function", deterministic=false)
    @Description(value="Simple scalar with deterministic property reset")
    public static final class NonDeterministicScalarFunction {
        @SqlType(value="double")
        public static double fun(@SqlType(value="double") double v) {
            return v;
        }
    }

    @ScalarFunction(value="hidden_scalar_function", hidden=true)
    @Description(value="Simple scalar with hidden property set")
    public static final class HiddenScalarFunction {
        @SqlType(value="double")
        public static double fun(@SqlType(value="double") double v) {
            return v;
        }
    }

    @ScalarFunction(value="single_implementation_parametric_scalar")
    @Description(value="Simple scalar with single implementation based on class")
    public static final class SingleImplementationScalarFunction {
        @SqlType(value="double")
        public static double fun(@SqlType(value="double") double v) {
            return v;
        }
    }
}

