/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.listagg;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.block.BlockAssertions;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.aggregation.AggregationTestUtils;
import io.trino.operator.aggregation.listagg.ListaggAggregationFunction;
import io.trino.operator.aggregation.listagg.ListaggAggregationState;
import io.trino.operator.aggregation.listagg.SingleListaggAggregationState;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.tree.QualifiedName;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestListaggAggregationFunction {
    private static final TestingFunctionResolution FUNCTION_RESOLUTION = new TestingFunctionResolution();

    @Test
    public void testInputEmptyState() {
        SingleListaggAggregationState state = new SingleListaggAggregationState();
        String s = "value1";
        Block value = BlockAssertions.createStringsBlock(s);
        Slice separator = Slices.utf8Slice((String)",");
        Slice overflowFiller = Slices.utf8Slice((String)"...");
        ListaggAggregationFunction.input((ListaggAggregationState)state, (Block)value, (Slice)separator, (boolean)false, (Slice)overflowFiller, (boolean)true, (int)0);
        Assert.assertFalse((boolean)state.isEmpty());
        Assert.assertEquals((Object)state.getSeparator(), (Object)separator);
        Assert.assertFalse((boolean)state.isOverflowError());
        Assert.assertEquals((Object)state.getOverflowFiller(), (Object)overflowFiller);
        Assert.assertTrue((boolean)state.showOverflowEntryCount());
        VariableWidthBlockBuilder out = new VariableWidthBlockBuilder(null, 16, 128);
        state.forEach((arg_0, arg_1) -> TestListaggAggregationFunction.lambda$testInputEmptyState$0((BlockBuilder)out, arg_0, arg_1));
        out.closeEntry();
        String result = (String)BlockAssertions.getOnlyValue((Type)VarcharType.VARCHAR, (Block)out);
        Assert.assertEquals((String)result, (String)s);
    }

    @Test
    public void testInputOverflowOverflowFillerTooLong() {
        String overflowFillerTooLong = ".".repeat(65537);
        SingleListaggAggregationState state = new SingleListaggAggregationState();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ListaggAggregationFunction.input((ListaggAggregationState)state, (Block)BlockAssertions.createStringsBlock("value1"), (Slice)Slices.utf8Slice((String)","), (boolean)false, (Slice)Slices.utf8Slice((String)overflowFillerTooLong), (boolean)false, (int)0)).isInstanceOf(TrinoException.class)).matches(throwable -> ((TrinoException)((Object)throwable)).getErrorCode() == StandardErrorCode.INVALID_FUNCTION_ARGUMENT.toErrorCode());
    }

    @Test
    public void testOutputStateSingleValue() {
        SingleListaggAggregationState state = TestListaggAggregationFunction.createListaggAggregationState(",", true, "...", false, "value1");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 1024), (String)"value1");
    }

    @Test
    public void testOutputStateWithOverflowError() {
        SingleListaggAggregationState state = TestListaggAggregationFunction.createListaggAggregationState("", true, "...", false, "overflowvalue1", "overflowvalue2");
        VariableWidthBlockBuilder out = new VariableWidthBlockBuilder(null, 16, 128);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestListaggAggregationFunction.lambda$testOutputStateWithOverflowError$3(state, (BlockBuilder)out)).isInstanceOf(TrinoException.class)).matches(throwable -> ((TrinoException)((Object)throwable)).getErrorCode() == StandardErrorCode.EXCEEDED_FUNCTION_MEMORY_LIMIT.toErrorCode());
    }

    @Test
    public void testOutputStateWithEmptyValues() {
        SingleListaggAggregationState state = TestListaggAggregationFunction.createListaggAggregationState(",", true, "...", false, "trino", "", "", "", "");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 12), (String)"trino,,,,");
    }

    @Test
    public void testOutputStateWithEmptyDelimiter() {
        SingleListaggAggregationState state = TestListaggAggregationFunction.createListaggAggregationState("", true, "...", false, "value1", "value2");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 12), (String)"value1value2");
    }

    @Test
    public void testOutputStateWithSeparatorSpecialUnicodeCharacter() {
        SingleListaggAggregationState state = TestListaggAggregationFunction.createListaggAggregationState("\u2665", true, "...", false, "Trino", "SQL", "on", "everything");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 29), (String)"Trino\u2665SQL\u2665on\u2665everything");
    }

    @Test
    public void testOutputTruncatedStateFirstValueTooBigWithoutIndicationCount() {
        SingleListaggAggregationState state = TestListaggAggregationFunction.createListaggAggregationState(",", false, "...", false, "value1", "value2");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 5), (String)"...");
    }

    @Test
    public void testOutputTruncatedStateLastDelimiterOmitted() {
        SingleListaggAggregationState state = TestListaggAggregationFunction.createListaggAggregationState("###", false, "...", false, "value1", "value2", "value3");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 18), (String)"value1###value2###...");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 19), (String)"value1###value2###...");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 20), (String)"value1###value2###...");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 21), (String)"value1###value2###...");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 22), (String)"value1###value2###...");
    }

    @Test
    public void testOutputTruncatedStateWithoutIndicationCount() {
        SingleListaggAggregationState state = TestListaggAggregationFunction.createListaggAggregationState(",", false, "...", false, "value1", "value2");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 9), (String)"value1,...");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 10), (String)"value1,...");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 11), (String)"value1,...");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 12), (String)"value1,...");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 13), (String)"value1,value2");
    }

    @Test
    public void testOutputTruncatedStateWithIndicationCount() {
        SingleListaggAggregationState state = TestListaggAggregationFunction.createListaggAggregationState(",", false, "...", true, "string1", "string2");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 12), (String)"string1,...(1)");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 13), (String)"string1,...(1)");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 14), (String)"string1,...(1)");
    }

    @Test
    public void testOutputTruncatedStateWithIndicationCountAlphabet() {
        SingleListaggAggregationState state = TestListaggAggregationFunction.createListaggAggregationState(",", false, "...", true, "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "x", "y", "z");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 13), (String)"a,b,c,d,e,f,g,...(18)");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 14), (String)"a,b,c,d,e,f,g,...(18)");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 15), (String)"a,b,c,d,e,f,g,h,...(17)");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 16), (String)"a,b,c,d,e,f,g,h,...(17)");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 17), (String)"a,b,c,d,e,f,g,h,i,...(16)");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 18), (String)"a,b,c,d,e,f,g,h,i,...(16)");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 19), (String)"a,b,c,d,e,f,g,h,i,j,...(15)");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 20), (String)"a,b,c,d,e,f,g,h,i,j,...(15)");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 21), (String)"a,b,c,d,e,f,g,h,i,j,k,...(14)");
    }

    @Test
    public void testOutputTruncatedStateWithIndicationCountComplexSeparator() {
        SingleListaggAggregationState state = TestListaggAggregationFunction.createListaggAggregationState("###", false, "...", true, "a", "b", "c", "dd", "e", "f", "g", "h", "i", "j", "k", "l");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 100), (String)"a###b###c###dd###e###f###g###h###i###j###k###l");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 15), (String)"a###b###c###dd###...(8)");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 16), (String)"a###b###c###dd###...(8)");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 17), (String)"a###b###c###dd###...(8)");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 18), (String)"a###b###c###dd###e###...(7)");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 19), (String)"a###b###c###dd###e###...(7)");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 20), (String)"a###b###c###dd###e###...(7)");
        Assert.assertEquals((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 21), (String)"a###b###c###dd###e###...(7)");
    }

    @Test
    public void testExecute() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BooleanType.BOOLEAN, VarcharType.VARCHAR, BooleanType.BOOLEAN});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"listagg"), (List<TypeSignatureProvider>)parameterTypes, null, BlockAssertions.createStringsBlock(null, null, null), BlockAssertions.createStringsBlock(",", ",", ","), BlockAssertions.createBooleansBlock(false, false, false), BlockAssertions.createStringsBlock("", "", ""), BlockAssertions.createBooleansBlock(false, false, false));
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"listagg"), (List<TypeSignatureProvider>)parameterTypes, (Object)"a,c", BlockAssertions.createStringsBlock("a", null, "c"), BlockAssertions.createStringsBlock(",", ",", ","), BlockAssertions.createBooleansBlock(false, false, false), BlockAssertions.createStringsBlock("", "", ""), BlockAssertions.createBooleansBlock(false, false, false));
    }

    private static String getOutputStateOnlyValue(SingleListaggAggregationState state, int maxOutputLengthInBytes) {
        VariableWidthBlockBuilder out = new VariableWidthBlockBuilder(null, 32, 256);
        ListaggAggregationFunction.outputState((ListaggAggregationState)state, (BlockBuilder)out, (int)maxOutputLengthInBytes);
        return (String)BlockAssertions.getOnlyValue((Type)VarcharType.VARCHAR, (Block)out);
    }

    private static SingleListaggAggregationState createListaggAggregationState(String separator, boolean overflowError, String overflowFiller, boolean showOverflowEntryCount, String ... values) {
        SingleListaggAggregationState state = new SingleListaggAggregationState();
        state.setSeparator(Slices.utf8Slice((String)separator));
        state.setOverflowError(overflowError);
        state.setOverflowFiller(Slices.utf8Slice((String)overflowFiller));
        state.setShowOverflowEntryCount(showOverflowEntryCount);
        for (String value : values) {
            state.add(BlockAssertions.createStringsBlock(value), 0);
        }
        return state;
    }

    private static /* synthetic */ void lambda$testOutputStateWithOverflowError$3(SingleListaggAggregationState state, BlockBuilder out) throws Throwable {
        ListaggAggregationFunction.outputState((ListaggAggregationState)state, (BlockBuilder)out, (int)20);
    }

    private static /* synthetic */ boolean lambda$testInputEmptyState$0(BlockBuilder out, Block block, int position) {
        block.writeBytesTo(position, 0, block.getSliceLength(position), out);
        return true;
    }
}

