/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.slice.Slices;
import io.airlift.testing.Assertions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.ExceededMemoryLimitException;
import io.trino.RowPagesBuilder;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.connector.CatalogServiceProvider;
import io.trino.execution.NodeTaskMap;
import io.trino.execution.StageId;
import io.trino.execution.TaskId;
import io.trino.execution.TaskStateMachine;
import io.trino.execution.scheduler.NodeScheduler;
import io.trino.execution.scheduler.NodeSchedulerConfig;
import io.trino.execution.scheduler.NodeSelectorFactory;
import io.trino.execution.scheduler.UniformNodeSelectorFactory;
import io.trino.metadata.InMemoryNodeManager;
import io.trino.metadata.InternalNodeManager;
import io.trino.operator.Driver;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorAssertion;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactories;
import io.trino.operator.OperatorFactory;
import io.trino.operator.ProcessorContext;
import io.trino.operator.TaskContext;
import io.trino.operator.TrinoOperatorFactories;
import io.trino.operator.ValuesOperator;
import io.trino.operator.WorkProcessor;
import io.trino.operator.WorkProcessorOperator;
import io.trino.operator.WorkProcessorOperatorFactory;
import io.trino.operator.index.PageBuffer;
import io.trino.operator.index.PageBufferOperator;
import io.trino.operator.join.HashBuilderOperator;
import io.trino.operator.join.JoinBridgeManager;
import io.trino.operator.join.JoinTestUtils;
import io.trino.operator.join.LookupSourceFactory;
import io.trino.operator.join.LookupSourceProvider;
import io.trino.operator.join.PartitionedLookupSourceFactory;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.spiller.GenericPartitioningSpillerFactory;
import io.trino.spiller.PartitioningSpillerFactory;
import io.trino.spiller.SingleStreamSpillerFactory;
import io.trino.sql.planner.NodePartitioningManager;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.MaterializedResult;
import io.trino.testing.TestingTaskContext;
import io.trino.type.BlockTypeOperators;
import io.trino.util.FinalizerService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractThrowableAssert;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestHashJoinOperator {
    private static final int PARTITION_COUNT = 4;
    private static final SingleStreamSpillerFactory SINGLE_STREAM_SPILLER_FACTORY = new JoinTestUtils.DummySpillerFactory();
    private static final PartitioningSpillerFactory PARTITIONING_SPILLER_FACTORY = new GenericPartitioningSpillerFactory(SINGLE_STREAM_SPILLER_FACTORY);
    private static final BlockTypeOperators TYPE_OPERATOR_FACTORY = new BlockTypeOperators(new TypeOperators());
    private final OperatorFactories operatorFactories;
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private NodePartitioningManager nodePartitioningManager;

    public TestHashJoinOperator() {
        this((OperatorFactories)new TrinoOperatorFactories());
    }

    protected TestHashJoinOperator(OperatorFactories operatorFactories) {
        this.operatorFactories = Objects.requireNonNull(operatorFactories, "operatorFactories is null");
    }

    @BeforeMethod
    public void setUp() {
        this.executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Threads.daemonThreadsNamed((String)"test-executor-%s"), new ThreadPoolExecutor.DiscardPolicy());
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
        NodeScheduler nodeScheduler = new NodeScheduler((NodeSelectorFactory)new UniformNodeSelectorFactory((InternalNodeManager)new InMemoryNodeManager(), new NodeSchedulerConfig().setIncludeCoordinator(true), new NodeTaskMap(new FinalizerService())));
        this.nodePartitioningManager = new NodePartitioningManager(nodeScheduler, new BlockTypeOperators(new TypeOperators()), CatalogServiceProvider.fail());
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @DataProvider(name="hashJoinTestValues")
    public static Object[][] hashJoinTestValuesProvider() {
        return new Object[][]{{true, true, true}, {true, true, false}, {true, false, true}, {true, false, false}, {false, true, true}, {false, true, false}, {false, false, true}, {false, false, false}};
    }

    @Test(dataProvider="hashJoinTestValues")
    public void testInnerJoin(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT)).addSequencePage(10, 20, 30, 40);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
        List<Page> probeInput = probePages.addSequencePage(1000, 0, 1000, 2000).build();
        OperatorFactory joinOperatorFactory = JoinTestUtils.innerJoinOperatorFactory(this.operatorFactories, lookupSourceFactory, probePages, PARTITIONING_SPILLER_FACTORY, false);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probePages.getTypesWithoutHash(), buildPages.getTypesWithoutHash())).row(new Object[]{"20", 1020L, 2020L, "20", 30L, 40L}).row(new Object[]{"21", 1021L, 2021L, "21", 31L, 41L}).row(new Object[]{"22", 1022L, 2022L, "22", 32L, 42L}).row(new Object[]{"23", 1023L, 2023L, "23", 33L, 43L}).row(new Object[]{"24", 1024L, 2024L, "24", 34L, 44L}).row(new Object[]{"25", 1025L, 2025L, "25", 35L, 45L}).row(new Object[]{"26", 1026L, 2026L, "26", 36L, 46L}).row(new Object[]{"27", 1027L, 2027L, "27", 37L, 47L}).row(new Object[]{"28", 1028L, 2028L, "28", 38L, 48L}).row(new Object[]{"29", 1029L, 2029L, "29", 39L, 49L}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testInnerJoinWithRunLengthEncodedProbe() {
        TaskContext taskContext = this.createTaskContext();
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(false, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR)).addSequencePage(10, 20).addSequencePage(10, 21);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, false, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(false, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR));
        ImmutableList probeInput = ImmutableList.of((Object)new Page(new Block[]{RunLengthEncodedBlock.create((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"20"), (int)2)}), (Object)new Page(new Block[]{RunLengthEncodedBlock.create((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"-1"), (int)2)}), (Object)new Page(new Block[]{RunLengthEncodedBlock.create((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"21"), (int)2)}));
        OperatorFactory joinOperatorFactory = JoinTestUtils.innerJoinOperatorFactory(this.operatorFactories, lookupSourceFactory, probePages, PARTITIONING_SPILLER_FACTORY, false);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probePages.getTypesWithoutHash(), buildPages.getTypesWithoutHash())).row(new Object[]{"20", "20"}).row(new Object[]{"20", "20"}).row(new Object[]{"21", "21"}).row(new Object[]{"21", "21"}).row(new Object[]{"21", "21"}).row(new Object[]{"21", "21"}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), (List<Page>)probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testUnwrapsLazyBlocks() {
        TaskContext taskContext = this.createTaskContext();
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        JoinTestUtils.TestInternalJoinFilterFunction filterFunction = new JoinTestUtils.TestInternalJoinFilterFunction((leftPosition, leftPage, rightPosition, rightPage) -> {
            rightPage.getBlock(1).getLoadedBlock();
            return true;
        });
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(false, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addSequencePage(1, 0);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, true, taskContext, buildPages, Optional.of(filterFunction), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(false, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
        List probeInput = probePages.addSequencePage(1, 0, 0).build();
        probeInput = (List)probeInput.stream().map(page -> new Page(new Block[]{page.getBlock(0), new LazyBlock(1, () -> page.getBlock(1))})).collect(ImmutableList.toImmutableList());
        OperatorFactory joinOperatorFactory = this.operatorFactories.innerJoin(0, new PlanNodeId("test"), lookupSourceFactory, false, false, true, true, probePages.getTypes(), Ints.asList((int[])new int[]{0}), JoinTestUtils.getHashChannelAsInt(probePages), Optional.empty(), OptionalInt.of(1), PARTITIONING_SPILLER_FACTORY, TYPE_OPERATOR_FACTORY);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        Operator operator = joinOperatorFactory.createOperator(driverContext);
        Assert.assertTrue((boolean)operator.needsInput());
        operator.addInput((Page)probeInput.get(0));
        operator.finish();
        Page output = operator.getOutput();
        Assert.assertFalse((boolean)(output.getBlock(1) instanceof LazyBlock));
    }

    @Test
    public void testYield() {
        TaskContext taskContext = this.createTaskContext();
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        AtomicInteger filterFunctionCalls = new AtomicInteger();
        JoinTestUtils.TestInternalJoinFilterFunction filterFunction = new JoinTestUtils.TestInternalJoinFilterFunction((leftPosition, leftPage, rightPosition, rightPage) -> {
            filterFunctionCalls.incrementAndGet();
            driverContext.getYieldSignal().forceYieldForTesting();
            return true;
        });
        int entries = 40;
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(true, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addSequencePage(entries, 42);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, true, taskContext, buildPages, Optional.of(filterFunction), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(false, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)BigintType.BIGINT));
        List<Page> probeInput = probePages.addSequencePage(100, 0).build();
        OperatorFactory joinOperatorFactory = this.operatorFactories.innerJoin(0, new PlanNodeId("test"), lookupSourceFactory, false, false, true, true, probePages.getTypes(), Ints.asList((int[])new int[]{0}), JoinTestUtils.getHashChannelAsInt(probePages), Optional.empty(), OptionalInt.of(1), PARTITIONING_SPILLER_FACTORY, TYPE_OPERATOR_FACTORY);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        Operator operator = joinOperatorFactory.createOperator(driverContext);
        Assert.assertTrue((boolean)operator.needsInput());
        operator.addInput(probeInput.get(0));
        operator.finish();
        for (int i = 0; i < entries; ++i) {
            driverContext.getYieldSignal().setWithDelay(5L * TimeUnit.SECONDS.toNanos(1L), driverContext.getYieldExecutor());
            filterFunctionCalls.set(0);
            Assert.assertNull((Object)operator.getOutput());
            io.trino.testing.assertions.Assert.assertEquals((int)filterFunctionCalls.get(), (int)1, (String)"Expected join to stop processing (yield) after calling filter function once");
            driverContext.getYieldSignal().reset();
        }
        driverContext.getYieldSignal().setWithDelay(5L * TimeUnit.SECONDS.toNanos(1L), driverContext.getYieldExecutor());
        Page output = null;
        for (int i = 0; output == null && i < 5; ++i) {
            output = operator.getOutput();
        }
        Assert.assertNotNull(output);
        driverContext.getYieldSignal().reset();
        io.trino.testing.assertions.Assert.assertEquals((int)output.getPositionCount(), (int)entries);
    }

    @DataProvider
    public Object[][] joinWithSpillValues() {
        return (Object[][])TestHashJoinOperator.joinWithSpillParameters(true).stream().map(List::toArray).toArray(x$0 -> new Object[x$0][]);
    }

    @DataProvider
    public Object[][] joinWithFailingSpillValues() {
        List spillFailValues = Arrays.stream(WhenSpillFails.values()).map(ImmutableList::of).collect(Collectors.toList());
        return (Object[][])TestHashJoinOperator.product(TestHashJoinOperator.joinWithSpillParameters(false), spillFailValues).stream().map(List::toArray).toArray(x$0 -> new Object[x$0][]);
    }

    private static List<List<Object>> joinWithSpillParameters(boolean allowNoSpill) {
        ArrayList<List<Object>> result = new ArrayList<List<Object>>();
        UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)false, (Object)true).iterator();
        while (unmodifiableIterator.hasNext()) {
            boolean probeHashEnabled = (Boolean)unmodifiableIterator.next();
            for (WhenSpill whenSpill : WhenSpill.values()) {
                if (allowNoSpill || whenSpill != WhenSpill.NEVER) {
                    result.add((List<Object>)ImmutableList.of((Object)probeHashEnabled, Collections.nCopies(4, whenSpill)));
                }
                if (whenSpill == WhenSpill.NEVER) continue;
                result.add((List<Object>)ImmutableList.of((Object)probeHashEnabled, TestHashJoinOperator.concat(Collections.singletonList(whenSpill), Collections.nCopies(3, WhenSpill.NEVER))));
            }
            result.add((List<Object>)ImmutableList.of((Object)probeHashEnabled, TestHashJoinOperator.concat(Arrays.asList(WhenSpill.DURING_BUILD, WhenSpill.AFTER_BUILD), Collections.nCopies(2, WhenSpill.NEVER))));
            result.add((List<Object>)ImmutableList.of((Object)probeHashEnabled, TestHashJoinOperator.concat(Arrays.asList(WhenSpill.DURING_BUILD, WhenSpill.DURING_USAGE), Collections.nCopies(2, WhenSpill.NEVER))));
        }
        return result;
    }

    @Test(dataProvider="joinWithSpillValues")
    public void testInnerJoinWithSpill(boolean probeHashEnabled, List<WhenSpill> whenSpill) throws Exception {
        this.innerJoinWithSpill(probeHashEnabled, whenSpill, SINGLE_STREAM_SPILLER_FACTORY, PARTITIONING_SPILLER_FACTORY);
    }

    @Test(dataProvider="joinWithFailingSpillValues")
    public void testInnerJoinWithFailingSpill(boolean probeHashEnabled, List<WhenSpill> whenSpill, WhenSpillFails whenSpillFails) {
        String expectedMessage;
        JoinTestUtils.DummySpillerFactory buildSpillerFactory = new JoinTestUtils.DummySpillerFactory();
        JoinTestUtils.DummySpillerFactory joinSpillerFactory = new JoinTestUtils.DummySpillerFactory();
        GenericPartitioningSpillerFactory partitioningSpillerFactory = new GenericPartitioningSpillerFactory((SingleStreamSpillerFactory)joinSpillerFactory);
        switch (whenSpillFails) {
            case SPILL_BUILD: {
                buildSpillerFactory.failSpill();
                expectedMessage = "Spill failed";
                break;
            }
            case SPILL_JOIN: {
                joinSpillerFactory.failSpill();
                expectedMessage = "Spill failed";
                break;
            }
            case UNSPILL_BUILD: {
                buildSpillerFactory.failUnspill();
                expectedMessage = "Unspill failed";
                break;
            }
            case UNSPILL_JOIN: {
                joinSpillerFactory.failUnspill();
                expectedMessage = "Unspill failed";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported option: %s", new Object[]{whenSpillFails}));
            }
        }
        ((AbstractThrowableAssert)org.assertj.core.api.Assertions.assertThatThrownBy(() -> this.lambda$testInnerJoinWithFailingSpill$6(probeHashEnabled, whenSpill, buildSpillerFactory, (PartitioningSpillerFactory)partitioningSpillerFactory)).isInstanceOf(RuntimeException.class)).hasMessage(expectedMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerJoinWithSpill(boolean probeHashEnabled, List<WhenSpill> whenSpill, SingleStreamSpillerFactory buildSpillerFactory, PartitioningSpillerFactory joinSpillerFactory) throws Exception {
        TaskStateMachine taskStateMachine = new TaskStateMachine(new TaskId(new StageId("query", 0), 0, 0), (Executor)this.executor);
        TaskContext taskContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION, (TaskStateMachine)taskStateMachine);
        DriverContext joinDriverContext = taskContext.addPipelineContext(2, true, true, false).addDriverContext();
        AtomicBoolean called = new AtomicBoolean(false);
        JoinTestUtils.TestInternalJoinFilterFunction filterFunction = new JoinTestUtils.TestInternalJoinFilterFunction((leftPosition, leftPage, rightPosition, rightPage) -> {
            called.set(true);
            joinDriverContext.getYieldSignal().forceYieldForTesting();
            return true;
        });
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(false, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT)).addSequencePage(4, 20, 200).addSequencePage(4, 20, 200).addSequencePage(4, 30, 300).addSequencePage(4, 40, 400);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, true, taskContext, buildPages, Optional.of(filterFunction), true, buildSpillerFactory);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactoryManager = buildSideSetup.getLookupSourceFactoryManager();
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT)).row("20", 123000L).row("20", 123000L).pageBreak().addSequencePage(20, 0, 123000).addSequencePage(10, 30, 123000);
        OperatorFactory joinOperatorFactory = JoinTestUtils.innerJoinOperatorFactory(this.operatorFactories, lookupSourceFactoryManager, probePages, joinSpillerFactory, true);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        List<Driver> buildDrivers = buildSideSetup.getBuildDrivers();
        int buildOperatorCount = buildDrivers.size();
        Preconditions.checkState((buildOperatorCount == whenSpill.size() ? 1 : 0) != 0);
        LookupSourceFactory lookupSourceFactory = (LookupSourceFactory)lookupSourceFactoryManager.getJoinBridge();
        try (Operator joinOperator = joinOperatorFactory.createOperator(joinDriverContext);){
            int i;
            ListenableFuture lookupSourceProvider = lookupSourceFactory.createLookupSourceProvider();
            ArrayList<Boolean> revoked = new ArrayList<Boolean>(Collections.nCopies(buildOperatorCount, false));
            while (!lookupSourceProvider.isDone()) {
                for (i = 0; i < buildOperatorCount; ++i) {
                    TestHashJoinOperator.checkErrors(taskStateMachine);
                    buildDrivers.get(i).processForNumberOfIterations(1);
                    HashBuilderOperator buildOperator = buildSideSetup.getBuildOperators().get(i);
                    if (whenSpill.get(i) != WhenSpill.DURING_BUILD || buildOperator.getOperatorContext().getReservedRevocableBytes() <= 0L) continue;
                    Preconditions.checkState((!lookupSourceProvider.isDone() ? 1 : 0) != 0, (Object)"Too late, LookupSource already done");
                    TestHashJoinOperator.revokeMemory(buildOperator);
                    revoked.set(i, true);
                }
            }
            ((LookupSourceProvider)MoreFutures.getFutureValue((Future)lookupSourceProvider)).close();
            io.trino.testing.assertions.Assert.assertEquals(revoked, (Collection)((Collection)whenSpill.stream().map(WhenSpill.DURING_BUILD::equals).collect(ImmutableList.toImmutableList())), (String)"Some operators not spilled before LookupSource built");
            for (i = 0; i < buildOperatorCount; ++i) {
                if (whenSpill.get(i) != WhenSpill.AFTER_BUILD) continue;
                TestHashJoinOperator.revokeMemory(buildSideSetup.getBuildOperators().get(i));
            }
            for (Driver buildDriver : buildDrivers) {
                JoinTestUtils.runDriverInThread(this.executor, buildDriver);
            }
            ValuesOperator.ValuesOperatorFactory valuesOperatorFactory = new ValuesOperator.ValuesOperatorFactory(17, new PlanNodeId("values"), probePages.build());
            PageBuffer pageBuffer = new PageBuffer(10);
            PageBufferOperator.PageBufferOperatorFactory pageBufferOperatorFactory = new PageBufferOperator.PageBufferOperatorFactory(18, new PlanNodeId("pageBuffer"), pageBuffer, "PageBuffer");
            Driver joinDriver = Driver.createDriver((DriverContext)joinDriverContext, (Operator)valuesOperatorFactory.createOperator(joinDriverContext), (Operator[])new Operator[]{joinOperator, pageBufferOperatorFactory.createOperator(joinDriverContext)});
            while (!called.get()) {
                TestHashJoinOperator.processRow(joinDriver, taskStateMachine);
            }
            for (int i2 = 0; i2 < buildOperatorCount; ++i2) {
                if (whenSpill.get(i2) != WhenSpill.DURING_USAGE) continue;
                TestHashJoinOperator.triggerMemoryRevokingAndWait(buildSideSetup.getBuildOperators().get(i2), taskStateMachine);
            }
            while (!joinDriver.isFinished()) {
                TestHashJoinOperator.checkErrors(taskStateMachine);
                TestHashJoinOperator.processRow(joinDriver, taskStateMachine);
            }
            TestHashJoinOperator.checkErrors(taskStateMachine);
            List<Page> actualPages = TestHashJoinOperator.getPages(pageBuffer);
            MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probePages.getTypesWithoutHash(), buildPages.getTypesWithoutHash())).row(new Object[]{"20", 123000L, "20", 200L}).row(new Object[]{"20", 123000L, "20", 200L}).row(new Object[]{"20", 123000L, "20", 200L}).row(new Object[]{"20", 123000L, "20", 200L}).row(new Object[]{"30", 123000L, "30", 300L}).row(new Object[]{"31", 123001L, "31", 301L}).row(new Object[]{"32", 123002L, "32", 302L}).row(new Object[]{"33", 123003L, "33", 303L}).build();
            Assertions.assertEqualsIgnoreOrder((Iterable)TestHashJoinOperator.getProperColumns(joinOperator, TestHashJoinOperator.concat(probePages.getTypes(), buildPages.getTypes()), probePages, actualPages).getMaterializedRows(), (Iterable)expected.getMaterializedRows());
        }
        finally {
            joinOperatorFactory.noMoreOperators();
        }
    }

    private static void processRow(Driver joinDriver, TaskStateMachine taskStateMachine) {
        joinDriver.process(new Duration(1.0, TimeUnit.NANOSECONDS), 1);
        TestHashJoinOperator.checkErrors(taskStateMachine);
    }

    private static void checkErrors(TaskStateMachine taskStateMachine) {
        if (taskStateMachine.getFailureCauses().size() > 0) {
            Throwable exception = Objects.requireNonNull((Throwable)taskStateMachine.getFailureCauses().peek());
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    private static void revokeMemory(HashBuilderOperator operator) {
        MoreFutures.getFutureValue((Future)operator.startMemoryRevoke());
        operator.finishMemoryRevoke();
        Preconditions.checkState((operator.getState() == HashBuilderOperator.State.SPILLING_INPUT || operator.getState() == HashBuilderOperator.State.INPUT_SPILLED ? 1 : 0) != 0);
    }

    private static void triggerMemoryRevokingAndWait(HashBuilderOperator operator, TaskStateMachine taskStateMachine) throws Exception {
        operator.getOperatorContext().requestMemoryRevoking();
        while (operator.getOperatorContext().isMemoryRevokingRequested()) {
            TestHashJoinOperator.checkErrors(taskStateMachine);
            Thread.sleep(10L);
        }
        TestHashJoinOperator.checkErrors(taskStateMachine);
        Preconditions.checkState((operator.getState() == HashBuilderOperator.State.SPILLING_INPUT || operator.getState() == HashBuilderOperator.State.INPUT_SPILLED ? 1 : 0) != 0);
    }

    private static List<Page> getPages(PageBuffer pageBuffer) {
        ArrayList<Page> result = new ArrayList<Page>();
        Page page = pageBuffer.poll();
        while (page != null) {
            result.add(page);
            page = pageBuffer.poll();
        }
        return result;
    }

    private static MaterializedResult getProperColumns(Operator joinOperator, List<Type> types, RowPagesBuilder probePages, List<Page> actualPages) {
        if (probePages.getHashChannel().isPresent()) {
            ImmutableList hashChannels = ImmutableList.of((Object)probePages.getHashChannel().get());
            actualPages = OperatorAssertion.dropChannel(actualPages, (List<Integer>)hashChannels);
            types = OperatorAssertion.without(types, (Collection<Integer>)hashChannels);
        }
        return OperatorAssertion.toMaterializedResult(joinOperator.getOperatorContext().getSession(), types, actualPages);
    }

    @Test(timeOut=30000L)
    public void testBuildGracefulSpill() throws Exception {
        TaskStateMachine taskStateMachine = new TaskStateMachine(new TaskId(new StageId("query", 0), 0, 0), (Executor)this.executor);
        TaskContext taskContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION, (TaskStateMachine)taskStateMachine);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(false, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT)).addSequencePage(4, 20, 200);
        JoinTestUtils.DummySpillerFactory buildSpillerFactory = new JoinTestUtils.DummySpillerFactory();
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, true, taskContext, buildPages, Optional.empty(), true, buildSpillerFactory);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactoryManager = buildSideSetup.getLookupSourceFactoryManager();
        PartitionedLookupSourceFactory lookupSourceFactory = (PartitionedLookupSourceFactory)lookupSourceFactoryManager.getJoinBridge();
        lookupSourceFactory.finishProbeOperator(OptionalInt.of(1));
        HashBuilderOperator hashBuilderOperator = buildSideSetup.getBuildOperators().get(0);
        hashBuilderOperator.startMemoryRevoke().get();
        hashBuilderOperator.finishMemoryRevoke();
        hashBuilderOperator.finish();
        hashBuilderOperator.isBlocked().get();
        lookupSourceFactory.destroy();
        Assert.assertTrue((boolean)hashBuilderOperator.isFinished());
    }

    @Test(dataProvider="hashJoinTestValues")
    public void testInnerJoinWithNullProbe(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes).row("a").row("b").row("c");
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("a").row(new Object[]{null}).row(new Object[]{null}).row("a").row("b").build();
        OperatorFactory joinOperatorFactory = JoinTestUtils.innerJoinOperatorFactory(this.operatorFactories, lookupSourceFactory, probePages, PARTITIONING_SPILLER_FACTORY, false);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildPages.getTypesWithoutHash())).row(new Object[]{"a", "a"}).row(new Object[]{"a", "a"}).row(new Object[]{"b", "b"}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test(dataProvider="hashJoinTestValues")
    public void testInnerJoinWithOutputSingleMatch(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes).row("a").row("a").row("b");
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("a").row("b").row("c").build();
        OperatorFactory joinOperatorFactory = JoinTestUtils.innerJoinOperatorFactory(this.operatorFactories, lookupSourceFactory, probePages, PARTITIONING_SPILLER_FACTORY, true, false);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{"a", "a"}).row(new Object[]{"b", "b"}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test(dataProvider="hashJoinTestValues")
    public void testInnerJoinWithNullBuild(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes).row("a").row(new Object[]{null}).row(new Object[]{null}).row("a").row("b");
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("a").row("b").row("c").build();
        OperatorFactory joinOperatorFactory = JoinTestUtils.innerJoinOperatorFactory(this.operatorFactories, lookupSourceFactory, probePages, PARTITIONING_SPILLER_FACTORY, false);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{"a", "a"}).row(new Object[]{"a", "a"}).row(new Object[]{"b", "b"}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test(dataProvider="hashJoinTestValues")
    public void testInnerJoinWithNullOnBothSides(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes).row("a").row(new Object[]{null}).row(new Object[]{null}).row("a").row("b");
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("a").row("b").row(new Object[]{null}).row("c").build();
        OperatorFactory joinOperatorFactory = JoinTestUtils.innerJoinOperatorFactory(this.operatorFactories, lookupSourceFactory, probePages, PARTITIONING_SPILLER_FACTORY, false);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{"a", "a"}).row(new Object[]{"a", "a"}).row(new Object[]{"b", "b"}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test(dataProvider="hashJoinTestValues")
    public void testProbeOuterJoin(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT)).addSequencePage(10, 20, 30, 40);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.addSequencePage(15, 20, 1020, 2020).build();
        OperatorFactory joinOperatorFactory = this.probeOuterJoinOperatorFactory(lookupSourceFactory, probePages, false);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{"20", 1020L, 2020L, "20", 30L, 40L}).row(new Object[]{"21", 1021L, 2021L, "21", 31L, 41L}).row(new Object[]{"22", 1022L, 2022L, "22", 32L, 42L}).row(new Object[]{"23", 1023L, 2023L, "23", 33L, 43L}).row(new Object[]{"24", 1024L, 2024L, "24", 34L, 44L}).row(new Object[]{"25", 1025L, 2025L, "25", 35L, 45L}).row(new Object[]{"26", 1026L, 2026L, "26", 36L, 46L}).row(new Object[]{"27", 1027L, 2027L, "27", 37L, 47L}).row(new Object[]{"28", 1028L, 2028L, "28", 38L, 48L}).row(new Object[]{"29", 1029L, 2029L, "29", 39L, 49L}).row(new Object[]{"30", 1030L, 2030L, null, null, null}).row(new Object[]{"31", 1031L, 2031L, null, null, null}).row(new Object[]{"32", 1032L, 2032L, null, null, null}).row(new Object[]{"33", 1033L, 2033L, null, null, null}).row(new Object[]{"34", 1034L, 2034L, null, null, null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test(dataProvider="hashJoinTestValues")
    public void testProbeOuterJoinWithFilterFunction(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        JoinTestUtils.TestInternalJoinFilterFunction filterFunction = new JoinTestUtils.TestInternalJoinFilterFunction((leftPosition, leftPage, rightPosition, rightPage) -> BigintType.BIGINT.getLong(rightPage.getBlock(1), rightPosition) >= 1025L);
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT)).addSequencePage(10, 20, 30, 40);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.of(filterFunction), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.addSequencePage(15, 20, 1020, 2020).build();
        OperatorFactory joinOperatorFactory = this.probeOuterJoinOperatorFactory(lookupSourceFactory, probePages, true);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{"20", 1020L, 2020L, null, null, null}).row(new Object[]{"21", 1021L, 2021L, null, null, null}).row(new Object[]{"22", 1022L, 2022L, null, null, null}).row(new Object[]{"23", 1023L, 2023L, null, null, null}).row(new Object[]{"24", 1024L, 2024L, null, null, null}).row(new Object[]{"25", 1025L, 2025L, "25", 35L, 45L}).row(new Object[]{"26", 1026L, 2026L, "26", 36L, 46L}).row(new Object[]{"27", 1027L, 2027L, "27", 37L, 47L}).row(new Object[]{"28", 1028L, 2028L, "28", 38L, 48L}).row(new Object[]{"29", 1029L, 2029L, "29", 39L, 49L}).row(new Object[]{"30", 1030L, 2030L, null, null, null}).row(new Object[]{"31", 1031L, 2031L, null, null, null}).row(new Object[]{"32", 1032L, 2032L, null, null, null}).row(new Object[]{"33", 1033L, 2033L, null, null, null}).row(new Object[]{"34", 1034L, 2034L, null, null, null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test(dataProvider="hashJoinTestValues")
    public void testOuterJoinWithNullProbe(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes).row("a").row("b").row("c");
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("a").row(new Object[]{null}).row(new Object[]{null}).row("a").row("b").build();
        OperatorFactory joinOperatorFactory = this.probeOuterJoinOperatorFactory(lookupSourceFactory, probePages, false);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{"a", "a"}).row(new Object[]{null, null}).row(new Object[]{null, null}).row(new Object[]{"a", "a"}).row(new Object[]{"b", "b"}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test(dataProvider="hashJoinTestValues")
    public void testOuterJoinWithNullProbeAndFilterFunction(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        JoinTestUtils.TestInternalJoinFilterFunction filterFunction = new JoinTestUtils.TestInternalJoinFilterFunction((leftPosition, leftPage, rightPosition, rightPage) -> VarcharType.VARCHAR.getSlice(rightPage.getBlock(0), rightPosition).toStringAscii().equals("a"));
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes).row("a").row("b").row("c");
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.of(filterFunction), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("a").row(new Object[]{null}).row(new Object[]{null}).row("a").row("b").build();
        OperatorFactory joinOperatorFactory = this.probeOuterJoinOperatorFactory(lookupSourceFactory, probePages, true);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{"a", "a"}).row(new Object[]{null, null}).row(new Object[]{null, null}).row(new Object[]{"a", "a"}).row(new Object[]{"b", null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test(dataProvider="hashJoinTestValues")
    public void testOuterJoinWithNullBuild(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR)).row("a").row(new Object[]{null}).row(new Object[]{null}).row("a").row("b");
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("a").row("b").row("c").build();
        OperatorFactory joinOperatorFactory = this.probeOuterJoinOperatorFactory(lookupSourceFactory, probePages, false);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{"a", "a"}).row(new Object[]{"a", "a"}).row(new Object[]{"b", "b"}).row(new Object[]{"c", null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test(dataProvider="hashJoinTestValues")
    public void testOuterJoinWithNullBuildAndFilterFunction(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        JoinTestUtils.TestInternalJoinFilterFunction filterFunction = new JoinTestUtils.TestInternalJoinFilterFunction((leftPosition, leftPage, rightPosition, rightPage) -> ImmutableSet.of((Object)"a", (Object)"c").contains((Object)VarcharType.VARCHAR.getSlice(rightPage.getBlock(0), rightPosition).toStringAscii()));
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR)).row("a").row(new Object[]{null}).row(new Object[]{null}).row("a").row("b");
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.of(filterFunction), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("a").row("b").row("c").build();
        OperatorFactory joinOperatorFactory = this.probeOuterJoinOperatorFactory(lookupSourceFactory, probePages, true);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{"a", "a"}).row(new Object[]{"a", "a"}).row(new Object[]{"b", null}).row(new Object[]{"c", null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test(dataProvider="hashJoinTestValues")
    public void testOuterJoinWithNullOnBothSides(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR)).row("a").row(new Object[]{null}).row(new Object[]{null}).row("a").row("b");
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("a").row("b").row(new Object[]{null}).row("c").build();
        OperatorFactory joinOperatorFactory = this.probeOuterJoinOperatorFactory(lookupSourceFactory, probePages, false);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildPages.getTypesWithoutHash())).row(new Object[]{"a", "a"}).row(new Object[]{"a", "a"}).row(new Object[]{"b", "b"}).row(new Object[]{null, null}).row(new Object[]{"c", null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test(dataProvider="hashJoinTestValues")
    public void testOuterJoinWithNullOnBothSidesAndFilterFunction(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        JoinTestUtils.TestInternalJoinFilterFunction filterFunction = new JoinTestUtils.TestInternalJoinFilterFunction((leftPosition, leftPage, rightPosition, rightPage) -> ImmutableSet.of((Object)"a", (Object)"c").contains((Object)VarcharType.VARCHAR.getSlice(rightPage.getBlock(0), rightPosition).toStringAscii()));
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR)).row("a").row(new Object[]{null}).row(new Object[]{null}).row("a").row("b");
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.of(filterFunction), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("a").row("b").row(new Object[]{null}).row("c").build();
        OperatorFactory joinOperatorFactory = this.probeOuterJoinOperatorFactory(lookupSourceFactory, probePages, true);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildPages.getTypesWithoutHash())).row(new Object[]{"a", "a"}).row(new Object[]{"a", "a"}).row(new Object[]{"b", null}).row(new Object[]{null, null}).row(new Object[]{"c", null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test(dataProvider="testMemoryLimitProvider")
    public void testMemoryLimit(boolean parallelBuild, boolean buildHashEnabled) {
        TaskContext taskContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION, (DataSize)DataSize.ofBytes((long)100L));
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT)).addSequencePage(10, 20, 30, 40);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        ((AbstractThrowableAssert)org.assertj.core.api.Assertions.assertThatThrownBy(() -> JoinTestUtils.buildLookupSource(this.executor, buildSideSetup)).isInstanceOf(ExceededMemoryLimitException.class)).hasMessageMatching("Query exceeded per-node memory limit of.*");
    }

    @Test(dataProvider="hashJoinTestValues")
    public void testInnerJoinWithEmptyLookupSource(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactoryManager = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        OperatorFactory joinOperatorFactory = this.operatorFactories.innerJoin(0, new PlanNodeId("test"), lookupSourceFactoryManager, false, false, false, true, probePages.getTypes(), Ints.asList((int[])new int[]{0}), JoinTestUtils.getHashChannelAsInt(probePages), Optional.empty(), OptionalInt.of(1), PARTITIONING_SPILLER_FACTORY, TYPE_OPERATOR_FACTORY);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        Operator operator = joinOperatorFactory.createOperator(taskContext.addPipelineContext(0, true, true, false).addDriverContext());
        List<Page> pages = probePages.row("test").build();
        operator.addInput(pages.get(0));
        Page outputPage = operator.getOutput();
        Assert.assertNull((Object)outputPage);
    }

    @Test(dataProvider="hashJoinTestValues")
    public void testLookupOuterJoinWithEmptyLookupSource(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactoryManager = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        OperatorFactory joinOperatorFactory = this.operatorFactories.lookupOuterJoin(0, new PlanNodeId("test"), lookupSourceFactoryManager, false, false, true, probePages.getTypes(), Ints.asList((int[])new int[]{0}), JoinTestUtils.getHashChannelAsInt(probePages), Optional.empty(), OptionalInt.of(1), PARTITIONING_SPILLER_FACTORY, TYPE_OPERATOR_FACTORY);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        Operator operator = joinOperatorFactory.createOperator(taskContext.addPipelineContext(0, true, true, false).addDriverContext());
        List<Page> pages = probePages.row("test").build();
        operator.addInput(pages.get(0));
        Page outputPage = operator.getOutput();
        Assert.assertNull((Object)outputPage);
    }

    @Test(dataProvider="hashJoinTestValues")
    public void testProbeOuterJoinWithEmptyLookupSource(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactoryManager = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("a").row("b").row(new Object[]{null}).row("c").build();
        OperatorFactory joinOperatorFactory = this.operatorFactories.probeOuterJoin(0, new PlanNodeId("test"), lookupSourceFactoryManager, false, false, true, probePages.getTypes(), Ints.asList((int[])new int[]{0}), JoinTestUtils.getHashChannelAsInt(probePages), Optional.empty(), OptionalInt.of(1), PARTITIONING_SPILLER_FACTORY, TYPE_OPERATOR_FACTORY);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{"a", null}).row(new Object[]{"b", null}).row(new Object[]{null, null}).row(new Object[]{"c", null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test(dataProvider="hashJoinTestValues")
    public void testFullOuterJoinWithEmptyLookupSource(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactoryManager = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("a").row("b").row(new Object[]{null}).row("c").build();
        OperatorFactory joinOperatorFactory = this.operatorFactories.fullOuterJoin(0, new PlanNodeId("test"), lookupSourceFactoryManager, false, true, probePages.getTypes(), Ints.asList((int[])new int[]{0}), JoinTestUtils.getHashChannelAsInt(probePages), Optional.empty(), OptionalInt.of(1), PARTITIONING_SPILLER_FACTORY, TYPE_OPERATOR_FACTORY);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{"a", null}).row(new Object[]{"b", null}).row(new Object[]{null, null}).row(new Object[]{"c", null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test(dataProvider="hashJoinTestValues")
    public void testInnerJoinWithNonEmptyLookupSourceAndEmptyProbe(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes).row("a").row("b").row(new Object[]{null}).row("c");
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactoryManager = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.build();
        OperatorFactory joinOperatorFactory = this.operatorFactories.innerJoin(0, new PlanNodeId("test"), lookupSourceFactoryManager, false, false, false, true, probePages.getTypes(), Ints.asList((int[])new int[]{0}), JoinTestUtils.getHashChannelAsInt(probePages), Optional.empty(), OptionalInt.of(1), PARTITIONING_SPILLER_FACTORY, TYPE_OPERATOR_FACTORY);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test(dataProvider="hashJoinTestValues")
    public void testInnerJoinWithBlockingLookupSourceAndEmptyProbe(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) throws Exception {
        TaskContext taskContext = this.createTaskContext();
        OperatorFactory joinOperatorFactory = this.createJoinOperatorFactoryWithBlockingLookupSource(taskContext, parallelBuild, probeHashEnabled, buildHashEnabled, true);
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        try (Operator joinOperator = joinOperatorFactory.createOperator(driverContext);){
            joinOperatorFactory.noMoreOperators();
            Assert.assertFalse((boolean)joinOperator.needsInput());
            joinOperator.finish();
            Assert.assertNull((Object)joinOperator.getOutput());
            Assert.assertFalse((boolean)joinOperator.isBlocked().isDone());
            Assert.assertFalse((boolean)joinOperator.isFinished());
        }
        taskContext = this.createTaskContext();
        joinOperatorFactory = this.createJoinOperatorFactoryWithBlockingLookupSource(taskContext, parallelBuild, probeHashEnabled, buildHashEnabled, false);
        driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        joinOperator = joinOperatorFactory.createOperator(driverContext);
        try {
            joinOperatorFactory.noMoreOperators();
            Assert.assertTrue((boolean)joinOperator.needsInput());
            joinOperator.finish();
            Assert.assertNull((Object)joinOperator.getOutput());
            Assert.assertNull((Object)joinOperator.getOutput());
            Assert.assertTrue((boolean)joinOperator.isBlocked().isDone());
            Assert.assertTrue((boolean)joinOperator.isFinished());
        }
        finally {
            if (joinOperator != null) {
                joinOperator.close();
            }
        }
    }

    @Test(dataProvider="hashJoinTestValues")
    public void testInnerJoinWithBlockingLookupSource(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) throws Exception {
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR));
        Page probePage = (Page)Iterables.getOnlyElement(probePages.addSequencePage(1, 0).build());
        TaskContext taskContext = this.createTaskContext();
        OperatorFactory joinOperatorFactory = this.createJoinOperatorFactoryWithBlockingLookupSource(taskContext, parallelBuild, probeHashEnabled, buildHashEnabled, true);
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        try (Operator joinOperator = joinOperatorFactory.createOperator(driverContext);){
            joinOperatorFactory.noMoreOperators();
            Assert.assertFalse((boolean)joinOperator.needsInput());
            Assert.assertNull((Object)joinOperator.getOutput());
            Assert.assertFalse((boolean)joinOperator.isBlocked().isDone());
            Assert.assertFalse((boolean)joinOperator.isFinished());
        }
        taskContext = this.createTaskContext();
        joinOperatorFactory = this.createJoinOperatorFactoryWithBlockingLookupSource(taskContext, parallelBuild, probeHashEnabled, buildHashEnabled, false);
        driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        joinOperator = joinOperatorFactory.createOperator(driverContext);
        try {
            joinOperatorFactory.noMoreOperators();
            Assert.assertTrue((boolean)joinOperator.needsInput());
            Assert.assertNull((Object)joinOperator.getOutput());
            Assert.assertTrue((boolean)joinOperator.isBlocked().isDone());
            Assert.assertFalse((boolean)joinOperator.isFinished());
            joinOperator.addInput(probePage);
            Assert.assertNull((Object)joinOperator.getOutput());
            Assert.assertFalse((boolean)joinOperator.isBlocked().isDone());
            Assert.assertFalse((boolean)joinOperator.isFinished());
        }
        finally {
            if (joinOperator != null) {
                joinOperator.close();
            }
        }
    }

    @Test
    public void testInnerJoinLoadsPagesInOrder() {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(false, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        for (int i = 0; i < 100000; ++i) {
            buildPages.row("a");
        }
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, false, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(false, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        probePages.row("a", 1L, 2L);
        WorkProcessorOperatorFactory joinOperatorFactory = (WorkProcessorOperatorFactory)JoinTestUtils.innerJoinOperatorFactory(this.operatorFactories, lookupSourceFactory, probePages, PARTITIONING_SPILLER_FACTORY, false);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        Page probePage = (Page)Iterables.getOnlyElement(probePages.build());
        AtomicInteger totalProbePages = new AtomicInteger();
        WorkProcessor inputPages = WorkProcessor.create(() -> {
            int probePageNumber = totalProbePages.incrementAndGet();
            if (probePageNumber == 5) {
                return WorkProcessor.ProcessState.finished();
            }
            return WorkProcessor.ProcessState.ofResult((Object)new Page(1, new Block[]{probePage.getBlock(0), new LazyBlock(1, () -> probePage.getBlock(1)), new LazyBlock(1, () -> {
                io.trino.testing.assertions.Assert.assertEquals((int)probePageNumber, (int)totalProbePages.get());
                return probePage.getBlock(2);
            })}));
        });
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(joinOperatorFactory.getOperatorId(), joinOperatorFactory.getPlanNodeId(), joinOperatorFactory.getOperatorType());
        WorkProcessorOperator joinOperator = joinOperatorFactory.create(new ProcessorContext(taskContext.getSession(), taskContext.getTaskMemoryContext(), operatorContext), inputPages);
        WorkProcessor outputPages = joinOperator.getOutputPages();
        int totalOutputPages = 0;
        for (int i = 0; i < 1000000; ++i) {
            if (!outputPages.process()) {
                driverContext.getYieldSignal().resetYieldForTesting();
                continue;
            }
            if (outputPages.isFinished()) break;
            Page page = (Page)outputPages.getResult();
            ++totalOutputPages;
            Assert.assertFalse((boolean)page.getBlock(1).isLoaded());
            page.getBlock(2).getLoadedBlock();
            driverContext.getYieldSignal().forceYieldForTesting();
        }
        Assert.assertTrue((totalOutputPages > totalProbePages.get() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)outputPages.isFinished());
    }

    private OperatorFactory createJoinOperatorFactoryWithBlockingLookupSource(TaskContext taskContext, boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled, boolean waitForBuild) {
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactoryManager = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        OperatorFactory joinOperatorFactory = this.operatorFactories.innerJoin(0, new PlanNodeId("test"), lookupSourceFactoryManager, false, waitForBuild, false, true, probePages.getTypes(), Ints.asList((int[])new int[]{0}), JoinTestUtils.getHashChannelAsInt(probePages), Optional.empty(), OptionalInt.of(1), PARTITIONING_SPILLER_FACTORY, TYPE_OPERATOR_FACTORY);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        return joinOperatorFactory;
    }

    @DataProvider
    public static Object[][] testMemoryLimitProvider() {
        return new Object[][]{{true, true}, {true, false}, {false, true}, {false, false}};
    }

    private TaskContext createTaskContext() {
        return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION);
    }

    private static List<Integer> getHashChannels(RowPagesBuilder probe, RowPagesBuilder build) {
        ImmutableList.Builder hashChannels = ImmutableList.builder();
        if (probe.getHashChannel().isPresent()) {
            hashChannels.add((Object)probe.getHashChannel().get());
        }
        if (build.getHashChannel().isPresent()) {
            hashChannels.add((Object)(probe.getTypes().size() + build.getHashChannel().get()));
        }
        return hashChannels.build();
    }

    private OperatorFactory probeOuterJoinOperatorFactory(JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactoryManager, RowPagesBuilder probePages, boolean hasFilter) {
        return this.operatorFactories.probeOuterJoin(0, new PlanNodeId("test"), lookupSourceFactoryManager, false, hasFilter, true, probePages.getTypes(), Ints.asList((int[])new int[]{0}), JoinTestUtils.getHashChannelAsInt(probePages), Optional.empty(), OptionalInt.of(1), PARTITIONING_SPILLER_FACTORY, TYPE_OPERATOR_FACTORY);
    }

    private static <T> List<List<T>> product(List<List<T>> left, List<List<T>> right) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        for (List<T> l : left) {
            for (List<T> r : right) {
                result.add(TestHashJoinOperator.concat(l, r));
            }
        }
        return result;
    }

    private static <T> List<T> concat(List<T> initialElements, List<T> moreElements) {
        return ImmutableList.copyOf((Iterable)Iterables.concat(initialElements, moreElements));
    }

    private /* synthetic */ void lambda$testInnerJoinWithFailingSpill$6(boolean probeHashEnabled, List whenSpill, JoinTestUtils.DummySpillerFactory buildSpillerFactory, PartitioningSpillerFactory partitioningSpillerFactory) throws Throwable {
        this.innerJoinWithSpill(probeHashEnabled, whenSpill, buildSpillerFactory, partitioningSpillerFactory);
    }

    private static enum WhenSpillFails {
        SPILL_BUILD,
        SPILL_JOIN,
        UNSPILL_BUILD,
        UNSPILL_JOIN;

    }

    private static enum WhenSpill {
        DURING_BUILD,
        AFTER_BUILD,
        DURING_USAGE,
        NEVER;

    }
}

