/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.base.CaseFormat;
import io.trino.spi.TrinoException;
import io.trino.sql.query.QueryAssertions;
import io.trino.sql.tree.Extract;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class AbstractTestExtract {
    protected QueryAssertions assertions;

    @BeforeClass
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testTestCompleteness() throws NoSuchMethodException {
        for (Extract.Field value : Extract.Field.values()) {
            String testMethodName = "test" + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, value.name());
            this.getClass().getMethod(testMethodName, new Class[0]);
        }
    }

    @Test
    public void testYear() {
        this.testUnsupportedExtract("YEAR");
    }

    @Test
    public void testQuarter() {
        this.testUnsupportedExtract("QUARTER");
    }

    @Test
    public void testMonth() {
        this.testUnsupportedExtract("MONTH");
    }

    @Test
    public void testWeek() {
        this.testUnsupportedExtract("WEEK");
    }

    @Test
    public void testDay() {
        this.testUnsupportedExtract("DAY");
    }

    @Test
    public void testDayOfMonth() {
        this.testUnsupportedExtract("DAY_OF_MONTH");
    }

    @Test
    public void testDayOfWeek() {
        this.testUnsupportedExtract("DAY_OF_WEEK");
    }

    @Test
    public void testDow() {
        this.testUnsupportedExtract("DOW");
    }

    @Test
    public void testDayOfYear() {
        this.testUnsupportedExtract("DAY_OF_YEAR");
    }

    @Test
    public void testDoy() {
        this.testUnsupportedExtract("DOY");
    }

    @Test
    public void testYearOfWeek() {
        this.testUnsupportedExtract("YEAR_OF_WEEK");
    }

    @Test
    public void testYow() {
        this.testUnsupportedExtract("YOW");
    }

    @Test
    public void testHour() {
        this.testUnsupportedExtract("HOUR");
    }

    @Test
    public void testMinute() {
        this.testUnsupportedExtract("MINUTE");
    }

    @Test
    public void testSecond() {
        this.testUnsupportedExtract("SECOND");
    }

    @Test
    public void testTimezoneMinute() {
        this.testUnsupportedExtract("TIMEZONE_MINUTE");
    }

    @Test
    public void testTimezoneHour() {
        this.testUnsupportedExtract("TIMEZONE_HOUR");
    }

    protected void testUnsupportedExtract(String extractField) {
        this.types().forEach(type -> {
            String expression = String.format("EXTRACT(%s FROM CAST(NULL AS %s))", extractField, type);
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertions.expression(expression), (String)expression, (Object[])new Object[0]).as(expression, new Object[0])).isInstanceOf(TrinoException.class)).hasMessageMatching(String.format("line 1:\\d+:\\Q Cannot extract %s from %s", extractField, type));
        });
    }

    protected abstract List<String> types();
}

