/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.airlift.testing.Closeables;
import io.trino.FeaturesConfig;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlFunction;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.FunctionAssertions;
import io.trino.operator.scalar.timestamp.VarcharToTimestampCast;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Plugin;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.Type;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.io.Closeable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public abstract class AbstractTestFunctions {
    protected final Session session;
    private final FeaturesConfig config;
    protected FunctionAssertions functionAssertions;

    protected AbstractTestFunctions() {
        this(SessionTestUtils.TEST_SESSION);
    }

    protected AbstractTestFunctions(Session session) {
        this(session, new FeaturesConfig());
    }

    protected AbstractTestFunctions(FeaturesConfig config) {
        this(SessionTestUtils.TEST_SESSION, config);
    }

    protected AbstractTestFunctions(Session session, FeaturesConfig config) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.config = Objects.requireNonNull(config, "config is null");
    }

    @BeforeClass
    public final void initTestFunctions() {
        this.functionAssertions = new FunctionAssertions(this.session, this.config);
    }

    @AfterClass(alwaysRun=true)
    public final void destroyTestFunctions() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.functionAssertions});
        this.functionAssertions = null;
    }

    protected void assertFunction(@Language(value="SQL") String projection, Type expectedType, Object expected) {
        this.functionAssertions.assertFunction(projection, expectedType, expected);
    }

    protected void assertOperator(OperatorType operator, String value, Type expectedType, Object expected) {
        this.functionAssertions.assertFunction(String.format("\"%s\"(%s)", Signature.mangleOperatorName((OperatorType)operator), value), expectedType, expected);
    }

    protected void assertDecimalFunction(@Language(value="SQL") String statement, SqlDecimal expectedResult) {
        this.assertFunction(statement, (Type)DecimalType.createDecimalType((int)expectedResult.getPrecision(), (int)expectedResult.getScale()), expectedResult);
    }

    protected void assertAmbiguousFunction(@Language(value="SQL") String projection, Type expectedType, Set<Object> expected) {
        this.functionAssertions.assertAmbiguousFunction(projection, expectedType, expected);
    }

    protected void assertInvalidFunction(@Language(value="SQL") String projection, ErrorCodeSupplier errorCode, String message) {
        this.functionAssertions.assertInvalidFunction(projection, errorCode, message);
    }

    protected void assertInvalidFunction(@Language(value="SQL") String projection, String message) {
        this.functionAssertions.assertInvalidFunction(projection, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, message);
    }

    protected void assertInvalidFunction(@Language(value="SQL") String projection, ErrorCodeSupplier expectedErrorCode) {
        this.functionAssertions.assertInvalidFunction(projection, expectedErrorCode);
    }

    protected void assertFunctionThrowsIncorrectly(@Language(value="SQL") String projection, Class<? extends Throwable> throwableClass, @Language(value="RegExp") String message) {
        this.functionAssertions.assertFunctionThrowsIncorrectly(projection, throwableClass, message);
    }

    protected void assertNumericOverflow(String projection, String message) {
        this.functionAssertions.assertNumericOverflow(projection, message);
    }

    protected void assertInvalidCast(String projection) {
        this.functionAssertions.assertInvalidCast(projection);
    }

    protected void assertInvalidCast(@Language(value="SQL") String projection, String message) {
        this.functionAssertions.assertInvalidCast(projection, message);
    }

    protected void assertCachedInstanceHasBoundedRetainedSize(String projection) {
        this.functionAssertions.assertCachedInstanceHasBoundedRetainedSize(projection);
    }

    protected void assertNotSupported(String projection, String message) {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.functionAssertions.executeProjectionWithFullEngine(projection)).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED).hasMessage(message);
    }

    protected void tryEvaluateWithAll(String projection, Type expectedType) {
        this.functionAssertions.tryEvaluateWithAll(projection, expectedType);
    }

    protected void registerScalarFunction(SqlScalarFunction sqlScalarFunction) {
        this.functionAssertions.addFunctions((FunctionBundle)new InternalFunctionBundle(new SqlFunction[]{sqlScalarFunction}));
    }

    protected void registerScalar(Class<?> clazz) {
        this.functionAssertions.addFunctions((FunctionBundle)InternalFunctionBundle.builder().scalars(clazz).build());
    }

    protected void registerParametricScalar(Class<?> clazz) {
        this.functionAssertions.addFunctions((FunctionBundle)InternalFunctionBundle.builder().scalar(clazz).build());
    }

    protected void installPlugin(Plugin plugin) {
        this.functionAssertions.installPlugin(plugin);
    }

    protected static SqlTimestamp timestamp(int precision, String timestampValue) {
        LongTimestamp longTimestamp = VarcharToTimestampCast.castToLongTimestamp((int)precision, (String)timestampValue);
        return SqlTimestamp.newInstance((int)precision, (long)longTimestamp.getEpochMicros(), (int)longTimestamp.getPicosOfMicro());
    }

    protected static <K, V> Map<K, V> asMap(List<K> keyList, List<V> valueList) {
        if (keyList.size() != valueList.size()) {
            Assert.fail((String)"keyList should have same size with valueList");
        }
        HashMap<K, V> map = new HashMap<K, V>();
        for (int i = 0; i < keyList.size(); ++i) {
            if (map.put(keyList.get(i), valueList.get(i)) == null) continue;
            Assert.fail((String)"keyList should have same size with valueList");
        }
        return map;
    }
}

