/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.base.Joiner;
import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import java.util.Collections;
import org.testng.annotations.Test;

public class TestArrayFunctions
extends AbstractTestFunctions {
    @Test
    public void testArrayConstructor() {
        this.tryEvaluateWithAll("array[" + Joiner.on((String)", ").join(Collections.nCopies(254, "rand()")) + "]", (Type)new ArrayType((Type)DoubleType.DOUBLE));
        this.assertInvalidFunction("array[" + Joiner.on((String)", ").join(Collections.nCopies(255, "rand()")) + "]", (ErrorCodeSupplier)StandardErrorCode.TOO_MANY_ARGUMENTS, "Too many arguments for array constructor");
    }

    @Test
    public void testArrayConcat() {
        this.assertFunction("CONCAT(" + Joiner.on((String)", ").join(Collections.nCopies(127, "array[1]")) + ")", (Type)new ArrayType((Type)IntegerType.INTEGER), Collections.nCopies(127, 1));
        this.assertInvalidFunction("CONCAT(" + Joiner.on((String)", ").join(Collections.nCopies(128, "array[1]")) + ")", (ErrorCodeSupplier)StandardErrorCode.TOO_MANY_ARGUMENTS, "line 1:1: Too many arguments for function call concat()");
    }
}

