/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.operator.scalar.DateTimeFunctions;
import io.trino.operator.scalar.FunctionAssertions;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.SqlDate;
import io.trino.spi.type.SqlTimestampWithTimeZone;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.testing.DateTimeTestingUtils;
import io.trino.testing.TestingConnectorSession;
import io.trino.testing.TestingSession;
import io.trino.type.IntervalDayTimeType;
import io.trino.type.SqlIntervalDayTime;
import io.trino.util.DateTimeZoneIndex;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.DurationFieldType;
import org.joda.time.Hours;
import org.joda.time.Minutes;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.joda.time.Weeks;
import org.joda.time.Years;
import org.joda.time.chrono.ISOChronology;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDateTimeFunctions
extends AbstractTestFunctions {
    protected static final TimeZoneKey TIME_ZONE_KEY = TestingSession.DEFAULT_TIME_ZONE_KEY;
    protected static final DateTimeZone DATE_TIME_ZONE = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TIME_ZONE_KEY);
    protected static final DateTimeZone UTC_TIME_ZONE = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TimeZoneKey.UTC_KEY);
    protected static final DateTimeZone DATE_TIME_ZONE_NUMERICAL = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"-11:00"));
    protected static final TimeZoneKey KATHMANDU_ZONE_KEY = TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu");
    protected static final DateTimeZone KATHMANDU_ZONE = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)KATHMANDU_ZONE_KEY);
    protected static final ZoneOffset WEIRD_ZONE = ZoneOffset.ofHoursMinutes(7, 9);
    protected static final DateTimeZone WEIRD_DATE_TIME_ZONE = DateTimeZone.forID((String)WEIRD_ZONE.getId());
    protected static final DateTime DATE = new DateTime(2001, 8, 22, 0, 0, 0, 0, DateTimeZone.UTC);
    protected static final String DATE_LITERAL = "DATE '2001-08-22'";
    protected static final String DATE_ISO8601_STRING = "2001-08-22";
    protected static final LocalTime TIME = LocalTime.of(3, 4, 5, 321000000);
    protected static final String TIME_LITERAL = "TIME '03:04:05.321'";
    protected static final OffsetTime WEIRD_TIME = OffsetTime.of(3, 4, 5, 321000000, WEIRD_ZONE);
    protected static final String WEIRD_TIME_LITERAL = "TIME '03:04:05.321 +07:09'";
    protected static final DateTime TIMESTAMP = new DateTime(2001, 8, 22, 3, 4, 5, 321, UTC_TIME_ZONE);
    protected static final DateTime TIMESTAMP_WITH_NUMERICAL_ZONE = new DateTime(2001, 8, 22, 3, 4, 5, 321, DATE_TIME_ZONE_NUMERICAL);
    protected static final String TIMESTAMP_LITERAL = "TIMESTAMP '2001-08-22 03:04:05.321'";
    protected static final String TIMESTAMP_ISO8601_STRING = "2001-08-22T03:04:05.321-11:00";
    protected static final String TIMESTAMP_ISO8601_STRING_NO_TIME_ZONE = "2001-08-22T03:04:05.321";
    protected static final DateTime WEIRD_TIMESTAMP = new DateTime(2001, 8, 22, 3, 4, 5, 321, WEIRD_DATE_TIME_ZONE);
    protected static final String WEIRD_TIMESTAMP_LITERAL = "TIMESTAMP '2001-08-22 03:04:05.321 +07:09'";
    protected static final String WEIRD_TIMESTAMP_ISO8601_STRING = "2001-08-22T03:04:05.321+07:09";
    protected static final String INTERVAL_LITERAL = "INTERVAL '90061.234' SECOND";
    protected static final Duration DAY_TO_SECOND_INTERVAL = Duration.ofMillis(90061234L);

    public TestDateTimeFunctions() {
        super(TestingSession.testSessionBuilder().setTimeZoneKey(TIME_ZONE_KEY).setStart(Instant.ofEpochMilli(new DateTime(2017, 4, 1, 12, 34, 56, 789, UTC_TIME_ZONE).getMillis())).build());
    }

    @Test
    public void testToIso8601ForTimestampWithoutTimeZone() {
        this.assertFunction("to_iso8601(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)VarcharType.createVarcharType((int)26), TIMESTAMP_ISO8601_STRING_NO_TIME_ZONE);
    }

    @Test
    public void testCurrentDate() {
        this.assertFunction("CURRENT_DATE", (Type)DateType.DATE, new SqlDate(Math.toIntExact(TestDateTimeFunctions.epochDaysInZone(TIME_ZONE_KEY, this.session.getStart()))));
    }

    @Test
    public void testCurrentDateTimezone() {
        TimeZoneKey kievTimeZoneKey = TimeZoneKey.getTimeZoneKey((String)"Europe/Kiev");
        TimeZoneKey bahiaBanderasTimeZoneKey = TimeZoneKey.getTimeZoneKey((String)"America/Bahia_Banderas");
        TimeZoneKey montrealTimeZoneKey = TimeZoneKey.getTimeZoneKey((String)"America/Montreal");
        long timeIncrement = TimeUnit.MINUTES.toMillis(53L);
        for (long millis = ISOChronology.getInstanceUTC().getDateTimeMillis(2000, 6, 15, 0, 0, 0, 0); millis < ISOChronology.getInstanceUTC().getDateTimeMillis(2016, 6, 15, 0, 0, 0, 0); millis += timeIncrement) {
            Instant instant = Instant.ofEpochMilli(millis);
            this.assertCurrentDateAtInstant(kievTimeZoneKey, instant);
            this.assertCurrentDateAtInstant(bahiaBanderasTimeZoneKey, instant);
            this.assertCurrentDateAtInstant(montrealTimeZoneKey, instant);
            this.assertCurrentDateAtInstant(TIME_ZONE_KEY, instant);
        }
    }

    private void assertCurrentDateAtInstant(TimeZoneKey timeZoneKey, Instant instant) {
        long expectedDays = TestDateTimeFunctions.epochDaysInZone(timeZoneKey, instant);
        TestingConnectorSession connectorSession = TestingConnectorSession.builder().setStart(instant).setTimeZoneKey(timeZoneKey).build();
        long dateTimeCalculation = DateTimeFunctions.currentDate((ConnectorSession)connectorSession);
        Assert.assertEquals((long)dateTimeCalculation, (long)expectedDays);
    }

    private static long epochDaysInZone(TimeZoneKey timeZoneKey, Instant instant) {
        return LocalDate.from(instant.atZone(ZoneId.of(timeZoneKey.getId()))).toEpochDay();
    }

    @Test
    public void testLocalTime() {
        this.functionAssertions.assertFunctionString("localtime", (Type)TimeType.TIME, "02:34:56.789");
        Session localSession = Session.builder((Session)this.session).setStart(Instant.ofEpochMilli(new DateTime(2017, 3, 1, 14, 30, 0, 0, DATE_TIME_ZONE).getMillis())).build();
        try (FunctionAssertions localAssertion = new FunctionAssertions(localSession);){
            localAssertion.assertFunctionString("localtime", (Type)TimeType.TIME, "14:30:00.000");
        }
        localSession = Session.builder((Session)this.session).setTimeZoneKey(KATHMANDU_ZONE_KEY).setStart(Instant.ofEpochMilli(new DateTime(2017, 3, 1, 15, 45, 0, 0, KATHMANDU_ZONE).getMillis())).build();
        localAssertion = new FunctionAssertions(localSession);
        try {
            localAssertion.assertFunctionString("localtime", (Type)TimeType.TIME, "15:45:00.000");
        }
        finally {
            localAssertion.close();
        }
    }

    @Test
    public void testCurrentTime() {
        this.functionAssertions.assertFunctionString("current_time", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, "02:34:56.789+14:00");
        Session localSession = Session.builder((Session)this.session).setTimeZoneKey(KATHMANDU_ZONE_KEY).setStart(Instant.ofEpochMilli(new DateTime(2017, 3, 1, 15, 45, 0, 0, KATHMANDU_ZONE).getMillis())).build();
        try (FunctionAssertions localAssertion = new FunctionAssertions(localSession);){
            localAssertion.assertFunctionString("current_time", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, "15:45:00.000+05:45");
        }
    }

    @Test
    public void testFromUnixTime() {
        DateTime dateTime = new DateTime(2001, 1, 22, 3, 4, 5, 0, DATE_TIME_ZONE);
        double seconds = (double)dateTime.getMillis() / 1000.0;
        this.assertFunction("from_unixtime(" + seconds + ")", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, SqlTimestampWithTimeZone.newInstance((int)3, (long)dateTime.getMillis(), (int)0, (TimeZoneKey)TIME_ZONE_KEY));
        dateTime = new DateTime(2001, 1, 22, 3, 4, 5, 888, DATE_TIME_ZONE);
        seconds = (double)dateTime.getMillis() / 1000.0;
        this.assertFunction("from_unixtime(" + seconds + ")", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, SqlTimestampWithTimeZone.newInstance((int)3, (long)dateTime.getMillis(), (int)0, (TimeZoneKey)TIME_ZONE_KEY));
    }

    @Test
    public void testFromUnixTimeNanos() {
        this.assertFunction("from_unixtime_nanos(1234567890123456789)", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_NANOS, SqlTimestampWithTimeZone.newInstance((int)9, (long)1234567890123L, (int)456789000, (TimeZoneKey)TIME_ZONE_KEY));
        this.assertFunction("from_unixtime_nanos(999999999)", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_NANOS, SqlTimestampWithTimeZone.newInstance((int)9, (long)999L, (int)999999000, (TimeZoneKey)TIME_ZONE_KEY));
        this.assertFunction("from_unixtime_nanos(-1234567890123456789)", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_NANOS, SqlTimestampWithTimeZone.newInstance((int)9, (long)-1234567890124L, (int)543211000, (TimeZoneKey)TIME_ZONE_KEY));
        this.assertFunction("from_unixtime_nanos(-999999999)", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_NANOS, SqlTimestampWithTimeZone.newInstance((int)9, (long)-1000L, (int)1000, (TimeZoneKey)TIME_ZONE_KEY));
        this.assertFunction("from_unixtime_nanos(DECIMAL '1234')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_NANOS, SqlTimestampWithTimeZone.newInstance((int)9, (long)0L, (int)1234000, (TimeZoneKey)TIME_ZONE_KEY));
        this.assertFunction("from_unixtime_nanos(DECIMAL '1234.0')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_NANOS, SqlTimestampWithTimeZone.newInstance((int)9, (long)0L, (int)1234000, (TimeZoneKey)TIME_ZONE_KEY));
        this.assertFunction("from_unixtime_nanos(DECIMAL '1234.499')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_NANOS, SqlTimestampWithTimeZone.newInstance((int)9, (long)0L, (int)1234000, (TimeZoneKey)TIME_ZONE_KEY));
        this.assertFunction("from_unixtime_nanos(DECIMAL '1234.500')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_NANOS, SqlTimestampWithTimeZone.newInstance((int)9, (long)0L, (int)1235000, (TimeZoneKey)TIME_ZONE_KEY));
        this.assertFunction("from_unixtime_nanos(DECIMAL '-1234')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_NANOS, SqlTimestampWithTimeZone.newInstance((int)9, (long)-1L, (int)998766000, (TimeZoneKey)TIME_ZONE_KEY));
        this.assertFunction("from_unixtime_nanos(DECIMAL '-1234.0')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_NANOS, SqlTimestampWithTimeZone.newInstance((int)9, (long)-1L, (int)998766000, (TimeZoneKey)TIME_ZONE_KEY));
        this.assertFunction("from_unixtime_nanos(DECIMAL '-1234.499')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_NANOS, SqlTimestampWithTimeZone.newInstance((int)9, (long)-1L, (int)998766000, (TimeZoneKey)TIME_ZONE_KEY));
        this.assertFunction("from_unixtime_nanos(DECIMAL '-1234.500')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_NANOS, SqlTimestampWithTimeZone.newInstance((int)9, (long)-1L, (int)998765000, (TimeZoneKey)TIME_ZONE_KEY));
        this.assertFunction("from_unixtime_nanos(DECIMAL '12345678900123456789')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_NANOS, SqlTimestampWithTimeZone.newInstance((int)9, (long)12345678900123L, (int)456789000, (TimeZoneKey)TIME_ZONE_KEY));
        this.assertFunction("from_unixtime_nanos(DECIMAL '12345678900123456789.000000')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_NANOS, SqlTimestampWithTimeZone.newInstance((int)9, (long)12345678900123L, (int)456789000, (TimeZoneKey)TIME_ZONE_KEY));
        this.assertFunction("from_unixtime_nanos(DECIMAL '12345678900123456789.499')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_NANOS, SqlTimestampWithTimeZone.newInstance((int)9, (long)12345678900123L, (int)456789000, (TimeZoneKey)TIME_ZONE_KEY));
        this.assertFunction("from_unixtime_nanos(DECIMAL '12345678900123456789.500')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_NANOS, SqlTimestampWithTimeZone.newInstance((int)9, (long)12345678900123L, (int)456790000, (TimeZoneKey)TIME_ZONE_KEY));
        this.assertFunction("from_unixtime_nanos(DECIMAL '-12345678900123456789')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_NANOS, SqlTimestampWithTimeZone.newInstance((int)9, (long)-12345678900124L, (int)543211000, (TimeZoneKey)TIME_ZONE_KEY));
        this.assertFunction("from_unixtime_nanos(DECIMAL '-12345678900123456789.000000')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_NANOS, SqlTimestampWithTimeZone.newInstance((int)9, (long)-12345678900124L, (int)543211000, (TimeZoneKey)TIME_ZONE_KEY));
        this.assertFunction("from_unixtime_nanos(DECIMAL '-12345678900123456789.499')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_NANOS, SqlTimestampWithTimeZone.newInstance((int)9, (long)-12345678900124L, (int)543211000, (TimeZoneKey)TIME_ZONE_KEY));
        this.assertFunction("from_unixtime_nanos(DECIMAL '-12345678900123456789.500')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_NANOS, SqlTimestampWithTimeZone.newInstance((int)9, (long)-12345678900124L, (int)543210000, (TimeZoneKey)TIME_ZONE_KEY));
    }

    @Test
    public void testFromUnixTimeWithOffset() {
        DateTime dateTime = new DateTime(2001, 1, 22, 3, 4, 5, 0, DATE_TIME_ZONE);
        double seconds = (double)dateTime.getMillis() / 1000.0;
        int timeZoneHoursOffset = 1;
        int timezoneMinutesOffset = 10;
        DateTime expected = new DateTime((Object)dateTime, DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)((long)timeZoneHoursOffset * 60L + (long)timezoneMinutesOffset))));
        this.assertFunction("from_unixtime(" + seconds + ", " + timeZoneHoursOffset + ", " + timezoneMinutesOffset + ")", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(expected));
        this.assertInvalidFunction("from_unixtime(0, 1, 10000)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("from_unixtime(0, 10000, 0)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("from_unixtime(0, -100, 100)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
    }

    @Test
    public void testFromUnixTimeWithTimeZone() {
        String zoneId = "Asia/Shanghai";
        DateTime expected = new DateTime(1970, 1, 1, 10, 0, 0, DateTimeZone.forID((String)zoneId));
        this.assertFunction(String.format("from_unixtime(7200, '%s')", zoneId), (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(expected));
        zoneId = "Asia/Tokyo";
        expected = new DateTime(1970, 1, 1, 11, 0, 0, DateTimeZone.forID((String)zoneId));
        this.assertFunction(String.format("from_unixtime(7200, '%s')", zoneId), (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(expected));
        zoneId = "Europe/Moscow";
        expected = new DateTime(1970, 1, 1, 5, 0, 0, DateTimeZone.forID((String)zoneId));
        this.assertFunction(String.format("from_unixtime(7200, '%s')", zoneId), (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(expected));
        zoneId = "America/New_York";
        expected = new DateTime(1969, 12, 31, 21, 0, 0, DateTimeZone.forID((String)zoneId));
        this.assertFunction(String.format("from_unixtime(7200, '%s')", zoneId), (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(expected));
        zoneId = "America/Chicago";
        expected = new DateTime(1969, 12, 31, 20, 0, 0, DateTimeZone.forID((String)zoneId));
        this.assertFunction(String.format("from_unixtime(7200, '%s')", zoneId), (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(expected));
        zoneId = "America/Los_Angeles";
        expected = new DateTime(1969, 12, 31, 18, 0, 0, DateTimeZone.forID((String)zoneId));
        this.assertFunction(String.format("from_unixtime(7200, '%s')", zoneId), (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(expected));
    }

    @Test
    public void testDate() {
        this.assertFunction("date('2001-08-22')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(DATE));
        this.assertFunction("date(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(DATE));
        this.assertFunction("date(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(DATE));
    }

    @Test
    public void testFromISO8601() {
        this.assertFunction("from_iso8601_timestamp('2001-08-22T03:04:05.321-11:00')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(TIMESTAMP_WITH_NUMERICAL_ZONE));
        this.assertFunction("from_iso8601_timestamp('2001-08-22T03:04:05.321+07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(WEIRD_TIMESTAMP));
        this.assertFunction("from_iso8601_date('2001-08-22')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(DATE));
    }

    @Test
    public void testFromIso8601Nanos() {
        Instant instant = ZonedDateTime.of(2001, 8, 22, 12, 34, 56, 123456789, ZoneId.of("UTC")).toInstant();
        this.assertFunction("from_iso8601_timestamp_nanos('2001-08-22T12:34:56.123456789Z')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_NANOS, SqlTimestampWithTimeZone.fromInstant((int)9, (Instant)instant, (ZoneId)ZoneId.of("UTC")));
        this.assertFunction("from_iso8601_timestamp_nanos('2001-08-22T07:34:56.123456789-05:00')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_NANOS, SqlTimestampWithTimeZone.fromInstant((int)9, (Instant)instant, (ZoneId)ZoneId.of("-0500")));
        this.assertFunction("from_iso8601_timestamp_nanos('2001-08-22T13:34:56.123456789+01:00')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_NANOS, SqlTimestampWithTimeZone.fromInstant((int)9, (Instant)instant, (ZoneId)ZoneId.of("+0100")));
        this.assertFunction("from_iso8601_timestamp_nanos('2001-08-22T12:34:56.123Z')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_NANOS, SqlTimestampWithTimeZone.fromInstant((int)9, (Instant)instant.minusNanos(456789L), (ZoneId)ZoneId.of("UTC")));
        ZoneId nineHoursBehindZone = ZoneId.of("-0900");
        Session localSession = Session.builder((Session)this.session).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)nineHoursBehindZone.getId())).build();
        try (FunctionAssertions localAssertion = new FunctionAssertions(localSession);){
            localAssertion.assertFunction("from_iso8601_timestamp_nanos('2001-08-22T03:34:56.123456789')", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_NANOS, SqlTimestampWithTimeZone.fromInstant((int)9, (Instant)instant, (ZoneId)nineHoursBehindZone));
        }
    }

    @Test
    public void testToIso8601() {
        this.assertFunction("to_iso8601(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)VarcharType.createVarcharType((int)32), WEIRD_TIMESTAMP_ISO8601_STRING);
        this.assertFunction("to_iso8601(DATE '2001-08-22')", (Type)VarcharType.createVarcharType((int)16), DATE_ISO8601_STRING);
    }

    @Test
    public void testTimeZone() {
        this.assertFunction("hour(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, TIMESTAMP.getHourOfDay());
        this.assertFunction("minute(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, TIMESTAMP.getMinuteOfHour());
        this.assertFunction("hour(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getHourOfDay());
        this.assertFunction("minute(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getMinuteOfHour());
        this.assertFunction("current_timezone()", (Type)VarcharType.VARCHAR, TIME_ZONE_KEY.getId());
    }

    @Test
    public void testPartFunctions() {
        this.assertFunction("millisecond(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, TIMESTAMP.getMillisOfSecond());
        this.assertFunction("second(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, TIMESTAMP.getSecondOfMinute());
        this.assertFunction("minute(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, TIMESTAMP.getMinuteOfHour());
        this.assertFunction("hour(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, TIMESTAMP.getHourOfDay());
        this.assertFunction("day_of_week(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, TIMESTAMP.dayOfWeek().get());
        this.assertFunction("dow(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, TIMESTAMP.dayOfWeek().get());
        this.assertFunction("day(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, TIMESTAMP.getDayOfMonth());
        this.assertFunction("day_of_month(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, TIMESTAMP.getDayOfMonth());
        this.assertFunction("day_of_year(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, TIMESTAMP.dayOfYear().get());
        this.assertFunction("doy(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, TIMESTAMP.dayOfYear().get());
        this.assertFunction("week(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, TIMESTAMP.weekOfWeekyear().get());
        this.assertFunction("week_of_year(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, TIMESTAMP.weekOfWeekyear().get());
        this.assertFunction("month(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, TIMESTAMP.getMonthOfYear());
        this.assertFunction("quarter(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, (long)TIMESTAMP.getMonthOfYear() / 4L + 1L);
        this.assertFunction("year(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, TIMESTAMP.getYear());
        this.assertFunction("timezone_minute(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("timezone_hour(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, -11L);
        this.assertFunction("timezone_hour(localtimestamp)", (Type)BigintType.BIGINT, 14L);
        this.assertFunction("timezone_hour(current_timestamp)", (Type)BigintType.BIGINT, 14L);
        this.assertFunction("millisecond(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getMillisOfSecond());
        this.assertFunction("second(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getSecondOfMinute());
        this.assertFunction("minute(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getMinuteOfHour());
        this.assertFunction("hour(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getHourOfDay());
        this.assertFunction("day_of_week(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.dayOfWeek().get());
        this.assertFunction("dow(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.dayOfWeek().get());
        this.assertFunction("day(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getDayOfMonth());
        this.assertFunction("day_of_month(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getDayOfMonth());
        this.assertFunction("day_of_year(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.dayOfYear().get());
        this.assertFunction("doy(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.dayOfYear().get());
        this.assertFunction("week(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.weekOfWeekyear().get());
        this.assertFunction("week_of_year(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.weekOfWeekyear().get());
        this.assertFunction("month(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getMonthOfYear());
        this.assertFunction("quarter(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, (long)WEIRD_TIMESTAMP.getMonthOfYear() / 4L + 1L);
        this.assertFunction("year(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getYear());
        this.assertFunction("timezone_minute(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, 9L);
        this.assertFunction("timezone_hour(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, 7L);
        this.assertFunction("millisecond(TIME '03:04:05.321')", (Type)BigintType.BIGINT, TIME.getLong(ChronoField.MILLI_OF_SECOND));
        this.assertFunction("second(TIME '03:04:05.321')", (Type)BigintType.BIGINT, TIME.getSecond());
        this.assertFunction("minute(TIME '03:04:05.321')", (Type)BigintType.BIGINT, TIME.getMinute());
        this.assertFunction("hour(TIME '03:04:05.321')", (Type)BigintType.BIGINT, TIME.getHour());
        this.assertFunction("millisecond(TIME '03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIME.getLong(ChronoField.MILLI_OF_SECOND));
        this.assertFunction("second(TIME '03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIME.getSecond());
        this.assertFunction("minute(TIME '03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIME.getMinute());
        this.assertFunction("hour(TIME '03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIME.getHour());
        this.assertFunction("millisecond(INTERVAL '90061.234' SECOND)", (Type)BigintType.BIGINT, (long)DAY_TO_SECOND_INTERVAL.getNano() / 1000000L);
        this.assertFunction("second(INTERVAL '90061.234' SECOND)", (Type)BigintType.BIGINT, DAY_TO_SECOND_INTERVAL.getSeconds() % 60L);
        this.assertFunction("minute(INTERVAL '90061.234' SECOND)", (Type)BigintType.BIGINT, DAY_TO_SECOND_INTERVAL.getSeconds() / 60L % 60L);
        this.assertFunction("hour(INTERVAL '90061.234' SECOND)", (Type)BigintType.BIGINT, DAY_TO_SECOND_INTERVAL.getSeconds() / 3600L % 24L);
    }

    @Test
    public void testYearOfWeek() {
        this.assertFunction("year_of_week(DATE '2001-08-22')", (Type)BigintType.BIGINT, 2001L);
        this.assertFunction("yow(DATE '2001-08-22')", (Type)BigintType.BIGINT, 2001L);
        this.assertFunction("year_of_week(DATE '2005-01-02')", (Type)BigintType.BIGINT, 2004L);
        this.assertFunction("year_of_week(DATE '2008-12-28')", (Type)BigintType.BIGINT, 2008L);
        this.assertFunction("year_of_week(DATE '2008-12-29')", (Type)BigintType.BIGINT, 2009L);
        this.assertFunction("year_of_week(DATE '2009-12-31')", (Type)BigintType.BIGINT, 2009L);
        this.assertFunction("year_of_week(DATE '2010-01-03')", (Type)BigintType.BIGINT, 2009L);
        this.assertFunction("year_of_week(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, 2001L);
        this.assertFunction("year_of_week(TIMESTAMP '2010-01-03 03:04:05.321')", (Type)BigintType.BIGINT, 2009L);
    }

    @Test
    public void testLastDayOfMonth() {
        this.assertFunction("last_day_of_month(DATE '2001-08-22')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(DATE.withDayOfMonth(31)));
        this.assertFunction("last_day_of_month(DATE '2019-08-01')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(LocalDate.of(2019, 8, 31)));
        this.assertFunction("last_day_of_month(DATE '2019-08-31')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(LocalDate.of(2019, 8, 31)));
        this.assertFunction("last_day_of_month(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(DATE.withDayOfMonth(31)));
        this.assertFunction("last_day_of_month(TIMESTAMP '2019-08-01 00:00:00.000')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(LocalDate.of(2019, 8, 31)));
        this.assertFunction("last_day_of_month(TIMESTAMP '2019-08-01 17:00:00.000')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(LocalDate.of(2019, 8, 31)));
        this.assertFunction("last_day_of_month(TIMESTAMP '2019-08-01 23:59:59.999')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(LocalDate.of(2019, 8, 31)));
        this.assertFunction("last_day_of_month(TIMESTAMP '2019-08-31 23:59:59.999')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(LocalDate.of(2019, 8, 31)));
        this.assertFunction("last_day_of_month(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(DATE.withDayOfMonth(31)));
        ImmutableList.of((Object)"+05:45", (Object)"+00:00", (Object)"-05:45", (Object)"Asia/Tokyo", (Object)"Europe/London", (Object)"America/Los_Angeles", (Object)"America/Bahia_Banderas").forEach(timeZone -> {
            this.assertFunction("last_day_of_month(TIMESTAMP '2018-12-31 17:00:00.000 " + timeZone + "')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(LocalDate.of(2018, 12, 31)));
            this.assertFunction("last_day_of_month(TIMESTAMP '2018-12-31 20:00:00.000 " + timeZone + "')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(LocalDate.of(2018, 12, 31)));
            this.assertFunction("last_day_of_month(TIMESTAMP '2018-12-31 23:59:59.999 " + timeZone + "')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(LocalDate.of(2018, 12, 31)));
            this.assertFunction("last_day_of_month(TIMESTAMP '2019-01-01 00:00:00.000 " + timeZone + "')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(LocalDate.of(2019, 1, 31)));
            this.assertFunction("last_day_of_month(TIMESTAMP '2019-01-01 00:00:00.001 " + timeZone + "')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(LocalDate.of(2019, 1, 31)));
            this.assertFunction("last_day_of_month(TIMESTAMP '2019-01-01 03:00:00.000 " + timeZone + "')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(LocalDate.of(2019, 1, 31)));
            this.assertFunction("last_day_of_month(TIMESTAMP '2019-01-01 06:00:00.000 " + timeZone + "')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(LocalDate.of(2019, 1, 31)));
            this.assertFunction("last_day_of_month(TIMESTAMP '2019-08-01 00:00:00.000 " + timeZone + "')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(LocalDate.of(2019, 8, 31)));
            this.assertFunction("last_day_of_month(TIMESTAMP '2019-08-01 17:00:00.000 " + timeZone + "')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(LocalDate.of(2019, 8, 31)));
            this.assertFunction("last_day_of_month(TIMESTAMP '2019-08-01 23:59:59.999 " + timeZone + "')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(LocalDate.of(2019, 8, 31)));
            this.assertFunction("last_day_of_month(TIMESTAMP '2019-08-31 23:59:59.999 " + timeZone + "')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(LocalDate.of(2019, 8, 31)));
        });
    }

    @Test
    public void testExtractFromTimestamp() {
        this.assertFunction("extract(second FROM TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, TIMESTAMP.getSecondOfMinute());
        this.assertFunction("extract(minute FROM TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, TIMESTAMP.getMinuteOfHour());
        this.assertFunction("extract(hour FROM TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, TIMESTAMP.getHourOfDay());
        this.assertFunction("extract(day_of_week FROM TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, TIMESTAMP.getDayOfWeek());
        this.assertFunction("extract(dow FROM TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, TIMESTAMP.getDayOfWeek());
        this.assertFunction("extract(day FROM TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, TIMESTAMP.getDayOfMonth());
        this.assertFunction("extract(day_of_month FROM TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, TIMESTAMP.getDayOfMonth());
        this.assertFunction("extract(day_of_year FROM TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, TIMESTAMP.getDayOfYear());
        this.assertFunction("extract(year_of_week FROM TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, 2001L);
        this.assertFunction("extract(doy FROM TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, TIMESTAMP.getDayOfYear());
        this.assertFunction("extract(week FROM TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, TIMESTAMP.getWeekOfWeekyear());
        this.assertFunction("extract(month FROM TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, TIMESTAMP.getMonthOfYear());
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, (long)TIMESTAMP.getMonthOfYear() / 4L + 1L);
        this.assertFunction("extract(year FROM TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, TIMESTAMP.getYear());
        this.assertFunction("extract(second FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getSecondOfMinute());
        this.assertFunction("extract(minute FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getMinuteOfHour());
        this.assertFunction("extract(hour FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getHourOfDay());
        this.assertFunction("extract(day_of_week FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getDayOfWeek());
        this.assertFunction("extract(dow FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getDayOfWeek());
        this.assertFunction("extract(day FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getDayOfMonth());
        this.assertFunction("extract(day_of_month FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getDayOfMonth());
        this.assertFunction("extract(day_of_year FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getDayOfYear());
        this.assertFunction("extract(doy FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getDayOfYear());
        this.assertFunction("extract(week FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getWeekOfWeekyear());
        this.assertFunction("extract(month FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getMonthOfYear());
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, (long)WEIRD_TIMESTAMP.getMonthOfYear() / 4L + 1L);
        this.assertFunction("extract(year FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, WEIRD_TIMESTAMP.getYear());
        this.assertFunction("extract(timezone_minute FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, 9L);
        this.assertFunction("extract(timezone_hour FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, 7L);
    }

    @Test
    public void testExtractFromTime() {
        this.assertFunction("extract(second FROM TIME '03:04:05.321')", (Type)BigintType.BIGINT, 5L);
        this.assertFunction("extract(minute FROM TIME '03:04:05.321')", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("extract(hour FROM TIME '03:04:05.321')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("extract(second FROM TIME '03:04:05.321 +07:09')", (Type)BigintType.BIGINT, 5L);
        this.assertFunction("extract(minute FROM TIME '03:04:05.321 +07:09')", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("extract(hour FROM TIME '03:04:05.321 +07:09')", (Type)BigintType.BIGINT, 3L);
    }

    @Test
    public void testExtractFromDate() {
        this.assertFunction("extract(day_of_week FROM DATE '2001-08-22')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("extract(dow FROM DATE '2001-08-22')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("extract(day FROM DATE '2001-08-22')", (Type)BigintType.BIGINT, 22L);
        this.assertFunction("extract(day_of_month FROM DATE '2001-08-22')", (Type)BigintType.BIGINT, 22L);
        this.assertFunction("extract(day_of_year FROM DATE '2001-08-22')", (Type)BigintType.BIGINT, 234L);
        this.assertFunction("extract(doy FROM DATE '2001-08-22')", (Type)BigintType.BIGINT, 234L);
        this.assertFunction("extract(year_of_week FROM DATE '2001-08-22')", (Type)BigintType.BIGINT, 2001L);
        this.assertFunction("extract(yow FROM DATE '2001-08-22')", (Type)BigintType.BIGINT, 2001L);
        this.assertFunction("extract(week FROM DATE '2001-08-22')", (Type)BigintType.BIGINT, 34L);
        this.assertFunction("extract(month FROM DATE '2001-08-22')", (Type)BigintType.BIGINT, 8L);
        this.assertFunction("extract(quarter FROM DATE '2001-08-22')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("extract(year FROM DATE '2001-08-22')", (Type)BigintType.BIGINT, 2001L);
        this.assertFunction("extract(quarter FROM DATE '2001-01-01')", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("extract(quarter FROM DATE '2001-03-31')", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("extract(quarter FROM DATE '2001-04-01')", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("extract(quarter FROM DATE '2001-06-30')", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("extract(quarter FROM DATE '2001-07-01')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("extract(quarter FROM DATE '2001-09-30')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("extract(quarter FROM DATE '2001-10-01')", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("extract(quarter FROM DATE '2001-12-31')", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-01-01 00:00:00.000')", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-03-31 23:59:59.999')", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-04-01 00:00:00.000')", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-06-30 23:59:59.999')", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-07-01 00:00:00.000')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-09-30 23:59:59.999')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-10-01 00:00:00.000')", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-12-31 23:59:59.999')", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-01-01 00:00:00.000 +06:00')", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-03-31 23:59:59.999 +06:00')", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-04-01 00:00:00.000 +06:00')", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-06-30 23:59:59.999 +06:00')", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-07-01 00:00:00.000 +06:00')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-09-30 23:59:59.999 +06:00')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-10-01 00:00:00.000 +06:00')", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-12-31 23:59:59.999 +06:00')", (Type)BigintType.BIGINT, 4L);
    }

    @Test
    public void testExtractFromInterval() {
        this.assertFunction("extract(second FROM INTERVAL '5' SECOND)", (Type)BigintType.BIGINT, 5L);
        this.assertFunction("extract(second FROM INTERVAL '65' SECOND)", (Type)BigintType.BIGINT, 5L);
        this.assertFunction("extract(minute FROM INTERVAL '4' MINUTE)", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("extract(minute FROM INTERVAL '64' MINUTE)", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("extract(minute FROM INTERVAL '247' SECOND)", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("extract(hour FROM INTERVAL '3' HOUR)", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("extract(hour FROM INTERVAL '27' HOUR)", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("extract(hour FROM INTERVAL '187' MINUTE)", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("extract(day FROM INTERVAL '2' DAY)", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("extract(day FROM INTERVAL '55' HOUR)", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("extract(month FROM INTERVAL '3' MONTH)", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("extract(month FROM INTERVAL '15' MONTH)", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("extract(year FROM INTERVAL '2' YEAR)", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("extract(year FROM INTERVAL '29' MONTH)", (Type)BigintType.BIGINT, 2L);
    }

    @Test
    public void testTruncateTimestamp() {
        DateTime result = TIMESTAMP;
        result = result.withMillisOfSecond(0);
        this.assertFunction("date_trunc('second', TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((DateTime)result));
        result = result.withSecondOfMinute(0);
        this.assertFunction("date_trunc('minute', TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((DateTime)result));
        result = result.withMinuteOfHour(0);
        this.assertFunction("date_trunc('hour', TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((DateTime)result));
        result = result.withHourOfDay(0);
        this.assertFunction("date_trunc('day', TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((DateTime)result));
        result = result.withDayOfMonth(20);
        this.assertFunction("date_trunc('week', TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((DateTime)result));
        result = result.withDayOfMonth(1);
        this.assertFunction("date_trunc('month', TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((DateTime)result));
        result = result.withMonthOfYear(7);
        this.assertFunction("date_trunc('quarter', TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((DateTime)result));
        result = result.withMonthOfYear(1);
        this.assertFunction("date_trunc('year', TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((DateTime)result));
        result = WEIRD_TIMESTAMP;
        result = result.withMillisOfSecond(0);
        this.assertFunction("date_trunc('second', TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(result));
        result = result.withSecondOfMinute(0);
        this.assertFunction("date_trunc('minute', TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(result));
        result = result.withMinuteOfHour(0);
        this.assertFunction("date_trunc('hour', TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(result));
        result = result.withHourOfDay(0);
        this.assertFunction("date_trunc('day', TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(result));
        result = result.withDayOfMonth(20);
        this.assertFunction("date_trunc('week', TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(result));
        result = result.withDayOfMonth(1);
        this.assertFunction("date_trunc('month', TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(result));
        result = result.withMonthOfYear(7);
        this.assertFunction("date_trunc('quarter', TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(result));
        result = result.withMonthOfYear(1);
        this.assertFunction("date_trunc('year', TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(result));
    }

    @Test
    public void testTruncateTime() {
        LocalTime result = TIME;
        result = result.withNano(0);
        this.assertFunction("date_trunc('second', TIME '03:04:05.321')", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((LocalTime)result));
        result = result.withSecond(0);
        this.assertFunction("date_trunc('minute', TIME '03:04:05.321')", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((LocalTime)result));
        result = result.withMinute(0);
        this.assertFunction("date_trunc('hour', TIME '03:04:05.321')", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((LocalTime)result));
    }

    @Test
    public void testTruncateDate() {
        DateTime result = DATE;
        this.assertFunction("date_trunc('day', DATE '2001-08-22')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(result));
        result = result.withDayOfMonth(20);
        this.assertFunction("date_trunc('week', DATE '2001-08-22')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(result));
        result = result.withDayOfMonth(1);
        this.assertFunction("date_trunc('month', DATE '2001-08-22')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(result));
        result = result.withMonthOfYear(7);
        this.assertFunction("date_trunc('quarter', DATE '2001-08-22')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(result));
        result = result.withMonthOfYear(1);
        this.assertFunction("date_trunc('year', DATE '2001-08-22')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(result));
    }

    @Test
    public void testAddFieldToTimestamp() {
        this.assertFunction("date_add('millisecond', 3, TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((DateTime)TIMESTAMP.plusMillis(3)));
        this.assertFunction("date_add('second', 3, TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((DateTime)TIMESTAMP.plusSeconds(3)));
        this.assertFunction("date_add('minute', 3, TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((DateTime)TIMESTAMP.plusMinutes(3)));
        this.assertFunction("date_add('hour', 3, TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((DateTime)TIMESTAMP.plusHours(3)));
        this.assertFunction("date_add('hour', 23, TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((DateTime)TIMESTAMP.plusHours(23)));
        this.assertFunction("date_add('hour', -4, TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((DateTime)TIMESTAMP.minusHours(4)));
        this.assertFunction("date_add('hour', -23, TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((DateTime)TIMESTAMP.minusHours(23)));
        this.assertFunction("date_add('day', 3, TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((DateTime)TIMESTAMP.plusDays(3)));
        this.assertFunction("date_add('week', 3, TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((DateTime)TIMESTAMP.plusWeeks(3)));
        this.assertFunction("date_add('month', 3, TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((DateTime)TIMESTAMP.plusMonths(3)));
        this.assertFunction("date_add('quarter', 3, TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((DateTime)TIMESTAMP.plusMonths(9)));
        this.assertFunction("date_add('year', 3, TIMESTAMP '2001-08-22 03:04:05.321')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((DateTime)TIMESTAMP.plusYears(3)));
        this.assertFunction("date_add('millisecond', 3, TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(WEIRD_TIMESTAMP.plusMillis(3)));
        this.assertFunction("date_add('second', 3, TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(WEIRD_TIMESTAMP.plusSeconds(3)));
        this.assertFunction("date_add('minute', 3, TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(WEIRD_TIMESTAMP.plusMinutes(3)));
        this.assertFunction("date_add('hour', 3, TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(WEIRD_TIMESTAMP.plusHours(3)));
        this.assertFunction("date_add('day', 3, TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(WEIRD_TIMESTAMP.plusDays(3)));
        this.assertFunction("date_add('week', 3, TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(WEIRD_TIMESTAMP.plusWeeks(3)));
        this.assertFunction("date_add('month', 3, TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(WEIRD_TIMESTAMP.plusMonths(3)));
        this.assertFunction("date_add('quarter', 3, TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(WEIRD_TIMESTAMP.plusMonths(9)));
        this.assertFunction("date_add('year', 3, TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(WEIRD_TIMESTAMP.plusYears(3)));
    }

    @Test
    public void testAddFieldToDate() {
        this.assertFunction("date_add('day', 0, DATE '2001-08-22')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(DATE));
        this.assertFunction("date_add('day', 3, DATE '2001-08-22')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(DATE.plusDays(3)));
        this.assertFunction("date_add('week', 3, DATE '2001-08-22')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(DATE.plusWeeks(3)));
        this.assertFunction("date_add('month', 3, DATE '2001-08-22')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(DATE.plusMonths(3)));
        this.assertFunction("date_add('quarter', 3, DATE '2001-08-22')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(DATE.plusMonths(9)));
        this.assertFunction("date_add('year', 3, DATE '2001-08-22')", (Type)DateType.DATE, TestDateTimeFunctions.toDate(DATE.plusYears(3)));
    }

    @Test
    public void testAddFieldToTime() {
        this.assertFunction("date_add('millisecond', 0, TIME '03:04:05.321')", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((LocalTime)TIME));
        this.assertFunction("date_add('millisecond', 3, TIME '03:04:05.321')", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((LocalTime)TIME.plusNanos(3000000L)));
        this.assertFunction("date_add('second', 3, TIME '03:04:05.321')", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((LocalTime)TIME.plusSeconds(3L)));
        this.assertFunction("date_add('minute', 3, TIME '03:04:05.321')", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((LocalTime)TIME.plusMinutes(3L)));
        this.assertFunction("date_add('hour', 3, TIME '03:04:05.321')", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((LocalTime)TIME.plusHours(3L)));
        this.assertFunction("date_add('hour', 23, TIME '03:04:05.321')", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((LocalTime)TIME.plusHours(23L)));
        this.assertFunction("date_add('hour', -4, TIME '03:04:05.321')", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((LocalTime)TIME.minusHours(4L)));
        this.assertFunction("date_add('hour', -23, TIME '03:04:05.321')", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((LocalTime)TIME.minusHours(23L)));
    }

    @Test
    public void testDateDiffTimestamp() {
        DateTime baseDateTime = new DateTime(1960, 5, 3, 7, 2, 9, 678, UTC_TIME_ZONE);
        String baseDateTimeLiteral = "TIMESTAMP '1960-05-03 07:02:09.678'";
        this.assertFunction("date_diff('millisecond', " + baseDateTimeLiteral + ", TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, TestDateTimeFunctions.millisBetween((ReadableInstant)baseDateTime, (ReadableInstant)TIMESTAMP));
        this.assertFunction("date_diff('second', " + baseDateTimeLiteral + ", TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, TestDateTimeFunctions.secondsBetween((ReadableInstant)baseDateTime, (ReadableInstant)TIMESTAMP).getSeconds());
        this.assertFunction("date_diff('minute', " + baseDateTimeLiteral + ", TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, TestDateTimeFunctions.minutesBetween((ReadableInstant)baseDateTime, (ReadableInstant)TIMESTAMP).getMinutes());
        this.assertFunction("date_diff('hour', " + baseDateTimeLiteral + ", TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, TestDateTimeFunctions.hoursBetween((ReadableInstant)baseDateTime, (ReadableInstant)TIMESTAMP).getHours());
        this.assertFunction("date_diff('day', " + baseDateTimeLiteral + ", TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, Days.daysBetween((ReadableInstant)baseDateTime, (ReadableInstant)TIMESTAMP).getDays());
        this.assertFunction("date_diff('week', " + baseDateTimeLiteral + ", TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, Weeks.weeksBetween((ReadableInstant)baseDateTime, (ReadableInstant)TIMESTAMP).getWeeks());
        this.assertFunction("date_diff('month', " + baseDateTimeLiteral + ", TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, Months.monthsBetween((ReadableInstant)baseDateTime, (ReadableInstant)TIMESTAMP).getMonths());
        this.assertFunction("date_diff('quarter', " + baseDateTimeLiteral + ", TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, (long)Months.monthsBetween((ReadableInstant)baseDateTime, (ReadableInstant)TIMESTAMP).getMonths() / 3L);
        this.assertFunction("date_diff('year', " + baseDateTimeLiteral + ", TIMESTAMP '2001-08-22 03:04:05.321')", (Type)BigintType.BIGINT, Years.yearsBetween((ReadableInstant)baseDateTime, (ReadableInstant)TIMESTAMP).getYears());
        DateTime weirdBaseDateTime = new DateTime(1960, 5, 3, 7, 2, 9, 678, WEIRD_DATE_TIME_ZONE);
        String weirdBaseDateTimeLiteral = "TIMESTAMP '1960-05-03 07:02:09.678 +07:09'";
        this.assertFunction("date_diff('millisecond', " + weirdBaseDateTimeLiteral + ", TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, TestDateTimeFunctions.millisBetween((ReadableInstant)weirdBaseDateTime, (ReadableInstant)WEIRD_TIMESTAMP));
        this.assertFunction("date_diff('second', " + weirdBaseDateTimeLiteral + ", TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, TestDateTimeFunctions.secondsBetween((ReadableInstant)weirdBaseDateTime, (ReadableInstant)WEIRD_TIMESTAMP).getSeconds());
        this.assertFunction("date_diff('minute', " + weirdBaseDateTimeLiteral + ", TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, TestDateTimeFunctions.minutesBetween((ReadableInstant)weirdBaseDateTime, (ReadableInstant)WEIRD_TIMESTAMP).getMinutes());
        this.assertFunction("date_diff('hour', " + weirdBaseDateTimeLiteral + ", TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, TestDateTimeFunctions.hoursBetween((ReadableInstant)weirdBaseDateTime, (ReadableInstant)WEIRD_TIMESTAMP).getHours());
        this.assertFunction("date_diff('day', " + weirdBaseDateTimeLiteral + ", TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, Days.daysBetween((ReadableInstant)weirdBaseDateTime, (ReadableInstant)WEIRD_TIMESTAMP).getDays());
        this.assertFunction("date_diff('week', " + weirdBaseDateTimeLiteral + ", TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, Weeks.weeksBetween((ReadableInstant)weirdBaseDateTime, (ReadableInstant)WEIRD_TIMESTAMP).getWeeks());
        this.assertFunction("date_diff('month', " + weirdBaseDateTimeLiteral + ", TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, Months.monthsBetween((ReadableInstant)weirdBaseDateTime, (ReadableInstant)WEIRD_TIMESTAMP).getMonths());
        this.assertFunction("date_diff('quarter', " + weirdBaseDateTimeLiteral + ", TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, (long)Months.monthsBetween((ReadableInstant)weirdBaseDateTime, (ReadableInstant)WEIRD_TIMESTAMP).getMonths() / 3L);
        this.assertFunction("date_diff('year', " + weirdBaseDateTimeLiteral + ", TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (Type)BigintType.BIGINT, Years.yearsBetween((ReadableInstant)weirdBaseDateTime, (ReadableInstant)WEIRD_TIMESTAMP).getYears());
    }

    @Test
    public void testDateDiffDate() {
        DateTime baseDateTime = new DateTime(1960, 5, 3, 0, 0, 0, 0, DateTimeZone.UTC);
        String baseDateTimeLiteral = "DATE '1960-05-03'";
        this.assertFunction("date_diff('day', " + baseDateTimeLiteral + ", DATE '2001-08-22')", (Type)BigintType.BIGINT, Days.daysBetween((ReadableInstant)baseDateTime, (ReadableInstant)DATE).getDays());
        this.assertFunction("date_diff('week', " + baseDateTimeLiteral + ", DATE '2001-08-22')", (Type)BigintType.BIGINT, Weeks.weeksBetween((ReadableInstant)baseDateTime, (ReadableInstant)DATE).getWeeks());
        this.assertFunction("date_diff('month', " + baseDateTimeLiteral + ", DATE '2001-08-22')", (Type)BigintType.BIGINT, Months.monthsBetween((ReadableInstant)baseDateTime, (ReadableInstant)DATE).getMonths());
        this.assertFunction("date_diff('quarter', " + baseDateTimeLiteral + ", DATE '2001-08-22')", (Type)BigintType.BIGINT, (long)Months.monthsBetween((ReadableInstant)baseDateTime, (ReadableInstant)DATE).getMonths() / 3L);
        this.assertFunction("date_diff('year', " + baseDateTimeLiteral + ", DATE '2001-08-22')", (Type)BigintType.BIGINT, Years.yearsBetween((ReadableInstant)baseDateTime, (ReadableInstant)DATE).getYears());
    }

    @Test
    public void testDateDiffTime() {
        LocalTime baseDateTime = LocalTime.of(7, 2, 9, 678000000);
        String baseDateTimeLiteral = "TIME '07:02:09.678'";
        this.assertFunction("date_diff('millisecond', " + baseDateTimeLiteral + ", TIME '03:04:05.321')", (Type)BigintType.BIGINT, TestDateTimeFunctions.millisBetween(baseDateTime, TIME));
        this.assertFunction("date_diff('second', " + baseDateTimeLiteral + ", TIME '03:04:05.321')", (Type)BigintType.BIGINT, TestDateTimeFunctions.secondsBetween(baseDateTime, TIME));
        this.assertFunction("date_diff('minute', " + baseDateTimeLiteral + ", TIME '03:04:05.321')", (Type)BigintType.BIGINT, TestDateTimeFunctions.minutesBetween(baseDateTime, TIME));
        this.assertFunction("date_diff('hour', " + baseDateTimeLiteral + ", TIME '03:04:05.321')", (Type)BigintType.BIGINT, TestDateTimeFunctions.hoursBetween(baseDateTime, TIME));
    }

    @Test
    public void testDateDiffTimeWithTimeZone() {
        OffsetTime weirdBaseDateTime = OffsetTime.of(7, 2, 9, 678000000, WEIRD_ZONE);
        String weirdBaseDateTimeLiteral = "TIME '07:02:09.678 +07:09'";
        this.assertFunction("date_diff('millisecond', " + weirdBaseDateTimeLiteral + ", TIME '03:04:05.321 +07:09')", (Type)BigintType.BIGINT, TestDateTimeFunctions.millisBetween(weirdBaseDateTime, WEIRD_TIME));
        this.assertFunction("date_diff('second', " + weirdBaseDateTimeLiteral + ", TIME '03:04:05.321 +07:09')", (Type)BigintType.BIGINT, TestDateTimeFunctions.secondsBetween(weirdBaseDateTime, WEIRD_TIME));
        this.assertFunction("date_diff('minute', " + weirdBaseDateTimeLiteral + ", TIME '03:04:05.321 +07:09')", (Type)BigintType.BIGINT, TestDateTimeFunctions.minutesBetween(weirdBaseDateTime, WEIRD_TIME));
        this.assertFunction("date_diff('hour', " + weirdBaseDateTimeLiteral + ", TIME '03:04:05.321 +07:09')", (Type)BigintType.BIGINT, TestDateTimeFunctions.hoursBetween(weirdBaseDateTime, WEIRD_TIME));
    }

    @Test
    public void testParseDatetime() {
        this.assertFunction("parse_datetime('2020-08-18 03:04:05.678', 'yyyy-MM-dd HH:mm:ss.SSS')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(new DateTime(2020, 8, 18, 3, 4, 5, 678, DATE_TIME_ZONE)));
        this.assertFunction("parse_datetime('1960/01/22 03:04', 'yyyy/MM/dd HH:mm')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(new DateTime(1960, 1, 22, 3, 4, 0, 0, DATE_TIME_ZONE)));
        this.assertFunction("parse_datetime('1960/01/22 03:04 Asia/Oral', 'yyyy/MM/dd HH:mm ZZZZZ')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(new DateTime(1960, 1, 22, 3, 4, 0, 0, DateTimeZone.forID((String)"Asia/Oral"))));
        this.assertFunction("parse_datetime('1960/01/22 03:04 +0500', 'yyyy/MM/dd HH:mm Z')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(new DateTime(1960, 1, 22, 3, 4, 0, 0, DateTimeZone.forOffsetHours((int)5))));
    }

    @Test
    public void testFormatDatetime() {
        this.assertFunction("format_datetime(TIMESTAMP '2001-08-22 03:04:05.321', 'YYYY/MM/dd HH:mm')", (Type)VarcharType.VARCHAR, "2001/08/22 03:04");
        this.assertFunction("format_datetime(TIMESTAMP '2001-08-22 03:04:05.321 +07:09', 'YYYY/MM/dd HH:mm')", (Type)VarcharType.VARCHAR, "2001/08/22 03:04");
        this.assertFunction("format_datetime(TIMESTAMP '2001-08-22 03:04:05.321 +07:09', 'YYYY/MM/dd HH:mm ZZZZ')", (Type)VarcharType.VARCHAR, "2001/08/22 03:04 +07:09");
    }

    @Test
    public void testDateFormat() {
        String dateTimeLiteral = "TIMESTAMP '2001-01-09 13:04:05.321'";
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%a')", (Type)VarcharType.VARCHAR, "Tue");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%b')", (Type)VarcharType.VARCHAR, "Jan");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%c')", (Type)VarcharType.VARCHAR, "1");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%d')", (Type)VarcharType.VARCHAR, "09");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%e')", (Type)VarcharType.VARCHAR, "9");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%f')", (Type)VarcharType.VARCHAR, "321000");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%H')", (Type)VarcharType.VARCHAR, "13");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%h')", (Type)VarcharType.VARCHAR, "01");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%I')", (Type)VarcharType.VARCHAR, "01");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%i')", (Type)VarcharType.VARCHAR, "04");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%j')", (Type)VarcharType.VARCHAR, "009");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%k')", (Type)VarcharType.VARCHAR, "13");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%l')", (Type)VarcharType.VARCHAR, "1");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%M')", (Type)VarcharType.VARCHAR, "January");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%m')", (Type)VarcharType.VARCHAR, "01");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%p')", (Type)VarcharType.VARCHAR, "PM");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%r')", (Type)VarcharType.VARCHAR, "01:04:05 PM");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%S')", (Type)VarcharType.VARCHAR, "05");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%s')", (Type)VarcharType.VARCHAR, "05");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%T')", (Type)VarcharType.VARCHAR, "13:04:05");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%v')", (Type)VarcharType.VARCHAR, "02");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%W')", (Type)VarcharType.VARCHAR, "Tuesday");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%Y')", (Type)VarcharType.VARCHAR, "2001");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%y')", (Type)VarcharType.VARCHAR, "01");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%%')", (Type)VarcharType.VARCHAR, "%");
        this.assertFunction("date_format(" + dateTimeLiteral + ", 'foo')", (Type)VarcharType.VARCHAR, "foo");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%g')", (Type)VarcharType.VARCHAR, "g");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%4')", (Type)VarcharType.VARCHAR, "4");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%x %v')", (Type)VarcharType.VARCHAR, "2001 02");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%Y\u5e74%m\u6708%d\u65e5')", (Type)VarcharType.VARCHAR, "2001\u5e7401\u670809\u65e5");
        String weirdDateTimeLiteral = "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'";
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%a')", (Type)VarcharType.VARCHAR, "Tue");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%b')", (Type)VarcharType.VARCHAR, "Jan");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%c')", (Type)VarcharType.VARCHAR, "1");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%d')", (Type)VarcharType.VARCHAR, "09");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%e')", (Type)VarcharType.VARCHAR, "9");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%f')", (Type)VarcharType.VARCHAR, "321000");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%H')", (Type)VarcharType.VARCHAR, "13");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%h')", (Type)VarcharType.VARCHAR, "01");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%I')", (Type)VarcharType.VARCHAR, "01");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%i')", (Type)VarcharType.VARCHAR, "04");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%j')", (Type)VarcharType.VARCHAR, "009");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%k')", (Type)VarcharType.VARCHAR, "13");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%l')", (Type)VarcharType.VARCHAR, "1");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%M')", (Type)VarcharType.VARCHAR, "January");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%m')", (Type)VarcharType.VARCHAR, "01");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%p')", (Type)VarcharType.VARCHAR, "PM");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%r')", (Type)VarcharType.VARCHAR, "01:04:05 PM");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%S')", (Type)VarcharType.VARCHAR, "05");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%s')", (Type)VarcharType.VARCHAR, "05");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%T')", (Type)VarcharType.VARCHAR, "13:04:05");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%v')", (Type)VarcharType.VARCHAR, "02");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%W')", (Type)VarcharType.VARCHAR, "Tuesday");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%Y')", (Type)VarcharType.VARCHAR, "2001");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%y')", (Type)VarcharType.VARCHAR, "01");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%%')", (Type)VarcharType.VARCHAR, "%");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", 'foo')", (Type)VarcharType.VARCHAR, "foo");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%g')", (Type)VarcharType.VARCHAR, "g");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%4')", (Type)VarcharType.VARCHAR, "4");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%x %v')", (Type)VarcharType.VARCHAR, "2001 02");
        this.assertFunction("date_format(" + weirdDateTimeLiteral + ", '%Y\u5e74%m\u6708%d\u65e5')", (Type)VarcharType.VARCHAR, "2001\u5e7401\u670809\u65e5");
        this.assertFunction("date_format(TIMESTAMP '2001-01-09 13:04:05.32', '%f')", (Type)VarcharType.VARCHAR, "320000");
        this.assertFunction("date_format(TIMESTAMP '2001-01-09 00:04:05.32', '%k')", (Type)VarcharType.VARCHAR, "0");
        this.assertInvalidFunction("date_format(DATE '2001-01-09', '%D')", "%D not supported in date format string");
        this.assertInvalidFunction("date_format(DATE '2001-01-09', '%U')", "%U not supported in date format string");
        this.assertInvalidFunction("date_format(DATE '2001-01-09', '%u')", "%u not supported in date format string");
        this.assertInvalidFunction("date_format(DATE '2001-01-09', '%V')", "%V not supported in date format string");
        this.assertInvalidFunction("date_format(DATE '2001-01-09', '%w')", "%w not supported in date format string");
        this.assertInvalidFunction("date_format(DATE '2001-01-09', '%X')", "%X not supported in date format string");
    }

    @Test
    public void testDateParse() {
        this.assertFunction("date_parse('2013', '%Y')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)1, (int)1, (int)0, (int)0, (int)0, (int)0));
        this.assertFunction("date_parse('2013-05', '%Y-%m')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)5, (int)1, (int)0, (int)0, (int)0, (int)0));
        this.assertFunction("date_parse('2013-05-17', '%Y-%m-%d')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)5, (int)17, (int)0, (int)0, (int)0, (int)0));
        this.assertFunction("date_parse('2013-05-17 12:35:10', '%Y-%m-%d %h:%i:%s')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)5, (int)17, (int)0, (int)35, (int)10, (int)0));
        this.assertFunction("date_parse('2013-05-17 12:35:10 PM', '%Y-%m-%d %h:%i:%s %p')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)5, (int)17, (int)12, (int)35, (int)10, (int)0));
        this.assertFunction("date_parse('2013-05-17 12:35:10 AM', '%Y-%m-%d %h:%i:%s %p')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)5, (int)17, (int)0, (int)35, (int)10, (int)0));
        this.assertFunction("date_parse('2013-05-17 00:35:10', '%Y-%m-%d %H:%i:%s')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)5, (int)17, (int)0, (int)35, (int)10, (int)0));
        this.assertFunction("date_parse('2013-05-17 23:35:10', '%Y-%m-%d %H:%i:%s')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)5, (int)17, (int)23, (int)35, (int)10, (int)0));
        this.assertFunction("date_parse('abc 2013-05-17 fff 23:35:10 xyz', 'abc %Y-%m-%d fff %H:%i:%s xyz')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)5, (int)17, (int)23, (int)35, (int)10, (int)0));
        this.assertFunction("date_parse('2013 14', '%Y %y')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2014, (int)1, (int)1, (int)0, (int)0, (int)0, (int)0));
        this.assertFunction("date_parse('1998 53', '%x %v')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)1998, (int)12, (int)28, (int)0, (int)0, (int)0, (int)0));
        this.assertFunction("date_parse('1.1', '%s.%f')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)100));
        this.assertFunction("date_parse('1.01', '%s.%f')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)10));
        this.assertFunction("date_parse('1.2006', '%s.%f')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)200));
        this.assertFunction("date_parse('59.123456789', '%s.%f')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)59, (int)123));
        this.assertFunction("date_parse('0', '%k')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)0, (int)0));
        this.assertFunction("date_parse('28-JAN-16 11.45.46.421000 PM','%d-%b-%y %l.%i.%s.%f %p')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2016, (int)1, (int)28, (int)23, (int)45, (int)46, (int)421));
        this.assertFunction("date_parse('11-DEC-70 11.12.13.456000 AM','%d-%b-%y %l.%i.%s.%f %p')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)1970, (int)12, (int)11, (int)11, (int)12, (int)13, (int)456));
        this.assertFunction("date_parse('31-MAY-69 04.59.59.999000 AM','%d-%b-%y %l.%i.%s.%f %p')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2069, (int)5, (int)31, (int)4, (int)59, (int)59, (int)999));
        this.assertInvalidFunction("date_parse('', '%D')", "%D not supported in date format string");
        this.assertInvalidFunction("date_parse('', '%U')", "%U not supported in date format string");
        this.assertInvalidFunction("date_parse('', '%u')", "%u not supported in date format string");
        this.assertInvalidFunction("date_parse('', '%V')", "%V not supported in date format string");
        this.assertInvalidFunction("date_parse('', '%w')", "%w not supported in date format string");
        this.assertInvalidFunction("date_parse('', '%X')", "%X not supported in date format string");
        this.assertInvalidFunction("date_parse('3.0123456789', '%s.%f')", "Invalid format: \"3.0123456789\" is malformed at \"9\"");
        this.assertInvalidFunction("date_parse('1970-01-01', '')", "Both printing and parsing not supported");
    }

    @Test
    public void testLocale() {
        Locale locale = Locale.KOREAN;
        Session localeSession = Session.builder((Session)this.session).setTimeZoneKey(TIME_ZONE_KEY).setLocale(locale).build();
        try (FunctionAssertions localeAssertions = new FunctionAssertions(localeSession);){
            String dateTimeLiteral = "TIMESTAMP '2001-01-09 13:04:05.321'";
            localeAssertions.assertFunction("date_format(" + dateTimeLiteral + ", '%a')", (Type)VarcharType.VARCHAR, "\ud654");
            localeAssertions.assertFunction("date_format(" + dateTimeLiteral + ", '%W')", (Type)VarcharType.VARCHAR, "\ud654\uc694\uc77c");
            localeAssertions.assertFunction("date_format(" + dateTimeLiteral + ", '%p')", (Type)VarcharType.VARCHAR, "\uc624\ud6c4");
            localeAssertions.assertFunction("date_format(" + dateTimeLiteral + ", '%r')", (Type)VarcharType.VARCHAR, "01:04:05 \uc624\ud6c4");
            localeAssertions.assertFunction("date_format(" + dateTimeLiteral + ", '%b')", (Type)VarcharType.VARCHAR, "1\uc6d4");
            localeAssertions.assertFunction("date_format(" + dateTimeLiteral + ", '%M')", (Type)VarcharType.VARCHAR, "1\uc6d4");
            localeAssertions.assertFunction("format_datetime(" + dateTimeLiteral + ", 'EEE')", (Type)VarcharType.VARCHAR, "\ud654");
            localeAssertions.assertFunction("format_datetime(" + dateTimeLiteral + ", 'EEEE')", (Type)VarcharType.VARCHAR, "\ud654\uc694\uc77c");
            localeAssertions.assertFunction("format_datetime(" + dateTimeLiteral + ", 'a')", (Type)VarcharType.VARCHAR, "\uc624\ud6c4");
            localeAssertions.assertFunction("format_datetime(" + dateTimeLiteral + ", 'MMM')", (Type)VarcharType.VARCHAR, "1\uc6d4");
            localeAssertions.assertFunction("format_datetime(" + dateTimeLiteral + ", 'MMMM')", (Type)VarcharType.VARCHAR, "1\uc6d4");
            localeAssertions.assertFunction("date_parse('2013-05-17 12:35:10 \uc624\ud6c4', '%Y-%m-%d %h:%i:%s %p')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)5, (int)17, (int)12, (int)35, (int)10, (int)0));
            localeAssertions.assertFunction("date_parse('2013-05-17 12:35:10 \uc624\uc804', '%Y-%m-%d %h:%i:%s %p')", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2013, (int)5, (int)17, (int)0, (int)35, (int)10, (int)0));
            localeAssertions.assertFunction("parse_datetime('2013-05-17 12:35:10 \uc624\ud6c4', 'yyyy-MM-dd hh:mm:ss a')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(new DateTime(2013, 5, 17, 12, 35, 10, 0, DATE_TIME_ZONE)));
            localeAssertions.assertFunction("parse_datetime('2013-05-17 12:35:10 \uc624\uc804', 'yyyy-MM-dd hh:mm:ss aaa')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(new DateTime(2013, 5, 17, 0, 35, 10, 0, DATE_TIME_ZONE)));
        }
    }

    @Test
    public void testDateTimeOutputString() {
        this.assertFunctionString("date '2012-12-31'", (Type)DateType.DATE, "2012-12-31");
        this.assertFunctionString("date '0000-12-31'", (Type)DateType.DATE, "0000-12-31");
        this.assertFunctionString("date '0000-09-23'", (Type)DateType.DATE, "0000-09-23");
        this.assertFunctionString("date '0001-10-25'", (Type)DateType.DATE, "0001-10-25");
        this.assertFunctionString("date '1560-04-29'", (Type)DateType.DATE, "1560-04-29");
        this.assertFunctionString("time '00:00:00'", (Type)TimeType.createTimeType((int)0), "00:00:00");
        this.assertFunctionString("time '01:02:03'", (Type)TimeType.createTimeType((int)0), "01:02:03");
        this.assertFunctionString("time '23:23:23.233'", (Type)TimeType.createTimeType((int)3), "23:23:23.233");
        this.assertFunctionString("time '23:59:59.999'", (Type)TimeType.createTimeType((int)3), "23:59:59.999");
        this.assertFunctionString("timestamp '0000-01-02 01:02:03'", (Type)TimestampType.createTimestampType((int)0), "0000-01-02 01:02:03");
        this.assertFunctionString("timestamp '2012-12-31 00:00:00'", (Type)TimestampType.createTimestampType((int)0), "2012-12-31 00:00:00");
        this.assertFunctionString("timestamp '1234-05-06 23:23:23.233'", (Type)TimestampType.createTimestampType((int)3), "1234-05-06 23:23:23.233");
        this.assertFunctionString("timestamp '2333-02-23 23:59:59.999'", (Type)TimestampType.createTimestampType((int)3), "2333-02-23 23:59:59.999");
        this.assertFunctionString("timestamp '2012-12-31 00:00:00 UTC'", (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0), "2012-12-31 00:00:00 UTC");
        this.assertFunctionString("timestamp '0000-01-02 01:02:03 Asia/Shanghai'", (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0), "0000-01-02 01:02:03 Asia/Shanghai");
        this.assertFunctionString("timestamp '1234-05-06 23:23:23.233 America/Los_Angeles'", (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3), "1234-05-06 23:23:23.233 America/Los_Angeles");
        this.assertFunctionString("timestamp '2333-02-23 23:59:59.999 Asia/Tokyo'", (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3), "2333-02-23 23:59:59.999 Asia/Tokyo");
    }

    @Test
    public void testParseDuration() {
        this.assertFunction("parse_duration('1234 ns')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 0, 0, 0));
        this.assertFunction("parse_duration('1234 us')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 0, 0, 1));
        this.assertFunction("parse_duration('1234 ms')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 0, 1, 234));
        this.assertFunction("parse_duration('1234 s')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 20, 34, 0));
        this.assertFunction("parse_duration('1234 m')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 20, 34, 0, 0));
        this.assertFunction("parse_duration('1234 h')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(51, 10, 0, 0, 0));
        this.assertFunction("parse_duration('1234 d')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(1234, 0, 0, 0, 0));
        this.assertFunction("parse_duration('1234.567 ns')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 0, 0, 0));
        this.assertFunction("parse_duration('1234.567 ms')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 0, 1, 235));
        this.assertFunction("parse_duration('1234.567 s')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 0, 1234, 567));
        this.assertFunction("parse_duration('1234.567 m')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 20, 34, 34, 20));
        this.assertFunction("parse_duration('1234.567 h')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(51, 10, 34, 1, 200));
        this.assertFunction("parse_duration('1234.567 d')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(1234, 13, 36, 28, 800));
        this.assertFunction("parse_duration('1234ns')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 0, 0, 0));
        this.assertFunction("parse_duration('1234us')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 0, 0, 1));
        this.assertFunction("parse_duration('1234ms')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 0, 1, 234));
        this.assertFunction("parse_duration('1234s')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 20, 34, 0));
        this.assertFunction("parse_duration('1234m')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 20, 34, 0, 0));
        this.assertFunction("parse_duration('1234h')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(51, 10, 0, 0, 0));
        this.assertFunction("parse_duration('1234d')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(1234, 0, 0, 0, 0));
        this.assertFunction("parse_duration('1234.567ns')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 0, 0, 0));
        this.assertFunction("parse_duration('1234.567ms')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 0, 1, 235));
        this.assertFunction("parse_duration('1234.567s')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 0, 0, 1234, 567));
        this.assertFunction("parse_duration('1234.567m')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(0, 20, 34, 34, 20));
        this.assertFunction("parse_duration('1234.567h')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(51, 10, 34, 1, 200));
        this.assertFunction("parse_duration('1234.567d')", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, new SqlIntervalDayTime(1234, 13, 36, 28, 800));
        this.assertInvalidFunction("parse_duration('')", "duration is empty");
        this.assertInvalidFunction("parse_duration('1f')", "Unknown time unit: f");
        this.assertInvalidFunction("parse_duration('abc')", "duration is not a valid data duration string: abc");
    }

    @Test
    public void testIntervalDayToSecondToMilliseconds() {
        this.assertFunction("to_milliseconds(parse_duration('1ns'))", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("to_milliseconds(parse_duration('1ms'))", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("to_milliseconds(parse_duration('1s'))", (Type)BigintType.BIGINT, TimeUnit.SECONDS.toMillis(1L));
        this.assertFunction("to_milliseconds(parse_duration('1h'))", (Type)BigintType.BIGINT, TimeUnit.HOURS.toMillis(1L));
        this.assertFunction("to_milliseconds(parse_duration('1d'))", (Type)BigintType.BIGINT, TimeUnit.DAYS.toMillis(1L));
    }

    @Test
    public void testWithTimezone() {
        this.assertFunction("with_timezone(TIMESTAMP '2001-08-22 03:04:05.321', 'UTC')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(new DateTime(2001, 8, 22, 3, 4, 5, 321, DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"UTC")))));
        this.assertFunction("with_timezone(TIMESTAMP '2001-08-22 03:04:05.321', '+13')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(new DateTime(2001, 8, 22, 3, 4, 5, 321, DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"+13")))));
        this.assertFunction("with_timezone(TIMESTAMP '2001-08-22 03:04:05.321', '-14')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(new DateTime(2001, 8, 22, 3, 4, 5, 321, DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"-14")))));
        this.assertFunction("with_timezone(TIMESTAMP '2001-08-22 03:04:05.321', '+00:45')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(new DateTime(2001, 8, 22, 3, 4, 5, 321, DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"+00:45")))));
        this.assertFunction("with_timezone(TIMESTAMP '2001-08-22 03:04:05.321', 'Asia/Shanghai')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(new DateTime(2001, 8, 22, 3, 4, 5, 321, DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Asia/Shanghai")))));
        this.assertFunction("with_timezone(TIMESTAMP '2001-08-22 03:04:05.321', 'America/New_York')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(new DateTime(2001, 8, 22, 3, 4, 5, 321, DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"America/New_York")))));
        this.assertFunction("with_timezone(TIMESTAMP '2001-06-01 03:04:05.321', 'America/Los_Angeles')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(new DateTime(2001, 6, 1, 3, 4, 5, 321, DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"America/Los_Angeles")))));
        this.assertFunction("with_timezone(TIMESTAMP '2001-12-01 03:04:05.321', 'America/Los_Angeles')", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, TestDateTimeFunctions.toTimestampWithTimeZone(new DateTime(2001, 12, 1, 3, 4, 5, 321, DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"America/Los_Angeles")))));
        this.assertInvalidFunction("with_timezone(TIMESTAMP '2001-08-22 03:04:05.321', 'invalidzoneid')", "'invalidzoneid' is not a valid time zone");
    }

    private void assertFunctionString(String projection, Type expectedType, String expected) {
        this.functionAssertions.assertFunctionString(projection, expectedType, expected);
    }

    private static SqlDate toDate(LocalDate localDate) {
        return new SqlDate(Math.toIntExact(localDate.toEpochDay()));
    }

    private static SqlDate toDate(DateTime dateDate) {
        long millis = dateDate.getMillis();
        return new SqlDate(Math.toIntExact(TimeUnit.MILLISECONDS.toDays(millis)));
    }

    private static long millisBetween(ReadableInstant start, ReadableInstant end) {
        Objects.requireNonNull(start, "start is null");
        Objects.requireNonNull(end, "end is null");
        return DurationFieldType.millis().getField(DateTimeUtils.getInstantChronology((ReadableInstant)start)).getDifferenceAsLong(end.getMillis(), start.getMillis());
    }

    private static Seconds secondsBetween(ReadableInstant start, ReadableInstant end) {
        return Seconds.secondsBetween((ReadableInstant)start, (ReadableInstant)end);
    }

    private static Minutes minutesBetween(ReadableInstant start, ReadableInstant end) {
        return Minutes.minutesBetween((ReadableInstant)start, (ReadableInstant)end);
    }

    private static Hours hoursBetween(ReadableInstant start, ReadableInstant end) {
        return Hours.hoursBetween((ReadableInstant)start, (ReadableInstant)end);
    }

    private static long millisBetween(LocalTime start, LocalTime end) {
        return TimeUnit.NANOSECONDS.toMillis(end.toNanoOfDay() - start.toNanoOfDay());
    }

    private static long secondsBetween(LocalTime start, LocalTime end) {
        return TimeUnit.NANOSECONDS.toSeconds(end.toNanoOfDay() - start.toNanoOfDay());
    }

    private static long minutesBetween(LocalTime start, LocalTime end) {
        return TimeUnit.NANOSECONDS.toMinutes(end.toNanoOfDay() - start.toNanoOfDay());
    }

    private static long hoursBetween(LocalTime start, LocalTime end) {
        return TimeUnit.NANOSECONDS.toHours(end.toNanoOfDay() - start.toNanoOfDay());
    }

    private static long millisBetween(OffsetTime start, OffsetTime end) {
        return TestDateTimeFunctions.millisUtc(end) - TestDateTimeFunctions.millisUtc(start);
    }

    private static long secondsBetween(OffsetTime start, OffsetTime end) {
        return TimeUnit.MILLISECONDS.toSeconds(TestDateTimeFunctions.millisBetween(start, end));
    }

    private static long minutesBetween(OffsetTime start, OffsetTime end) {
        return TimeUnit.MILLISECONDS.toMinutes(TestDateTimeFunctions.millisBetween(start, end));
    }

    private static long hoursBetween(OffsetTime start, OffsetTime end) {
        return TimeUnit.MILLISECONDS.toHours(TestDateTimeFunctions.millisBetween(start, end));
    }

    private static long millisUtc(OffsetTime offsetTime) {
        return offsetTime.atDate(LocalDate.ofEpochDay(0L)).toInstant().toEpochMilli();
    }

    private static SqlTimestampWithTimeZone toTimestampWithTimeZone(DateTime dateTime) {
        return SqlTimestampWithTimeZone.newInstance((int)3, (long)dateTime.getMillis(), (int)0, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)dateTime.getZone().getID()));
    }
}

