/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.type.SqlVarbinary;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.testng.annotations.Test;

public class TestJsonOutputFunctions
extends AbstractTestFunctions {
    private static final String JSON_EXPRESSION = "\"$varchar_to_json\"('{\"key1\" : 1e0, \"key2\" : true, \"key3\" : null}', true)";
    private static final String OUTPUT = "{\"key1\":1.0,\"key2\":true,\"key3\":null}";

    @Test
    public void testJsonToVarchar() {
        this.assertFunction("\"$json_to_varchar\"(\"$varchar_to_json\"('{\"key1\" : 1e0, \"key2\" : true, \"key3\" : null}', true), TINYINT '1', true)", (Type)VarcharType.VARCHAR, OUTPUT);
    }

    @Test
    public void testJsonToVarbinaryUtf8() {
        byte[] bytes = OUTPUT.getBytes(StandardCharsets.UTF_8);
        SqlVarbinary varbinaryOutput = new SqlVarbinary(bytes);
        this.assertFunction("\"$json_to_varbinary\"(\"$varchar_to_json\"('{\"key1\" : 1e0, \"key2\" : true, \"key3\" : null}', true), TINYINT '1', true)", (Type)VarbinaryType.VARBINARY, varbinaryOutput);
        this.assertFunction("\"$json_to_varbinary_utf8\"(\"$varchar_to_json\"('{\"key1\" : 1e0, \"key2\" : true, \"key3\" : null}', true), TINYINT '1', true)", (Type)VarbinaryType.VARBINARY, varbinaryOutput);
    }

    @Test
    public void testJsonToVarbinaryUtf16() {
        byte[] bytes = OUTPUT.getBytes(StandardCharsets.UTF_16LE);
        SqlVarbinary varbinaryOutput = new SqlVarbinary(bytes);
        this.assertFunction("\"$json_to_varbinary_utf16\"(\"$varchar_to_json\"('{\"key1\" : 1e0, \"key2\" : true, \"key3\" : null}', true), TINYINT '1', true)", (Type)VarbinaryType.VARBINARY, varbinaryOutput);
    }

    @Test
    public void testJsonToVarbinaryUtf32() {
        byte[] bytes = OUTPUT.getBytes(Charset.forName("UTF-32LE"));
        SqlVarbinary varbinaryOutput = new SqlVarbinary(bytes);
        this.assertFunction("\"$json_to_varbinary_utf32\"(\"$varchar_to_json\"('{\"key1\" : 1e0, \"key2\" : true, \"key3\" : null}', true), TINYINT '1', true)", (Type)VarbinaryType.VARBINARY, varbinaryOutput);
    }

    @Test
    public void testQuotesBehavior() {
        String jsonScalarString = "\"$varchar_to_json\"('\"some_text\"', true)";
        this.assertFunction("\"$json_to_varchar\"(" + jsonScalarString + ", TINYINT '1', false)", (Type)VarcharType.VARCHAR, "\"some_text\"");
        this.assertFunction("\"$json_to_varchar\"(" + jsonScalarString + ", TINYINT '1', true)", (Type)VarcharType.VARCHAR, "some_text");
        this.assertFunction("\"$json_to_varchar\"(\"$varchar_to_json\"('[\"some_text\"]', true), TINYINT '1', true)", (Type)VarcharType.VARCHAR, "[\"some_text\"]");
    }

    @Test
    public void testNullInput() {
        this.assertFunction("\"$json_to_varchar\"(null, TINYINT '1', true)", (Type)VarcharType.VARCHAR, null);
    }
}

