/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.type.UnknownType;
import io.trino.util.StructuralTestUtil;
import java.util.Arrays;
import java.util.List;
import org.testng.annotations.Test;

public class TestZipWithFunction
extends AbstractTestFunctions {
    @Test
    public void testRetainedSizeBounded() {
        this.assertCachedInstanceHasBoundedRetainedSize("zip_with(ARRAY [25, 26, 27], ARRAY [1, 2, 3], (x, y) -> x + y)");
    }

    @Test
    public void testSameLength() {
        this.assertFunction("zip_with(ARRAY[], ARRAY[], (x, y) -> (y, x))", (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)UnknownType.UNKNOWN, (Object)UnknownType.UNKNOWN))), ImmutableList.of());
        this.assertFunction("zip_with(ARRAY[1, 2], ARRAY['a', 'b'], (x, y) -> (y, x))", (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)VarcharType.createVarcharType((int)1), (Object)IntegerType.INTEGER))), ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)1), (Object)ImmutableList.of((Object)"b", (Object)2)));
        this.assertFunction("zip_with(ARRAY[1, 2], ARRAY[VARCHAR 'a', VARCHAR 'b'], (x, y) -> (y, x))", (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)IntegerType.INTEGER))), ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)1), (Object)ImmutableList.of((Object)"b", (Object)2)));
        this.assertFunction("zip_with(ARRAY[1, 1], ARRAY[1, 2], (x, y) -> x + y)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)2, (Object)3));
        this.assertFunction("zip_with(CAST(ARRAY[3, 5] AS ARRAY(BIGINT)), CAST(ARRAY[1, 2] AS ARRAY(BIGINT)), (x, y) -> x * y)", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)3L, (Object)10L));
        this.assertFunction("zip_with(ARRAY[true, false], ARRAY[false, true], (x, y) -> x OR y)", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true, (Object)true));
        this.assertFunction("zip_with(ARRAY['a', 'b'], ARRAY['c', 'd'], (x, y) -> concat(x, y))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"ac", (Object)"bd"));
        this.assertFunction("zip_with(ARRAY[MAP(ARRAY[CAST ('a' AS VARCHAR)], ARRAY[1]), MAP(ARRAY[VARCHAR 'b'], ARRAY[2])], ARRAY[MAP(ARRAY['c'], ARRAY[3]), MAP()], (x, y) -> map_concat(x, y))", (Type)new ArrayType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER)), ImmutableList.of((Object)ImmutableMap.of((Object)"a", (Object)1, (Object)"c", (Object)3), (Object)ImmutableMap.of((Object)"b", (Object)2)));
    }

    @Test
    public void testDifferentLength() {
        this.assertFunction("zip_with(ARRAY[1], ARRAY['a', 'bc'], (x, y) -> (y, x))", (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)VarcharType.createVarcharType((int)2), (Object)IntegerType.INTEGER))), ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)1), Arrays.asList("bc", null)));
        this.assertFunction("zip_with(ARRAY[NULL, 2], ARRAY['a'], (x, y) -> (y, x))", (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)VarcharType.createVarcharType((int)1), (Object)IntegerType.INTEGER))), ImmutableList.of(Arrays.asList("a", null), Arrays.asList(null, 2)));
        this.assertFunction("zip_with(ARRAY[NULL, NULL], ARRAY[NULL, 2, 1], (x, y) -> x + y)", (Type)new ArrayType((Type)IntegerType.INTEGER), Arrays.asList(null, null, null));
    }

    @Test
    public void testWithNull() {
        this.assertFunction("zip_with(CAST(NULL AS ARRAY(UNKNOWN)), ARRAY[], (x, y) -> (y, x))", (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)UnknownType.UNKNOWN, (Object)UnknownType.UNKNOWN))), null);
        this.assertFunction("zip_with(ARRAY[NULL], ARRAY[NULL], (x, y) -> (y, x))", (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)UnknownType.UNKNOWN, (Object)UnknownType.UNKNOWN))), ImmutableList.of(Arrays.asList(null, null)));
        this.assertFunction("zip_with(ARRAY[NULL], ARRAY[NULL], (x, y) -> x IS NULL AND y IS NULL)", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true));
        this.assertFunction("zip_with(ARRAY['a', NULL], ARRAY[NULL, 1], (x, y) -> x IS NULL OR y IS NULL)", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true, (Object)true));
        this.assertFunction("zip_with(ARRAY[1, NULL], ARRAY[3, 4], (x, y) -> x + y)", (Type)new ArrayType((Type)IntegerType.INTEGER), Arrays.asList(4, null));
        this.assertFunction("zip_with(ARRAY['a', 'b'], ARRAY[1, 3], (x, y) -> NULL)", (Type)new ArrayType((Type)UnknownType.UNKNOWN), Arrays.asList(null, null));
    }
}

