/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.Plugin;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.DesugarTryExpressionRewriter;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.assertions.ExpressionVerifier;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.DecimalLiteral;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.LambdaExpression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.TryExpression;
import io.trino.type.FunctionType;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDesugarTryExpressionRewriter
extends BaseRuleTest {
    public TestDesugarTryExpressionRewriter() {
        super(new Plugin[0]);
    }

    @Test
    public void testTryExpressionDesugaringRewriter() {
        ArithmeticBinaryExpression initial = new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new DecimalLiteral("1"), (Expression)new TryExpression((Expression)new DecimalLiteral("2")));
        Expression rewritten = DesugarTryExpressionRewriter.rewrite((Expression)initial, (Metadata)this.tester().getMetadata(), (TypeAnalyzer)this.tester().getTypeAnalyzer(), (Session)this.tester().getSession(), (SymbolAllocator)new SymbolAllocator());
        ArithmeticBinaryExpression expected = new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new DecimalLiteral("1"), (Expression)new TestingFunctionResolution().functionCallBuilder(QualifiedName.of((String)"$internal$try")).addArgument((Type)new FunctionType((List)ImmutableList.of(), (Type)DecimalType.createDecimalType((int)1)), (Expression)new LambdaExpression((List)ImmutableList.of(), (Expression)new DecimalLiteral("2"))).build());
        ExpressionVerifier verifier = new ExpressionVerifier(new SymbolAliases());
        Assert.assertTrue((boolean)((Boolean)verifier.process((Node)rewritten, expected)));
    }
}

