/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.connector.StaticConnectorFactory;
import io.trino.metadata.MaterializedViewDefinition;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.ViewColumn;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.Identity;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.transaction.IsolationLevel;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingMetadata;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestMaterializedViews
extends BasePlanTest {
    private static final String CATALOG = "local";
    private static final String SCHEMA = "tiny";

    @Override
    protected LocalQueryRunner createLocalQueryRunner() {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog(CATALOG).setSchema(SCHEMA).setSystemProperty("task_concurrency", "1");
        TestingMetadata testingConnectorMetadata = new TestingMetadata();
        LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)sessionBuilder.build());
        queryRunner.createCatalog(CATALOG, (ConnectorFactory)new StaticConnectorFactory("test", new TestMaterializedViewConnector((ConnectorMetadata)testingConnectorMetadata)), (Map)ImmutableMap.of());
        Metadata metadata = queryRunner.getMetadata();
        SchemaTableName testTable = new SchemaTableName(SCHEMA, "test_table");
        queryRunner.inTransaction(session -> {
            metadata.createTable(session, CATALOG, new ConnectorTableMetadata(testTable, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("b", (Type)BigintType.BIGINT))), false);
            return null;
        });
        SchemaTableName storageTable = new SchemaTableName(SCHEMA, "storage_table");
        queryRunner.inTransaction(session -> {
            metadata.createTable(session, CATALOG, new ConnectorTableMetadata(storageTable, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("b", (Type)BigintType.BIGINT))), false);
            return null;
        });
        SchemaTableName storageTableWithCasts = new SchemaTableName(SCHEMA, "storage_table_with_casts");
        queryRunner.inTransaction(session -> {
            metadata.createTable(session, CATALOG, new ConnectorTableMetadata(storageTableWithCasts, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)TinyintType.TINYINT), (Object)new ColumnMetadata("b", (Type)VarcharType.VARCHAR))), false);
            return null;
        });
        QualifiedObjectName freshMaterializedView = new QualifiedObjectName(CATALOG, SCHEMA, "fresh_materialized_view");
        MaterializedViewDefinition materializedViewDefinition = new MaterializedViewDefinition("SELECT a, b FROM test_table", Optional.of(CATALOG), Optional.of(SCHEMA), (List)ImmutableList.of((Object)new ViewColumn("a", BigintType.BIGINT.getTypeId()), (Object)new ViewColumn("b", BigintType.BIGINT.getTypeId())), Optional.empty(), Identity.ofUser((String)"some user"), Optional.of(new CatalogSchemaTableName(CATALOG, SCHEMA, "storage_table")), (Map)ImmutableMap.of());
        queryRunner.inTransaction(session -> {
            metadata.createMaterializedView(session, freshMaterializedView, materializedViewDefinition, false, false);
            return null;
        });
        testingConnectorMetadata.markMaterializedViewIsFresh(freshMaterializedView.asSchemaTableName());
        QualifiedObjectName notFreshMaterializedView = new QualifiedObjectName(CATALOG, SCHEMA, "not_fresh_materialized_view");
        queryRunner.inTransaction(session -> {
            metadata.createMaterializedView(session, notFreshMaterializedView, materializedViewDefinition, false, false);
            return null;
        });
        MaterializedViewDefinition materializedViewDefinitionWithCasts = new MaterializedViewDefinition("SELECT a, b FROM test_table", Optional.of(CATALOG), Optional.of(SCHEMA), (List)ImmutableList.of((Object)new ViewColumn("a", BigintType.BIGINT.getTypeId()), (Object)new ViewColumn("b", BigintType.BIGINT.getTypeId())), Optional.empty(), Identity.ofUser((String)"some user"), Optional.of(new CatalogSchemaTableName(CATALOG, SCHEMA, "storage_table_with_casts")), (Map)ImmutableMap.of());
        QualifiedObjectName materializedViewWithCasts = new QualifiedObjectName(CATALOG, SCHEMA, "materialized_view_with_casts");
        queryRunner.inTransaction(session -> {
            metadata.createMaterializedView(session, materializedViewWithCasts, materializedViewDefinitionWithCasts, false, false);
            return null;
        });
        testingConnectorMetadata.markMaterializedViewIsFresh(materializedViewWithCasts.asSchemaTableName());
        return queryRunner;
    }

    @Test
    public void testFreshMaterializedView() {
        this.assertPlan("SELECT * FROM fresh_materialized_view", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("storage_table")));
    }

    @Test
    public void testNotFreshMaterializedView() {
        this.assertPlan("SELECT * FROM not_fresh_materialized_view", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("test_table")));
    }

    @Test
    public void testMaterializedViewWithCasts() {
        TestingAccessControlManager accessControl = this.getQueryRunner().getAccessControl();
        accessControl.columnMask(new QualifiedObjectName(CATALOG, SCHEMA, "materialized_view_with_casts"), "a", "user", new ViewExpression("user", Optional.empty(), Optional.empty(), "a + 1"));
        this.assertPlan("SELECT * FROM materialized_view_with_casts", PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"A_CAST", (Object)PlanMatchPattern.expression("CAST(A as BIGINT) + BIGINT '1'"), (Object)"B_CAST", (Object)PlanMatchPattern.expression("CAST(B as BIGINT)")), PlanMatchPattern.tableScan("storage_table_with_casts", (Map<String, String>)ImmutableMap.of((Object)"A", (Object)"a", (Object)"B", (Object)"b")))));
    }

    private static class TestMaterializedViewConnector
    implements Connector {
        private final ConnectorMetadata metadata;

        public TestMaterializedViewConnector(ConnectorMetadata metadata) {
            this.metadata = metadata;
        }

        public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
            return new ConnectorTransactionHandle(){};
        }

        public ConnectorMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transaction) {
            return this.metadata;
        }
    }
}

