/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.AliasMatcher;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionVerifier;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.MeasureMatcher;
import io.trino.sql.planner.assertions.PatternRecognitionExpressionRewriter;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.assertions.WindowFunctionMatcher;
import io.trino.sql.planner.plan.PatternRecognitionNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.planner.rowpattern.ExpressionAndValuePointersEquivalence;
import io.trino.sql.planner.rowpattern.LogicalIndexExtractor;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.PatternRecognitionRelation;
import io.trino.sql.tree.SkipTo;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class PatternRecognitionMatcher
implements Matcher {
    private final Optional<ExpectedValueProvider<WindowNode.Specification>> specification;
    private final Optional<ExpectedValueProvider<WindowNode.Frame>> frame;
    private final PatternRecognitionRelation.RowsPerMatch rowsPerMatch;
    private final Optional<IrLabel> skipToLabel;
    private final SkipTo.Position skipToPosition;
    private final boolean initial;
    private final IrRowPattern pattern;
    private final Map<IrLabel, Set<IrLabel>> subsets;
    private final Map<IrLabel, LogicalIndexExtractor.ExpressionAndValuePointers> variableDefinitions;

    private PatternRecognitionMatcher(Optional<ExpectedValueProvider<WindowNode.Specification>> specification, Optional<ExpectedValueProvider<WindowNode.Frame>> frame, PatternRecognitionRelation.RowsPerMatch rowsPerMatch, Optional<IrLabel> skipToLabel, SkipTo.Position skipToPosition, boolean initial, IrRowPattern pattern, Map<IrLabel, Set<IrLabel>> subsets, Map<IrLabel, LogicalIndexExtractor.ExpressionAndValuePointers> variableDefinitions) {
        this.specification = Objects.requireNonNull(specification, "specification is null");
        this.frame = Objects.requireNonNull(frame, "frame is null");
        this.rowsPerMatch = Objects.requireNonNull(rowsPerMatch, "rowsPerMatch is null");
        this.skipToLabel = Objects.requireNonNull(skipToLabel, "skipToLabel is null");
        this.skipToPosition = Objects.requireNonNull(skipToPosition, "skipToPosition is null");
        this.initial = initial;
        this.pattern = Objects.requireNonNull(pattern, "pattern is null");
        this.subsets = Objects.requireNonNull(subsets, "subsets is null");
        this.variableDefinitions = Objects.requireNonNull(variableDefinitions, "variableDefinitions is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof PatternRecognitionNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        PatternRecognitionNode patternRecognitionNode = (PatternRecognitionNode)node;
        boolean specificationMatches = this.specification.map(expected -> ((WindowNode.Specification)expected.getExpectedValue(symbolAliases)).equals((Object)patternRecognitionNode.getSpecification())).orElse(true);
        if (!specificationMatches) {
            return MatchResult.NO_MATCH;
        }
        if (this.frame.isPresent()) {
            if (patternRecognitionNode.getCommonBaseFrame().isEmpty()) {
                return MatchResult.NO_MATCH;
            }
            if (!this.frame.get().getExpectedValue(symbolAliases).equals(patternRecognitionNode.getCommonBaseFrame().get())) {
                return MatchResult.NO_MATCH;
            }
        }
        if (this.rowsPerMatch != patternRecognitionNode.getRowsPerMatch()) {
            return MatchResult.NO_MATCH;
        }
        if (!this.skipToLabel.equals(patternRecognitionNode.getSkipToLabel())) {
            return MatchResult.NO_MATCH;
        }
        if (this.skipToPosition != patternRecognitionNode.getSkipToPosition()) {
            return MatchResult.NO_MATCH;
        }
        if (this.initial != patternRecognitionNode.isInitial()) {
            return MatchResult.NO_MATCH;
        }
        if (!this.pattern.equals(patternRecognitionNode.getPattern())) {
            return MatchResult.NO_MATCH;
        }
        if (!this.subsets.equals(patternRecognitionNode.getSubsets())) {
            return MatchResult.NO_MATCH;
        }
        if (this.variableDefinitions.size() != patternRecognitionNode.getVariableDefinitions().size()) {
            return MatchResult.NO_MATCH;
        }
        for (Map.Entry<IrLabel, LogicalIndexExtractor.ExpressionAndValuePointers> entry : this.variableDefinitions.entrySet()) {
            ExpressionVerifier verifier;
            IrLabel name = entry.getKey();
            LogicalIndexExtractor.ExpressionAndValuePointers actual = (LogicalIndexExtractor.ExpressionAndValuePointers)patternRecognitionNode.getVariableDefinitions().get(name);
            if (actual == null) {
                return MatchResult.NO_MATCH;
            }
            LogicalIndexExtractor.ExpressionAndValuePointers expected2 = entry.getValue();
            if (ExpressionAndValuePointersEquivalence.equivalent((LogicalIndexExtractor.ExpressionAndValuePointers)actual, (LogicalIndexExtractor.ExpressionAndValuePointers)expected2, (arg_0, arg_1) -> PatternRecognitionMatcher.lambda$detailMatches$1(verifier = new ExpressionVerifier(symbolAliases), arg_0, arg_1))) continue;
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("specification", this.specification.orElse(null)).add("frame", this.frame.orElse(null)).add("rowsPerMatch", (Object)this.rowsPerMatch).add("skipToLabel", this.skipToLabel.orElse(null)).add("skipToPosition", (Object)this.skipToPosition).add("initial", this.initial).add("pattern", (Object)this.pattern).add("subsets", this.subsets).add("variableDefinitions", this.variableDefinitions).toString();
    }

    private static /* synthetic */ Boolean lambda$detailMatches$1(ExpressionVerifier verifier, Symbol actualSymbol, Symbol expectedSymbol) {
        return (Boolean)verifier.process((Node)actualSymbol.toSymbolReference(), expectedSymbol.toSymbolReference());
    }

    public static class Builder {
        private final PlanMatchPattern source;
        private Optional<ExpectedValueProvider<WindowNode.Specification>> specification = Optional.empty();
        private final List<AliasMatcher> windowFunctionMatchers = new LinkedList<AliasMatcher>();
        private final Map<String, Map.Entry<String, Type>> measures = new HashMap<String, Map.Entry<String, Type>>();
        private Optional<ExpectedValueProvider<WindowNode.Frame>> frame = Optional.empty();
        private PatternRecognitionRelation.RowsPerMatch rowsPerMatch = PatternRecognitionRelation.RowsPerMatch.ONE;
        private Optional<IrLabel> skipToLabel = Optional.empty();
        private SkipTo.Position skipToPosition = SkipTo.Position.PAST_LAST;
        private boolean initial = true;
        private IrRowPattern pattern;
        private final Map<IrLabel, Set<IrLabel>> subsets = new HashMap<IrLabel, Set<IrLabel>>();
        private final Map<IrLabel, String> variableDefinitionsBySql = new HashMap<IrLabel, String>();
        private final Map<IrLabel, Expression> variableDefinitionsByExpression = new HashMap<IrLabel, Expression>();

        Builder(PlanMatchPattern source) {
            this.source = Objects.requireNonNull(source, "source is null");
        }

        public Builder specification(ExpectedValueProvider<WindowNode.Specification> specification) {
            this.specification = Optional.of(specification);
            return this;
        }

        public Builder addFunction(String outputAlias, ExpectedValueProvider<FunctionCall> functionCall) {
            this.windowFunctionMatchers.add(new AliasMatcher(Optional.of(outputAlias), new WindowFunctionMatcher(functionCall, Optional.empty(), Optional.empty())));
            return this;
        }

        public Builder addMeasure(String outputAlias, String expression, Type type) {
            this.measures.put(outputAlias, new AbstractMap.SimpleEntry<String, Type>(expression, type));
            return this;
        }

        public Builder frame(ExpectedValueProvider<WindowNode.Frame> frame) {
            this.frame = Optional.of(frame);
            return this;
        }

        public Builder rowsPerMatch(PatternRecognitionRelation.RowsPerMatch rowsPerMatch) {
            this.rowsPerMatch = rowsPerMatch;
            return this;
        }

        public Builder skipTo(SkipTo.Position position, IrLabel label) {
            this.skipToLabel = Optional.of(label);
            this.skipToPosition = position;
            return this;
        }

        public Builder skipTo(SkipTo.Position position) {
            this.skipToPosition = position;
            return this;
        }

        public Builder seek() {
            this.initial = false;
            return this;
        }

        public Builder pattern(IrRowPattern pattern) {
            this.pattern = pattern;
            return this;
        }

        public Builder addSubset(IrLabel name, Set<IrLabel> elements) {
            this.subsets.put(name, elements);
            return this;
        }

        public Builder addVariableDefinition(IrLabel name, String expression) {
            this.variableDefinitionsBySql.put(name, expression);
            return this;
        }

        public Builder addVariableDefinition(IrLabel name, Expression expression) {
            this.variableDefinitionsByExpression.put(name, expression);
            return this;
        }

        public PlanMatchPattern build() {
            ImmutableMap.Builder variableDefinitions = ImmutableMap.builder().putAll((Map)this.variableDefinitionsBySql.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> PatternRecognitionExpressionRewriter.rewrite((String)entry.getValue(), this.subsets)))).putAll((Map)this.variableDefinitionsByExpression.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> PatternRecognitionExpressionRewriter.rewrite((Expression)entry.getValue(), this.subsets))));
            PlanMatchPattern result = PlanMatchPattern.node(PatternRecognitionNode.class, this.source).with(new PatternRecognitionMatcher(this.specification, this.frame, this.rowsPerMatch, this.skipToLabel, this.skipToPosition, this.initial, this.pattern, this.subsets, (Map<IrLabel, LogicalIndexExtractor.ExpressionAndValuePointers>)variableDefinitions.buildOrThrow()));
            this.windowFunctionMatchers.forEach(result::with);
            this.measures.entrySet().stream().map(entry -> {
                String name = (String)entry.getKey();
                Map.Entry definition = (Map.Entry)entry.getValue();
                return new AliasMatcher(Optional.of(name), new MeasureMatcher((String)definition.getKey(), this.subsets, (Type)definition.getValue()));
            }).forEach(result::with);
            return result;
        }
    }
}

