/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.connector.CatalogName;
import io.trino.metadata.TableHandle;
import io.trino.plugin.tpch.TpchColumnHandle;
import io.trino.plugin.tpch.TpchTableHandle;
import io.trino.plugin.tpch.TpchTransactionHandle;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneIndexSourceColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.testng.annotations.Test;

public class TestPruneIndexSourceColumns
extends BaseRuleTest {
    public TestPruneIndexSourceColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testNotAllOutputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneIndexSourceColumns()).on(p -> TestPruneIndexSourceColumns.buildProjectedIndexSource(p, symbol -> symbol.getName().equals("orderkey"))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"x", (Object)PlanMatchPattern.expression("orderkey")), PlanMatchPattern.constrainedIndexSource("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))));
    }

    @Test
    public void testAllOutputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneIndexSourceColumns()).on(p -> TestPruneIndexSourceColumns.buildProjectedIndexSource(p, (Predicate<Symbol>)Predicates.alwaysTrue())).doesNotFire();
    }

    private static PlanNode buildProjectedIndexSource(PlanBuilder p, Predicate<Symbol> projectionFilter) {
        Symbol orderkey = p.symbol("orderkey", (Type)IntegerType.INTEGER);
        Symbol custkey = p.symbol("custkey", (Type)IntegerType.INTEGER);
        Symbol totalprice = p.symbol("totalprice", (Type)DoubleType.DOUBLE);
        TpchColumnHandle orderkeyHandle = new TpchColumnHandle(orderkey.getName(), (Type)IntegerType.INTEGER);
        TpchColumnHandle custkeyHandle = new TpchColumnHandle(custkey.getName(), (Type)IntegerType.INTEGER);
        TpchColumnHandle totalpriceHandle = new TpchColumnHandle(totalprice.getName(), (Type)DoubleType.DOUBLE);
        return p.project(Assignments.identity((Iterable)((Iterable)ImmutableList.of((Object)orderkey, (Object)custkey, (Object)totalprice).stream().filter(projectionFilter).collect(ImmutableList.toImmutableList()))), (PlanNode)p.indexSource(new TableHandle(new CatalogName("local"), (ConnectorTableHandle)new TpchTableHandle("tiny", "orders", 0.01), (ConnectorTransactionHandle)TpchTransactionHandle.INSTANCE), (Set<Symbol>)ImmutableSet.of((Object)orderkey, (Object)custkey), (List<Symbol>)ImmutableList.of((Object)orderkey, (Object)custkey, (Object)totalprice), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)orderkey, (Object)orderkeyHandle, (Object)custkey, (Object)custkeyHandle, (Object)totalprice, (Object)totalpriceHandle)));
    }
}

