/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.RemoveEmptyExceptBranches;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.NullLiteral;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestRemoveEmptyExceptBranches
extends BaseRuleTest {
    public TestRemoveEmptyExceptBranches() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoNotEliminateNonEmptyBranches() {
        this.tester().assertThat((Rule<?>)new RemoveEmptyExceptBranches()).on(p -> {
            Symbol output = p.symbol("output");
            Symbol input1 = p.symbol("input1");
            Symbol input2 = p.symbol("input2");
            return p.except((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)output, (Object)input1).put((Object)output, (Object)input2).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(1, input1), (Object)p.values(2, input2)));
        }).doesNotFire();
    }

    @Test
    public void testRemoveEmptyBranches() {
        this.tester().assertThat((Rule<?>)new RemoveEmptyExceptBranches()).on(p -> {
            Symbol output = p.symbol("output");
            Symbol input1 = p.symbol("input1");
            Symbol input2 = p.symbol("input2");
            Symbol input3 = p.symbol("input3");
            Symbol input4 = p.symbol("input4");
            return p.except((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)output, (Object)input1).put((Object)output, (Object)input2).put((Object)output, (Object)input3).put((Object)output, (Object)input4).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(1, input1), (Object)p.values(0, input2), (Object)p.values(2, input3), (Object)p.values(0, input4)));
        }).matches(PlanMatchPattern.except(PlanMatchPattern.values(List.of("input1"), List.of(List.of(new NullLiteral()))), PlanMatchPattern.values(List.of("input3"), List.of(List.of(new NullLiteral()), List.of(new NullLiteral())))));
    }

    @Test
    public void testReplaceRedundantExceptAll() {
        this.tester().assertThat((Rule<?>)new RemoveEmptyExceptBranches()).on(p -> {
            Symbol output = p.symbol("output");
            Symbol input1 = p.symbol("input1");
            Symbol input2 = p.symbol("input2");
            return p.except((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)output, (Object)input1).put((Object)output, (Object)input2).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(1, input1), (Object)p.values(0, input2)), false);
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"output", (Object)PlanMatchPattern.expression("input1")), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"input1"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new NullLiteral())))));
    }

    @Test
    public void testReplaceRedundantExceptDistinct() {
        this.tester().assertThat((Rule<?>)new RemoveEmptyExceptBranches()).on(p -> {
            Symbol output = p.symbol("output");
            Symbol input1 = p.symbol("input1");
            Symbol input2 = p.symbol("input2");
            return p.except((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)output, (Object)input1).put((Object)output, (Object)input2).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(1, input1), (Object)p.values(0, input2)), true);
        }).matches(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("output"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"output", (Object)PlanMatchPattern.expression("input1")), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"input1"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new NullLiteral()))))));
    }

    @Test
    public void testRemoveExceptWhenSetEmpty() {
        this.tester().assertThat((Rule<?>)new RemoveEmptyExceptBranches()).on(p -> {
            Symbol output = p.symbol("output");
            Symbol input1 = p.symbol("input1");
            Symbol input2 = p.symbol("input2");
            Symbol input3 = p.symbol("input3");
            Symbol input4 = p.symbol("input4");
            return p.except((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)output, (Object)input1).put((Object)output, (Object)input2).put((Object)output, (Object)input3).put((Object)output, (Object)input4).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(0, input1), (Object)p.values(1, input2), (Object)p.values(2, input3), (Object)p.values(0, input4)));
        }).matches(PlanMatchPattern.values("output"));
    }
}

