/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.sanity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.connector.CatalogName;
import io.trino.connector.MockConnectorFactory;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.TableHandle;
import io.trino.plugin.tpch.TpchColumnHandle;
import io.trino.plugin.tpch.TpchTableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.OutputNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.TableWriterNode;
import io.trino.sql.planner.sanity.ValidateScaledWritersUsage;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingTransactionHandle;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestValidateScaledWritersUsage
extends BasePlanTest {
    private PlannerContext plannerContext;
    private PlanBuilder planBuilder;
    private Symbol symbol;
    private TableScanNode tableScanNode;
    private CatalogName catalogSupportingScaledWriters;
    private CatalogName catalogNotSupportingScaledWriters;
    private LocalQueryRunner queryRunner;
    private SchemaTableName schemaTableName;

    @BeforeClass
    public void setup() {
        this.schemaTableName = new SchemaTableName("any", "any");
        this.catalogSupportingScaledWriters = new CatalogName("bytes_written_reported");
        this.catalogNotSupportingScaledWriters = new CatalogName("no_bytes_written_reported");
        this.queryRunner = LocalQueryRunner.create((Session)SessionTestUtils.TEST_SESSION);
        this.queryRunner.createCatalog(this.catalogSupportingScaledWriters.getCatalogName(), (ConnectorFactory)this.createConnectorFactorySupportingReportingBytesWritten(true, this.catalogSupportingScaledWriters.getCatalogName()), (Map)ImmutableMap.of());
        this.queryRunner.createCatalog(this.catalogNotSupportingScaledWriters.getCatalogName(), (ConnectorFactory)this.createConnectorFactorySupportingReportingBytesWritten(false, this.catalogNotSupportingScaledWriters.getCatalogName()), (Map)ImmutableMap.of());
        this.plannerContext = this.queryRunner.getPlannerContext();
        this.planBuilder = new PlanBuilder(new PlanNodeIdAllocator(), this.plannerContext.getMetadata(), SessionTestUtils.TEST_SESSION);
        TableHandle nationTableHandle = new TableHandle(this.catalogSupportingScaledWriters, (ConnectorTableHandle)new TpchTableHandle("sf1", "nation", 1.0), (ConnectorTransactionHandle)TestingTransactionHandle.create());
        TpchColumnHandle nationkeyColumnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.symbol = new Symbol("nationkey");
        this.tableScanNode = this.planBuilder.tableScan(nationTableHandle, (List<Symbol>)ImmutableList.of((Object)this.symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)this.symbol, (Object)nationkeyColumnHandle));
    }

    private MockConnectorFactory createConnectorFactorySupportingReportingBytesWritten(boolean supportsWrittenBytes, String name) {
        return MockConnectorFactory.builder().withSupportsReportingWrittenBytes(supportsWrittenBytes).withGetTableHandle((session, schemaTableName) -> null).withName(name).build();
    }

    @Test
    public void testScaledWritersUsedAndTargetSupportsIt() {
        ExchangeNode tableWriterSource = this.planBuilder.exchange(ex -> ex.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))).addInputsSet(this.symbol).addSource((PlanNode)this.planBuilder.exchange(innerExchange -> innerExchange.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SCALED_WRITER_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))).addInputsSet(this.symbol).addSource((PlanNode)this.tableScanNode))));
        OutputNode root = this.planBuilder.output(arg_0 -> this.lambda$testScaledWritersUsedAndTargetSupportsIt$3((PlanNode)tableWriterSource, arg_0));
        this.validatePlan((PlanNode)root);
    }

    @Test
    public void testScaledWritersUsedAndTargetDoesNotSupportIt() {
        ExchangeNode tableWriterSource = this.planBuilder.exchange(ex -> ex.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))).addInputsSet(this.symbol).addSource((PlanNode)this.planBuilder.exchange(innerExchange -> innerExchange.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SCALED_WRITER_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))).addInputsSet(this.symbol).addSource((PlanNode)this.tableScanNode))));
        OutputNode root = this.planBuilder.output(arg_0 -> this.lambda$testScaledWritersUsedAndTargetDoesNotSupportIt$6((PlanNode)tableWriterSource, arg_0));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testScaledWritersUsedAndTargetDoesNotSupportIt$7((PlanNode)root)).isInstanceOf(IllegalStateException.class)).hasMessage("The partitioning scheme is set to SCALED_WRITER_DISTRIBUTION but writer target no_bytes_written_reported:INSTANCE does support for it");
    }

    @Test
    public void testScaledWritersUsedAndTargetDoesNotSupportItMultipleSourceExchanges() {
        ExchangeNode tableWriterSource = this.planBuilder.exchange(ex -> ex.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol, (Object)this.symbol))).addInputsSet(this.symbol, this.symbol).addInputsSet(this.symbol, this.symbol).addSource((PlanNode)this.planBuilder.exchange(innerExchange -> innerExchange.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SCALED_WRITER_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))).addInputsSet(this.symbol).addSource((PlanNode)this.tableScanNode))).addSource((PlanNode)this.planBuilder.exchange(innerExchange -> innerExchange.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))).addInputsSet(this.symbol).addSource((PlanNode)this.tableScanNode))));
        OutputNode root = this.planBuilder.output(arg_0 -> this.lambda$testScaledWritersUsedAndTargetDoesNotSupportItMultipleSourceExchanges$11((PlanNode)tableWriterSource, arg_0));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testScaledWritersUsedAndTargetDoesNotSupportItMultipleSourceExchanges$12((PlanNode)root)).isInstanceOf(IllegalStateException.class)).hasMessage("The partitioning scheme is set to SCALED_WRITER_DISTRIBUTION but writer target no_bytes_written_reported:INSTANCE does support for it");
    }

    @Test
    public void testScaledWritersUsedAndTargetSupportsItMultipleSourceExchanges() {
        ExchangeNode tableWriterSource = this.planBuilder.exchange(ex -> ex.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol, (Object)this.symbol))).addInputsSet(this.symbol, this.symbol).addInputsSet(this.symbol, this.symbol).addSource((PlanNode)this.planBuilder.exchange(innerExchange -> innerExchange.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SCALED_WRITER_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))).addInputsSet(this.symbol).addSource((PlanNode)this.tableScanNode))).addSource((PlanNode)this.planBuilder.exchange(innerExchange -> innerExchange.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))).addInputsSet(this.symbol).addSource((PlanNode)this.tableScanNode))));
        OutputNode root = this.planBuilder.output(arg_0 -> this.lambda$testScaledWritersUsedAndTargetSupportsItMultipleSourceExchanges$16((PlanNode)tableWriterSource, arg_0));
        this.validatePlan((PlanNode)root);
    }

    @Test
    public void testScaledWritersUsedAboveTableWriterInThePlanTree() {
        ExchangeNode tableWriterSource = this.planBuilder.exchange(ex -> ex.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))).addInputsSet(this.symbol).addSource((PlanNode)this.planBuilder.exchange(innerExchange -> innerExchange.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))).addInputsSet(this.symbol).addSource((PlanNode)this.tableScanNode))));
        OutputNode root = this.planBuilder.output(arg_0 -> this.lambda$testScaledWritersUsedAboveTableWriterInThePlanTree$19((PlanNode)tableWriterSource, arg_0));
        this.validatePlan((PlanNode)root);
    }

    @Test
    public void testScaledWritersTwoTableWritersNodes() {
        ExchangeNode tableWriterSource = this.planBuilder.exchange(ex -> ex.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))).addInputsSet(this.symbol).addSource((PlanNode)this.planBuilder.tableWriter((List<Symbol>)ImmutableList.of((Object)this.symbol), (List<String>)ImmutableList.of((Object)"column_a"), Optional.empty(), Optional.empty(), (TableWriterNode.WriterTarget)this.planBuilder.createTarget(this.catalogSupportingScaledWriters, this.schemaTableName, true), (PlanNode)this.planBuilder.exchange(innerExchange -> innerExchange.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SCALED_WRITER_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))).addInputsSet(this.symbol).addSource((PlanNode)this.tableScanNode)), this.symbol)));
        OutputNode root = this.planBuilder.output(arg_0 -> this.lambda$testScaledWritersTwoTableWritersNodes$22((PlanNode)tableWriterSource, arg_0));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testScaledWritersTwoTableWritersNodes$23((PlanNode)root)).isInstanceOf(IllegalStateException.class)).hasMessage("The partitioning scheme is set to SCALED_WRITER_DISTRIBUTION but writer target no_bytes_written_reported:INSTANCE does support for it");
    }

    private void validatePlan(PlanNode root) {
        this.queryRunner.inTransaction(session -> {
            this.plannerContext.getMetadata().getCatalogHandle(session, this.catalogSupportingScaledWriters.getCatalogName());
            this.plannerContext.getMetadata().getCatalogHandle(session, this.catalogNotSupportingScaledWriters.getCatalogName());
            new ValidateScaledWritersUsage().validate(root, session, this.plannerContext, TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)this.plannerContext), TypeProvider.empty(), WarningCollector.NOOP);
            return null;
        });
    }

    private /* synthetic */ void lambda$testScaledWritersTwoTableWritersNodes$23(PlanNode root) throws Throwable {
        this.validatePlan(root);
    }

    private /* synthetic */ void lambda$testScaledWritersTwoTableWritersNodes$22(PlanNode tableWriterSource, PlanBuilder.OutputBuilder outputBuilder) {
        outputBuilder.source((PlanNode)this.planBuilder.tableWithExchangeCreate((TableWriterNode.WriterTarget)this.planBuilder.createTarget(this.catalogNotSupportingScaledWriters, this.schemaTableName, false), tableWriterSource, this.symbol, new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))));
    }

    private /* synthetic */ void lambda$testScaledWritersUsedAboveTableWriterInThePlanTree$19(PlanNode tableWriterSource, PlanBuilder.OutputBuilder outputBuilder) {
        outputBuilder.source((PlanNode)this.planBuilder.tableWithExchangeCreate((TableWriterNode.WriterTarget)this.planBuilder.createTarget(this.catalogNotSupportingScaledWriters, this.schemaTableName, false), tableWriterSource, this.symbol, new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SCALED_WRITER_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))));
    }

    private /* synthetic */ void lambda$testScaledWritersUsedAndTargetSupportsItMultipleSourceExchanges$16(PlanNode tableWriterSource, PlanBuilder.OutputBuilder outputBuilder) {
        outputBuilder.source((PlanNode)this.planBuilder.tableWithExchangeCreate((TableWriterNode.WriterTarget)this.planBuilder.createTarget(this.catalogSupportingScaledWriters, this.schemaTableName, true), tableWriterSource, this.symbol, new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))));
    }

    private /* synthetic */ void lambda$testScaledWritersUsedAndTargetDoesNotSupportItMultipleSourceExchanges$12(PlanNode root) throws Throwable {
        this.validatePlan(root);
    }

    private /* synthetic */ void lambda$testScaledWritersUsedAndTargetDoesNotSupportItMultipleSourceExchanges$11(PlanNode tableWriterSource, PlanBuilder.OutputBuilder outputBuilder) {
        outputBuilder.source((PlanNode)this.planBuilder.tableWithExchangeCreate((TableWriterNode.WriterTarget)this.planBuilder.createTarget(this.catalogNotSupportingScaledWriters, this.schemaTableName, false), tableWriterSource, this.symbol, new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))));
    }

    private /* synthetic */ void lambda$testScaledWritersUsedAndTargetDoesNotSupportIt$7(PlanNode root) throws Throwable {
        this.validatePlan(root);
    }

    private /* synthetic */ void lambda$testScaledWritersUsedAndTargetDoesNotSupportIt$6(PlanNode tableWriterSource, PlanBuilder.OutputBuilder outputBuilder) {
        outputBuilder.source((PlanNode)this.planBuilder.tableWithExchangeCreate((TableWriterNode.WriterTarget)this.planBuilder.createTarget(this.catalogNotSupportingScaledWriters, this.schemaTableName, false), tableWriterSource, this.symbol, new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))));
    }

    private /* synthetic */ void lambda$testScaledWritersUsedAndTargetSupportsIt$3(PlanNode tableWriterSource, PlanBuilder.OutputBuilder outputBuilder) {
        outputBuilder.source((PlanNode)this.planBuilder.tableWithExchangeCreate((TableWriterNode.WriterTarget)this.planBuilder.createTarget(this.catalogSupportingScaledWriters, this.schemaTableName, true), tableWriterSource, this.symbol, new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))));
    }
}

