/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestComplexTypesWithNull {
    private QueryAssertions assertions;

    @BeforeClass
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testRowTypeWithNull() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT r.a, r.b, c FROM (VALUES ROW(CAST(ROW(1, NULL) AS ROW(a INTEGER, b INTEGER)))) t(r) JOIN (VALUES 1) u(c) ON c = r.a")))).matches("VALUES (1, CAST(NULL AS INTEGER), 1)");
    }

    @Test
    public void testArrayTypeWithNull() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT t.a, t.b, c FROM UNNEST(ARRAY[CAST(ROW(1, NULL) as ROW(a INTEGER, b INTEGER)) ]) t JOIN (VALUES 1) u(c) ON c = t.a")))).matches("VALUES (1, CAST(NULL AS INTEGER), 1)");
    }

    @Test
    public void testNestedRowTypeWithNull() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT r.a, r[2].b, r[2].c, c FROM (VALUES ROW(CAST(ROW(1, ROW(1, NULL)) AS ROW(a INTEGER, ROW(b INTEGER, c INTEGER))))) t(r) JOIN (VALUES 1) u(c) ON c = r.a")))).matches("VALUES (1, 1, CAST(NULL AS INTEGER), 1)");
    }

    @Test
    public void testNestedArrayTypeWithNull() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT r.a, r.b, c FROM (VALUES CAST(ROW(ROW(1, ARRAY[NULL])) AS ROW(ROW(a INTEGER, b ARRAY(INTEGER))))) t(r) JOIN (VALUES 1) u(c) ON c = r.a")))).matches("VALUES (1, ARRAY[CAST(NULL AS INTEGER)], 1)");
    }
}

