/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import com.google.common.collect.ImmutableMap;
import io.trino.FeaturesConfig;
import io.trino.Session;
import io.trino.metadata.QualifiedObjectName;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.security.Identity;
import io.trino.spi.security.ViewExpression;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.MaterializedRow;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingSession;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestFilterInaccessibleColumns {
    private static final String CATALOG = "local";
    private static final String USER = "user";
    private static final String ADMIN = "admin";
    private static final Session SESSION = TestingSession.testSessionBuilder().setCatalog("local").setSchema("tiny").setSystemProperty("hide_inaccessible_columns", "true").setIdentity(Identity.forUser((String)"user").build()).build();
    private QueryAssertions assertions;
    private TestingAccessControlManager accessControl;

    @BeforeClass
    public void init() {
        LocalQueryRunner runner = LocalQueryRunner.builder((Session)SESSION).withFeaturesConfig(new FeaturesConfig().setHideInaccessibleColumns(true)).build();
        runner.createCatalog(CATALOG, (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        this.assertions = new QueryAssertions((QueryRunner)runner);
        this.accessControl = this.assertions.getQueryRunner().getAccessControl();
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @BeforeMethod
    public void beforeMethod() {
        this.accessControl.reset();
    }

    @Test
    public void testSelectBaseline() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM nation WHERE name = 'FRANCE'")))).matches("VALUES (BIGINT '6', CAST('FRANCE' AS VARCHAR(25)), BIGINT '3', CAST('refully final requests. regular, ironi' AS VARCHAR(152)))");
    }

    @Test
    public void testSimpleTableSchemaFilter() {
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)USER, (String)"nation.comment", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM nation WHERE name = 'FRANCE'")))).matches("VALUES (BIGINT '6', CAST('FRANCE' AS VARCHAR(25)), BIGINT '3')");
    }

    @Test
    public void testDescribeBaseline() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("DESCRIBE nation")))).matches(materializedRows -> materializedRows.getMaterializedRows().stream().filter(materializedRow -> materializedRow.getField(0).equals("comment")).findFirst().isPresent());
    }

    @Test
    public void testDescribe() {
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)USER, (String)"nation.comment", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("DESCRIBE nation")))).matches(materializedRows -> materializedRows.getMaterializedRows().stream().filter(materializedRow -> materializedRow.getField(0).equals("comment")).findFirst().isEmpty());
    }

    @Test
    public void testShowColumnsBaseline() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW COLUMNS FROM nation")))).matches(materializedRows -> materializedRows.getMaterializedRows().stream().filter(materializedRow -> materializedRow.getField(0).equals("comment")).findFirst().isPresent());
    }

    @Test
    public void testShowColumns() {
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"nation.comment", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW COLUMNS FROM nation")))).matches(materializedRows -> materializedRows.getMaterializedRows().stream().filter(materializedRow -> materializedRow.getField(0).equals("comment")).findFirst().isEmpty());
    }

    @Test
    public void testFilterExplicitSelect() {
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)USER, (String)"nation.comment", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT nationkey, name, regionkey FROM nation WHERE name = 'FRANCE'")))).matches("VALUES (BIGINT '6', CAST('FRANCE' AS VARCHAR(25)), BIGINT '3')");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT nationkey, name, regionkey, comment FROM nation WHERE name = 'FRANCE'")).hasMessage("Access Denied: Cannot select from columns [nationkey, regionkey, name, comment] in table or view local.tiny.nation");
    }

    @Test
    public void testRowFilterOnNotAccessibleColumn() {
        this.accessControl.rowFilter(new QualifiedObjectName(CATALOG, "tiny", "nation"), USER, new ViewExpression(ADMIN, Optional.of(CATALOG), Optional.of("tiny"), "comment IS NOT null"));
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)USER, (String)"nation.comment", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM nation WHERE name = 'FRANCE'")))).matches("VALUES (BIGINT '6', CAST('FRANCE' AS VARCHAR(25)), BIGINT '3')");
    }

    @Test
    public void testRowFilterOnNotAccessibleColumnKO() {
        this.accessControl.rowFilter(new QualifiedObjectName(CATALOG, "tiny", "nation"), USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("tiny"), "comment IS NOT null"));
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)USER, (String)"nation.comment", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM nation WHERE name = 'FRANCE'")).hasMessage("Access Denied: Cannot select from columns [nationkey, regionkey, name, comment] in table or view local.tiny.nation");
    }

    @Test
    public void testMaskingOnAccessibleColumn() {
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "nation"), "nationkey", USER, new ViewExpression(ADMIN, Optional.of(CATALOG), Optional.of("tiny"), "-nationkey"));
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM nation WHERE name = 'FRANCE'")))).matches("VALUES (BIGINT '-6',CAST('FRANCE' AS VARCHAR(25)), BIGINT '3', CAST('refully final requests. regular, ironi' AS VARCHAR(152)))");
    }

    @Test
    public void testMaskingWithCaseOnNotAccessibleColumnKO() {
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)USER, (String)"nation.nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "nation"), "comment", USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("tiny"), "CASE nationkey WHEN 6 THEN 'masked-comment' ELSE comment END"));
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM nation WHERE name = 'FRANCE'")).hasMessage("Access Denied: Cannot select from columns [nationkey, regionkey, name, comment] in table or view local.tiny.nation");
    }

    @Test
    public void testMaskingWithCaseOnNotAccessibleColumn() {
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)USER, (String)"nation.nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "nation"), "comment", USER, new ViewExpression(ADMIN, Optional.of(CATALOG), Optional.of("tiny"), "CASE nationkey WHEN 6 THEN 'masked-comment' ELSE comment END"));
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM nation WHERE name = 'FRANCE'")))).matches("VALUES (CAST('FRANCE' AS VARCHAR(25)), BIGINT '3', CAST('masked-comment' AS VARCHAR(152)))");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM nation WHERE name = 'CANADA'")))).matches("VALUES (CAST('CANADA' AS VARCHAR(25)), BIGINT '1', CAST('eas hang ironic, silent packages. slyly regular packages are furiously over the tithes. fluffily bold' AS VARCHAR(152)))");
    }

    @Test
    public void testPredicateOnInaccessibleColumn() {
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)USER, (String)"nation.name", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM nation WHERE name = 'FRANCE'")).hasMessage("Access Denied: Cannot select from columns [nationkey, regionkey, name, comment] in table or view local.tiny.nation");
    }

    @Test
    public void testJoinBaseline() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM nation,customer WHERE customer.nationkey = nation.nationkey AND nation.name = 'FRANCE' AND customer.name='Customer#000001477'")))).matches(materializedRows -> ((MaterializedRow)materializedRows.getMaterializedRows().get(0)).getField(11).equals("ites nag blithely alongside of the ironic accounts. accounts use. carefully silent deposits"));
    }

    @Test
    public void testJoin() {
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)USER, (String)"nation.comment", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM nation,customer WHERE customer.nationkey = nation.nationkey AND nation.name = 'FRANCE' AND customer.name='Customer#000001477'")))).matches(materializedRows -> ((MaterializedRow)materializedRows.getMaterializedRows().get(0)).getFields().size() == 11);
    }

    @Test
    public void testConstantFields() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (SELECT 'test')")))).matches("VALUES ('test')");
    }

    @Test
    public void testFunctionFields() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (SELECT concat(name,'-test') FROM nation WHERE name = 'FRANCE')")))).matches("VALUES (CAST('FRANCE-test' AS VARCHAR))");
    }

    @Test
    public void testFunctionOnInaccessibleColumn() {
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)USER, (String)"nation.name", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (SELECT concat(name,'-test') FROM nation WHERE name = 'FRANCE')")).hasMessage("Access Denied: Cannot select from columns [name] in table or view local.tiny.nation");
    }
}

