/*
 * Decompiled with CFR 0.152.
 */
package io.trino.transaction;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.connector.CatalogName;
import io.trino.metadata.CatalogManager;
import io.trino.metadata.CatalogMetadata;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.assertions.Assert;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionInfo;
import io.trino.transaction.TransactionManager;
import io.trino.transaction.TransactionManagerConfig;
import java.io.Closeable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestTransactionManager {
    private static final String CATALOG = "test_catalog";
    private static final CatalogName CATALOG_NAME = new CatalogName("test_catalog");
    private final ExecutorService finishingExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"transaction-%s"));

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.finishingExecutor.shutdownNow();
    }

    @Test
    public void testTransactionWorkflow() {
        try (LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)SessionTestUtils.TEST_SESSION);){
            TransactionManager transactionManager = queryRunner.getTransactionManager();
            queryRunner.createCatalog(CATALOG, (ConnectorFactory)new TpchConnectorFactory(), (Map)ImmutableMap.of());
            TransactionId transactionId = transactionManager.beginTransaction(false);
            org.testng.Assert.assertEquals((int)transactionManager.getAllTransactionInfos().size(), (int)1);
            TransactionInfo transactionInfo = transactionManager.getTransactionInfo(transactionId);
            org.testng.Assert.assertFalse((boolean)transactionInfo.isAutoCommitContext());
            org.testng.Assert.assertTrue((boolean)transactionInfo.getCatalogNames().isEmpty());
            org.testng.Assert.assertFalse((boolean)transactionInfo.getWrittenConnectorId().isPresent());
            ConnectorMetadata metadata = ((CatalogMetadata)transactionManager.getOptionalCatalogMetadata(transactionId, CATALOG).get()).getMetadata(SessionTestUtils.TEST_SESSION);
            metadata.listSchemaNames(SessionTestUtils.TEST_SESSION.toConnectorSession(CATALOG_NAME));
            transactionInfo = transactionManager.getTransactionInfo(transactionId);
            org.testng.Assert.assertEquals((Collection)transactionInfo.getCatalogNames(), (Collection)ImmutableList.of((Object)CATALOG_NAME));
            org.testng.Assert.assertFalse((boolean)transactionInfo.getWrittenConnectorId().isPresent());
            MoreFutures.getFutureValue((Future)transactionManager.asyncCommit(transactionId));
            org.testng.Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty());
        }
    }

    @Test
    public void testAbortedTransactionWorkflow() {
        try (LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)SessionTestUtils.TEST_SESSION);){
            TransactionManager transactionManager = queryRunner.getTransactionManager();
            queryRunner.createCatalog(CATALOG, (ConnectorFactory)new TpchConnectorFactory(), (Map)ImmutableMap.of());
            TransactionId transactionId = transactionManager.beginTransaction(false);
            org.testng.Assert.assertEquals((int)transactionManager.getAllTransactionInfos().size(), (int)1);
            TransactionInfo transactionInfo = transactionManager.getTransactionInfo(transactionId);
            org.testng.Assert.assertFalse((boolean)transactionInfo.isAutoCommitContext());
            org.testng.Assert.assertTrue((boolean)transactionInfo.getCatalogNames().isEmpty());
            org.testng.Assert.assertFalse((boolean)transactionInfo.getWrittenConnectorId().isPresent());
            ConnectorMetadata metadata = ((CatalogMetadata)transactionManager.getOptionalCatalogMetadata(transactionId, CATALOG).get()).getMetadata(SessionTestUtils.TEST_SESSION);
            metadata.listSchemaNames(SessionTestUtils.TEST_SESSION.toConnectorSession(CATALOG_NAME));
            transactionInfo = transactionManager.getTransactionInfo(transactionId);
            org.testng.Assert.assertEquals((Collection)transactionInfo.getCatalogNames(), (Collection)ImmutableList.of((Object)CATALOG_NAME));
            org.testng.Assert.assertFalse((boolean)transactionInfo.getWrittenConnectorId().isPresent());
            MoreFutures.getFutureValue((Future)transactionManager.asyncAbort(transactionId));
            org.testng.Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty());
        }
    }

    @Test
    public void testFailedTransactionWorkflow() {
        try (LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)SessionTestUtils.TEST_SESSION);){
            TransactionManager transactionManager = queryRunner.getTransactionManager();
            queryRunner.createCatalog(CATALOG, (ConnectorFactory)new TpchConnectorFactory(), (Map)ImmutableMap.of());
            TransactionId transactionId = transactionManager.beginTransaction(false);
            org.testng.Assert.assertEquals((int)transactionManager.getAllTransactionInfos().size(), (int)1);
            TransactionInfo transactionInfo = transactionManager.getTransactionInfo(transactionId);
            org.testng.Assert.assertFalse((boolean)transactionInfo.isAutoCommitContext());
            org.testng.Assert.assertTrue((boolean)transactionInfo.getCatalogNames().isEmpty());
            org.testng.Assert.assertFalse((boolean)transactionInfo.getWrittenConnectorId().isPresent());
            ConnectorMetadata metadata = ((CatalogMetadata)transactionManager.getOptionalCatalogMetadata(transactionId, CATALOG).get()).getMetadata(SessionTestUtils.TEST_SESSION);
            metadata.listSchemaNames(SessionTestUtils.TEST_SESSION.toConnectorSession(CATALOG_NAME));
            transactionInfo = transactionManager.getTransactionInfo(transactionId);
            org.testng.Assert.assertEquals((Collection)transactionInfo.getCatalogNames(), (Collection)ImmutableList.of((Object)CATALOG_NAME));
            org.testng.Assert.assertFalse((boolean)transactionInfo.getWrittenConnectorId().isPresent());
            transactionManager.fail(transactionId);
            org.testng.Assert.assertEquals((int)transactionManager.getAllTransactionInfos().size(), (int)1);
            TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> transactionManager.getCatalogMetadata(transactionId, CATALOG_NAME)).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TRANSACTION_ALREADY_ABORTED);
            org.testng.Assert.assertEquals((int)transactionManager.getAllTransactionInfos().size(), (int)1);
            MoreFutures.getFutureValue((Future)transactionManager.asyncAbort(transactionId));
            org.testng.Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty());
        }
    }

    @Test
    public void testExpiration() {
        try (IdleCheckExecutor executor = new IdleCheckExecutor();){
            TransactionManager transactionManager = InMemoryTransactionManager.create((TransactionManagerConfig)new TransactionManagerConfig().setIdleTimeout(new Duration(1.0, TimeUnit.MILLISECONDS)).setIdleCheckInterval(new Duration(5.0, TimeUnit.MILLISECONDS)), (ScheduledExecutorService)executor.getExecutor(), (CatalogManager)new CatalogManager(), (Executor)this.finishingExecutor);
            TransactionId transactionId = transactionManager.beginTransaction(false);
            org.testng.Assert.assertEquals((int)transactionManager.getAllTransactionInfos().size(), (int)1);
            TransactionInfo transactionInfo = transactionManager.getTransactionInfo(transactionId);
            org.testng.Assert.assertFalse((boolean)transactionInfo.isAutoCommitContext());
            org.testng.Assert.assertTrue((boolean)transactionInfo.getCatalogNames().isEmpty());
            org.testng.Assert.assertFalse((boolean)transactionInfo.getWrittenConnectorId().isPresent());
            transactionManager.trySetInactive(transactionId);
            Assert.assertEventually((Duration)new Duration(10.0, TimeUnit.SECONDS), () -> org.testng.Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty()));
        }
    }

    private static class IdleCheckExecutor
    implements Closeable {
        private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"idle-check"));

        private IdleCheckExecutor() {
        }

        public ScheduledExecutorService getExecutor() {
            return this.executorService;
        }

        @Override
        public void close() {
            this.executorService.shutdownNow();
        }
    }
}

