/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.SqlDate;
import io.trino.spi.type.SqlTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.testing.DateTimeTestingUtils;
import io.trino.testing.TestingSession;
import io.trino.util.DateTimeZoneIndex;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.annotations.Test;

public class TestDate
extends AbstractTestFunctions {
    private static final TimeZoneKey TIME_ZONE_KEY = TimeZoneKey.getTimeZoneKey((String)"Europe/Berlin");
    private static final DateTimeZone DATE_TIME_ZONE = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TIME_ZONE_KEY);

    protected TestDate() {
        super(TestingSession.testSessionBuilder().setTimeZoneKey(TIME_ZONE_KEY).build());
    }

    @Test
    public void testLiteral() {
        long millis = new DateTime(2001, 1, 22, 0, 0, DateTimeZone.UTC).getMillis();
        this.assertFunction("DATE '2001-1-22'", (Type)DateType.DATE, new SqlDate((int)TimeUnit.MILLISECONDS.toDays(millis)));
    }

    @Test
    public void testEqual() {
        this.assertFunction("DATE '2001-1-22' = DATE '2001-1-22'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DATE '2001-1-22' = DATE '2001-1-22'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DATE '2001-1-22' = DATE '2001-1-23'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DATE '2001-1-22' = DATE '2001-1-11'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testNotEqual() {
        this.assertFunction("DATE '2001-1-22' <> DATE '2001-1-23'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DATE '2001-1-22' <> DATE '2001-1-11'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DATE '2001-1-22' <> DATE '2001-1-22'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThan() {
        this.assertFunction("DATE '2001-1-22' < DATE '2001-1-23'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DATE '2001-1-22' < DATE '2001-1-22'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DATE '2001-1-22' < DATE '2001-1-20'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThanOrEqual() {
        this.assertFunction("DATE '2001-1-22' <= DATE '2001-1-22'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DATE '2001-1-22' <= DATE '2001-1-23'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DATE '2001-1-22' <= DATE '2001-1-20'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testGreaterThan() {
        this.assertFunction("DATE '2001-1-22' > DATE '2001-1-11'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DATE '2001-1-22' > DATE '2001-1-22'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DATE '2001-1-22' > DATE '2001-1-23'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testGreaterThanOrEqual() {
        this.assertFunction("DATE '2001-1-22' >= DATE '2001-1-22'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DATE '2001-1-22' >= DATE '2001-1-11'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DATE '2001-1-22' >= DATE '2001-1-23'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testBetween() {
        this.assertFunction("DATE '2001-1-22' between DATE '2001-1-11' and DATE '2001-1-23'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DATE '2001-1-22' between DATE '2001-1-11' and DATE '2001-1-22'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DATE '2001-1-22' between DATE '2001-1-22' and DATE '2001-1-23'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DATE '2001-1-22' between DATE '2001-1-22' and DATE '2001-1-22'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DATE '2001-1-22' between DATE '2001-1-11' and DATE '2001-1-12'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DATE '2001-1-22' between DATE '2001-1-23' and DATE '2001-1-24'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DATE '2001-1-22' between DATE '2001-1-23' and DATE '2001-1-11'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testCastToTimestamp() {
        this.assertFunction("cast(DATE '2001-1-22' as timestamp)", (Type)TimestampType.TIMESTAMP_MILLIS, DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2001, (int)1, (int)22, (int)0, (int)0, (int)0, (int)0));
    }

    @Test
    public void testCastToTimestampWithTimeZone() {
        this.assertFunction("cast(DATE '2001-1-22' as timestamp with time zone)", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, SqlTimestampWithTimeZone.newInstance((int)3, (long)new DateTime(2001, 1, 22, 0, 0, 0, 0, DATE_TIME_ZONE).getMillis(), (int)0, (TimeZoneKey)TIME_ZONE_KEY));
    }

    @Test
    public void testCastToVarchar() {
        this.assertFunction("cast(DATE '2001-1-22' as varchar)", (Type)VarcharType.VARCHAR, "2001-01-22");
    }

    @Test
    public void testCastFromVarchar() {
        this.assertFunction("cast('2001-1-22' as date) = Date '2001-1-22'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('\n\t 2001-1-22' as date) = Date '2001-1-22'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('2001-1-22 \t\n' as date) = Date '2001-1-22'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('\n\t 2001-1-22 \t\n' as date) = Date '2001-1-22'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testGreatest() {
        int days = (int)TimeUnit.MILLISECONDS.toDays(new DateTime(2013, 3, 30, 0, 0, DateTimeZone.UTC).getMillis());
        this.assertFunction("greatest(DATE '2013-03-30', DATE '2012-05-23')", (Type)DateType.DATE, new SqlDate(days));
        this.assertFunction("greatest(DATE '2013-03-30', DATE '2012-05-23', DATE '2012-06-01')", (Type)DateType.DATE, new SqlDate(days));
    }

    @Test
    public void testLeast() {
        int days = (int)TimeUnit.MILLISECONDS.toDays(new DateTime(2012, 5, 23, 0, 0, DateTimeZone.UTC).getMillis());
        this.assertFunction("least(DATE '2013-03-30', DATE '2012-05-23')", (Type)DateType.DATE, new SqlDate(days));
        this.assertFunction("least(DATE '2013-03-30', DATE '2012-05-23', DATE '2012-06-01')", (Type)DateType.DATE, new SqlDate(days));
    }

    @Test
    public void testIndeterminate() {
        this.assertOperator(OperatorType.INDETERMINATE, "cast(null as DATE)", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "DATE '2013-10-27'", (Type)BooleanType.BOOLEAN, false);
    }
}

