/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.Type;
import io.trino.type.DecimalOperators;
import io.trino.type.UnknownType;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestDecimalOperators
extends AbstractTestFunctions {
    @Test
    public void testAdd() {
        this.assertDecimalFunction("DECIMAL '137.7' + DECIMAL '17.1'", SqlDecimal.decimal((String)"0154.8", (DecimalType)DecimalType.createDecimalType((int)5, (int)1)));
        this.assertDecimalFunction("DECIMAL '-1' + DECIMAL '-2'", SqlDecimal.decimal((String)"-03", (DecimalType)DecimalType.createDecimalType((int)2)));
        this.assertDecimalFunction("DECIMAL '1' + DECIMAL '2'", SqlDecimal.decimal((String)"03", (DecimalType)DecimalType.createDecimalType((int)2)));
        this.assertDecimalFunction("DECIMAL '.1234567890123456' + DECIMAL '.1234567890123456'", SqlDecimal.decimal((String)"0.2469135780246912", (DecimalType)DecimalType.createDecimalType((int)17, (int)16)));
        this.assertDecimalFunction("DECIMAL '-.1234567890123456' + DECIMAL '-.1234567890123456'", SqlDecimal.decimal((String)"-0.2469135780246912", (DecimalType)DecimalType.createDecimalType((int)17, (int)16)));
        this.assertDecimalFunction("DECIMAL '1234567890123456' + DECIMAL '1234567890123456'", SqlDecimal.decimal((String)"02469135780246912", (DecimalType)DecimalType.createDecimalType((int)17)));
        this.assertDecimalFunction("DECIMAL '123456789012345678' + DECIMAL '123456789012345678'", SqlDecimal.decimal((String)"0246913578024691356", (DecimalType)DecimalType.createDecimalType((int)19)));
        this.assertDecimalFunction("DECIMAL '.123456789012345678' + DECIMAL '.123456789012345678'", SqlDecimal.decimal((String)"0.246913578024691356", (DecimalType)DecimalType.createDecimalType((int)19, (int)18)));
        this.assertDecimalFunction("DECIMAL '1234567890123456789' + DECIMAL '1234567890123456789'", SqlDecimal.decimal((String)"02469135780246913578", (DecimalType)DecimalType.createDecimalType((int)20)));
        this.assertDecimalFunction("DECIMAL '12345678901234567890123456789012345678' + DECIMAL '12345678901234567890123456789012345678'", SqlDecimal.decimal((String)"24691357802469135780246913578024691356", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("DECIMAL '-99999999999999999999999999999999999999' + DECIMAL '99999999999999999999999999999999999999'", SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("DECIMAL '12345678901234567890' + DECIMAL '-12345678901234567890'", SqlDecimal.decimal((String)"000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)21)));
        this.assertDecimalFunction("DECIMAL '-12345678901234567890' + DECIMAL '12345678901234567890'", SqlDecimal.decimal((String)"000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)21)));
        this.assertDecimalFunction("DECIMAL '-12345678901234567890' + DECIMAL '-12345678901234567890'", SqlDecimal.decimal((String)"-024691357802469135780", (DecimalType)DecimalType.createDecimalType((int)21)));
        this.assertDecimalFunction("DECIMAL '12345678901234567890' + DECIMAL '-12345678901234567891'", SqlDecimal.decimal((String)"-000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)21)));
        this.assertDecimalFunction("DECIMAL '-12345678901234567891' + DECIMAL '12345678901234567890'", SqlDecimal.decimal((String)"-000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)21)));
        this.assertDecimalFunction("DECIMAL '-12345678901234567890' + DECIMAL '12345678901234567891'", SqlDecimal.decimal((String)"000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)21)));
        this.assertDecimalFunction("DECIMAL '12345678901234567891' + DECIMAL '-12345678901234567890'", SqlDecimal.decimal((String)"000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)21)));
        this.assertDecimalFunction("DECIMAL '999999999999999999' + DECIMAL '999999999999999999'", SqlDecimal.decimal((String)"1999999999999999998", (DecimalType)DecimalType.createDecimalType((int)19)));
        this.assertDecimalFunction("DECIMAL '999999999999999999' + DECIMAL '.999999999999999999'", SqlDecimal.decimal((String)"0999999999999999999.999999999999999999", (DecimalType)DecimalType.createDecimalType((int)37, (int)18)));
        this.assertDecimalFunction("DECIMAL '123456789012345678901234567890' + DECIMAL '.12345678'", SqlDecimal.decimal((String)"123456789012345678901234567890.12345678", (DecimalType)DecimalType.createDecimalType((int)38, (int)8)));
        this.assertDecimalFunction("DECIMAL '.123456789012345678901234567890' + DECIMAL '12345678'", SqlDecimal.decimal((String)"12345678.123456789012345678901234567890", (DecimalType)DecimalType.createDecimalType((int)38, (int)30)));
        this.assertDecimalFunction("DECIMAL '.12345678' + DECIMAL '123456789012345678901234567890'", SqlDecimal.decimal((String)"123456789012345678901234567890.12345678", (DecimalType)DecimalType.createDecimalType((int)38, (int)8)));
        this.assertDecimalFunction("DECIMAL '12345678' + DECIMAL '.123456789012345678901234567890'", SqlDecimal.decimal((String)"12345678.123456789012345678901234567890", (DecimalType)DecimalType.createDecimalType((int)38, (int)30)));
        this.assertInvalidFunction("DECIMAL '99999999999999999999999999999999999999' + DECIMAL '1'", (ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE);
        this.assertInvalidFunction("DECIMAL '.1' + DECIMAL '99999999999999999999999999999999999999'", (ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE);
        this.assertInvalidFunction("DECIMAL '1' + DECIMAL '99999999999999999999999999999999999999'", (ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE);
        this.assertInvalidFunction("DECIMAL '99999999999999999999999999999999999999' + DECIMAL '.1'", (ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE);
        this.assertInvalidFunction("DECIMAL '99999999999999999999999999999999999999' + DECIMAL '99999999999999999999999999999999999999'", (ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE);
        this.assertInvalidFunction("DECIMAL '-99999999999999999999999999999999999999' + DECIMAL '-99999999999999999999999999999999999999'", (ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE);
        this.assertDecimalFunction("DECIMAL '17014000000000000000000000000000000000' + DECIMAL '-7014000000000000000000000000000000000.1'", SqlDecimal.decimal((String)"9999999999999999999999999999999999999.9", (DecimalType)DecimalType.createDecimalType((int)38, (int)1)));
        this.assertInvalidFunction("DECIMAL '17015000000000000000000000000000000000' + DECIMAL '-7015000000000000000000000000000000000.1'", (ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE);
    }

    @Test
    public void testSubtract() {
        this.assertDecimalFunction("DECIMAL '107.7' - DECIMAL '17.1'", SqlDecimal.decimal((String)"0090.6", (DecimalType)DecimalType.createDecimalType((int)5, (int)1)));
        this.assertDecimalFunction("DECIMAL '-1' - DECIMAL '-2'", SqlDecimal.decimal((String)"01", (DecimalType)DecimalType.createDecimalType((int)2)));
        this.assertDecimalFunction("DECIMAL '1' - DECIMAL '2'", SqlDecimal.decimal((String)"-01", (DecimalType)DecimalType.createDecimalType((int)2)));
        this.assertDecimalFunction("DECIMAL '.1234567890123456' - DECIMAL '.1234567890123456'", SqlDecimal.decimal((String)"0.0000000000000000", (DecimalType)DecimalType.createDecimalType((int)17, (int)16)));
        this.assertDecimalFunction("DECIMAL '-.1234567890123456' - DECIMAL '-.1234567890123456'", SqlDecimal.decimal((String)"0.0000000000000000", (DecimalType)DecimalType.createDecimalType((int)17, (int)16)));
        this.assertDecimalFunction("DECIMAL '1234567890123456' - DECIMAL '1234567890123456'", SqlDecimal.decimal((String)"00000000000000000", (DecimalType)DecimalType.createDecimalType((int)17)));
        this.assertDecimalFunction("DECIMAL '1234567890123456789' - DECIMAL '1234567890123456789'", SqlDecimal.decimal((String)"00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)20)));
        this.assertDecimalFunction("DECIMAL '.1234567890123456789' - DECIMAL '.1234567890123456789'", SqlDecimal.decimal((String)"0.0000000000000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)19)));
        this.assertDecimalFunction("DECIMAL '12345678901234567890' - DECIMAL '12345678901234567890'", SqlDecimal.decimal((String)"000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)21)));
        this.assertDecimalFunction("DECIMAL '12345678901234567890123456789012345678' - DECIMAL '12345678901234567890123456789012345678'", SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("DECIMAL '-12345678901234567890' - DECIMAL '12345678901234567890'", SqlDecimal.decimal((String)"-024691357802469135780", (DecimalType)DecimalType.createDecimalType((int)21)));
        this.assertDecimalFunction("DECIMAL '12345678901234567890' - DECIMAL '12345678901234567890'", SqlDecimal.decimal((String)"000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)21)));
        this.assertDecimalFunction("DECIMAL '-12345678901234567890' - DECIMAL '-12345678901234567890'", SqlDecimal.decimal((String)"000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)21)));
        this.assertDecimalFunction("DECIMAL '-12345678901234567890' - DECIMAL '12345678901234567890'", SqlDecimal.decimal((String)"-024691357802469135780", (DecimalType)DecimalType.createDecimalType((int)21)));
        this.assertDecimalFunction("DECIMAL '12345678901234567890' - DECIMAL '12345678901234567891'", SqlDecimal.decimal((String)"-000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)21)));
        this.assertDecimalFunction("DECIMAL '-12345678901234567891' - DECIMAL '-12345678901234567890'", SqlDecimal.decimal((String)"-000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)21)));
        this.assertDecimalFunction("DECIMAL '-12345678901234567890' - DECIMAL '-12345678901234567891'", SqlDecimal.decimal((String)"000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)21)));
        this.assertDecimalFunction("DECIMAL '12345678901234567891' - DECIMAL '12345678901234567890'", SqlDecimal.decimal((String)"000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)21)));
        this.assertDecimalFunction("DECIMAL '999999999999999999' - DECIMAL '999999999999999999'", SqlDecimal.decimal((String)"0000000000000000000", (DecimalType)DecimalType.createDecimalType((int)19)));
        this.assertDecimalFunction("DECIMAL '999999999999999999' - DECIMAL '.999999999999999999'", SqlDecimal.decimal((String)"0999999999999999998.000000000000000001", (DecimalType)DecimalType.createDecimalType((int)37, (int)18)));
        this.assertDecimalFunction("DECIMAL '123456789012345678901234567890' - DECIMAL '.00000001'", SqlDecimal.decimal((String)"123456789012345678901234567889.99999999", (DecimalType)DecimalType.createDecimalType((int)38, (int)8)));
        this.assertDecimalFunction("DECIMAL '.000000000000000000000000000001' - DECIMAL '87654321'", SqlDecimal.decimal((String)"-87654320.999999999999999999999999999999", (DecimalType)DecimalType.createDecimalType((int)38, (int)30)));
        this.assertDecimalFunction("DECIMAL '.00000001' - DECIMAL '123456789012345678901234567890'", SqlDecimal.decimal((String)"-123456789012345678901234567889.99999999", (DecimalType)DecimalType.createDecimalType((int)38, (int)8)));
        this.assertDecimalFunction("DECIMAL '12345678' - DECIMAL '.000000000000000000000000000001'", SqlDecimal.decimal((String)"12345677.999999999999999999999999999999", (DecimalType)DecimalType.createDecimalType((int)38, (int)30)));
        this.assertInvalidFunction("DECIMAL '-99999999999999999999999999999999999999' - DECIMAL '1'", (ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE);
        this.assertInvalidFunction("DECIMAL '.1' - DECIMAL '99999999999999999999999999999999999999'", (ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE);
        this.assertInvalidFunction("DECIMAL '-1' - DECIMAL '99999999999999999999999999999999999999'", (ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE);
        this.assertInvalidFunction("DECIMAL '99999999999999999999999999999999999999' - DECIMAL '.1'", (ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE);
        this.assertInvalidFunction("DECIMAL '-99999999999999999999999999999999999999' - DECIMAL '99999999999999999999999999999999999999'", (ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE);
        this.assertDecimalFunction("DECIMAL '17014000000000000000000000000000000000' - DECIMAL '7014000000000000000000000000000000000.1'", SqlDecimal.decimal((String)"9999999999999999999999999999999999999.9", (DecimalType)DecimalType.createDecimalType((int)38, (int)1)));
        this.assertInvalidFunction("DECIMAL '17015000000000000000000000000000000000' - DECIMAL '7015000000000000000000000000000000000.1'", (ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE);
    }

    @Test
    public void testMultiply() {
        this.assertDecimalFunction("DECIMAL '0' * DECIMAL '1'", SqlDecimal.decimal((String)"00", (DecimalType)DecimalType.createDecimalType((int)2)));
        this.assertDecimalFunction("DECIMAL '0' * DECIMAL '-1'", SqlDecimal.decimal((String)"00", (DecimalType)DecimalType.createDecimalType((int)2)));
        this.assertDecimalFunction("DECIMAL '1' * DECIMAL '0'", SqlDecimal.decimal((String)"00", (DecimalType)DecimalType.createDecimalType((int)2)));
        this.assertDecimalFunction("DECIMAL '-1' * DECIMAL '0'", SqlDecimal.decimal((String)"00", (DecimalType)DecimalType.createDecimalType((int)2)));
        this.assertDecimalFunction("DECIMAL '12' * DECIMAL '3'", SqlDecimal.decimal((String)"036", (DecimalType)DecimalType.createDecimalType((int)3)));
        this.assertDecimalFunction("DECIMAL '12' * DECIMAL '-3'", SqlDecimal.decimal((String)"-036", (DecimalType)DecimalType.createDecimalType((int)3)));
        this.assertDecimalFunction("DECIMAL '-12' * DECIMAL '3'", SqlDecimal.decimal((String)"-036", (DecimalType)DecimalType.createDecimalType((int)3)));
        this.assertDecimalFunction("DECIMAL '1234567890123456' * DECIMAL '3'", SqlDecimal.decimal((String)"03703703670370368", (DecimalType)DecimalType.createDecimalType((int)17)));
        this.assertDecimalFunction("DECIMAL '.1234567890123456' * DECIMAL '3'", SqlDecimal.decimal((String)"0.3703703670370368", (DecimalType)DecimalType.createDecimalType((int)17, (int)16)));
        this.assertDecimalFunction("DECIMAL '.1234567890123456' * DECIMAL '.3'", SqlDecimal.decimal((String)".03703703670370368", (DecimalType)DecimalType.createDecimalType((int)17, (int)17)));
        this.assertDecimalFunction("CAST(0 AS DECIMAL(18,0)) * CAST(1 AS DECIMAL(18,0))", SqlDecimal.decimal((String)"000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)36)));
        this.assertDecimalFunction("CAST(0 AS DECIMAL(18,0)) * CAST(-1 AS DECIMAL(18,0))", SqlDecimal.decimal((String)"000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)36)));
        this.assertDecimalFunction("CAST(1 AS DECIMAL(18,0)) * CAST(0 AS DECIMAL(18,0))", SqlDecimal.decimal((String)"000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)36)));
        this.assertDecimalFunction("CAST(-1 AS DECIMAL(18,0)) * CAST(0 AS DECIMAL(18,0))", SqlDecimal.decimal((String)"000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)36)));
        this.assertDecimalFunction("DECIMAL '12345678901234567' * DECIMAL '123456789012345670'", SqlDecimal.decimal((String)"01524157875323883455265967556774890", (DecimalType)DecimalType.createDecimalType((int)35)));
        this.assertDecimalFunction("DECIMAL '-12345678901234567' * DECIMAL '123456789012345670'", SqlDecimal.decimal((String)"-01524157875323883455265967556774890", (DecimalType)DecimalType.createDecimalType((int)35)));
        this.assertDecimalFunction("DECIMAL '-12345678901234567' * DECIMAL '-123456789012345670'", SqlDecimal.decimal((String)"01524157875323883455265967556774890", (DecimalType)DecimalType.createDecimalType((int)35)));
        this.assertDecimalFunction("DECIMAL '.12345678901234567' * DECIMAL '.123456789012345670'", SqlDecimal.decimal((String)".01524157875323883455265967556774890", (DecimalType)DecimalType.createDecimalType((int)35, (int)35)));
        this.assertDecimalFunction("CAST(0 AS DECIMAL(38,0)) * 1", SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("CAST(0 AS DECIMAL(38,0)) * -1", SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("CAST(1 AS DECIMAL(38,0)) * 0", SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("CAST(-1 AS DECIMAL(38,0)) * 0", SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("DECIMAL '12345678901234567890123456789012345678' * DECIMAL '3'", SqlDecimal.decimal((String)"37037036703703703670370370367037037034", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("DECIMAL '1234567890123456789.0123456789012345678' * DECIMAL '3'", SqlDecimal.decimal((String)"3703703670370370367.0370370367037037034", (DecimalType)DecimalType.createDecimalType((int)38, (int)19)));
        this.assertDecimalFunction("DECIMAL '.12345678901234567890123456789012345678' * DECIMAL '3'", SqlDecimal.decimal((String)".37037036703703703670370370367037037034", (DecimalType)DecimalType.createDecimalType((int)38, (int)38)));
        this.assertDecimalFunction("0 * CAST(1 AS DECIMAL(38,0))", SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("0 * CAST(-1 AS DECIMAL(38,0))", SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("1 * CAST(0 AS DECIMAL(38,0))", SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("-1 * CAST(0 AS DECIMAL(38,0))", SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("DECIMAL '3' * DECIMAL '12345678901234567890123456789012345678'", SqlDecimal.decimal((String)"37037036703703703670370370367037037034", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("DECIMAL '3' * DECIMAL '1234567890123456789.0123456789012345678'", SqlDecimal.decimal((String)"3703703670370370367.0370370367037037034", (DecimalType)DecimalType.createDecimalType((int)38, (int)19)));
        this.assertDecimalFunction("DECIMAL '3' * DECIMAL '.12345678901234567890123456789012345678'", SqlDecimal.decimal((String)".37037036703703703670370370367037037034", (DecimalType)DecimalType.createDecimalType((int)38, (int)38)));
        this.assertDecimalFunction("CAST(0 AS DECIMAL(38,0)) * CAST(1 AS DECIMAL(38,0))", SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("CAST(0 AS DECIMAL(38,0)) * CAST(-1 AS DECIMAL(38,0))", SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("CAST(1 AS DECIMAL(38,0)) * CAST(0 AS DECIMAL(38,0))", SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("CAST(-1 AS DECIMAL(38,0)) * CAST(0 AS DECIMAL(38,0))", SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("CAST(3 AS DECIMAL(38,0)) * CAST(2 AS DECIMAL(38,0))", SqlDecimal.decimal((String)"00000000000000000000000000000000000006", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("CAST(3 AS DECIMAL(38,0)) * CAST(DECIMAL '0.2' AS DECIMAL(38,1))", SqlDecimal.decimal((String)"0000000000000000000000000000000000000.6", (DecimalType)DecimalType.createDecimalType((int)38, (int)1)));
        this.assertDecimalFunction("DECIMAL '.1234567890123456789' * DECIMAL '.1234567890123456789'", SqlDecimal.decimal((String)".01524157875323883675019051998750190521", (DecimalType)DecimalType.createDecimalType((int)38, (int)38)));
        this.assertInvalidFunction("DECIMAL '.1234567890123456789' * DECIMAL '.12345678901234567890'", "DECIMAL scale must be in range [0, precision (38)]: 39");
        this.assertInvalidFunction("DECIMAL '.1' * DECIMAL '.12345678901234567890123456789012345678'", "DECIMAL scale must be in range [0, precision (38)]: 39");
        this.assertInvalidFunction("DECIMAL '12345678901234567890123456789012345678' * DECIMAL '9'", (ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE);
        this.assertInvalidFunction("DECIMAL '.12345678901234567890123456789012345678' * DECIMAL '9'", (ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE);
        this.assertInvalidFunction("DECIMAL '12345678901234567890123456789012345678' * DECIMAL '-9'", (ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE);
        this.assertInvalidFunction("DECIMAL '.12345678901234567890123456789012345678' * DECIMAL '-9'", (ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE);
        Assertions.assertThatThrownBy(() -> DecimalOperators.multiplyLongShortLong((Int128)Int128.valueOf((String)"12345678901234567890123456789012345678"), (long)9L)).hasMessage("Decimal overflow");
        Assertions.assertThatThrownBy(() -> DecimalOperators.multiplyShortLongLong((long)9L, (Int128)Int128.valueOf((String)"12345678901234567890123456789012345678"))).hasMessage("Decimal overflow");
        Assertions.assertThatThrownBy(() -> DecimalOperators.multiplyLongLongLong((Int128)Int128.valueOf((String)"12345678901234567890123456789012345678"), (Int128)Int128.valueOf((String)"9"))).hasMessage("Decimal overflow");
    }

    @Test
    public void testDivide() {
        this.assertDecimalFunction("DECIMAL '1' / DECIMAL '3'", SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '1' / DECIMAL '3'", SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '1.0' / DECIMAL '3'", SqlDecimal.decimal((String)"0.3", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        this.assertDecimalFunction("DECIMAL '1.0' / DECIMAL '0.1'", SqlDecimal.decimal((String)"10.0", (DecimalType)DecimalType.createDecimalType((int)3, (int)1)));
        this.assertDecimalFunction("DECIMAL '1.0' / DECIMAL '9.0'", SqlDecimal.decimal((String)"00.1", (DecimalType)DecimalType.createDecimalType((int)3, (int)1)));
        this.assertDecimalFunction("DECIMAL '500.00' / DECIMAL '0.1'", SqlDecimal.decimal((String)"5000.00", (DecimalType)DecimalType.createDecimalType((int)6, (int)2)));
        this.assertDecimalFunction("DECIMAL '100.00' / DECIMAL '0.3'", SqlDecimal.decimal((String)"0333.33", (DecimalType)DecimalType.createDecimalType((int)6, (int)2)));
        this.assertDecimalFunction("DECIMAL '100.00' / DECIMAL '0.30'", SqlDecimal.decimal((String)"00333.33", (DecimalType)DecimalType.createDecimalType((int)7, (int)2)));
        this.assertDecimalFunction("DECIMAL '100.00' / DECIMAL '-0.30'", SqlDecimal.decimal((String)"-00333.33", (DecimalType)DecimalType.createDecimalType((int)7, (int)2)));
        this.assertDecimalFunction("DECIMAL '-100.00' / DECIMAL '0.30'", SqlDecimal.decimal((String)"-00333.33", (DecimalType)DecimalType.createDecimalType((int)7, (int)2)));
        this.assertDecimalFunction("DECIMAL '200.00' / DECIMAL '0.3'", SqlDecimal.decimal((String)"0666.67", (DecimalType)DecimalType.createDecimalType((int)6, (int)2)));
        this.assertDecimalFunction("DECIMAL '200.00000' / DECIMAL '0.3'", SqlDecimal.decimal((String)"0666.66667", (DecimalType)DecimalType.createDecimalType((int)9, (int)5)));
        this.assertDecimalFunction("DECIMAL '200.00000' / DECIMAL '-0.3'", SqlDecimal.decimal((String)"-0666.66667", (DecimalType)DecimalType.createDecimalType((int)9, (int)5)));
        this.assertDecimalFunction("DECIMAL '-200.00000' / DECIMAL '0.3'", SqlDecimal.decimal((String)"-0666.66667", (DecimalType)DecimalType.createDecimalType((int)9, (int)5)));
        this.assertDecimalFunction("DECIMAL '999999999999999999' / DECIMAL '1'", SqlDecimal.decimal((String)"999999999999999999", (DecimalType)DecimalType.createDecimalType((int)18)));
        this.assertDecimalFunction("DECIMAL '9' / DECIMAL '000000000000000003'", SqlDecimal.decimal((String)"3", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '9.0' / DECIMAL '3.0'", SqlDecimal.decimal((String)"03.0", (DecimalType)DecimalType.createDecimalType((int)3, (int)1)));
        this.assertDecimalFunction("DECIMAL '999999999999999999' / DECIMAL '500000000000000000'", SqlDecimal.decimal((String)"000000000000000002", (DecimalType)DecimalType.createDecimalType((int)18)));
        this.assertDecimalFunction("DECIMAL '1' / DECIMAL '999999999999999999'", SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '-1' / DECIMAL '999999999999999999'", SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '9' / DECIMAL '5'", SqlDecimal.decimal((String)"2", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '7' / DECIMAL '5'", SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '-9' / DECIMAL '5'", SqlDecimal.decimal((String)"-2", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '-7' / DECIMAL '5'", SqlDecimal.decimal((String)"-1", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '-9' / DECIMAL '-5'", SqlDecimal.decimal((String)"2", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '-7' / DECIMAL '-5'", SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '9' / DECIMAL '-5'", SqlDecimal.decimal((String)"-2", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '7' / DECIMAL '-5'", SqlDecimal.decimal((String)"-1", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '-1' / DECIMAL '2'", SqlDecimal.decimal((String)"-1", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '1' / DECIMAL '-2'", SqlDecimal.decimal((String)"-1", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '-1' / DECIMAL '3'", SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '10' / DECIMAL '.000000001'", SqlDecimal.decimal((String)"10000000000.000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)9)));
        this.assertDecimalFunction("DECIMAL '-10' / DECIMAL '.000000001'", SqlDecimal.decimal((String)"-10000000000.000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)9)));
        this.assertDecimalFunction("DECIMAL '10' / DECIMAL '-.000000001'", SqlDecimal.decimal((String)"-10000000000.000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)9)));
        this.assertDecimalFunction("DECIMAL '-10' / DECIMAL '-.000000001'", SqlDecimal.decimal((String)"10000000000.000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)9)));
        this.assertDecimalFunction("DECIMAL '200000000000000000000000000000000000' / DECIMAL '0.30'", SqlDecimal.decimal((String)"666666666666666666666666666666666666.67", (DecimalType)DecimalType.createDecimalType((int)38, (int)2)));
        this.assertDecimalFunction("DECIMAL '200000000000000000000000000000000000' / DECIMAL '-0.30'", SqlDecimal.decimal((String)"-666666666666666666666666666666666666.67", (DecimalType)DecimalType.createDecimalType((int)38, (int)2)));
        this.assertDecimalFunction("DECIMAL '-.20000000000000000000000000000000000000' / DECIMAL '0.30'", SqlDecimal.decimal((String)"-.66666666666666666666666666666666666667", (DecimalType)DecimalType.createDecimalType((int)38, (int)38)));
        this.assertDecimalFunction("DECIMAL '-.20000000000000000000000000000000000000' / DECIMAL '-0.30'", SqlDecimal.decimal((String)".66666666666666666666666666666666666667", (DecimalType)DecimalType.createDecimalType((int)38, (int)38)));
        this.assertDecimalFunction("DECIMAL '.20000000000000000000000000000000000000' / DECIMAL '0.30'", SqlDecimal.decimal((String)".66666666666666666666666666666666666667", (DecimalType)DecimalType.createDecimalType((int)38, (int)38)));
        this.assertDecimalFunction("DECIMAL '500000000000000000000000000000000075' / DECIMAL '50'", SqlDecimal.decimal((String)"010000000000000000000000000000000002", (DecimalType)DecimalType.createDecimalType((int)36)));
        this.assertDecimalFunction("DECIMAL '500000000000000000000000000000000070' / DECIMAL '50'", SqlDecimal.decimal((String)"010000000000000000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)36)));
        this.assertDecimalFunction("DECIMAL '-500000000000000000000000000000000075' / DECIMAL '50'", SqlDecimal.decimal((String)"-010000000000000000000000000000000002", (DecimalType)DecimalType.createDecimalType((int)36)));
        this.assertDecimalFunction("DECIMAL '-500000000000000000000000000000000070' / DECIMAL '50'", SqlDecimal.decimal((String)"-010000000000000000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)36)));
        this.assertDecimalFunction("DECIMAL '500000000000000000000000000000000075' / DECIMAL '-50'", SqlDecimal.decimal((String)"-010000000000000000000000000000000002", (DecimalType)DecimalType.createDecimalType((int)36)));
        this.assertDecimalFunction("DECIMAL '500000000000000000000000000000000070' / DECIMAL '-50'", SqlDecimal.decimal((String)"-010000000000000000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)36)));
        this.assertDecimalFunction("DECIMAL '-500000000000000000000000000000000075' / DECIMAL '-50'", SqlDecimal.decimal((String)"010000000000000000000000000000000002", (DecimalType)DecimalType.createDecimalType((int)36)));
        this.assertDecimalFunction("DECIMAL '-500000000000000000000000000000000070' / DECIMAL '-50'", SqlDecimal.decimal((String)"010000000000000000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)36)));
        this.assertDecimalFunction("CAST(-1 AS DECIMAL(19,0))/ DECIMAL '2'", SqlDecimal.decimal((String)"-0000000000000000001", (DecimalType)DecimalType.createDecimalType((int)19)));
        this.assertDecimalFunction("CAST(1 AS DECIMAL(19,0))/ DECIMAL '-2'", SqlDecimal.decimal((String)"-0000000000000000001", (DecimalType)DecimalType.createDecimalType((int)19)));
        this.assertDecimalFunction("CAST(-1 AS DECIMAL(19,0))/ DECIMAL '3'", SqlDecimal.decimal((String)"0000000000000000000", (DecimalType)DecimalType.createDecimalType((int)19)));
        this.assertDecimalFunction("DECIMAL '0.1' / DECIMAL '.0000000000000000001'", SqlDecimal.decimal((String)"1000000000000000000.0000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)19)));
        this.assertDecimalFunction("DECIMAL '-0.1' / DECIMAL '.0000000000000000001'", SqlDecimal.decimal((String)"-1000000000000000000.0000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)19)));
        this.assertDecimalFunction("DECIMAL '0.1' / DECIMAL '-.0000000000000000001'", SqlDecimal.decimal((String)"-1000000000000000000.0000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)19)));
        this.assertDecimalFunction("DECIMAL '-0.1' / DECIMAL '-.0000000000000000001'", SqlDecimal.decimal((String)"1000000000000000000.0000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)19)));
        this.assertDecimalFunction("DECIMAL '9' / DECIMAL '000000000000000003.0'", SqlDecimal.decimal((String)"03.0", (DecimalType)DecimalType.createDecimalType((int)3, (int)1)));
        this.assertDecimalFunction("DECIMAL '1' / DECIMAL '99999999999999999999999999999999999999'", SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '-1' / DECIMAL '99999999999999999999999999999999999999'", SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '1' / DECIMAL '-99999999999999999999999999999999999999'", SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '-1' / DECIMAL '-99999999999999999999999999999999999999'", SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '99999999999999999999999999999999999999' / DECIMAL '11111111111111111111111111111111111111'", SqlDecimal.decimal((String)"00000000000000000000000000000000000009", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("DECIMAL '-99999999999999999999999999999999999999' / DECIMAL '11111111111111111111111111111111111111'", SqlDecimal.decimal((String)"-00000000000000000000000000000000000009", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("DECIMAL '99999999999999999999999999999999999999' / DECIMAL '-11111111111111111111111111111111111111'", SqlDecimal.decimal((String)"-00000000000000000000000000000000000009", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("DECIMAL '-99999999999999999999999999999999999999' / DECIMAL '-11111111111111111111111111111111111111'", SqlDecimal.decimal((String)"00000000000000000000000000000000000009", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("DECIMAL '11111111111111111111111111111111111111' / DECIMAL '99999999999999999999999999999999999999'", SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("DECIMAL '-11111111111111111111111111111111111111' / DECIMAL '99999999999999999999999999999999999999'", SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("DECIMAL '11111111111111111111111111111111111111' / DECIMAL '-99999999999999999999999999999999999999'", SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("DECIMAL '-11111111111111111111111111111111111111' / DECIMAL '-99999999999999999999999999999999999999'", SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("DECIMAL '99999999999999999999999999999999999998' / DECIMAL '99999999999999999999999999999999999999'", SqlDecimal.decimal((String)"00000000000000000000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("DECIMAL '9999999999999999999999999999999999999.8' / DECIMAL '9999999999999999999999999999999999999.9'", SqlDecimal.decimal((String)"0000000000000000000000000000000000001.0", (DecimalType)DecimalType.createDecimalType((int)38, (int)1)));
        this.assertDecimalFunction("DECIMAL '9999999999999999999999.9' / DECIMAL '1111111111111111111111.100'", SqlDecimal.decimal((String)"0000000000000000000000009.000", (DecimalType)DecimalType.createDecimalType((int)28, (int)3)));
        this.assertDecimalFunction("CAST('1635619.3155' AS DECIMAL(38,4)) / CAST('47497517.7405' AS DECIMAL(38,4))", SqlDecimal.decimal((String)"0000000000000000000000000000000000.0344", (DecimalType)DecimalType.createDecimalType((int)38, (int)4)));
        this.assertInvalidFunction("DECIMAL '12345678901234567890123456789012345678' / DECIMAL '.1'", (ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE);
        this.assertInvalidFunction("DECIMAL '.12345678901234567890123456789012345678' / DECIMAL '.1'", (ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE);
        this.assertInvalidFunction("DECIMAL '12345678901234567890123456789012345678' / DECIMAL '.12345678901234567890123456789012345678'", (ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE);
        this.assertInvalidFunction("DECIMAL '1' / DECIMAL '.12345678901234567890123456789012345678'", (ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE);
        this.assertInvalidFunction("DECIMAL '1' / DECIMAL '0'", (ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO);
        this.assertInvalidFunction("DECIMAL '1.000000000000000000000000000000000000' / DECIMAL '0'", (ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO);
        this.assertInvalidFunction("DECIMAL '1.000000000000000000000000000000000000' / DECIMAL '0.0000000000000000000000000000000000000'", (ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO);
        this.assertInvalidFunction("DECIMAL '1' / DECIMAL '0.0000000000000000000000000000000000000'", (ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO);
        this.assertDecimalFunction("CAST(1000 AS DECIMAL(38,8)) / CAST(25 AS DECIMAL(38,8))", SqlDecimal.decimal((String)"000000000000000000000000000040.00000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)8)));
    }

    @Test
    public void testModulus() {
        this.assertDecimalFunction("DECIMAL '1' % DECIMAL '3'", SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)1, (int)0)));
        this.assertDecimalFunction("DECIMAL '10' % DECIMAL '3'", SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)1, (int)0)));
        this.assertDecimalFunction("DECIMAL '0' % DECIMAL '3'", SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1, (int)0)));
        this.assertDecimalFunction("DECIMAL '0' % DECIMAL '-3'", SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1, (int)0)));
        this.assertDecimalFunction("DECIMAL '10.0' % DECIMAL '3'", SqlDecimal.decimal((String)"1.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        this.assertDecimalFunction("DECIMAL '10.0' % DECIMAL '3.000'", SqlDecimal.decimal((String)"1.000", (DecimalType)DecimalType.createDecimalType((int)4, (int)3)));
        this.assertDecimalFunction("DECIMAL '7' % DECIMAL '3.0000000000000000'", SqlDecimal.decimal((String)"1.0000000000000000", (DecimalType)DecimalType.createDecimalType((int)17, (int)16)));
        this.assertDecimalFunction("DECIMAL '7.00000000000000000' % DECIMAL '3.00000000000000000'", SqlDecimal.decimal((String)"1.00000000000000000", (DecimalType)DecimalType.createDecimalType((int)18, (int)17)));
        this.assertDecimalFunction("DECIMAL '7.00000000000000000' % DECIMAL '3'", SqlDecimal.decimal((String)"1.00000000000000000", (DecimalType)DecimalType.createDecimalType((int)18, (int)17)));
        this.assertDecimalFunction("DECIMAL '7' % CAST(3 AS DECIMAL(17,0))", SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '.1' % DECIMAL '.03'", SqlDecimal.decimal((String)".01", (DecimalType)DecimalType.createDecimalType((int)2, (int)2)));
        this.assertDecimalFunction("DECIMAL '.0001' % DECIMAL '.03'", SqlDecimal.decimal((String)".0001", (DecimalType)DecimalType.createDecimalType((int)4, (int)4)));
        this.assertDecimalFunction("DECIMAL '-10' % DECIMAL '3'", SqlDecimal.decimal((String)"-1", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '10' % DECIMAL '-3'", SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '-10' % DECIMAL '-3'", SqlDecimal.decimal((String)"-1", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '9' % DECIMAL '3'", SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '-9' % DECIMAL '3'", SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '9' % DECIMAL '-3'", SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '-9' % DECIMAL '-3'", SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '0' % CAST(3 AS DECIMAL(38,16))", SqlDecimal.decimal((String)"0.0000000000000000", (DecimalType)DecimalType.createDecimalType((int)17, (int)16)));
        this.assertDecimalFunction("DECIMAL '0' % CAST(-3 AS DECIMAL(38,16))", SqlDecimal.decimal((String)"0.0000000000000000", (DecimalType)DecimalType.createDecimalType((int)17, (int)16)));
        this.assertDecimalFunction("DECIMAL '7' % CAST(3 AS DECIMAL(38,0))", SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '7' % CAST(3 AS DECIMAL(38,16))", SqlDecimal.decimal((String)"1.0000000000000000", (DecimalType)DecimalType.createDecimalType((int)17, (int)16)));
        this.assertDecimalFunction("DECIMAL '7.00000000000000000' % CAST(3 AS DECIMAL(38,17))", SqlDecimal.decimal((String)"1.00000000000000000", (DecimalType)DecimalType.createDecimalType((int)18, (int)17)));
        this.assertDecimalFunction("DECIMAL '-7.00000000000000000' % CAST(3 AS DECIMAL(38,17))", SqlDecimal.decimal((String)"-1.00000000000000000", (DecimalType)DecimalType.createDecimalType((int)18, (int)17)));
        this.assertDecimalFunction("DECIMAL '7.0000000000000000' % CAST(-3 AS DECIMAL(38,16))", SqlDecimal.decimal((String)"1.0000000000000000", (DecimalType)DecimalType.createDecimalType((int)17, (int)16)));
        this.assertDecimalFunction("DECIMAL '-7.0000000000000000' % CAST(-3 AS DECIMAL(38,16))", SqlDecimal.decimal((String)"-1.0000000000000000", (DecimalType)DecimalType.createDecimalType((int)17, (int)16)));
        this.assertDecimalFunction("DECIMAL '9.00000000000000000' % CAST(3 AS DECIMAL(38,17))", SqlDecimal.decimal((String)"0.00000000000000000", (DecimalType)DecimalType.createDecimalType((int)18, (int)17)));
        this.assertDecimalFunction("DECIMAL '-9.00000000000000000' % CAST(3 AS DECIMAL(38,17))", SqlDecimal.decimal((String)"0.00000000000000000", (DecimalType)DecimalType.createDecimalType((int)18, (int)17)));
        this.assertDecimalFunction("DECIMAL '9.0000000000000000' % CAST(-3 AS DECIMAL(38,16))", SqlDecimal.decimal((String)"0.0000000000000000", (DecimalType)DecimalType.createDecimalType((int)17, (int)16)));
        this.assertDecimalFunction("DECIMAL '-9.0000000000000000' % CAST(-3 AS DECIMAL(38,16))", SqlDecimal.decimal((String)"0.0000000000000000", (DecimalType)DecimalType.createDecimalType((int)17, (int)16)));
        this.assertDecimalFunction("DECIMAL '0' % DECIMAL '3.0000000000000000000000000000000000000'", SqlDecimal.decimal((String)"0.0000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)37)));
        this.assertDecimalFunction("DECIMAL '0' % DECIMAL '-3.0000000000000000000000000000000000000'", SqlDecimal.decimal((String)"0.0000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)37)));
        this.assertDecimalFunction("DECIMAL '7' % DECIMAL '3.0000000000000000000000000000000000000'", SqlDecimal.decimal((String)"1.0000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)37)));
        this.assertDecimalFunction("DECIMAL '7.00000000000000000' % DECIMAL '3.0000000000000000000000000000000000000'", SqlDecimal.decimal((String)"1.0000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)37)));
        this.assertDecimalFunction("DECIMAL '.01' % DECIMAL '3.0000000000000000000000000000000000000'", SqlDecimal.decimal((String)".0100000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)37, (int)37)));
        this.assertDecimalFunction("DECIMAL '-7' % DECIMAL '3.0000000000000000000000000000000000000'", SqlDecimal.decimal((String)"-1.0000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)37)));
        this.assertDecimalFunction("DECIMAL '7' % DECIMAL '-3.0000000000000000000000000000000000000'", SqlDecimal.decimal((String)"1.0000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)37)));
        this.assertDecimalFunction("DECIMAL '-7' % DECIMAL '-3.0000000000000000000000000000000000000'", SqlDecimal.decimal((String)"-1.0000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)37)));
        this.assertDecimalFunction("DECIMAL '9' % DECIMAL '3.0000000000000000000000000000000000000'", SqlDecimal.decimal((String)"0.0000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)37)));
        this.assertDecimalFunction("DECIMAL '-9' % DECIMAL '3.0000000000000000000000000000000000000'", SqlDecimal.decimal((String)"0.0000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)37)));
        this.assertDecimalFunction("DECIMAL '9' % DECIMAL '-3.0000000000000000000000000000000000000'", SqlDecimal.decimal((String)"0.0000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)37)));
        this.assertDecimalFunction("DECIMAL '-9' % DECIMAL '-3.0000000000000000000000000000000000000'", SqlDecimal.decimal((String)"0.0000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)37)));
        this.assertDecimalFunction("DECIMAL '99999999999999999999999999999999999997' % DECIMAL '3'", SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '99999999999999999999999999999999999997' % DECIMAL '3.0000000000000000'", SqlDecimal.decimal((String)"1.0000000000000000", (DecimalType)DecimalType.createDecimalType((int)17, (int)16)));
        this.assertDecimalFunction("DECIMAL '-99999999999999999999999999999999999997' % DECIMAL '3'", SqlDecimal.decimal((String)"-1", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '99999999999999999999999999999999999997' % DECIMAL '-3'", SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '-99999999999999999999999999999999999997' % DECIMAL '-3'", SqlDecimal.decimal((String)"-1", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '99999999999999999999999999999999999999' % DECIMAL '3'", SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '-99999999999999999999999999999999999999' % DECIMAL '3'", SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '99999999999999999999999999999999999999' % DECIMAL '-3'", SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '-99999999999999999999999999999999999999' % DECIMAL '-3'", SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("DECIMAL '0.000000000000000000000000000000000000' % DECIMAL '3'", SqlDecimal.decimal((String)".000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)36, (int)36)));
        this.assertDecimalFunction("DECIMAL '0.000000000000000000000000000000000000' % DECIMAL '-3'", SqlDecimal.decimal((String)".000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)36, (int)36)));
        this.assertDecimalFunction("DECIMAL '7.000000000000000000000000000000000000' % DECIMAL '3'", SqlDecimal.decimal((String)"1.000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)37, (int)36)));
        this.assertDecimalFunction("DECIMAL '-7.000000000000000000000000000000000000' % DECIMAL '3'", SqlDecimal.decimal((String)"-1.000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)37, (int)36)));
        this.assertDecimalFunction("DECIMAL '7.000000000000000000000000000000000000' % DECIMAL '-3'", SqlDecimal.decimal((String)"1.000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)37, (int)36)));
        this.assertDecimalFunction("DECIMAL '-7.000000000000000000000000000000000000' % DECIMAL '-3'", SqlDecimal.decimal((String)"-1.000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)37, (int)36)));
        this.assertDecimalFunction("DECIMAL '9.000000000000000000000000000000000000' % DECIMAL '3'", SqlDecimal.decimal((String)"0.000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)37, (int)36)));
        this.assertDecimalFunction("DECIMAL '-9.000000000000000000000000000000000000' % DECIMAL '3'", SqlDecimal.decimal((String)"0.000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)37, (int)36)));
        this.assertDecimalFunction("DECIMAL '9.000000000000000000000000000000000000' % DECIMAL '-3'", SqlDecimal.decimal((String)"0.000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)37, (int)36)));
        this.assertDecimalFunction("DECIMAL '-9.000000000000000000000000000000000000' % DECIMAL '-3'", SqlDecimal.decimal((String)"0.000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)37, (int)36)));
        this.assertDecimalFunction("CAST(0 AS DECIMAL(38,0)) % CAST(3 AS DECIMAL(38,0))", SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("CAST(0 AS DECIMAL(38,0)) % CAST(-3 AS DECIMAL(38,0))", SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("CAST(7 AS DECIMAL(38,0)) % CAST(3 AS DECIMAL(38,0))", SqlDecimal.decimal((String)"00000000000000000000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("CAST(7 AS DECIMAL(34,0)) % CAST(3 AS DECIMAL(38,0))", SqlDecimal.decimal((String)"0000000000000000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)34)));
        this.assertDecimalFunction("CAST(7 AS DECIMAL(38,0)) % CAST(3 AS DECIMAL(34,0))", SqlDecimal.decimal((String)"0000000000000000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)34)));
        this.assertDecimalFunction("CAST(-7 AS DECIMAL(38,0)) % CAST(3 AS DECIMAL(38,0))", SqlDecimal.decimal((String)"-00000000000000000000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("CAST(7 AS DECIMAL(38,0)) % CAST(-3 AS DECIMAL(38,0))", SqlDecimal.decimal((String)"00000000000000000000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("CAST(-7 AS DECIMAL(38,0)) % CAST(-3 AS DECIMAL(38,0))", SqlDecimal.decimal((String)"-00000000000000000000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("CAST(9 AS DECIMAL(38,0)) % CAST(3 AS DECIMAL(38,0))", SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("CAST(-9 AS DECIMAL(38,0)) % CAST(3 AS DECIMAL(38,0))", SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("CAST(9 AS DECIMAL(38,0)) % CAST(-3 AS DECIMAL(38,0))", SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("CAST(-9 AS DECIMAL(38,0)) % CAST(-3 AS DECIMAL(38,0))", SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertInvalidFunction("DECIMAL '1' % DECIMAL '0'", (ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO);
        this.assertInvalidFunction("DECIMAL '1.000000000000000000000000000000000000' % DECIMAL '0'", (ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO);
        this.assertInvalidFunction("DECIMAL '1.000000000000000000000000000000000000' % DECIMAL '0.0000000000000000000000000000000000000'", (ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO);
        this.assertInvalidFunction("DECIMAL '1' % DECIMAL '0.0000000000000000000000000000000000000'", (ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO);
        this.assertInvalidFunction("DECIMAL '1' % CAST(0 AS DECIMAL(38,0))", (ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO);
    }

    @Test
    public void testNegation() {
        this.assertDecimalFunction("-DECIMAL '1' ", SqlDecimal.decimal((String)"-1", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("-DECIMAL '-1' ", SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("-DECIMAL '123456.00000010' ", SqlDecimal.decimal((String)"-123456.00000010", (DecimalType)DecimalType.createDecimalType((int)14, (int)8)));
        this.assertDecimalFunction("-DECIMAL '1234567.00500010734' ", SqlDecimal.decimal((String)"-1234567.00500010734", (DecimalType)DecimalType.createDecimalType((int)18, (int)11)));
        this.assertDecimalFunction("-DECIMAL '-1234567.00500010734' ", SqlDecimal.decimal((String)"1234567.00500010734", (DecimalType)DecimalType.createDecimalType((int)18, (int)11)));
        this.assertDecimalFunction("-DECIMAL '0' ", SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("-DECIMAL '0.00000000000000000000' ", SqlDecimal.decimal((String)".00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)20)));
        this.assertDecimalFunction("-DECIMAL '12345678901234567890123456789012345678'", SqlDecimal.decimal((String)"-12345678901234567890123456789012345678", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("-DECIMAL '-12345678901234567890123456789012345678'", SqlDecimal.decimal((String)"12345678901234567890123456789012345678", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("-DECIMAL '123456789012345678.90123456789012345678'", SqlDecimal.decimal((String)"-123456789012345678.90123456789012345678", (DecimalType)DecimalType.createDecimalType((int)38, (int)20)));
    }

    @Test
    public void testEqual() {
        this.assertFunction("DECIMAL '37' = DECIMAL '37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37' = DECIMAL '0037'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37' = DECIMAL '37.0'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37.0' = DECIMAL '37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-0.000' = DECIMAL '0.00000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37' = DECIMAL '38'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37' = DECIMAL '38.0'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37.0' = DECIMAL '38'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '-37.000' = DECIMAL '37.000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '-123456789123456789' = DECIMAL '-123456789123456789'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-123456789123456789' = DECIMAL '123456789123456789'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37' = DECIMAL '37.0000000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37' = DECIMAL '00000000037.0000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '037.0' = DECIMAL '00000000037.0000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-0.000' = DECIMAL '0.000000000000000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37' = DECIMAL '00000000038.0000000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '-37' = DECIMAL '00000000037.0000000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37.0000000000000000' = DECIMAL '00000000037.0000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37.0000000000000000' = DECIMAL '00000000036.0000000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37.0000000000000000000000000' = DECIMAL '37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' = DECIMAL '37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' = DECIMAL '037.0'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-0.000000000000000000000000000000000' = DECIMAL '0.000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000038.0000000000000000000000' = DECIMAL '37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '-00000000037.0000000000000000000000' = DECIMAL '37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' = DECIMAL '37.0000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000036.0000000000000000000000' = DECIMAL '37.0000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37.0000000000000000000000000' = DECIMAL '37.0000000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' = DECIMAL '0037.0000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '0.0000000000000000000000000000000' = DECIMAL '-0.000000000000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000038.0000000000000000000000' = DECIMAL '000000000037.00000000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '-00000000038.0000000000000000000000' = DECIMAL '00000000038.0000000000000000000000'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testNotEqual() {
        this.assertFunction("DECIMAL '37' != DECIMAL '37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37' != DECIMAL '0037'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37' != DECIMAL '37.0'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37.0' != DECIMAL '37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '0' != DECIMAL '-0.00'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37' != DECIMAL '-37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37' != DECIMAL '38'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37' != DECIMAL '38.0'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37.0' != DECIMAL '38'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37' != DECIMAL '-37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-999999999999999999' != DECIMAL '-999999999999999999'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '-999999999999999999' != DECIMAL '999999999999999998'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37' != DECIMAL '37.0000000000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37' != DECIMAL '00000000037.0000000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '037.0' != DECIMAL '00000000037.0000000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '0' != DECIMAL '-0.0000000000000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37' != DECIMAL '00000000038.0000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37' != DECIMAL '-000000000037.00000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '38.0000000000000000' != DECIMAL '00000000038.0000000000000000000001'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-987654321987654321' != DECIMAL '-987654321987654321.00000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37.0000000000000000000000000' != DECIMAL '37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' != DECIMAL '37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' != DECIMAL '037.0'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '0.0000000000000000000000000000' != DECIMAL '-0'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '00000000038.0000000000000000000000' != DECIMAL '37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000000037.00000000000000000000' != DECIMAL '-37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' != DECIMAL '37.0000000000000001'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-00000000000037.00000000000000000000' != DECIMAL '-37.0000000000000001'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37.0000000000000000000000000' != DECIMAL '37.0000000000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' != DECIMAL '0037.0000000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '0.00000000000000000000000000000000000' != DECIMAL '-0.000000000000000000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '00000000038.0000000000000000000000' != DECIMAL '000000000037.00000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000000037.00000000000000000000' != DECIMAL '-00000000000037.00000000000000000000'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testLessThan() {
        this.assertFunction("DECIMAL '37' < DECIMAL '37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37' < DECIMAL '0037'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37' < DECIMAL '37.0'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37.0' < DECIMAL '37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '0037.0' < DECIMAL '00036.0'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37' < DECIMAL '38'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37' < DECIMAL '0038.0'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '0037.0' < DECIMAL '38'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-100' < DECIMAL '20'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '1' < DECIMAL '10000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '1.0000000000000000' < DECIMAL '10000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-123456789123456789' < DECIMAL '-123456789123456789'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '-123456789123456789' < DECIMAL '123456789123456789'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37' < DECIMAL '37.0000000000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37' < DECIMAL '00000000037.0000000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '037.0' < DECIMAL '00000000037.0000000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '037.0' < DECIMAL '00000000036.0000000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37' < DECIMAL '37.00000000000000000000000001'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37' < DECIMAL '00000000038.0000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '037.0' < DECIMAL '00000000038.0000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-100' < DECIMAL '20.00000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '38.0000000000000000' < DECIMAL '00000000038.0000000000000000000001'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-987654321987654321' < DECIMAL '-987654321987654321.00000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37.0000000000000000000000000' < DECIMAL '37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' < DECIMAL '37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' < DECIMAL '037.0'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' < DECIMAL '036.0'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37.0000000000000000000000000' < DECIMAL '38'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000001' < DECIMAL '38'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' < DECIMAL '038.0'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-00000000000100.000000000000' < DECIMAL '20'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' < DECIMAL '37.0000000000000001'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-00000000000037.00000000000000000000' < DECIMAL '-37.0000000000000001'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37.0000000000000000000000000' < DECIMAL '37.0000000000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37.0000000000000000000000000' < DECIMAL '00000037.0000000000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37.0000000000000000000000000' < DECIMAL '00000036.0000000000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' < DECIMAL '38.0000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' < DECIMAL '000000000037.00000000000000000000001'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-00000000000100.000000000000' < DECIMAL '0000000020.0000000000000'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testGreaterThan() {
        this.assertFunction("DECIMAL '37' > DECIMAL '37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37' > DECIMAL '0037'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37' > DECIMAL '37.0'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37.0' > DECIMAL '37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '0037.0' > DECIMAL '00038.0'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37' > DECIMAL '36'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37' > DECIMAL '0036.0'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '0037.0' > DECIMAL '36'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '100' > DECIMAL '-20'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '10000000000000000' > DECIMAL '1'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '10000000000000000' > DECIMAL '1.0000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-123456789123456788' > DECIMAL '-123456789123456789'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-123456789123456789' > DECIMAL '123456789123456789'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37' > DECIMAL '37.0000000000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37' > DECIMAL '00000000037.0000000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '037.0' > DECIMAL '00000000037.0000000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '037.0' > DECIMAL '00000000038.0000000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37' > DECIMAL '36.00000000000000000000000001'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37' > DECIMAL '00000000036.0000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '037.0' > DECIMAL '00000000036.0000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '100' > DECIMAL '-0000000020.00000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '38.0000000000000000' > DECIMAL '00000000038.0000000000000000000001'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '-987654321987654320' > DECIMAL '-987654321987654321.00000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37.0000000000000000000000000' > DECIMAL '37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' > DECIMAL '37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' > DECIMAL '037.0'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' > DECIMAL '038.0'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37.0000000000000000000000000' > DECIMAL '36'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000001' > DECIMAL '36'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' > DECIMAL '036.0'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '0000000000100.000000000000' > DECIMAL '20'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000002' > DECIMAL '37.0000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-00000000000037.00000000000000000000' > DECIMAL '-37.0000000000000001'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37.0000000000000000000000000' > DECIMAL '37.0000000000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37.0000000000000000000000000' > DECIMAL '00000037.0000000000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37.0000000000000000000000000' > DECIMAL '00000038.0000000000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' > DECIMAL '36.0000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' > DECIMAL '000000000036.9999999999999999999999'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '000000000000100.0000000000000000000000' > DECIMAL '-0000000020.00000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testLessThanOrEqual() {
        this.assertFunction("DECIMAL '37' <= DECIMAL '36'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37' <= DECIMAL '000036.99999'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37' <= DECIMAL '37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37' <= DECIMAL '0037'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37' <= DECIMAL '37.0'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37.0' <= DECIMAL '37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37' <= DECIMAL '38'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37' <= DECIMAL '0038.0'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '0037.0' <= DECIMAL '38'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-100' <= DECIMAL '20'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-123456789123456789' <= DECIMAL '-123456789123456789'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-123456789123456789' <= DECIMAL '123456789123456789'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '037.0' <= DECIMAL '00000000036.0000000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '037.0' <= DECIMAL '00000000036.9999999999999999999'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37' <= DECIMAL '37.0000000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37' <= DECIMAL '00000000037.0000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '037.0' <= DECIMAL '00000000037.0000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37' <= DECIMAL '37.00000000000000000000000001'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37' <= DECIMAL '00000000038.0000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '037.0' <= DECIMAL '00000000038.0000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-100' <= DECIMAL '20.00000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '38.0000000000000000' <= DECIMAL '00000000038.0000000000000000000001'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-987654321987654321' <= DECIMAL '-987654321987654321.00000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' <= DECIMAL '036.0'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' <= DECIMAL '000036.99999999'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37.0000000000000000000000000' <= DECIMAL '37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' <= DECIMAL '37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' <= DECIMAL '037.0'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37.0000000000000000000000000' <= DECIMAL '38'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000001' <= DECIMAL '38'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' <= DECIMAL '038.0'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-00000000000100.000000000000' <= DECIMAL '20'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' <= DECIMAL '37.0000000000000001'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-00000000000037.00000000000000000000' <= DECIMAL '-37.0000000000000001'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37.0000000000000000000000000' <= DECIMAL '00000036.0000000000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37.0000000000000000000000000' <= DECIMAL '37.0000000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37.0000000000000000000000000' <= DECIMAL '00000037.0000000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' <= DECIMAL '38.0000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' <= DECIMAL '000000000037.00000000000000000000001'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-00000000000100.000000000000' <= DECIMAL '0000000020.0000000000000'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testGreaterThanOrEqual() {
        this.assertFunction("DECIMAL '37' >= DECIMAL '38'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37' >= DECIMAL '000038.00001'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37' >= DECIMAL '37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37' >= DECIMAL '0037'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37' >= DECIMAL '37.0'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37.0' >= DECIMAL '37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37' >= DECIMAL '36'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37' >= DECIMAL '0036.0'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '0037.0' >= DECIMAL '36'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '100' >= DECIMAL '-20'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-123456789123456789' >= DECIMAL '-123456789123456789'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-123456789123456789' >= DECIMAL '123456789123456789'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '037.0' >= DECIMAL '00000000038.0000000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '037.0' >= DECIMAL '00000000037.0000000000000000001'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37' >= DECIMAL '37.0000000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37' >= DECIMAL '00000000037.0000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '037.0' >= DECIMAL '00000000037.0000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37' >= DECIMAL '36.9999999999999999999'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37' >= DECIMAL '00000000036.0000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '037.0' >= DECIMAL '00000000036.0000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '100' >= DECIMAL '-0000000020.00000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '38.0000000000000000' >= DECIMAL '00000000038.0000000000000000000001'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '-987654321987654321' >= DECIMAL '-987654321987654321.00000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' >= DECIMAL '038.0'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' >= DECIMAL '000037.00000001'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37.0000000000000000000000000' >= DECIMAL '37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' >= DECIMAL '37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' >= DECIMAL '037.0'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37.0000000000000000000000000' >= DECIMAL '36'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000001' >= DECIMAL '36'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' >= DECIMAL '036.0'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '0000000000100.000000000000' >= DECIMAL '20'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' >= DECIMAL '37.0000000000000001'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '-00000000000037.00000000000000000000' >= DECIMAL '-37.0000000000000001'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37.0000000000000000000000000' >= DECIMAL '00000038.0000000000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37.0000000000000000000000000' >= DECIMAL '37.0000000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '37.0000000000000000000000000' >= DECIMAL '00000037.0000000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' >= DECIMAL '36.0000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '00000000037.0000000000000000000000' >= DECIMAL '000000000036.9999999999999999'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '000000000000100.0000000000000000000000' >= DECIMAL '-0000000020.00000000000000000000000'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testBetween() {
        this.assertFunction("DECIMAL '1' BETWEEN DECIMAL '-5' AND DECIMAL '5'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-6' BETWEEN DECIMAL '-5' AND DECIMAL '5'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '6' BETWEEN DECIMAL '-5' AND DECIMAL '5'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '333333333333333333' BETWEEN DECIMAL '-111111111111111111' AND DECIMAL '999999999999999999'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '1' BETWEEN DECIMAL '-5' AND DECIMAL '5.00000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-6' BETWEEN DECIMAL '-5' AND DECIMAL '5.00000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '6' BETWEEN DECIMAL '-5' AND DECIMAL '5.00000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '333333333333333333' BETWEEN DECIMAL '-111111111111111111' AND DECIMAL '9999999999999999999'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '1' BETWEEN DECIMAL '-5.00000000000000000000' AND DECIMAL '5.00000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-6' BETWEEN DECIMAL '-5.00000000000000000000' AND DECIMAL '5.00000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '6' BETWEEN DECIMAL '-5.00000000000000000000' AND DECIMAL '5.00000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '333333333333333333' BETWEEN DECIMAL '-1111111111111111111' AND DECIMAL '9999999999999999999'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '1.00000000000000000000' BETWEEN DECIMAL '-5' AND DECIMAL '5'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-6.00000000000000000000' BETWEEN DECIMAL '-5' AND DECIMAL '5'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '6.00000000000000000000' BETWEEN DECIMAL '-5' AND DECIMAL '5'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '333333333333333333.3' BETWEEN DECIMAL '-111111111111111111' AND DECIMAL '999999999999999999'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '1.00000000000000000000' BETWEEN DECIMAL '-5' AND DECIMAL '5.00000000000000000000' ", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-6.00000000000000000000' BETWEEN DECIMAL '-5' AND DECIMAL '5.00000000000000000000' ", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '6.00000000000000000000' BETWEEN DECIMAL '-5' AND DECIMAL '5.00000000000000000000' ", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '333333333333333333.3' BETWEEN DECIMAL '-111111111111111111' AND DECIMAL '9999999999999999999'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '1.00000000000000000000' BETWEEN DECIMAL '-5.00000000000000000000'  AND DECIMAL '5'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-6.00000000000000000000' BETWEEN DECIMAL '-5.00000000000000000000'  AND DECIMAL '5'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '6.00000000000000000000' BETWEEN DECIMAL '-5.00000000000000000000'  AND DECIMAL '5'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '333333333333333333.3' BETWEEN DECIMAL '-111111111111111111.1' AND DECIMAL '999999999999999999'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '1.00000000000000000000' BETWEEN DECIMAL '-5.00000000000000000000'  AND DECIMAL '5.00000000000000000000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-6.00000000000000000000' BETWEEN DECIMAL '-5.00000000000000000000'  AND DECIMAL '5.00000000000000000000'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '6.00000000000000000000' BETWEEN DECIMAL '-5.00000000000000000000'  AND DECIMAL '5.00000000000000000000'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testAddDecimalBigint() {
        this.assertDecimalFunction("DECIMAL '123456789012345678' + 123456789012345678", SqlDecimal.decimal((String)"00246913578024691356", (DecimalType)DecimalType.createDecimalType((int)20)));
        this.assertDecimalFunction("DECIMAL '.123456789012345678' + 123456789012345678", SqlDecimal.decimal((String)"00123456789012345678.123456789012345678", (DecimalType)DecimalType.createDecimalType((int)38, (int)18)));
        this.assertDecimalFunction("DECIMAL '-1234567890123456789' + 1234567890123456789", SqlDecimal.decimal((String)"00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)20)));
        this.assertDecimalFunction("123456789012345678 + DECIMAL '123456789012345678'", SqlDecimal.decimal((String)"00246913578024691356", (DecimalType)DecimalType.createDecimalType((int)20)));
        this.assertDecimalFunction("123456789012345678 + DECIMAL '.123456789012345678'", SqlDecimal.decimal((String)"00123456789012345678.123456789012345678", (DecimalType)DecimalType.createDecimalType((int)38, (int)18)));
        this.assertDecimalFunction("1234567890123456789 + DECIMAL '-1234567890123456789'", SqlDecimal.decimal((String)"00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)20)));
    }

    @Test
    public void testSubtractDecimalBigint() {
        this.assertDecimalFunction("DECIMAL '1234567890123456789' - 1234567890123456789", SqlDecimal.decimal((String)"00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)20)));
        this.assertDecimalFunction("DECIMAL '.1234567890123456789' - 1234567890123456789", SqlDecimal.decimal((String)"-1234567890123456788.8765432109876543211", (DecimalType)DecimalType.createDecimalType((int)38, (int)19)));
        this.assertDecimalFunction("DECIMAL '-1234567890123456789' - 1234567890123456789", SqlDecimal.decimal((String)"-02469135780246913578", (DecimalType)DecimalType.createDecimalType((int)20)));
        this.assertDecimalFunction("1234567890123456789 - DECIMAL '1234567890123456789'", SqlDecimal.decimal((String)"00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)20)));
        this.assertDecimalFunction("1234567890123456789 - DECIMAL '.1234567890123456789'", SqlDecimal.decimal((String)"1234567890123456788.8765432109876543211", (DecimalType)DecimalType.createDecimalType((int)38, (int)19)));
        this.assertDecimalFunction("-1234567890123456789 - DECIMAL '1234567890123456789'", SqlDecimal.decimal((String)"-02469135780246913578", (DecimalType)DecimalType.createDecimalType((int)20)));
    }

    @Test
    public void testMultiplyDecimalBigint() {
        this.assertDecimalFunction("DECIMAL '12345678901234567' * 12345678901234567", SqlDecimal.decimal((String)"000152415787532388345526596755677489", (DecimalType)DecimalType.createDecimalType((int)36)));
        this.assertDecimalFunction("DECIMAL '-12345678901234567' * 12345678901234567", SqlDecimal.decimal((String)"-000152415787532388345526596755677489", (DecimalType)DecimalType.createDecimalType((int)36)));
        this.assertDecimalFunction("DECIMAL '-12345678901234567' * -12345678901234567", SqlDecimal.decimal((String)"000152415787532388345526596755677489", (DecimalType)DecimalType.createDecimalType((int)36)));
        this.assertDecimalFunction("DECIMAL '.1234567890' * BIGINT '3'", SqlDecimal.decimal((String)"0000000000000000000.3703703670", (DecimalType)DecimalType.createDecimalType((int)29, (int)10)));
        this.assertDecimalFunction("DECIMAL '.1234567890' * BIGINT '0'", SqlDecimal.decimal((String)"0000000000000000000.0000000000", (DecimalType)DecimalType.createDecimalType((int)29, (int)10)));
        this.assertDecimalFunction("DECIMAL '-.1234567890' * BIGINT '0'", SqlDecimal.decimal((String)"0000000000000000000.0000000000", (DecimalType)DecimalType.createDecimalType((int)29, (int)10)));
        this.assertDecimalFunction("12345678901234567 * DECIMAL '12345678901234567'", SqlDecimal.decimal((String)"000152415787532388345526596755677489", (DecimalType)DecimalType.createDecimalType((int)36)));
        this.assertDecimalFunction("12345678901234567 * DECIMAL '-12345678901234567'", SqlDecimal.decimal((String)"-000152415787532388345526596755677489", (DecimalType)DecimalType.createDecimalType((int)36)));
        this.assertDecimalFunction("-12345678901234567 * DECIMAL '-12345678901234567'", SqlDecimal.decimal((String)"000152415787532388345526596755677489", (DecimalType)DecimalType.createDecimalType((int)36)));
        this.assertDecimalFunction("BIGINT '3' * DECIMAL '.1234567890'", SqlDecimal.decimal((String)"0000000000000000000.3703703670", (DecimalType)DecimalType.createDecimalType((int)29, (int)10)));
        this.assertDecimalFunction("BIGINT '3' * DECIMAL '.0000000000'", SqlDecimal.decimal((String)"0000000000000000000.0000000000", (DecimalType)DecimalType.createDecimalType((int)29, (int)10)));
        this.assertDecimalFunction("BIGINT '-3' * DECIMAL '.0000000000'", SqlDecimal.decimal((String)"0000000000000000000.0000000000", (DecimalType)DecimalType.createDecimalType((int)29, (int)10)));
    }

    @Test
    public void testDivideDecimalBigint() {
        this.assertDecimalFunction("BIGINT '9' / DECIMAL '3.0'", SqlDecimal.decimal((String)"00000000000000000003.0", (DecimalType)DecimalType.createDecimalType((int)21, (int)1)));
        this.assertDecimalFunction("BIGINT '-9' / DECIMAL '3.0'", SqlDecimal.decimal((String)"-00000000000000000003.0", (DecimalType)DecimalType.createDecimalType((int)21, (int)1)));
        this.assertDecimalFunction("BIGINT '9' / DECIMAL '-3.0'", SqlDecimal.decimal((String)"-00000000000000000003.0", (DecimalType)DecimalType.createDecimalType((int)21, (int)1)));
        this.assertDecimalFunction("BIGINT '-9' / DECIMAL '-3.0'", SqlDecimal.decimal((String)"00000000000000000003.0", (DecimalType)DecimalType.createDecimalType((int)21, (int)1)));
        this.assertDecimalFunction("BIGINT '9' / DECIMAL '000000000000000003.0'", SqlDecimal.decimal((String)"00000000000000000003.0", (DecimalType)DecimalType.createDecimalType((int)21, (int)1)));
        this.assertDecimalFunction("BIGINT '18' / DECIMAL '0.01'", SqlDecimal.decimal((String)"000000000000000001800.00", (DecimalType)DecimalType.createDecimalType((int)23, (int)2)));
        this.assertDecimalFunction("BIGINT '9' / DECIMAL '00000000000000000.1'", SqlDecimal.decimal((String)"00000000000000000090.0", (DecimalType)DecimalType.createDecimalType((int)21, (int)1)));
        this.assertDecimalFunction("BIGINT '9' / DECIMAL '300.0'", SqlDecimal.decimal((String)"00000000000000000000.0", (DecimalType)DecimalType.createDecimalType((int)21, (int)1)));
        this.assertDecimalFunction("BIGINT '-9' / DECIMAL '300.0'", SqlDecimal.decimal((String)"00000000000000000000.0", (DecimalType)DecimalType.createDecimalType((int)21, (int)1)));
        this.assertDecimalFunction("BIGINT '9' / DECIMAL '-300.0'", SqlDecimal.decimal((String)"00000000000000000000.0", (DecimalType)DecimalType.createDecimalType((int)21, (int)1)));
        this.assertDecimalFunction("BIGINT '-9' / DECIMAL '-300.0'", SqlDecimal.decimal((String)"00000000000000000000.0", (DecimalType)DecimalType.createDecimalType((int)21, (int)1)));
        this.assertDecimalFunction("DECIMAL '9.0' / BIGINT '3'", SqlDecimal.decimal((String)"3.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        this.assertDecimalFunction("DECIMAL '-9.0' / BIGINT '3'", SqlDecimal.decimal((String)"-3.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        this.assertDecimalFunction("DECIMAL '9.0' / BIGINT '-3'", SqlDecimal.decimal((String)"-3.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        this.assertDecimalFunction("DECIMAL '-9.0' / BIGINT '-3'", SqlDecimal.decimal((String)"3.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        this.assertDecimalFunction("DECIMAL '0.018' / BIGINT '9'", SqlDecimal.decimal((String)".002", (DecimalType)DecimalType.createDecimalType((int)3, (int)3)));
        this.assertDecimalFunction("DECIMAL '-0.018' / BIGINT '9'", SqlDecimal.decimal((String)"-.002", (DecimalType)DecimalType.createDecimalType((int)3, (int)3)));
        this.assertDecimalFunction("DECIMAL '0.018' / BIGINT '-9'", SqlDecimal.decimal((String)"-.002", (DecimalType)DecimalType.createDecimalType((int)3, (int)3)));
        this.assertDecimalFunction("DECIMAL '-0.018' / BIGINT '-9'", SqlDecimal.decimal((String)".002", (DecimalType)DecimalType.createDecimalType((int)3, (int)3)));
        this.assertDecimalFunction("DECIMAL '.999' / BIGINT '9'", SqlDecimal.decimal((String)".111", (DecimalType)DecimalType.createDecimalType((int)3, (int)3)));
        this.assertDecimalFunction("DECIMAL '9.0' / BIGINT '300'", SqlDecimal.decimal((String)"0.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        this.assertDecimalFunction("DECIMAL '-9.0' / BIGINT '300'", SqlDecimal.decimal((String)"0.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        this.assertDecimalFunction("DECIMAL '9.0' / BIGINT '-300'", SqlDecimal.decimal((String)"0.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        this.assertDecimalFunction("DECIMAL '-9.0' / BIGINT '-300'", SqlDecimal.decimal((String)"0.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
    }

    @Test
    public void testModulusDecimalBigint() {
        this.assertDecimalFunction("BIGINT '13' % DECIMAL '9.0'", SqlDecimal.decimal((String)"4.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        this.assertDecimalFunction("BIGINT '18' % DECIMAL '0.01'", SqlDecimal.decimal((String)".00", (DecimalType)DecimalType.createDecimalType((int)2, (int)2)));
        this.assertDecimalFunction("BIGINT '9' % DECIMAL '.1'", SqlDecimal.decimal((String)".0", (DecimalType)DecimalType.createDecimalType((int)1, (int)1)));
        this.assertDecimalFunction("BIGINT '-9' % DECIMAL '.1'", SqlDecimal.decimal((String)".0", (DecimalType)DecimalType.createDecimalType((int)1, (int)1)));
        this.assertDecimalFunction("BIGINT '9' % DECIMAL '-.1'", SqlDecimal.decimal((String)".0", (DecimalType)DecimalType.createDecimalType((int)1, (int)1)));
        this.assertDecimalFunction("BIGINT '-9' % DECIMAL '-.1'", SqlDecimal.decimal((String)".0", (DecimalType)DecimalType.createDecimalType((int)1, (int)1)));
        this.assertDecimalFunction("DECIMAL '13.0' % BIGINT '9'", SqlDecimal.decimal((String)"04.0", (DecimalType)DecimalType.createDecimalType((int)3, (int)1)));
        this.assertDecimalFunction("DECIMAL '-13.0' % BIGINT '9'", SqlDecimal.decimal((String)"-04.0", (DecimalType)DecimalType.createDecimalType((int)3, (int)1)));
        this.assertDecimalFunction("DECIMAL '13.0' % BIGINT '-9'", SqlDecimal.decimal((String)"04.0", (DecimalType)DecimalType.createDecimalType((int)3, (int)1)));
        this.assertDecimalFunction("DECIMAL '-13.0' % BIGINT '-9'", SqlDecimal.decimal((String)"-04.0", (DecimalType)DecimalType.createDecimalType((int)3, (int)1)));
        this.assertDecimalFunction("DECIMAL '18.00' % BIGINT '3'", SqlDecimal.decimal((String)"00.00", (DecimalType)DecimalType.createDecimalType((int)4, (int)2)));
        this.assertDecimalFunction("DECIMAL '9.0' % BIGINT '3'", SqlDecimal.decimal((String)"0.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        this.assertDecimalFunction("DECIMAL '-9.0' % BIGINT '3'", SqlDecimal.decimal((String)"0.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        this.assertDecimalFunction("DECIMAL '9.0' % BIGINT '-3'", SqlDecimal.decimal((String)"0.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        this.assertDecimalFunction("DECIMAL '-9.0' % BIGINT '-3'", SqlDecimal.decimal((String)"0.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        this.assertDecimalFunction("DECIMAL '5.128' % BIGINT '2'", SqlDecimal.decimal((String)"1.128", (DecimalType)DecimalType.createDecimalType((int)4, (int)3)));
    }

    @Test
    public void testIsDistinctFrom() {
        this.assertFunction("CAST(NULL AS DECIMAL) IS DISTINCT FROM CAST(NULL AS DECIMAL)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '37' IS DISTINCT FROM DECIMAL '37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("37 IS DISTINCT FROM 38", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("NULL IS DISTINCT FROM 37", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("37 IS DISTINCT FROM NULL", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-2' IS DISTINCT FROM DECIMAL '-3'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-2' IS DISTINCT FROM CAST(NULL AS DECIMAL(1,0))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST(NULL AS DECIMAL(2,0)) IS DISTINCT FROM CAST(NULL AS DECIMAL(1,0))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '-2' IS DISTINCT FROM DECIMAL '-2'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST(NULL AS DECIMAL(1,0)) IS DISTINCT FROM DECIMAL '-2'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '12345678901234567.89012345678901234567' IS DISTINCT FROM DECIMAL '12345678901234567.8902345678901234567'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '12345678901234567.89012345678901234567' IS DISTINCT FROM CAST(NULL AS DECIMAL(36,1))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST(NULL AS DECIMAL(36,1)) IS DISTINCT FROM CAST(NULL AS DECIMAL(27,3))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '-12345678901234567.89012345678901234567' IS DISTINCT FROM DECIMAL '-12345678901234567.89012345678901234567'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST(NULL AS DECIMAL(36,1)) IS DISTINCT FROM DECIMAL '12345678901234567.89012345678901234567'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '12345678901234567.89012345678901234567' IS DISTINCT FROM DECIMAL '-3'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '12345678901234567.89012345678901234567' IS DISTINCT FROM CAST(NULL AS DECIMAL(1,0))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST(NULL AS DECIMAL(36,1)) IS DISTINCT FROM CAST(NULL AS DECIMAL(1,0))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DECIMAL '00000000000000007.80000000000000000000' IS DISTINCT FROM DECIMAL '7.8'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST(NULL AS DECIMAL(36,1)) IS DISTINCT FROM DECIMAL '7.8'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("NULL IS DISTINCT FROM DECIMAL '-2'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '-2' IS DISTINCT FROM NULL", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("NULL IS DISTINCT FROM DECIMAL '12345678901234567.89012345678901234567'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DECIMAL '12345678901234567.89012345678901234567' IS DISTINCT FROM NULL", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1.23, 4.56] IS DISTINCT FROM ARRAY [1.23, 4.56]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1.23, NULL] IS DISTINCT FROM ARRAY [1.23, 4.56]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1.23, NULL] IS DISTINCT FROM ARRAY [NULL, 4.56]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1234567890.123456789, 9876543210.987654321] IS DISTINCT FROM ARRAY [1234567890.123456789, 9876543210.987654321]", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("ARRAY [1234567890.123456789, NULL] IS DISTINCT FROM ARRAY [1234567890.123456789, 9876543210.987654321]", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("ARRAY [1234567890.123456789, NULL] IS DISTINCT FROM ARRAY [NULL, 9876543210.987654321]", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testNullIf() {
        this.assertDecimalFunction("nullif(DECIMAL '-2', DECIMAL '-3')", SqlDecimal.decimal((String)"-2", (DecimalType)DecimalType.createDecimalType((int)1, (int)0)));
        this.assertDecimalFunction("nullif(DECIMAL '-2', CAST(NULL AS DECIMAL(1,0)))", SqlDecimal.decimal((String)"-2", (DecimalType)DecimalType.createDecimalType((int)1, (int)0)));
        this.assertFunction("nullif(DECIMAL '-2', DECIMAL '-2')", (Type)DecimalType.createDecimalType((int)1, (int)0), null);
        this.assertFunction("nullif(CAST(NULL AS DECIMAL(1,0)), DECIMAL '-2')", (Type)DecimalType.createDecimalType((int)1, (int)0), null);
        this.assertFunction("nullif(CAST(NULL AS DECIMAL(1,0)), CAST(NULL AS DECIMAL(1,0)))", (Type)DecimalType.createDecimalType((int)1, (int)0), null);
        this.assertDecimalFunction("nullif(DECIMAL '12345678901234567.89012345678901234567', DECIMAL '12345678901234567.8902345678901234567')", SqlDecimal.decimal((String)"12345678901234567.89012345678901234567", (DecimalType)DecimalType.createDecimalType((int)37, (int)20)));
        this.assertDecimalFunction("nullif(DECIMAL '12345678901234567.89012345678901234567', CAST(NULL AS DECIMAL(36,1)))", SqlDecimal.decimal((String)"12345678901234567.89012345678901234567", (DecimalType)DecimalType.createDecimalType((int)37, (int)20)));
        this.assertFunction("nullif(DECIMAL '12345678901234567.89012345678901234567', DECIMAL '12345678901234567.89012345678901234567')", (Type)DecimalType.createDecimalType((int)37, (int)20), null);
        this.assertFunction("nullif(CAST(NULL AS DECIMAL(38,0)), DECIMAL '12345678901234567.89012345678901234567')", (Type)DecimalType.createDecimalType((int)38, (int)0), null);
        this.assertFunction("nullif(CAST(NULL AS DECIMAL(38,0)), CAST(NULL AS DECIMAL(38,0)))", (Type)DecimalType.createDecimalType((int)38, (int)0), null);
        this.assertDecimalFunction("nullif(DECIMAL '12345678901234567.89012345678901234567', DECIMAL '-3')", SqlDecimal.decimal((String)"12345678901234567.89012345678901234567", (DecimalType)DecimalType.createDecimalType((int)37, (int)20)));
        this.assertDecimalFunction("nullif(DECIMAL '12345678901234567.89012345678901234567', CAST(NULL AS DECIMAL(1,0)))", SqlDecimal.decimal((String)"12345678901234567.89012345678901234567", (DecimalType)DecimalType.createDecimalType((int)37, (int)20)));
        this.assertFunction("nullif(DECIMAL '12345678901234567.89012345678901234567', DECIMAL '12345678901234567.89012345678901234567')", (Type)DecimalType.createDecimalType((int)37, (int)20), null);
        this.assertFunction("nullif(CAST(NULL AS DECIMAL(1,0)), DECIMAL '12345678901234567.89012345678901234567')", (Type)DecimalType.createDecimalType((int)1, (int)0), null);
        this.assertFunction("nullif(NULL, NULL)", (Type)UnknownType.UNKNOWN, null);
        this.assertFunction("nullif(NULL, DECIMAL '-2')", (Type)UnknownType.UNKNOWN, null);
        this.assertDecimalFunction("nullif(DECIMAL '-2', NULL)", SqlDecimal.decimal((String)"-2", (DecimalType)DecimalType.createDecimalType((int)1, (int)0)));
        this.assertFunction("nullif(NULL, DECIMAL '12345678901234567.89012345678901234567')", (Type)UnknownType.UNKNOWN, null);
        this.assertDecimalFunction("nullif(DECIMAL '12345678901234567.89012345678901234567', NULL)", SqlDecimal.decimal((String)"12345678901234567.89012345678901234567", (DecimalType)DecimalType.createDecimalType((int)37, (int)20)));
    }

    @Test
    public void testCoalesce() {
        this.assertDecimalFunction("coalesce(2.1, null, cast(null as decimal(5,3)))", SqlDecimal.decimal((String)"02.100", (DecimalType)DecimalType.createDecimalType((int)5, (int)3)));
        this.assertFunction("coalesce(cast(null as decimal(17,3)), null, cast(null as decimal(12,3)))", (Type)DecimalType.createDecimalType((int)17, (int)3), null);
        this.assertDecimalFunction("coalesce(3, 2.1, null, cast(null as decimal(6,3)))", SqlDecimal.decimal((String)"0000000003.000", (DecimalType)DecimalType.createDecimalType((int)13, (int)3)));
        this.assertFunction("coalesce(cast(null as decimal(17,3)), null, cast(null as decimal(12,3)))", (Type)DecimalType.createDecimalType((int)17, (int)3), null);
    }

    @Test
    public void testIndeterminate() {
        this.assertOperator(OperatorType.INDETERMINATE, "cast(null as DECIMAL)", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "cast(null as DECIMAL(37,3))", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "DECIMAL '.999'", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "DECIMAL '18'", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "DECIMAL '9.0'", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "DECIMAL '12345678901234567.89012345678901234567'", (Type)BooleanType.BOOLEAN, false);
    }
}

