/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.SqlDecimal;
import org.testng.annotations.Test;

public class TestDecimalToDecimalCasts
extends AbstractTestFunctions {
    @Test
    public void testShortDecimalToShortDecimalCasts() {
        this.assertDecimalFunction("CAST(DECIMAL '0' AS DECIMAL(1, 0))", SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("CAST(DECIMAL '0' AS DECIMAL(2, 0))", SqlDecimal.decimal((String)"00", (DecimalType)DecimalType.createDecimalType((int)2)));
        this.assertDecimalFunction("CAST(DECIMAL '0' AS DECIMAL(3, 2))", SqlDecimal.decimal((String)"0.00", (DecimalType)DecimalType.createDecimalType((int)3, (int)2)));
        this.assertDecimalFunction("CAST(DECIMAL '2' AS DECIMAL(1, 0))", SqlDecimal.decimal((String)"2", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("CAST(DECIMAL '-2' AS DECIMAL(1, 0))", SqlDecimal.decimal((String)"-2", (DecimalType)DecimalType.createDecimalType((int)1)));
        this.assertDecimalFunction("CAST(DECIMAL '2.0' AS DECIMAL(2, 1))", SqlDecimal.decimal((String)"2.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        this.assertDecimalFunction("CAST(DECIMAL '-2.0' AS DECIMAL(2, 1))", SqlDecimal.decimal((String)"-2.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        this.assertDecimalFunction("CAST(DECIMAL '2.0' AS DECIMAL(2, 0))", SqlDecimal.decimal((String)"02", (DecimalType)DecimalType.createDecimalType((int)2)));
        this.assertDecimalFunction("CAST(DECIMAL '-2.0' AS DECIMAL(2, 0))", SqlDecimal.decimal((String)"-02", (DecimalType)DecimalType.createDecimalType((int)2)));
        this.assertDecimalFunction("CAST(DECIMAL '2.0' AS DECIMAL(3, 2))", SqlDecimal.decimal((String)"2.00", (DecimalType)DecimalType.createDecimalType((int)3, (int)2)));
        this.assertDecimalFunction("CAST(DECIMAL '-2.0' AS DECIMAL(3, 2))", SqlDecimal.decimal((String)"-2.00", (DecimalType)DecimalType.createDecimalType((int)3, (int)2)));
        this.assertDecimalFunction("CAST(DECIMAL '1.449' AS DECIMAL(2, 1))", SqlDecimal.decimal((String)"1.4", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        this.assertDecimalFunction("CAST(DECIMAL '1.459' AS DECIMAL(2, 1))", SqlDecimal.decimal((String)"1.5", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        this.assertDecimalFunction("CAST(DECIMAL '-1.449' AS DECIMAL(2, 1))", SqlDecimal.decimal((String)"-1.4", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        this.assertDecimalFunction("CAST(DECIMAL '-1.459' AS DECIMAL(2, 1))", SqlDecimal.decimal((String)"-1.5", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        this.assertInvalidCast("CAST(DECIMAL '12345.6' AS DECIMAL(4,0))", "Cannot cast DECIMAL(6, 1) '12345.6' to DECIMAL(4, 0)");
        this.assertInvalidCast("CAST(DECIMAL '-12345.6' AS DECIMAL(4,0))", "Cannot cast DECIMAL(6, 1) '-12345.6' to DECIMAL(4, 0)");
        this.assertInvalidCast("CAST(DECIMAL '12345.6' AS DECIMAL(4,2))", "Cannot cast DECIMAL(6, 1) '12345.6' to DECIMAL(4, 2)");
        this.assertInvalidCast("CAST(DECIMAL '-12345.6' AS DECIMAL(4,2))", "Cannot cast DECIMAL(6, 1) '-12345.6' to DECIMAL(4, 2)");
    }

    @Test
    public void testShortDecimalToLongDecimalCasts() {
        this.assertDecimalFunction("CAST(DECIMAL '1.2345' AS DECIMAL(21, 20))", SqlDecimal.decimal((String)"1.23450000000000000000", (DecimalType)DecimalType.createDecimalType((int)21, (int)20)));
        this.assertDecimalFunction("CAST(DECIMAL '-1.2345' AS DECIMAL(21, 20))", SqlDecimal.decimal((String)"-1.23450000000000000000", (DecimalType)DecimalType.createDecimalType((int)21, (int)20)));
    }

    @Test
    public void testLongDecimalToShortDecimalCasts() {
        this.assertDecimalFunction("CAST(DECIMAL '1.23450000000000000000' AS DECIMAL(5, 4))", SqlDecimal.decimal((String)"1.2345", (DecimalType)DecimalType.createDecimalType((int)5, (int)4)));
        this.assertDecimalFunction("CAST(DECIMAL '-1.23450000000000000000' AS DECIMAL(5, 4))", SqlDecimal.decimal((String)"-1.2345", (DecimalType)DecimalType.createDecimalType((int)5, (int)4)));
    }

    @Test
    public void testLongDecimalToLongDecimalCasts() {
        this.assertDecimalFunction("CAST(DECIMAL '0.00000000000000000000' AS DECIMAL(21, 20))", SqlDecimal.decimal((String)"0.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)21, (int)20)));
        this.assertDecimalFunction("CAST(DECIMAL '0.00000000000000000000' AS DECIMAL(22, 20))", SqlDecimal.decimal((String)"00.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)22, (int)20)));
        this.assertDecimalFunction("CAST(DECIMAL '0.00000000000000000000' AS DECIMAL(23, 20))", SqlDecimal.decimal((String)"000.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)23, (int)20)));
        this.assertDecimalFunction("CAST(DECIMAL '2.00000000000000000000' AS DECIMAL(20, 19))", SqlDecimal.decimal((String)"2.0000000000000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)19)));
        this.assertDecimalFunction("CAST(DECIMAL '-2.00000000000000000000' AS DECIMAL(20, 19))", SqlDecimal.decimal((String)"-2.0000000000000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)19)));
        this.assertDecimalFunction("CAST(DECIMAL '2.00000000000000000000' AS DECIMAL(21, 20))", SqlDecimal.decimal((String)"2.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)21, (int)20)));
        this.assertDecimalFunction("CAST(DECIMAL '-2.00000000000000000000' AS DECIMAL(21, 20))", SqlDecimal.decimal((String)"-2.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)21, (int)20)));
        this.assertDecimalFunction("CAST(DECIMAL '2.00000000000000000000' AS DECIMAL(22, 20))", SqlDecimal.decimal((String)"02.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)22, (int)20)));
        this.assertDecimalFunction("CAST(DECIMAL '-2.00000000000000000000' AS DECIMAL(22, 20))", SqlDecimal.decimal((String)"-02.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)22, (int)20)));
        this.assertDecimalFunction("CAST(DECIMAL '2.00000000000000000000' AS DECIMAL(22, 21))", SqlDecimal.decimal((String)"2.000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)22, (int)21)));
        this.assertDecimalFunction("CAST(DECIMAL '-2.00000000000000000000' AS DECIMAL(22, 21))", SqlDecimal.decimal((String)"-2.000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)22, (int)21)));
        this.assertDecimalFunction("CAST(DECIMAL '1.000000000000000000004' AS DECIMAL(21, 20))", SqlDecimal.decimal((String)"1.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)21, (int)20)));
        this.assertDecimalFunction("CAST(DECIMAL '1.000000000000000000005' AS DECIMAL(21, 20))", SqlDecimal.decimal((String)"1.00000000000000000001", (DecimalType)DecimalType.createDecimalType((int)21, (int)20)));
        this.assertDecimalFunction("CAST(DECIMAL '-1.000000000000000000004' AS DECIMAL(21, 20))", SqlDecimal.decimal((String)"-1.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)21, (int)20)));
        this.assertDecimalFunction("CAST(DECIMAL '-1.000000000000000000005' AS DECIMAL(21, 20))", SqlDecimal.decimal((String)"-1.00000000000000000001", (DecimalType)DecimalType.createDecimalType((int)21, (int)20)));
        this.assertInvalidCast("CAST(DECIMAL '1234500000000000000000000.6' AS DECIMAL(20,0))", "Cannot cast DECIMAL(26, 1) '1234500000000000000000000.6' to DECIMAL(20, 0)");
        this.assertInvalidCast("CAST(DECIMAL '-1234500000000000000000000.6' AS DECIMAL(20,0))", "Cannot cast DECIMAL(26, 1) '-1234500000000000000000000.6' to DECIMAL(20, 0)");
        this.assertInvalidCast("CAST(DECIMAL '1234500000000000000000000.6' AS DECIMAL(22,2))", "Cannot cast DECIMAL(26, 1) '1234500000000000000000000.6' to DECIMAL(22, 2)");
        this.assertInvalidCast("CAST(DECIMAL '-1234500000000000000000000.6' AS DECIMAL(22,2))", "Cannot cast DECIMAL(26, 1) '-1234500000000000000000000.6' to DECIMAL(22, 2)");
    }
}

