/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDoubleOperators
extends AbstractTestFunctions {
    @Test
    public void testLiteral() {
        this.assertFunction("37.7E0", (Type)DoubleType.DOUBLE, 37.7);
        this.assertFunction("17.1E0", (Type)DoubleType.DOUBLE, 17.1);
    }

    @Test
    public void testTypeConstructor() {
        this.assertFunction("DOUBLE '12.34'", (Type)DoubleType.DOUBLE, 12.34);
        this.assertFunction("DOUBLE '-17.6'", (Type)DoubleType.DOUBLE, -17.6);
        this.assertFunction("DOUBLE '+754'", (Type)DoubleType.DOUBLE, 754.0);
        this.assertFunction("DOUBLE 'NaN'", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("DOUBLE '-NaN'", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("DOUBLE PRECISION '12.34'", (Type)DoubleType.DOUBLE, 12.34);
        this.assertFunction("DOUBLE PRECISION '-17.6'", (Type)DoubleType.DOUBLE, -17.6);
        this.assertFunction("DOUBLE PRECISION '+754'", (Type)DoubleType.DOUBLE, 754.0);
        this.assertFunction("DOUBLE PRECISION 'NaN'", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("DOUBLE PRECISION '-NaN'", (Type)DoubleType.DOUBLE, Double.NaN);
    }

    @Test
    public void testAdd() {
        this.assertFunction("37.7E0 + 37.7E0", (Type)DoubleType.DOUBLE, 75.4);
        this.assertFunction("37.7E0 + 17.1E0", (Type)DoubleType.DOUBLE, 54.800000000000004);
        this.assertFunction("17.1E0 + 37.7E0", (Type)DoubleType.DOUBLE, 54.800000000000004);
        this.assertFunction("17.1E0 + 17.1E0", (Type)DoubleType.DOUBLE, 34.2);
        this.assertFunction("DOUBLE 'NaN' + 37.7E0", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("37.7E0 + DOUBLE 'NaN'", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("DOUBLE 'NaN' + DOUBLE '-NaN'", (Type)DoubleType.DOUBLE, Double.NaN);
    }

    @Test
    public void testSubtract() {
        this.assertFunction("37.7E0 - 37.7E0", (Type)DoubleType.DOUBLE, 0.0);
        this.assertFunction("37.7E0 - 17.1E0", (Type)DoubleType.DOUBLE, 20.6);
        this.assertFunction("17.1E0 - 37.7E0", (Type)DoubleType.DOUBLE, -20.6);
        this.assertFunction("17.1E0 - 17.1E0", (Type)DoubleType.DOUBLE, 0.0);
        this.assertFunction("DOUBLE 'NaN' - 37.7E0", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("37.7E0 - DOUBLE 'NaN'", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("DOUBLE 'NaN' - DOUBLE 'NaN'", (Type)DoubleType.DOUBLE, Double.NaN);
    }

    @Test
    public void testMultiply() {
        this.assertFunction("37.7E0 * 37.7E0", (Type)DoubleType.DOUBLE, 1421.2900000000002);
        this.assertFunction("37.7E0 * 17.1E0", (Type)DoubleType.DOUBLE, 644.6700000000001);
        this.assertFunction("17.1E0 * 37.7E0", (Type)DoubleType.DOUBLE, 644.6700000000001);
        this.assertFunction("17.1E0 * 17.1E0", (Type)DoubleType.DOUBLE, 292.41);
        this.assertFunction("DOUBLE 'NaN' * 37.7E0", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("37.7E0 * DOUBLE 'NaN'", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("DOUBLE 'NaN' * DOUBLE '-NaN'", (Type)DoubleType.DOUBLE, Double.NaN);
    }

    @Test
    public void testDivide() {
        this.assertFunction("37.7E0 / 37.7E0", (Type)DoubleType.DOUBLE, 1.0);
        this.assertFunction("37.7E0 / 17.1E0", (Type)DoubleType.DOUBLE, 2.2046783625730995);
        this.assertFunction("17.1E0 / 37.7E0", (Type)DoubleType.DOUBLE, 0.4535809018567639);
        this.assertFunction("17.1E0 / 17.1E0", (Type)DoubleType.DOUBLE, 1.0);
        this.assertFunction("DOUBLE 'NaN' / 37.7E0", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("37.7E0 / DOUBLE 'NaN'", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("DOUBLE 'NaN' / DOUBLE '-NaN'", (Type)DoubleType.DOUBLE, Double.NaN);
    }

    @Test
    public void testModulus() {
        this.assertFunction("37.7E0 % 37.7E0", (Type)DoubleType.DOUBLE, 0.0);
        this.assertFunction("37.7E0 % 17.1E0", (Type)DoubleType.DOUBLE, 3.5);
        this.assertFunction("17.1E0 % 37.7E0", (Type)DoubleType.DOUBLE, 17.1);
        this.assertFunction("17.1E0 % 17.1E0", (Type)DoubleType.DOUBLE, 0.0);
        this.assertFunction("DOUBLE 'NaN' % 37.7E0", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("37.7E0 % DOUBLE 'NaN'", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("DOUBLE 'NaN' % DOUBLE 'NaN'", (Type)DoubleType.DOUBLE, Double.NaN);
    }

    @Test
    public void testNegation() {
        this.assertFunction("-(37.7E0)", (Type)DoubleType.DOUBLE, -37.7);
        this.assertFunction("-(17.1E0)", (Type)DoubleType.DOUBLE, -17.1);
        this.assertFunction("-DOUBLE 'NaN'", (Type)DoubleType.DOUBLE, Double.NaN);
    }

    @Test
    public void testEqual() {
        this.assertFunction("37.7E0 = 37.7E0", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("37.7E0 = 17.1E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("17.1E0 = 37.7E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("17.1E0 = 17.1E0", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("0E0 = -0E0", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DOUBLE 'NaN' = 37.7E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("37.7E0 = DOUBLE 'NaN'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DOUBLE 'NaN' = DOUBLE 'NaN'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testNotEqual() {
        this.assertFunction("37.7E0 <> 37.7E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("37.7E0 <> 17.1E0", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("17.1E0 <> 37.7E0", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("17.1E0 <> 17.1E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DOUBLE 'NaN' <> 37.7E0", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("37.7E0 <> DOUBLE 'NaN'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DOUBLE 'NaN' <> DOUBLE 'NaN'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testLessThan() {
        this.assertFunction("37.7E0 < 37.7E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("37.7E0 < 17.1E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("17.1E0 < 37.7E0", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("17.1E0 < 17.1E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DOUBLE 'NaN' < 37.7E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("37.7E0 < DOUBLE 'NaN'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DOUBLE 'NaN' < DOUBLE 'NaN'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThanOrEqual() {
        this.assertFunction("37.7E0 <= 37.7E0", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("37.7E0 <= 17.1E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("17.1E0 <= 37.7E0", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("17.1E0 <= 17.1E0", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DOUBLE 'NaN' <= 37.7E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("37.7E0 <= DOUBLE 'NaN'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DOUBLE 'NaN' <= DOUBLE 'NaN'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testGreaterThan() {
        this.assertFunction("37.7E0 > 37.7E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("37.7E0 > 17.1E0", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("17.1E0 > 37.7E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("17.1E0 > 17.1E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DOUBLE 'NaN' > 37.7E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("37.7E0 > DOUBLE 'NaN'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DOUBLE 'NaN' > DOUBLE 'NaN'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testGreaterThanOrEqual() {
        this.assertFunction("37.7E0 >= 37.7E0", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("37.7E0 >= 17.1E0", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("17.1E0 >= 37.7E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("17.1E0 >= 17.1E0", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DOUBLE 'NaN' >= 37.7E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("37.7E0 >= DOUBLE 'NaN'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DOUBLE 'NaN' >= DOUBLE 'NaN'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testBetween() {
        this.assertFunction("37.7E0 BETWEEN 37.7E0 AND 37.7E0", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("37.7E0 BETWEEN 37.7E0 AND 17.1E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("37.7E0 BETWEEN 17.1E0 AND 37.7E0", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("37.7E0 BETWEEN 17.1E0 AND 17.1E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("17.1E0 BETWEEN 37.7E0 AND 37.7E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("17.1E0 BETWEEN 37.7E0 AND 17.1E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("17.1E0 BETWEEN 17.1E0 AND 37.7E0", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("17.1E0 BETWEEN 17.1E0 AND 17.1E0", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DOUBLE 'NaN' BETWEEN 17.1E0 AND 37.7E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("17.1E0 BETWEEN DOUBLE '-NaN' AND DOUBLE 'NaN'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("17.1E0 BETWEEN DOUBLE 'NaN' AND DOUBLE '-NaN'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("17.1E0 BETWEEN 17.1E0 AND DOUBLE 'NaN'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DOUBLE 'NaN' BETWEEN DOUBLE 'NaN' AND DOUBLE 'NaN'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testCastToVarchar() {
        this.assertFunction("cast(37.7E0 as varchar)", (Type)VarcharType.VARCHAR, "3.77E1");
        this.assertFunction("cast(17.1E0 as varchar)", (Type)VarcharType.VARCHAR, "1.71E1");
        this.assertFunction("cast(0E0/0E0 as varchar)", (Type)VarcharType.VARCHAR, "NaN");
        this.assertFunction("cast(12e2 as varchar(6))", (Type)VarcharType.createVarcharType((int)6), "1.2E3");
        this.assertFunction("cast(12e2 as varchar(50))", (Type)VarcharType.createVarcharType((int)50), "1.2E3");
        this.assertFunction("cast(12345678.9e0 as varchar(50))", (Type)VarcharType.createVarcharType((int)50), "1.23456789E7");
        this.assertFunction("cast(DOUBLE 'NaN' as varchar(3))", (Type)VarcharType.createVarcharType((int)3), "NaN");
        this.assertFunction("cast(DOUBLE 'Infinity' as varchar(50))", (Type)VarcharType.createVarcharType((int)50), "Infinity");
        this.assertFunction("cast(12e2 as varchar(5))", (Type)VarcharType.createVarcharType((int)5), "1.2E3");
        this.assertInvalidCast("cast(12e2 as varchar(4))", "Value 1200.0 (1.2E3) cannot be represented as varchar(4)");
        this.assertInvalidCast("cast(0e0 as varchar(2))", "Value 0.0 (0E0) cannot be represented as varchar(2)");
        this.assertInvalidCast("cast(-0e0 as varchar(3))", "Value -0.0 (-0E0) cannot be represented as varchar(3)");
        this.assertInvalidCast("cast(0e0 / 0e0 as varchar(2))", "Value NaN (NaN) cannot be represented as varchar(2)");
        this.assertInvalidCast("cast(DOUBLE 'Infinity' as varchar(7))", "Value Infinity (Infinity) cannot be represented as varchar(7)");
    }

    @Test
    public void testCastToBigint() {
        this.assertFunction("cast(37.7E0 as bigint)", (Type)BigintType.BIGINT, 38L);
        this.assertFunction("cast(-37.7E0 as bigint)", (Type)BigintType.BIGINT, -38L);
        this.assertFunction("cast(17.1E0 as bigint)", (Type)BigintType.BIGINT, 17L);
        this.assertFunction("cast(-17.1E0 as bigint)", (Type)BigintType.BIGINT, -17L);
        this.assertFunction("cast(9.2E18 as bigint)", (Type)BigintType.BIGINT, 9200000000000000000L);
        this.assertFunction("cast(-9.2E18 as bigint)", (Type)BigintType.BIGINT, -9200000000000000000L);
        this.assertFunction("cast(2.21E9 as bigint)", (Type)BigintType.BIGINT, 2210000000L);
        this.assertFunction("cast(-2.21E9 as bigint)", (Type)BigintType.BIGINT, -2210000000L);
        this.assertFunction("cast(17.5E0 as bigint)", (Type)BigintType.BIGINT, 18L);
        this.assertFunction("cast(-17.5E0 as bigint)", (Type)BigintType.BIGINT, -18L);
        this.assertFunction("cast(" + Math.nextDown(9.223372036854776E18) + " as bigint)", (Type)BigintType.BIGINT, (long)Math.nextDown(9.223372036854776E18));
        this.assertInvalidFunction("cast(9.223372036854776E18 as bigint)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertInvalidFunction("cast(" + Math.nextUp(9.223372036854776E18) + " as bigint)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertInvalidFunction("cast(" + Math.nextDown(-9.223372036854776E18) + " as bigint)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertFunction("cast(-9.223372036854776E18 as bigint)", (Type)BigintType.BIGINT, Long.MIN_VALUE);
        this.assertFunction("cast(" + Math.nextUp(-9.223372036854776E18) + " as bigint)", (Type)BigintType.BIGINT, (long)Math.nextUp(-9.223372036854776E18));
        this.assertInvalidFunction("cast(9.3E18 as bigint)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertInvalidFunction("cast(-9.3E18 as bigint)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertInvalidFunction("cast(infinity() as bigint)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertInvalidFunction("cast(-infinity() as bigint)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertInvalidFunction("cast(nan() as bigint)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
    }

    @Test
    public void testCastNaN() {
        this.assertInvalidFunction("cast(nan() as integer)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertInvalidFunction("cast(nan() as smallint)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertInvalidFunction("cast(nan() as tinyint)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertFunction("cast(nan() as real)", (Type)RealType.REAL, Float.valueOf(Float.NaN));
    }

    @Test
    public void testCastToBoolean() {
        this.assertFunction("cast(37.7E0 as boolean)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast(17.1E0 as boolean)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast(0.0E0 as boolean)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("cast(nan() as boolean)", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testCastToFloat() {
        this.assertFunction("cast('754.1985' as real)", (Type)RealType.REAL, Float.valueOf(754.1985f));
        this.assertFunction("cast('-754.2008' as real)", (Type)RealType.REAL, Float.valueOf(-754.2008f));
        this.assertFunction("cast('0.0' as real)", (Type)RealType.REAL, Float.valueOf(0.0f));
        this.assertFunction("cast('-0.0' as real)", (Type)RealType.REAL, Float.valueOf(-0.0f));
    }

    @Test
    public void testCastFromVarchar() {
        this.assertFunction("cast('37.7' as double)", (Type)DoubleType.DOUBLE, 37.7);
        this.assertFunction("cast('17.1' as double)", (Type)DoubleType.DOUBLE, 17.1);
        this.assertFunction("cast('NaN' as double)", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("cast('37.7' as double precision)", (Type)DoubleType.DOUBLE, 37.7);
        this.assertFunction("cast('17.1' as double precision)", (Type)DoubleType.DOUBLE, 17.1);
        this.assertFunction("cast('NaN' as double precision)", (Type)DoubleType.DOUBLE, Double.NaN);
    }

    @Test
    public void testIsDistinctFrom() {
        this.assertFunction("CAST(NULL AS DOUBLE) IS DISTINCT FROM CAST(NULL AS DOUBLE)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("37.7 IS DISTINCT FROM 37.7", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("37 IS DISTINCT FROM 37.8", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("NULL IS DISTINCT FROM 37.7", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("37.7 IS DISTINCT FROM NULL", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("nan() IS DISTINCT FROM nan()", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testIndeterminate() {
        this.assertOperator(OperatorType.INDETERMINATE, "cast(null as double)", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "1.2", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "cast(1.2 as double)", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "cast(1 as double)", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "nan()", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testNanHash() throws Throwable {
        long[] nanRepresentations;
        for (long nanRepresentation : nanRepresentations = new long[]{Double.doubleToLongBits(Double.NaN), -2251799813685248L, 9221140251894092340L, -2231784960683468L}) {
            Assert.assertTrue((boolean)Double.isNaN(Double.longBitsToDouble(nanRepresentation)));
            Assert.assertTrue((nanRepresentation == nanRepresentations[0] || Double.doubleToRawLongBits(Double.longBitsToDouble(nanRepresentation)) != Double.doubleToRawLongBits(Double.longBitsToDouble(nanRepresentations[0])) ? 1 : 0) != 0);
            Assert.assertEquals((long)this.executeHashOperator(Double.longBitsToDouble(nanRepresentation)), (long)this.executeHashOperator(Double.longBitsToDouble(nanRepresentations[0])));
            Assert.assertEquals((long)this.executeXxHash64Operator(Double.longBitsToDouble(nanRepresentation)), (long)this.executeXxHash64Operator(Double.longBitsToDouble(nanRepresentations[0])));
        }
    }

    @Test
    public void testZeroHash() throws Throwable {
        double[] zeroes;
        for (double zero : zeroes = new double[]{0.0, -0.0}) {
            Assert.assertTrue((zero == 0.0 ? 1 : 0) != 0);
            Assert.assertEquals((long)this.executeHashOperator(zero), (long)this.executeHashOperator(zeroes[0]));
            Assert.assertEquals((long)this.executeXxHash64Operator(zero), (long)this.executeXxHash64Operator(zeroes[0]));
        }
    }

    private long executeHashOperator(double value) throws Throwable {
        MethodHandle hashCodeOperator = this.functionAssertions.getTypeOperators().getHashCodeOperator((Type)DoubleType.DOUBLE, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL}));
        return hashCodeOperator.invokeExact(value);
    }

    private long executeXxHash64Operator(double value) throws Throwable {
        MethodHandle xxHash64Operator = this.functionAssertions.getTypeOperators().getXxHash64Operator((Type)DoubleType.DOUBLE, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL}));
        return xxHash64Operator.invokeExact(value);
    }
}

