/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.block.AbstractTestBlock;
import io.trino.spi.block.ArrayBlock;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ByteArrayBlock;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Optional;
import java.util.Random;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestArrayBlock
extends AbstractTestBlock {
    private static final int[] ARRAY_SIZES = new int[]{16, 0, 13, 1, 2, 11, 4, 7};

    @Test
    public void testWithFixedWidthBlock() {
        long[][] expectedValues = new long[ARRAY_SIZES.length][];
        Random rand = new Random(47L);
        for (int i = 0; i < ARRAY_SIZES.length; ++i) {
            expectedValues[i] = rand.longs(ARRAY_SIZES[i]).toArray();
        }
        BlockBuilder blockBuilder = TestArrayBlock.createBlockBuilderWithValues(expectedValues);
        this.assertBlock((Block)blockBuilder, () -> blockBuilder.newBlockBuilderLike(null), (T[])expectedValues);
        this.assertBlock(blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), (T[])expectedValues);
        this.assertBlockFilteredPositions((T[])expectedValues, blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), 0, 1, 3, 4, 7);
        this.assertBlockFilteredPositions((T[])expectedValues, blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), 2, 3, 5, 6);
        long[][] expectedValuesWithNull = (long[][])TestArrayBlock.alternatingNullValues(expectedValues);
        BlockBuilder blockBuilderWithNull = TestArrayBlock.createBlockBuilderWithValues(expectedValuesWithNull);
        this.assertBlock((Block)blockBuilderWithNull, () -> blockBuilder.newBlockBuilderLike(null), (T[])expectedValuesWithNull);
        this.assertBlock(blockBuilderWithNull.build(), () -> blockBuilder.newBlockBuilderLike(null), (T[])expectedValuesWithNull);
        this.assertBlockFilteredPositions((T[])expectedValuesWithNull, blockBuilderWithNull.build(), () -> blockBuilder.newBlockBuilderLike(null), 0, 1, 5, 6, 7, 10, 11, 12, 15);
        this.assertBlockFilteredPositions((T[])expectedValuesWithNull, blockBuilderWithNull.build(), () -> blockBuilder.newBlockBuilderLike(null), 2, 3, 4, 9, 13, 14);
    }

    @Test
    public void testWithVariableWidthBlock() {
        Slice[][] expectedValues = new Slice[ARRAY_SIZES.length][];
        for (int i = 0; i < ARRAY_SIZES.length; ++i) {
            expectedValues[i] = new Slice[ARRAY_SIZES[i]];
            for (int j = 0; j < ARRAY_SIZES[i]; ++j) {
                expectedValues[i][j] = Slices.utf8Slice((String)String.format("%d.%d", i, j));
            }
        }
        BlockBuilder blockBuilder = TestArrayBlock.createBlockBuilderWithValues(expectedValues);
        this.assertBlock((Block)blockBuilder, () -> blockBuilder.newBlockBuilderLike(null), (T[])expectedValues);
        this.assertBlock(blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), (T[])expectedValues);
        this.assertBlockFilteredPositions((T[])expectedValues, blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), 0, 1, 3, 4, 7);
        this.assertBlockFilteredPositions((T[])expectedValues, blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), 2, 3, 5, 6);
        Slice[][] expectedValuesWithNull = (Slice[][])TestArrayBlock.alternatingNullValues(expectedValues);
        BlockBuilder blockBuilderWithNull = TestArrayBlock.createBlockBuilderWithValues(expectedValuesWithNull);
        this.assertBlock((Block)blockBuilderWithNull, () -> blockBuilder.newBlockBuilderLike(null), (T[])expectedValuesWithNull);
        this.assertBlock(blockBuilderWithNull.build(), () -> blockBuilder.newBlockBuilderLike(null), (T[])expectedValuesWithNull);
        this.assertBlockFilteredPositions((T[])expectedValuesWithNull, blockBuilderWithNull.build(), () -> blockBuilder.newBlockBuilderLike(null), 0, 1, 5, 6, 7, 10, 11, 12, 15);
        this.assertBlockFilteredPositions((T[])expectedValuesWithNull, blockBuilderWithNull.build(), () -> blockBuilder.newBlockBuilderLike(null), 2, 3, 4, 9, 13, 14);
    }

    @Test
    public void testWithArrayBlock() {
        long[][][] expectedValues = TestArrayBlock.createExpectedValues();
        BlockBuilder blockBuilder = TestArrayBlock.createBlockBuilderWithValues(expectedValues);
        this.assertBlock((Block)blockBuilder, () -> blockBuilder.newBlockBuilderLike(null), (T[])expectedValues);
        this.assertBlock(blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), (T[])expectedValues);
        this.assertBlockFilteredPositions((T[])expectedValues, blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), 0, 1, 3, 4, 7);
        this.assertBlockFilteredPositions((T[])expectedValues, blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), 2, 3, 5, 6);
        long[][][] expectedValuesWithNull = (long[][][])TestArrayBlock.alternatingNullValues(expectedValues);
        BlockBuilder blockBuilderWithNull = TestArrayBlock.createBlockBuilderWithValues(expectedValuesWithNull);
        this.assertBlock((Block)blockBuilderWithNull, () -> blockBuilder.newBlockBuilderLike(null), (T[])expectedValuesWithNull);
        this.assertBlock(blockBuilderWithNull.build(), () -> blockBuilder.newBlockBuilderLike(null), (T[])expectedValuesWithNull);
        this.assertBlockFilteredPositions((T[])expectedValuesWithNull, blockBuilderWithNull.build(), () -> blockBuilder.newBlockBuilderLike(null), 0, 1, 5, 6, 7, 10, 11, 12, 15);
        this.assertBlockFilteredPositions((T[])expectedValuesWithNull, blockBuilderWithNull.build(), () -> blockBuilder.newBlockBuilderLike(null), 2, 3, 4, 9, 13, 14);
    }

    private static long[][][] createExpectedValues() {
        long[][][] expectedValues = new long[ARRAY_SIZES.length][][];
        for (int i = 0; i < ARRAY_SIZES.length; ++i) {
            expectedValues[i] = new long[ARRAY_SIZES[i]][];
            for (int j = 1; j < ARRAY_SIZES[i]; ++j) {
                expectedValues[i][j] = (long[])((i + j) % 5 == 0 ? null : new long[]{i, j, i + j});
            }
        }
        return expectedValues;
    }

    @Test
    public void testLazyBlockBuilderInitialization() {
        long[][] expectedValues = new long[ARRAY_SIZES.length][];
        Random rand = new Random(47L);
        for (int i = 0; i < ARRAY_SIZES.length; ++i) {
            expectedValues[i] = rand.longs(ARRAY_SIZES[i]).toArray();
        }
        ArrayBlockBuilder emptyBlockBuilder = new ArrayBlockBuilder((Type)BigintType.BIGINT, null, 0, 0);
        ArrayBlockBuilder blockBuilder = new ArrayBlockBuilder((Type)BigintType.BIGINT, null, 100, 100);
        Assert.assertEquals((long)blockBuilder.getSizeInBytes(), (long)emptyBlockBuilder.getSizeInBytes());
        Assert.assertEquals((long)blockBuilder.getRetainedSizeInBytes(), (long)emptyBlockBuilder.getRetainedSizeInBytes());
        TestArrayBlock.writeValues(expectedValues, (BlockBuilder)blockBuilder);
        Assert.assertTrue((blockBuilder.getSizeInBytes() > emptyBlockBuilder.getSizeInBytes() ? 1 : 0) != 0);
        Assert.assertTrue((blockBuilder.getRetainedSizeInBytes() > emptyBlockBuilder.getRetainedSizeInBytes() ? 1 : 0) != 0);
        blockBuilder = blockBuilder.newBlockBuilderLike(null);
        Assert.assertEquals((long)blockBuilder.getSizeInBytes(), (long)emptyBlockBuilder.getSizeInBytes());
        Assert.assertEquals((long)blockBuilder.getRetainedSizeInBytes(), (long)emptyBlockBuilder.getRetainedSizeInBytes());
    }

    @Test
    public void testEstimatedDataSizeForStats() {
        long[][][] expectedValues = (long[][][])TestArrayBlock.alternatingNullValues(TestArrayBlock.createExpectedValues());
        BlockBuilder blockBuilder = TestArrayBlock.createBlockBuilderWithValues(expectedValues);
        Block block = blockBuilder.build();
        Assert.assertEquals((int)block.getPositionCount(), (int)expectedValues.length);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            int expectedSize = TestArrayBlock.getExpectedEstimatedDataSize(expectedValues[i]);
            Assert.assertEquals((long)blockBuilder.getEstimatedDataSizeForStats(i), (long)expectedSize);
            Assert.assertEquals((long)block.getEstimatedDataSizeForStats(i), (long)expectedSize);
        }
    }

    private static int getExpectedEstimatedDataSize(long[][] values) {
        if (values == null) {
            return 0;
        }
        int size = 0;
        for (long[] value : values) {
            if (value == null) continue;
            size += 8 * value.length;
        }
        return size;
    }

    @Test
    public void testCompactBlock() {
        ByteArrayBlock emptyValueBlock = new ByteArrayBlock(0, Optional.empty(), new byte[0]);
        ByteArrayBlock compactValueBlock = new ByteArrayBlock(16, Optional.empty(), TestArrayBlock.createExpectedValue(16).getBytes());
        ByteArrayBlock inCompactValueBlock = new ByteArrayBlock(16, Optional.empty(), TestArrayBlock.createExpectedValue(17).getBytes());
        int[] offsets = new int[]{0, 1, 1, 2, 4, 8, 16};
        boolean[] valueIsNull = new boolean[]{false, true, false, false, false, false};
        TestArrayBlock.testCompactBlock(ArrayBlock.fromElementBlock((int)0, Optional.empty(), (int[])new int[1], (Block)emptyValueBlock));
        TestArrayBlock.testCompactBlock(ArrayBlock.fromElementBlock((int)valueIsNull.length, Optional.of(valueIsNull), (int[])offsets, (Block)compactValueBlock));
        TestArrayBlock.testIncompactBlock(ArrayBlock.fromElementBlock((int)(valueIsNull.length - 1), Optional.of(valueIsNull), (int[])offsets, (Block)compactValueBlock));
        TestArrayBlock.testIncompactBlock(ArrayBlock.fromElementBlock((int)valueIsNull.length, Optional.of(valueIsNull), (int[])offsets, (Block)inCompactValueBlock));
    }

    private static BlockBuilder createBlockBuilderWithValues(long[][][] expectedValues) {
        ArrayBlockBuilder blockBuilder = new ArrayBlockBuilder((BlockBuilder)new ArrayBlockBuilder((Type)BigintType.BIGINT, null, 100, 100), null, 100);
        for (long[][] expectedValue : expectedValues) {
            if (expectedValue == null) {
                blockBuilder.appendNull();
                continue;
            }
            BlockBuilder intermediateBlockBuilder = blockBuilder.beginBlockEntry();
            for (int j = 0; j < expectedValue.length; ++j) {
                if (expectedValue[j] == null) {
                    intermediateBlockBuilder.appendNull();
                    continue;
                }
                BlockBuilder innerMostBlockBuilder = intermediateBlockBuilder.beginBlockEntry();
                for (long v : expectedValue[j]) {
                    BigintType.BIGINT.writeLong(innerMostBlockBuilder, v);
                }
                intermediateBlockBuilder.closeEntry();
            }
            blockBuilder.closeEntry();
        }
        return blockBuilder;
    }

    private static BlockBuilder createBlockBuilderWithValues(long[][] expectedValues) {
        ArrayBlockBuilder blockBuilder = new ArrayBlockBuilder((Type)BigintType.BIGINT, null, 100, 100);
        return TestArrayBlock.writeValues(expectedValues, (BlockBuilder)blockBuilder);
    }

    private static BlockBuilder writeValues(long[][] expectedValues, BlockBuilder blockBuilder) {
        for (long[] expectedValue : expectedValues) {
            if (expectedValue == null) {
                blockBuilder.appendNull();
                continue;
            }
            BlockBuilder elementBlockBuilder = blockBuilder.beginBlockEntry();
            for (long v : expectedValue) {
                BigintType.BIGINT.writeLong(elementBlockBuilder, v);
            }
            blockBuilder.closeEntry();
        }
        return blockBuilder;
    }

    private static BlockBuilder createBlockBuilderWithValues(Slice[][] expectedValues) {
        ArrayBlockBuilder blockBuilder = new ArrayBlockBuilder((Type)VarcharType.VARCHAR, null, 100, 100);
        for (Slice[] expectedValue : expectedValues) {
            if (expectedValue == null) {
                blockBuilder.appendNull();
                continue;
            }
            BlockBuilder elementBlockBuilder = blockBuilder.beginBlockEntry();
            for (Slice v : expectedValue) {
                VarcharType.VARCHAR.writeSlice(elementBlockBuilder, v);
            }
            blockBuilder.closeEntry();
        }
        return blockBuilder;
    }
}

