/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.stats.GcMonitor;
import io.airlift.stats.TestingGcMonitor;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.cost.StatsAndCosts;
import io.trino.exchange.ExchangeManagerRegistry;
import io.trino.execution.NodeTaskMap;
import io.trino.execution.PartitionedSplitsInfo;
import io.trino.execution.RemoteTask;
import io.trino.execution.RemoteTaskFactory;
import io.trino.execution.StateMachine;
import io.trino.execution.TaskId;
import io.trino.execution.TaskInfo;
import io.trino.execution.TaskState;
import io.trino.execution.TaskStateMachine;
import io.trino.execution.TaskStatus;
import io.trino.execution.buffer.LazyOutputBuffer;
import io.trino.execution.buffer.OutputBuffer;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.memory.MemoryPool;
import io.trino.memory.QueryContext;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.SimpleLocalMemoryContext;
import io.trino.metadata.ExchangeHandleResolver;
import io.trino.metadata.InternalNode;
import io.trino.metadata.Split;
import io.trino.metadata.TableHandle;
import io.trino.operator.TaskContext;
import io.trino.operator.TaskStats;
import io.trino.spi.SplitWeight;
import io.trino.spi.type.VarcharType;
import io.trino.spiller.SpillSpaceTracker;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.testing.TestingHandles;
import io.trino.testing.TestingMetadata;
import io.trino.util.Failures;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import javax.annotation.concurrent.GuardedBy;
import org.joda.time.DateTime;

public class MockRemoteTaskFactory
implements RemoteTaskFactory {
    private static final String TASK_INSTANCE_ID = "task-instance-id";
    private final Executor executor;
    private final ScheduledExecutorService scheduledExecutor;

    public MockRemoteTaskFactory(Executor executor, ScheduledExecutorService scheduledExecutor) {
        this.executor = executor;
        this.scheduledExecutor = scheduledExecutor;
    }

    public MockRemoteTask createTableScanTask(TaskId taskId, InternalNode newNode, List<Split> splits, NodeTaskMap.PartitionedSplitCountTracker partitionedSplitCountTracker) {
        Symbol symbol = new Symbol("column");
        PlanNodeId sourceId = new PlanNodeId("sourceId");
        PlanFragment testFragment = new PlanFragment(new PlanFragmentId("test"), (PlanNode)TableScanNode.newInstance((PlanNodeId)sourceId, (TableHandle)TestingHandles.TEST_TABLE_HANDLE, (List)ImmutableList.of((Object)symbol), (Map)ImmutableMap.of((Object)symbol, (Object)new TestingMetadata.TestingColumnHandle("column")), (boolean)false, Optional.empty()), (Map)ImmutableMap.of((Object)symbol, (Object)VarcharType.VARCHAR), SystemPartitioningHandle.SOURCE_DISTRIBUTION, (List)ImmutableList.of((Object)sourceId), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)symbol)), StatsAndCosts.empty(), (List)ImmutableList.of(), Optional.empty());
        ImmutableMultimap.Builder initialSplits = ImmutableMultimap.builder();
        for (Split sourceSplit : splits) {
            initialSplits.put((Object)sourceId, (Object)sourceSplit);
        }
        return this.createRemoteTask(SessionTestUtils.TEST_SESSION, taskId, newNode, testFragment, (Multimap)initialSplits.build(), OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.BROADCAST), partitionedSplitCountTracker, (Set)ImmutableSet.of(), Optional.empty(), true);
    }

    public MockRemoteTask createRemoteTask(Session session, TaskId taskId, InternalNode node, PlanFragment fragment, Multimap<PlanNodeId, Split> initialSplits, OutputBuffers outputBuffers, NodeTaskMap.PartitionedSplitCountTracker partitionedSplitCountTracker, Set<DynamicFilterId> outboundDynamicFilterIds, Optional<DataSize> estimatedMemory, boolean summarizeTaskInfo) {
        return new MockRemoteTask(taskId, fragment, node.getNodeIdentifier(), this.executor, this.scheduledExecutor, initialSplits, partitionedSplitCountTracker);
    }

    public static final class MockRemoteTask
    implements RemoteTask {
        private final AtomicLong nextTaskInfoVersion = new AtomicLong(0L);
        private final URI location;
        private final TaskStateMachine taskStateMachine;
        private final TaskContext taskContext;
        private final OutputBuffer outputBuffer;
        private final String nodeId;
        private final PlanFragment fragment;
        @GuardedBy(value="this")
        private final Set<PlanNodeId> noMoreSplits = new HashSet<PlanNodeId>();
        @GuardedBy(value="this")
        private final Multimap<PlanNodeId, Split> splits = HashMultimap.create();
        @GuardedBy(value="this")
        private int runningDrivers;
        @GuardedBy(value="this")
        private int maxUnacknowledgedSplits = Integer.MAX_VALUE;
        @GuardedBy(value="this")
        private int unacknowledgedSplits;
        @GuardedBy(value="this")
        private SettableFuture<Void> whenSplitQueueHasSpace = SettableFuture.create();
        private final NodeTaskMap.PartitionedSplitCountTracker partitionedSplitCountTracker;
        private boolean isOutputBufferOverUtilized;

        public MockRemoteTask(TaskId taskId, PlanFragment fragment, String nodeId, Executor executor, ScheduledExecutorService scheduledExecutor, Multimap<PlanNodeId, Split> initialSplits, NodeTaskMap.PartitionedSplitCountTracker partitionedSplitCountTracker) {
            this.taskStateMachine = new TaskStateMachine(Objects.requireNonNull(taskId, "taskId is null"), Objects.requireNonNull(executor, "executor is null"));
            MemoryPool memoryPool = new MemoryPool(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
            SpillSpaceTracker spillSpaceTracker = new SpillSpaceTracker(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
            QueryContext queryContext = new QueryContext(taskId.getQueryId(), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), memoryPool, (GcMonitor)new TestingGcMonitor(), executor, scheduledExecutor, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), spillSpaceTracker);
            this.taskContext = queryContext.addTaskContext(this.taskStateMachine, SessionTestUtils.TEST_SESSION, () -> {}, true, true);
            this.location = URI.create("fake://task/" + taskId);
            this.outputBuffer = new LazyOutputBuffer(taskId, MockRemoteTaskFactory.TASK_INSTANCE_ID, executor, DataSize.ofBytes((long)1L), DataSize.ofBytes((long)1L), () -> new SimpleLocalMemoryContext(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), "test"), () -> {}, new ExchangeManagerRegistry(new ExchangeHandleResolver()));
            this.fragment = Objects.requireNonNull(fragment, "fragment is null");
            this.nodeId = Objects.requireNonNull(nodeId, "nodeId is null");
            this.splits.putAll(initialSplits);
            this.partitionedSplitCountTracker = Objects.requireNonNull(partitionedSplitCountTracker, "partitionedSplitCountTracker is null");
            partitionedSplitCountTracker.setPartitionedSplits(this.getPartitionedSplitsInfo());
            this.updateSplitQueueSpace();
        }

        public TaskId getTaskId() {
            return this.taskStateMachine.getTaskId();
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public TaskInfo getTaskInfo() {
            TaskState state = this.taskStateMachine.getState();
            Object failures = ImmutableList.of();
            if (state == TaskState.FAILED) {
                failures = Failures.toFailures((Collection)this.taskStateMachine.getFailureCauses());
            }
            return new TaskInfo(new TaskStatus(this.taskStateMachine.getTaskId(), MockRemoteTaskFactory.TASK_INSTANCE_ID, this.nextTaskInfoVersion.getAndIncrement(), state, this.location, this.nodeId, (List)failures, 0, 0, this.isOutputBufferOverUtilized, DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), 0L, new Duration(0.0, TimeUnit.MILLISECONDS), 0L, 0L, 0L), DateTime.now(), this.outputBuffer.getInfo(), (Set)ImmutableSet.of(), this.taskContext.getTaskStats(), Optional.empty(), true);
        }

        public TaskStatus getTaskStatus() {
            TaskStats stats = this.taskContext.getTaskStats();
            PartitionedSplitsInfo combinedSplitsInfo = this.getPartitionedSplitsInfo();
            PartitionedSplitsInfo queuedSplitsInfo = this.getQueuedPartitionedSplitsInfo();
            return new TaskStatus(this.taskStateMachine.getTaskId(), MockRemoteTaskFactory.TASK_INSTANCE_ID, this.nextTaskInfoVersion.get(), this.taskStateMachine.getState(), this.location, this.nodeId, (List)ImmutableList.of(), queuedSplitsInfo.getCount(), combinedSplitsInfo.getCount() - queuedSplitsInfo.getCount(), this.isOutputBufferOverUtilized, stats.getPhysicalWrittenDataSize(), stats.getUserMemoryReservation(), stats.getPeakUserMemoryReservation(), stats.getRevocableMemoryReservation(), 0L, new Duration(0.0, TimeUnit.MILLISECONDS), 0L, queuedSplitsInfo.getWeightSum(), combinedSplitsInfo.getWeightSum() - queuedSplitsInfo.getWeightSum());
        }

        private synchronized void updateSplitQueueSpace() {
            if (this.unacknowledgedSplits < this.maxUnacknowledgedSplits && this.getQueuedPartitionedSplitsInfo().getWeightSum() < 900L) {
                if (!this.whenSplitQueueHasSpace.isDone()) {
                    this.whenSplitQueueHasSpace.set(null);
                }
            } else if (this.whenSplitQueueHasSpace.isDone()) {
                this.whenSplitQueueHasSpace = SettableFuture.create();
            }
        }

        public synchronized void finishSplits(int splits) {
            ArrayList<Map.Entry> toRemove = new ArrayList<Map.Entry>();
            Iterator iterator = this.splits.entries().iterator();
            while (toRemove.size() < splits && iterator.hasNext()) {
                toRemove.add((Map.Entry)iterator.next());
            }
            for (Map.Entry entry : toRemove) {
                this.splits.remove(entry.getKey(), entry.getValue());
            }
            this.updateSplitQueueSpace();
        }

        public synchronized void clearSplits() {
            this.unacknowledgedSplits = 0;
            this.splits.clear();
            this.partitionedSplitCountTracker.setPartitionedSplits(PartitionedSplitsInfo.forZeroSplits());
            this.runningDrivers = 0;
            this.updateSplitQueueSpace();
        }

        public synchronized void setMaxUnacknowledgedSplits(int maxUnacknowledgedSplits) {
            Preconditions.checkArgument((maxUnacknowledgedSplits > 0 ? 1 : 0) != 0);
            this.maxUnacknowledgedSplits = maxUnacknowledgedSplits;
            this.updateSplitQueueSpace();
        }

        public synchronized void setUnacknowledgedSplits(int unacknowledgedSplits) {
            Preconditions.checkArgument((unacknowledgedSplits >= 0 ? 1 : 0) != 0);
            this.unacknowledgedSplits = unacknowledgedSplits;
            this.updateSplitQueueSpace();
        }

        public synchronized void startSplits(int maxRunning) {
            this.runningDrivers = this.splits.size();
            this.runningDrivers = Math.min(this.runningDrivers, maxRunning);
            this.updateSplitQueueSpace();
        }

        public synchronized void setOutputBufferOverUtilized(boolean isOutputBufferOverUtilized) {
            this.isOutputBufferOverUtilized = isOutputBufferOverUtilized;
        }

        public void start() {
            this.taskStateMachine.addStateChangeListener(newValue -> {
                if (newValue.isDone()) {
                    this.clearSplits();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSplits(Multimap<PlanNodeId, Split> splits) {
            MockRemoteTask mockRemoteTask = this;
            synchronized (mockRemoteTask) {
                this.splits.putAll(splits);
            }
            this.partitionedSplitCountTracker.setPartitionedSplits(this.getPartitionedSplitsInfo());
            this.updateSplitQueueSpace();
        }

        public synchronized void noMoreSplits(PlanNodeId sourceId) {
            this.noMoreSplits.add(sourceId);
            boolean allSourcesComplete = Stream.concat(this.fragment.getPartitionedSourceNodes().stream(), this.fragment.getRemoteSourceNodes().stream()).filter(Objects::nonNull).map(PlanNode::getId).allMatch(this.noMoreSplits::contains);
            if (allSourcesComplete) {
                this.taskStateMachine.finished();
            }
        }

        public void setOutputBuffers(OutputBuffers outputBuffers) {
            this.outputBuffer.setOutputBuffers(outputBuffers);
        }

        public void addStateChangeListener(StateMachine.StateChangeListener<TaskStatus> stateChangeListener) {
            this.taskStateMachine.addStateChangeListener(newValue -> stateChangeListener.stateChanged((Object)this.getTaskStatus()));
        }

        public void addFinalTaskInfoListener(StateMachine.StateChangeListener<TaskInfo> stateChangeListener) {
            AtomicBoolean done = new AtomicBoolean();
            StateMachine.StateChangeListener fireOnceStateChangeListener = state -> {
                if (state.isDone() && done.compareAndSet(false, true)) {
                    stateChangeListener.stateChanged((Object)this.getTaskInfo());
                }
            };
            this.taskStateMachine.addStateChangeListener(fireOnceStateChangeListener);
            fireOnceStateChangeListener.stateChanged((Object)this.taskStateMachine.getState());
        }

        public synchronized ListenableFuture<Void> whenSplitQueueHasSpace(long weightThreshold) {
            return Futures.nonCancellationPropagating(this.whenSplitQueueHasSpace);
        }

        public void cancel() {
            this.taskStateMachine.cancel();
        }

        public void abort() {
            this.taskStateMachine.abort();
            this.clearSplits();
        }

        public void fail(Throwable cause) {
            this.taskStateMachine.failed(cause);
            this.clearSplits();
        }

        public void failRemotely(Throwable cause) {
            this.taskStateMachine.failed(cause);
            this.clearSplits();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PartitionedSplitsInfo getPartitionedSplitsInfo() {
            if (this.taskStateMachine.getState().isDone()) {
                return PartitionedSplitsInfo.forZeroSplits();
            }
            MockRemoteTask mockRemoteTask = this;
            synchronized (mockRemoteTask) {
                int count = 0;
                long weight = 0L;
                for (PlanNodeId tableScanPlanNodeId : this.fragment.getPartitionedSources()) {
                    Collection partitionedSplits = this.splits.get((Object)tableScanPlanNodeId);
                    count += partitionedSplits.size();
                    weight = Math.addExact(weight, SplitWeight.rawValueSum((Collection)partitionedSplits, Split::getSplitWeight));
                }
                return PartitionedSplitsInfo.forSplitCountAndWeightSum((int)count, (long)weight);
            }
        }

        public synchronized PartitionedSplitsInfo getQueuedPartitionedSplitsInfo() {
            if (this.taskStateMachine.getState().isDone()) {
                return PartitionedSplitsInfo.forZeroSplits();
            }
            int remainingRunning = this.runningDrivers;
            int queuedCount = 0;
            long queuedWeight = 0L;
            for (PlanNodeId tableScanPlanNodeId : this.fragment.getPartitionedSources()) {
                for (Split split : this.splits.get((Object)tableScanPlanNodeId)) {
                    if (remainingRunning > 0) {
                        --remainingRunning;
                        continue;
                    }
                    ++queuedCount;
                    queuedWeight = Math.addExact(queuedWeight, split.getSplitWeight().getRawValue());
                }
            }
            return PartitionedSplitsInfo.forSplitCountAndWeightSum((int)queuedCount, (long)queuedWeight);
        }

        public synchronized int getUnacknowledgedPartitionedSplitCount() {
            return this.unacknowledgedSplits;
        }
    }
}

