/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.airlift.concurrent.MoreFutures;
import io.trino.Session;
import io.trino.connector.CatalogHandle;
import io.trino.connector.MockConnectorFactory;
import io.trino.eventlistener.EventListenerConfig;
import io.trino.eventlistener.EventListenerManager;
import io.trino.execution.CreateTableTask;
import io.trino.metadata.AbstractMockMetadata;
import io.trino.metadata.ColumnPropertyManager;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableMetadata;
import io.trino.metadata.TablePropertyManager;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorCapabilities;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.QueryUtil;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.planner.TestingConnectorTransactionHandle;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.tree.ColumnDefinition;
import io.trino.sql.tree.CreateTable;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.LikeClause;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.StringLiteral;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingHandles;
import io.trino.testing.TestingMetadata;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.transaction.TransactionManager;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestCreateTableTask {
    private static final String OTHER_CATALOG_NAME = "other_catalog";
    private static final CatalogHandle OTHER_CATALOG_HANDLE = TestingHandles.createTestCatalogHandle((String)"other_catalog");
    private static final ConnectorTableMetadata PARENT_TABLE = new ConnectorTableMetadata(new SchemaTableName("schema", "parent_table"), List.of(new ColumnMetadata("a", (Type)SmallintType.SMALLINT), new ColumnMetadata("b", (Type)BigintType.BIGINT)), Map.of("baz", "property_value"));
    private LocalQueryRunner queryRunner;
    private Session testSession;
    private MockMetadata metadata;
    private PlannerContext plannerContext;
    private TransactionManager transactionManager;
    private ColumnPropertyManager columnPropertyManager;
    private TablePropertyManager tablePropertyManager;

    @BeforeMethod
    public void setUp() {
        this.queryRunner = LocalQueryRunner.create((Session)TestingSession.testSessionBuilder().setCatalog("test-catalog").build());
        this.transactionManager = this.queryRunner.getTransactionManager();
        this.queryRunner.createCatalog("test-catalog", (ConnectorFactory)MockConnectorFactory.builder().withTableProperties(() -> ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"baz", (String)"test property", null, (boolean)false))).build(), (Map)ImmutableMap.of());
        this.queryRunner.createCatalog(OTHER_CATALOG_NAME, (ConnectorFactory)MockConnectorFactory.builder().withName("other_mock").build(), (Map)ImmutableMap.of());
        this.tablePropertyManager = this.queryRunner.getTablePropertyManager();
        this.columnPropertyManager = this.queryRunner.getColumnPropertyManager();
        this.testSession = Session.builder((Session)this.queryRunner.getDefaultSession()).setTransactionId(this.transactionManager.beginTransaction(false)).build();
        this.metadata = new MockMetadata();
        this.plannerContext = TestingPlannerContext.plannerContextBuilder().withMetadata(this.metadata).build();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        if (this.queryRunner != null) {
            this.queryRunner.close();
        }
    }

    @Test
    public void testCreateTableNotExistsTrue() {
        CreateTable statement = new CreateTable(QualifiedName.of((String)"test_table"), (List)ImmutableList.of((Object)new ColumnDefinition(QueryUtil.identifier((String)"a"), TypeSignatureTranslator.toSqlType((Type)BigintType.BIGINT), true, Collections.emptyList(), Optional.empty())), true, (List)ImmutableList.of(), Optional.empty());
        CreateTableTask createTableTask = new CreateTableTask(this.plannerContext, (AccessControl)new AllowAllAccessControl(), this.columnPropertyManager, this.tablePropertyManager);
        MoreFutures.getFutureValue((Future)createTableTask.internalExecute(statement, this.testSession, Collections.emptyList(), output -> {}));
        Assert.assertEquals((int)this.metadata.getCreateTableCallCount(), (int)1);
    }

    @Test
    public void testCreateTableNotExistsFalse() {
        CreateTable statement = new CreateTable(QualifiedName.of((String)"test_table"), (List)ImmutableList.of((Object)new ColumnDefinition(QueryUtil.identifier((String)"a"), TypeSignatureTranslator.toSqlType((Type)BigintType.BIGINT), true, Collections.emptyList(), Optional.empty())), false, (List)ImmutableList.of(), Optional.empty());
        CreateTableTask createTableTask = new CreateTableTask(this.plannerContext, (AccessControl)new AllowAllAccessControl(), this.columnPropertyManager, this.tablePropertyManager);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue((Future)createTableTask.internalExecute(statement, this.testSession, Collections.emptyList(), output -> {}))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS).hasMessage("Table already exists");
        Assert.assertEquals((int)this.metadata.getCreateTableCallCount(), (int)1);
    }

    @Test
    public void testCreateTableWithMaterializedViewPropertyFails() {
        CreateTable statement = new CreateTable(QualifiedName.of((String)"test_table"), (List)ImmutableList.of((Object)new ColumnDefinition(QueryUtil.identifier((String)"a"), TypeSignatureTranslator.toSqlType((Type)BigintType.BIGINT), true, Collections.emptyList(), Optional.empty())), false, (List)ImmutableList.of((Object)new Property(new Identifier("foo"), (Expression)new StringLiteral("bar"))), Optional.empty());
        CreateTableTask createTableTask = new CreateTableTask(this.plannerContext, (AccessControl)new AllowAllAccessControl(), this.columnPropertyManager, this.tablePropertyManager);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue((Future)createTableTask.internalExecute(statement, this.testSession, Collections.emptyList(), output -> {}))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY).hasMessage("Catalog 'test-catalog' table property 'foo' does not exist");
        Assert.assertEquals((int)this.metadata.getCreateTableCallCount(), (int)0);
    }

    @Test
    public void testCreateWithNotNullColumns() {
        this.metadata.setConnectorCapabilities(ConnectorCapabilities.NOT_NULL_COLUMN_CONSTRAINT);
        ImmutableList inputColumns = ImmutableList.of((Object)new ColumnDefinition(QueryUtil.identifier((String)"a"), TypeSignatureTranslator.toSqlType((Type)DateType.DATE), true, Collections.emptyList(), Optional.empty()), (Object)new ColumnDefinition(QueryUtil.identifier((String)"b"), TypeSignatureTranslator.toSqlType((Type)VarcharType.VARCHAR), false, Collections.emptyList(), Optional.empty()), (Object)new ColumnDefinition(QueryUtil.identifier((String)"c"), TypeSignatureTranslator.toSqlType((Type)VarbinaryType.VARBINARY), false, Collections.emptyList(), Optional.empty()));
        CreateTable statement = new CreateTable(QualifiedName.of((String)"test_table"), (List)inputColumns, true, (List)ImmutableList.of(), Optional.empty());
        CreateTableTask createTableTask = new CreateTableTask(this.plannerContext, (AccessControl)new AllowAllAccessControl(), this.columnPropertyManager, this.tablePropertyManager);
        MoreFutures.getFutureValue((Future)createTableTask.internalExecute(statement, this.testSession, Collections.emptyList(), output -> {}));
        Assert.assertEquals((int)this.metadata.getCreateTableCallCount(), (int)1);
        List columns = this.metadata.getReceivedTableMetadata().get(0).getColumns();
        Assert.assertEquals((int)columns.size(), (int)3);
        Assert.assertEquals((String)((ColumnMetadata)columns.get(0)).getName(), (String)"a");
        Assert.assertEquals((String)((ColumnMetadata)columns.get(0)).getType().getDisplayName().toUpperCase(Locale.ENGLISH), (String)"DATE");
        Assert.assertTrue((boolean)((ColumnMetadata)columns.get(0)).isNullable());
        Assert.assertEquals((String)((ColumnMetadata)columns.get(1)).getName(), (String)"b");
        Assert.assertEquals((String)((ColumnMetadata)columns.get(1)).getType().getDisplayName().toUpperCase(Locale.ENGLISH), (String)"VARCHAR");
        Assert.assertFalse((boolean)((ColumnMetadata)columns.get(1)).isNullable());
        Assert.assertEquals((String)((ColumnMetadata)columns.get(2)).getName(), (String)"c");
        Assert.assertEquals((String)((ColumnMetadata)columns.get(2)).getType().getDisplayName().toUpperCase(Locale.ENGLISH), (String)"VARBINARY");
        Assert.assertFalse((boolean)((ColumnMetadata)columns.get(2)).isNullable());
    }

    @Test
    public void testCreateWithUnsupportedConnectorThrowsWhenNotNull() {
        ImmutableList inputColumns = ImmutableList.of((Object)new ColumnDefinition(QueryUtil.identifier((String)"a"), TypeSignatureTranslator.toSqlType((Type)DateType.DATE), true, Collections.emptyList(), Optional.empty()), (Object)new ColumnDefinition(QueryUtil.identifier((String)"b"), TypeSignatureTranslator.toSqlType((Type)VarcharType.VARCHAR), false, Collections.emptyList(), Optional.empty()), (Object)new ColumnDefinition(QueryUtil.identifier((String)"c"), TypeSignatureTranslator.toSqlType((Type)VarbinaryType.VARBINARY), false, Collections.emptyList(), Optional.empty()));
        CreateTable statement = new CreateTable(QualifiedName.of((String)"test_table"), (List)inputColumns, true, (List)ImmutableList.of(), Optional.empty());
        CreateTableTask createTableTask = new CreateTableTask(this.plannerContext, (AccessControl)new AllowAllAccessControl(), this.columnPropertyManager, this.tablePropertyManager);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue((Future)createTableTask.internalExecute(statement, this.testSession, Collections.emptyList(), output -> {}))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED).hasMessage("Catalog 'test-catalog' does not support non-null column for column name 'b'");
    }

    @Test
    public void testCreateLike() {
        CreateTable statement = TestCreateTableTask.getCreateLikeStatement(false);
        CreateTableTask createTableTask = new CreateTableTask(this.plannerContext, (AccessControl)new AllowAllAccessControl(), this.columnPropertyManager, this.tablePropertyManager);
        MoreFutures.getFutureValue((Future)createTableTask.internalExecute(statement, this.testSession, List.of(), output -> {}));
        Assert.assertEquals((int)this.metadata.getCreateTableCallCount(), (int)1);
        Assertions.assertThat((List)this.metadata.getReceivedTableMetadata().get(0).getColumns()).isEqualTo((Object)PARENT_TABLE.getColumns());
        Assertions.assertThat((Map)this.metadata.getReceivedTableMetadata().get(0).getProperties()).isEmpty();
    }

    @Test
    public void testCreateLikeIncludingProperties() {
        CreateTable statement = TestCreateTableTask.getCreateLikeStatement(true);
        CreateTableTask createTableTask = new CreateTableTask(this.plannerContext, (AccessControl)new AllowAllAccessControl(), this.columnPropertyManager, this.tablePropertyManager);
        MoreFutures.getFutureValue((Future)createTableTask.internalExecute(statement, this.testSession, List.of(), output -> {}));
        Assert.assertEquals((int)this.metadata.getCreateTableCallCount(), (int)1);
        Assertions.assertThat((List)this.metadata.getReceivedTableMetadata().get(0).getColumns()).isEqualTo((Object)PARENT_TABLE.getColumns());
        Assertions.assertThat((Map)this.metadata.getReceivedTableMetadata().get(0).getProperties()).isEqualTo((Object)PARENT_TABLE.getProperties());
    }

    @Test
    public void testCreateLikeExcludingPropertiesAcrossCatalogs() {
        CreateTable statement = TestCreateTableTask.getCreateLikeStatement(QualifiedName.of((String)OTHER_CATALOG_NAME, (String[])new String[]{"other_schema", "test_table"}), false);
        CreateTableTask createTableTask = new CreateTableTask(this.plannerContext, (AccessControl)new AllowAllAccessControl(), this.columnPropertyManager, this.tablePropertyManager);
        MoreFutures.getFutureValue((Future)createTableTask.internalExecute(statement, this.testSession, List.of(), output -> {}));
        Assert.assertEquals((int)this.metadata.getCreateTableCallCount(), (int)1);
        Assertions.assertThat((List)this.metadata.getReceivedTableMetadata().get(0).getColumns()).isEqualTo((Object)PARENT_TABLE.getColumns());
    }

    @Test
    public void testCreateLikeIncludingPropertiesAcrossCatalogs() {
        CreateTable failingStatement = TestCreateTableTask.getCreateLikeStatement(QualifiedName.of((String)OTHER_CATALOG_NAME, (String[])new String[]{"other_schema", "test_table"}), true);
        CreateTableTask failingCreateTableTask = new CreateTableTask(this.plannerContext, (AccessControl)new AllowAllAccessControl(), this.columnPropertyManager, this.tablePropertyManager);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MoreFutures.getFutureValue((Future)failingCreateTableTask.internalExecute(failingStatement, this.testSession, List.of(), output -> {}))).isInstanceOf(TrinoException.class)).hasMessageContaining("CREATE TABLE LIKE table INCLUDING PROPERTIES across catalogs is not supported");
    }

    @Test
    public void testCreateLikeDenyPermission() {
        CreateTable statement = TestCreateTableTask.getCreateLikeStatement(false);
        TestingAccessControlManager accessControl = new TestingAccessControlManager(this.transactionManager, new EventListenerManager(new EventListenerConfig()));
        accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"parent_table", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        CreateTableTask createTableTask = new CreateTableTask(this.plannerContext, (AccessControl)accessControl, this.columnPropertyManager, this.tablePropertyManager);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MoreFutures.getFutureValue((Future)createTableTask.internalExecute(statement, this.testSession, List.of(), output -> {}))).isInstanceOf(AccessDeniedException.class)).hasMessageContaining("Cannot reference columns of table");
    }

    @Test
    public void testCreateLikeIncludingPropertiesDenyPermission() {
        CreateTable statement = TestCreateTableTask.getCreateLikeStatement(true);
        TestingAccessControlManager accessControl = new TestingAccessControlManager(this.transactionManager, new EventListenerManager(new EventListenerConfig()));
        accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"parent_table", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SHOW_CREATE_TABLE)});
        CreateTableTask createTableTask = new CreateTableTask(this.plannerContext, (AccessControl)accessControl, this.columnPropertyManager, this.tablePropertyManager);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MoreFutures.getFutureValue((Future)createTableTask.internalExecute(statement, this.testSession, List.of(), output -> {}))).isInstanceOf(AccessDeniedException.class)).hasMessageContaining("Cannot reference properties of table");
    }

    private static CreateTable getCreateLikeStatement(boolean includingProperties) {
        return TestCreateTableTask.getCreateLikeStatement(QualifiedName.of((String)"test_table"), includingProperties);
    }

    private static CreateTable getCreateLikeStatement(QualifiedName name, boolean includingProperties) {
        return new CreateTable(name, List.of(new LikeClause(QualifiedName.of((String)PARENT_TABLE.getTable().getTableName()), includingProperties ? Optional.of(LikeClause.PropertiesOption.INCLUDING) : Optional.empty())), true, (List)ImmutableList.of(), Optional.empty());
    }

    private static class MockMetadata
    extends AbstractMockMetadata {
        private final List<ConnectorTableMetadata> tables = new CopyOnWriteArrayList<ConnectorTableMetadata>();
        private Set<ConnectorCapabilities> connectorCapabilities = ImmutableSet.of();

        private MockMetadata() {
        }

        @Override
        public void createTable(Session session, String catalogName, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
            this.tables.add(tableMetadata);
            if (!ignoreExisting) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Table already exists");
            }
        }

        @Override
        public Optional<CatalogHandle> getCatalogHandle(Session session, String catalogName) {
            if (catalogName.equals("test-catalog")) {
                return Optional.of(TestingHandles.TEST_CATALOG_HANDLE);
            }
            if (catalogName.equals(TestCreateTableTask.OTHER_CATALOG_NAME)) {
                return Optional.of(OTHER_CATALOG_HANDLE);
            }
            return Optional.empty();
        }

        @Override
        public Optional<TableHandle> getTableHandle(Session session, QualifiedObjectName tableName) {
            if (tableName.asSchemaTableName().equals((Object)PARENT_TABLE.getTable())) {
                return Optional.of(new TableHandle(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorTableHandle)new TestingMetadata.TestingTableHandle(tableName.asSchemaTableName()), (ConnectorTransactionHandle)TestingConnectorTransactionHandle.INSTANCE));
            }
            return Optional.empty();
        }

        @Override
        public TableMetadata getTableMetadata(Session session, TableHandle tableHandle) {
            if (tableHandle.getConnectorHandle() instanceof TestingMetadata.TestingTableHandle && ((TestingMetadata.TestingTableHandle)tableHandle.getConnectorHandle()).getTableName().equals((Object)PARENT_TABLE.getTable())) {
                return new TableMetadata("test-catalog", PARENT_TABLE);
            }
            return super.getTableMetadata(session, tableHandle);
        }

        public int getCreateTableCallCount() {
            return this.tables.size();
        }

        public List<ConnectorTableMetadata> getReceivedTableMetadata() {
            return this.tables;
        }

        @Override
        public Set<ConnectorCapabilities> getConnectorCapabilities(Session session, CatalogHandle catalogHandle) {
            return this.connectorCapabilities;
        }

        public void setConnectorCapabilities(ConnectorCapabilities ... connectorCapabilities) {
            this.connectorCapabilities = Sets.immutableEnumSet((Iterable)ImmutableList.copyOf((Object[])connectorCapabilities));
        }
    }
}

