/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.trino.execution.scheduler.NodeSchedulerConfig;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestNodeSchedulerConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((NodeSchedulerConfig)ConfigAssertions.recordDefaults(NodeSchedulerConfig.class)).setNodeSchedulerPolicy(NodeSchedulerConfig.NodeSchedulerPolicy.UNIFORM.name()).setMinCandidates(10).setMaxSplitsPerNode(100).setMaxPendingSplitsPerTask(10).setMaxUnacknowledgedSplitsPerTask(500).setIncludeCoordinator(true).setSplitsBalancingPolicy(NodeSchedulerConfig.SplitsBalancingPolicy.STAGE).setOptimizedLocalScheduling(true).setAllowedNoMatchingNodePeriod(new Duration(2.0, TimeUnit.MINUTES)).setNodeAllocatorType("bin_packing"));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"node-scheduler.policy", (Object)"topology").put((Object)"node-scheduler.min-candidates", (Object)"11").put((Object)"node-scheduler.include-coordinator", (Object)"false").put((Object)"node-scheduler.max-pending-splits-per-task", (Object)"11").put((Object)"node-scheduler.max-splits-per-node", (Object)"101").put((Object)"node-scheduler.max-unacknowledged-splits-per-task", (Object)"501").put((Object)"node-scheduler.splits-balancing-policy", (Object)"node").put((Object)"node-scheduler.optimized-local-scheduling", (Object)"false").put((Object)"node-scheduler.allowed-no-matching-node-period", (Object)"1m").put((Object)"node-scheduler.allocator-type", (Object)"fixed_count").buildOrThrow();
        NodeSchedulerConfig expected = new NodeSchedulerConfig().setNodeSchedulerPolicy("topology").setIncludeCoordinator(false).setMaxSplitsPerNode(101).setMaxPendingSplitsPerTask(11).setMaxUnacknowledgedSplitsPerTask(501).setMinCandidates(11).setSplitsBalancingPolicy(NodeSchedulerConfig.SplitsBalancingPolicy.NODE).setOptimizedLocalScheduling(false).setAllowedNoMatchingNodePeriod(new Duration(1.0, TimeUnit.MINUTES)).setNodeAllocatorType("fixed_count");
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

