/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.testing.TestingTicker;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.client.FailureInfo;
import io.trino.eventlistener.EventListenerManager;
import io.trino.execution.Column;
import io.trino.execution.Input;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryState;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.QueryStats;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.plugin.base.security.AllowAllSystemAccessControl;
import io.trino.security.AccessControl;
import io.trino.security.AccessControlConfig;
import io.trino.security.AccessControlManager;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.resourcegroups.QueryType;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.Output;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.TestingEventListenerManager;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionManager;
import java.io.IOException;
import java.net.URI;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestQueryStateMachine {
    private static final String QUERY = "sql";
    private static final URI LOCATION = URI.create("fake://fake-query");
    private static final SQLException FAILED_CAUSE = new SQLException("FAILED");
    private static final List<Input> INPUTS = ImmutableList.of((Object)new Input("connector", "schema", "table", Optional.empty(), (List)ImmutableList.of((Object)new Column("a", "varchar")), new PlanFragmentId("fragment"), new PlanNodeId("plan-node")));
    private static final Optional<Output> OUTPUT = Optional.empty();
    private static final List<String> OUTPUT_FIELD_NAMES = ImmutableList.of((Object)"a", (Object)"b", (Object)"c");
    private static final List<Type> OUTPUT_FIELD_TYPES = ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
    private static final String UPDATE_TYPE = "update type";
    private static final Map<String, String> SET_SESSION_PROPERTIES = ImmutableMap.builder().put((Object)"fruit", (Object)"apple").put((Object)"drink", (Object)"coffee").buildOrThrow();
    private static final List<String> RESET_SESSION_PROPERTIES = ImmutableList.of((Object)"candy");
    private static final Optional<QueryType> QUERY_TYPE = Optional.of(QueryType.SELECT);
    private ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "=%s")));

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.executor = null;
    }

    @Test
    public void testBasicStateChanges() {
        QueryStateMachine stateMachine = this.createQueryStateMachine();
        TestQueryStateMachine.assertState(stateMachine, QueryState.QUEUED);
        Assert.assertTrue((boolean)stateMachine.transitionToDispatching());
        TestQueryStateMachine.assertState(stateMachine, QueryState.DISPATCHING);
        Assert.assertTrue((boolean)stateMachine.transitionToPlanning());
        TestQueryStateMachine.assertState(stateMachine, QueryState.PLANNING);
        Assert.assertTrue((boolean)stateMachine.transitionToStarting());
        TestQueryStateMachine.assertState(stateMachine, QueryState.STARTING);
        Assert.assertTrue((boolean)stateMachine.transitionToRunning());
        TestQueryStateMachine.assertState(stateMachine, QueryState.RUNNING);
        Assert.assertTrue((boolean)stateMachine.transitionToFinishing());
        TestQueryStateMachine.assertState(stateMachine, QueryState.FINISHING);
        stateMachine.resultsConsumed();
        MoreFutures.tryGetFutureValue((Future)stateMachine.getStateChange(QueryState.FINISHING), (int)2, (TimeUnit)TimeUnit.SECONDS);
        TestQueryStateMachine.assertState(stateMachine, QueryState.FINISHED);
    }

    @Test
    public void testStateChangesWithResourceWaiting() {
        QueryStateMachine stateMachine = this.createQueryStateMachine();
        TestQueryStateMachine.assertState(stateMachine, QueryState.QUEUED);
        Assert.assertTrue((boolean)stateMachine.transitionToWaitingForResources());
        TestQueryStateMachine.assertState(stateMachine, QueryState.WAITING_FOR_RESOURCES);
        Assert.assertTrue((boolean)stateMachine.transitionToDispatching());
        TestQueryStateMachine.assertState(stateMachine, QueryState.DISPATCHING);
        Assert.assertTrue((boolean)stateMachine.transitionToPlanning());
        TestQueryStateMachine.assertState(stateMachine, QueryState.PLANNING);
        Assert.assertTrue((boolean)stateMachine.transitionToStarting());
        TestQueryStateMachine.assertState(stateMachine, QueryState.STARTING);
        Assert.assertTrue((boolean)stateMachine.transitionToRunning());
        TestQueryStateMachine.assertState(stateMachine, QueryState.RUNNING);
        Assert.assertTrue((boolean)stateMachine.transitionToFinishing());
        stateMachine.resultsConsumed();
        MoreFutures.tryGetFutureValue((Future)stateMachine.getStateChange(QueryState.FINISHING), (int)2, (TimeUnit)TimeUnit.SECONDS);
        TestQueryStateMachine.assertState(stateMachine, QueryState.FINISHED);
    }

    @Test
    public void testQueued() {
        this.assertAllTimeSpentInQueueing(QueryState.QUEUED, queryStateMachine -> {});
        this.assertAllTimeSpentInQueueing(QueryState.WAITING_FOR_RESOURCES, QueryStateMachine::transitionToWaitingForResources);
        this.assertAllTimeSpentInQueueing(QueryState.DISPATCHING, QueryStateMachine::transitionToDispatching);
        this.assertAllTimeSpentInQueueing(QueryState.PLANNING, QueryStateMachine::transitionToPlanning);
        this.assertAllTimeSpentInQueueing(QueryState.STARTING, QueryStateMachine::transitionToStarting);
        this.assertAllTimeSpentInQueueing(QueryState.RUNNING, QueryStateMachine::transitionToRunning);
        this.assertAllTimeSpentInQueueing(QueryState.FINISHED, stateMachine -> {
            stateMachine.resultsConsumed();
            stateMachine.transitionToFinishing();
            MoreFutures.tryGetFutureValue((Future)stateMachine.getStateChange(QueryState.FINISHING), (int)2, (TimeUnit)TimeUnit.SECONDS);
        });
        this.assertAllTimeSpentInQueueing(QueryState.FAILED, stateMachine -> stateMachine.transitionToFailed((Throwable)FAILED_CAUSE));
    }

    private void assertAllTimeSpentInQueueing(QueryState expectedState, Consumer<QueryStateMachine> stateTransition) {
        TestingTicker ticker = new TestingTicker();
        QueryStateMachine stateMachine = this.createQueryStateMachineWithTicker((Ticker)ticker);
        ticker.increment(7L, TimeUnit.MILLISECONDS);
        stateTransition.accept(stateMachine);
        Assert.assertEquals((Object)stateMachine.getQueryState(), (Object)expectedState);
        QueryStats queryStats = stateMachine.getQueryInfo(Optional.empty()).getQueryStats();
        Assert.assertEquals((Object)queryStats.getQueuedTime(), (Object)new Duration(7.0, TimeUnit.MILLISECONDS));
        Assert.assertEquals((Object)queryStats.getResourceWaitingTime(), (Object)new Duration(0.0, TimeUnit.MILLISECONDS));
        Assert.assertEquals((Object)queryStats.getDispatchingTime(), (Object)new Duration(0.0, TimeUnit.MILLISECONDS));
        Assert.assertEquals((Object)queryStats.getPlanningTime(), (Object)new Duration(0.0, TimeUnit.MILLISECONDS));
        Assert.assertEquals((Object)queryStats.getExecutionTime(), (Object)new Duration(0.0, TimeUnit.MILLISECONDS));
        Assert.assertEquals((Object)queryStats.getFinishingTime(), (Object)new Duration(0.0, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testPlanning() {
        QueryStateMachine stateMachine = this.createQueryStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToPlanning());
        TestQueryStateMachine.assertState(stateMachine, QueryState.PLANNING);
        Assert.assertFalse((boolean)stateMachine.transitionToDispatching());
        TestQueryStateMachine.assertState(stateMachine, QueryState.PLANNING);
        Assert.assertFalse((boolean)stateMachine.transitionToPlanning());
        TestQueryStateMachine.assertState(stateMachine, QueryState.PLANNING);
        Assert.assertTrue((boolean)stateMachine.transitionToStarting());
        TestQueryStateMachine.assertState(stateMachine, QueryState.STARTING);
        stateMachine = this.createQueryStateMachine();
        stateMachine.transitionToPlanning();
        Assert.assertTrue((boolean)stateMachine.transitionToRunning());
        TestQueryStateMachine.assertState(stateMachine, QueryState.RUNNING);
        stateMachine = this.createQueryStateMachine();
        stateMachine.transitionToPlanning();
        Assert.assertTrue((boolean)stateMachine.transitionToFinishing());
        stateMachine.resultsConsumed();
        MoreFutures.tryGetFutureValue((Future)stateMachine.getStateChange(QueryState.FINISHING), (int)2, (TimeUnit)TimeUnit.SECONDS);
        TestQueryStateMachine.assertState(stateMachine, QueryState.FINISHED);
        stateMachine = this.createQueryStateMachine();
        stateMachine.transitionToPlanning();
        Assert.assertTrue((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE));
        TestQueryStateMachine.assertState(stateMachine, QueryState.FAILED, FAILED_CAUSE);
    }

    @Test
    public void testStarting() {
        QueryStateMachine stateMachine = this.createQueryStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToStarting());
        TestQueryStateMachine.assertState(stateMachine, QueryState.STARTING);
        Assert.assertFalse((boolean)stateMachine.transitionToDispatching());
        TestQueryStateMachine.assertState(stateMachine, QueryState.STARTING);
        Assert.assertFalse((boolean)stateMachine.transitionToPlanning());
        TestQueryStateMachine.assertState(stateMachine, QueryState.STARTING);
        Assert.assertFalse((boolean)stateMachine.transitionToStarting());
        TestQueryStateMachine.assertState(stateMachine, QueryState.STARTING);
        Assert.assertTrue((boolean)stateMachine.transitionToRunning());
        TestQueryStateMachine.assertState(stateMachine, QueryState.RUNNING);
        stateMachine = this.createQueryStateMachine();
        stateMachine.transitionToStarting();
        stateMachine.resultsConsumed();
        Assert.assertTrue((boolean)stateMachine.transitionToFinishing());
        MoreFutures.tryGetFutureValue((Future)stateMachine.getStateChange(QueryState.FINISHING), (int)2, (TimeUnit)TimeUnit.SECONDS);
        TestQueryStateMachine.assertState(stateMachine, QueryState.FINISHED);
        stateMachine = this.createQueryStateMachine();
        stateMachine.transitionToStarting();
        Assert.assertTrue((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE));
        TestQueryStateMachine.assertState(stateMachine, QueryState.FAILED, FAILED_CAUSE);
    }

    @Test
    public void testRunning() {
        QueryStateMachine stateMachine = this.createQueryStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToRunning());
        TestQueryStateMachine.assertState(stateMachine, QueryState.RUNNING);
        Assert.assertFalse((boolean)stateMachine.transitionToDispatching());
        TestQueryStateMachine.assertState(stateMachine, QueryState.RUNNING);
        Assert.assertFalse((boolean)stateMachine.transitionToPlanning());
        TestQueryStateMachine.assertState(stateMachine, QueryState.RUNNING);
        Assert.assertFalse((boolean)stateMachine.transitionToStarting());
        TestQueryStateMachine.assertState(stateMachine, QueryState.RUNNING);
        Assert.assertFalse((boolean)stateMachine.transitionToRunning());
        TestQueryStateMachine.assertState(stateMachine, QueryState.RUNNING);
        stateMachine.resultsConsumed();
        Assert.assertTrue((boolean)stateMachine.transitionToFinishing());
        MoreFutures.tryGetFutureValue((Future)stateMachine.getStateChange(QueryState.FINISHING), (int)2, (TimeUnit)TimeUnit.SECONDS);
        TestQueryStateMachine.assertState(stateMachine, QueryState.FINISHED);
        stateMachine = this.createQueryStateMachine();
        stateMachine.transitionToRunning();
        Assert.assertTrue((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE));
        TestQueryStateMachine.assertState(stateMachine, QueryState.FAILED, FAILED_CAUSE);
    }

    @Test
    public void testFinished() {
        QueryStateMachine stateMachine = this.createQueryStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToFinishing());
        TestQueryStateMachine.assertState(stateMachine, QueryState.FINISHING);
        stateMachine.resultsConsumed();
        MoreFutures.tryGetFutureValue((Future)stateMachine.getStateChange(QueryState.FINISHING), (int)2, (TimeUnit)TimeUnit.SECONDS);
        TestQueryStateMachine.assertFinalState(stateMachine, QueryState.FINISHED);
    }

    @Test
    public void testFailed() {
        QueryStateMachine stateMachine = this.createQueryStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE));
        TestQueryStateMachine.assertFinalState(stateMachine, QueryState.FAILED, FAILED_CAUSE);
    }

    @Test
    public void testCanceled() {
        QueryStateMachine stateMachine = this.createQueryStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToCanceled());
        TestQueryStateMachine.assertFinalState(stateMachine, QueryState.FAILED, (Exception)((Object)new TrinoException((ErrorCodeSupplier)StandardErrorCode.USER_CANCELED, "canceled")));
    }

    @Test
    public void testPlanningTimeDuration() {
        TestingTicker mockTicker = new TestingTicker();
        QueryStateMachine stateMachine = this.createQueryStateMachineWithTicker((Ticker)mockTicker);
        TestQueryStateMachine.assertState(stateMachine, QueryState.QUEUED);
        mockTicker.increment(25L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)stateMachine.transitionToWaitingForResources());
        TestQueryStateMachine.assertState(stateMachine, QueryState.WAITING_FOR_RESOURCES);
        mockTicker.increment(50L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)stateMachine.transitionToDispatching());
        TestQueryStateMachine.assertState(stateMachine, QueryState.DISPATCHING);
        mockTicker.increment(100L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)stateMachine.transitionToPlanning());
        TestQueryStateMachine.assertState(stateMachine, QueryState.PLANNING);
        mockTicker.increment(200L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)stateMachine.transitionToStarting());
        TestQueryStateMachine.assertState(stateMachine, QueryState.STARTING);
        mockTicker.increment(300L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)stateMachine.transitionToRunning());
        TestQueryStateMachine.assertState(stateMachine, QueryState.RUNNING);
        mockTicker.increment(400L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)stateMachine.transitionToFinishing());
        stateMachine.resultsConsumed();
        MoreFutures.tryGetFutureValue((Future)stateMachine.getStateChange(QueryState.FINISHING), (int)2, (TimeUnit)TimeUnit.SECONDS);
        TestQueryStateMachine.assertState(stateMachine, QueryState.FINISHED);
        QueryStats queryStats = stateMachine.getQueryInfo(Optional.empty()).getQueryStats();
        Assert.assertEquals((long)queryStats.getElapsedTime().toMillis(), (long)1075L);
        Assert.assertEquals((long)queryStats.getQueuedTime().toMillis(), (long)25L);
        Assert.assertEquals((long)queryStats.getResourceWaitingTime().toMillis(), (long)50L);
        Assert.assertEquals((long)queryStats.getDispatchingTime().toMillis(), (long)100L);
        Assert.assertEquals((long)queryStats.getPlanningTime().toMillis(), (long)200L);
        Assert.assertEquals((long)queryStats.getFinishingTime().toMillis(), (long)0L);
        Assert.assertEquals((long)queryStats.getExecutionTime().toMillis(), (long)900L);
    }

    @Test
    public void testUpdateMemoryUsage() {
        QueryStateMachine stateMachine = this.createQueryStateMachine();
        stateMachine.updateMemoryUsage(5L, 15L, 10L, 1L, 5L, 3L);
        Assert.assertEquals((long)stateMachine.getPeakUserMemoryInBytes(), (long)5L);
        Assert.assertEquals((long)stateMachine.getPeakTotalMemoryInBytes(), (long)10L);
        Assert.assertEquals((long)stateMachine.getPeakRevocableMemoryInBytes(), (long)15L);
        Assert.assertEquals((long)stateMachine.getPeakTaskUserMemory(), (long)1L);
        Assert.assertEquals((long)stateMachine.getPeakTaskTotalMemory(), (long)3L);
        Assert.assertEquals((long)stateMachine.getPeakTaskRevocableMemory(), (long)5L);
        stateMachine.updateMemoryUsage(0L, 0L, 0L, 2L, 2L, 2L);
        Assert.assertEquals((long)stateMachine.getPeakUserMemoryInBytes(), (long)5L);
        Assert.assertEquals((long)stateMachine.getPeakTotalMemoryInBytes(), (long)10L);
        Assert.assertEquals((long)stateMachine.getPeakRevocableMemoryInBytes(), (long)15L);
        Assert.assertEquals((long)stateMachine.getPeakTaskUserMemory(), (long)2L);
        Assert.assertEquals((long)stateMachine.getPeakTaskTotalMemory(), (long)3L);
        Assert.assertEquals((long)stateMachine.getPeakTaskRevocableMemory(), (long)5L);
        stateMachine.updateMemoryUsage(1L, 1L, 1L, 1L, 10L, 5L);
        Assert.assertEquals((long)stateMachine.getPeakUserMemoryInBytes(), (long)6L);
        Assert.assertEquals((long)stateMachine.getPeakTotalMemoryInBytes(), (long)11L);
        Assert.assertEquals((long)stateMachine.getPeakRevocableMemoryInBytes(), (long)16L);
        Assert.assertEquals((long)stateMachine.getPeakTaskUserMemory(), (long)2L);
        Assert.assertEquals((long)stateMachine.getPeakTaskTotalMemory(), (long)5L);
        Assert.assertEquals((long)stateMachine.getPeakTaskRevocableMemory(), (long)10L);
        stateMachine.updateMemoryUsage(3L, 3L, 3L, 5L, 1L, 2L);
        Assert.assertEquals((long)stateMachine.getPeakUserMemoryInBytes(), (long)9L);
        Assert.assertEquals((long)stateMachine.getPeakTotalMemoryInBytes(), (long)14L);
        Assert.assertEquals((long)stateMachine.getPeakRevocableMemoryInBytes(), (long)19L);
        Assert.assertEquals((long)stateMachine.getPeakTaskUserMemory(), (long)5L);
        Assert.assertEquals((long)stateMachine.getPeakTaskTotalMemory(), (long)5L);
        Assert.assertEquals((long)stateMachine.getPeakTaskRevocableMemory(), (long)10L);
    }

    private static void assertFinalState(QueryStateMachine stateMachine, QueryState expectedState) {
        TestQueryStateMachine.assertFinalState(stateMachine, expectedState, null);
    }

    private static void assertFinalState(QueryStateMachine stateMachine, QueryState expectedState, Exception expectedException) {
        Assert.assertTrue((boolean)expectedState.isDone());
        TestQueryStateMachine.assertState(stateMachine, expectedState, expectedException);
        Assert.assertFalse((boolean)stateMachine.transitionToDispatching());
        TestQueryStateMachine.assertState(stateMachine, expectedState, expectedException);
        Assert.assertFalse((boolean)stateMachine.transitionToPlanning());
        TestQueryStateMachine.assertState(stateMachine, expectedState, expectedException);
        Assert.assertFalse((boolean)stateMachine.transitionToStarting());
        TestQueryStateMachine.assertState(stateMachine, expectedState, expectedException);
        Assert.assertFalse((boolean)stateMachine.transitionToRunning());
        TestQueryStateMachine.assertState(stateMachine, expectedState, expectedException);
        Assert.assertFalse((boolean)stateMachine.transitionToFinishing());
        TestQueryStateMachine.assertState(stateMachine, expectedState, expectedException);
        Assert.assertFalse((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE));
        TestQueryStateMachine.assertState(stateMachine, expectedState, expectedException);
        Assert.assertFalse((boolean)stateMachine.transitionToFailed((Throwable)new IOException("failure after finish")));
        TestQueryStateMachine.assertState(stateMachine, expectedState, expectedException);
    }

    private static void assertState(QueryStateMachine stateMachine, QueryState expectedState) {
        TestQueryStateMachine.assertState(stateMachine, expectedState, null);
    }

    private static void assertState(QueryStateMachine stateMachine, QueryState expectedState, Exception expectedException) {
        Assert.assertEquals((Object)stateMachine.getQueryId(), (Object)SessionTestUtils.TEST_SESSION.getQueryId());
        TestQueryStateMachine.assertEqualSessionsWithoutTransactionId(stateMachine.getSession(), SessionTestUtils.TEST_SESSION);
        Assert.assertEquals((Map)stateMachine.getSetSessionProperties(), SET_SESSION_PROPERTIES);
        Assert.assertEquals((Collection)stateMachine.getResetSessionProperties(), RESET_SESSION_PROPERTIES);
        QueryInfo queryInfo = stateMachine.getQueryInfo(Optional.empty());
        Assert.assertEquals((Object)queryInfo.getQueryId(), (Object)SessionTestUtils.TEST_SESSION.getQueryId());
        Assert.assertEquals((Object)queryInfo.getSelf(), (Object)LOCATION);
        Assert.assertFalse((boolean)queryInfo.getOutputStage().isPresent());
        Assert.assertEquals((String)queryInfo.getQuery(), (String)QUERY);
        Assert.assertEquals((Collection)queryInfo.getInputs(), INPUTS);
        Assert.assertEquals((Object)queryInfo.getOutput(), OUTPUT);
        Assert.assertEquals((Collection)queryInfo.getFieldNames(), OUTPUT_FIELD_NAMES);
        Assert.assertEquals((String)queryInfo.getUpdateType(), (String)UPDATE_TYPE);
        Assert.assertTrue((boolean)queryInfo.getQueryType().isPresent());
        Assert.assertEquals(queryInfo.getQueryType().get(), (Object)QUERY_TYPE.get());
        QueryStats queryStats = queryInfo.getQueryStats();
        Assert.assertNotNull((Object)queryStats.getElapsedTime());
        Assert.assertNotNull((Object)queryStats.getQueuedTime());
        Assert.assertNotNull((Object)queryStats.getResourceWaitingTime());
        Assert.assertNotNull((Object)queryStats.getDispatchingTime());
        Assert.assertNotNull((Object)queryStats.getExecutionTime());
        Assert.assertNotNull((Object)queryStats.getPlanningTime());
        Assert.assertNotNull((Object)queryStats.getFinishingTime());
        Assert.assertNotNull((Object)queryStats.getCreateTime());
        if (queryInfo.getState() == QueryState.QUEUED || queryInfo.getState() == QueryState.WAITING_FOR_RESOURCES || queryInfo.getState() == QueryState.DISPATCHING) {
            Assert.assertNull((Object)queryStats.getExecutionStartTime());
        } else {
            Assert.assertNotNull((Object)queryStats.getExecutionStartTime());
        }
        if (queryInfo.getState().isDone()) {
            Assert.assertNotNull((Object)queryStats.getEndTime());
        } else {
            Assert.assertNull((Object)queryStats.getEndTime());
        }
        Assert.assertEquals((Object)stateMachine.getQueryState(), (Object)expectedState);
        Assert.assertEquals((Object)queryInfo.getState(), (Object)expectedState);
        Assert.assertEquals((boolean)stateMachine.isDone(), (boolean)expectedState.isDone());
        if (expectedState == QueryState.FAILED) {
            Assert.assertNotNull((Object)queryInfo.getFailureInfo());
            FailureInfo failure = queryInfo.getFailureInfo().toFailureInfo();
            Assert.assertNotNull((Object)failure);
            Assert.assertEquals((String)failure.getType(), (String)expectedException.getClass().getName());
            if (expectedException instanceof TrinoException) {
                Assert.assertEquals((Object)queryInfo.getErrorCode(), (Object)((TrinoException)((Object)expectedException)).getErrorCode());
            } else {
                Assert.assertEquals((Object)queryInfo.getErrorCode(), (Object)StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode());
            }
        } else {
            Assert.assertNull((Object)queryInfo.getFailureInfo());
        }
    }

    private QueryStateMachine createQueryStateMachine() {
        return this.createQueryStateMachineWithTicker(Ticker.systemTicker());
    }

    private QueryStateMachine createQueryStateMachineWithTicker(Ticker ticker) {
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControl = new AccessControlManager(transactionManager, (EventListenerManager)TestingEventListenerManager.emptyEventListenerManager(), new AccessControlConfig(), "default");
        accessControl.setSystemAccessControls(List.of(AllowAllSystemAccessControl.INSTANCE));
        QueryStateMachine stateMachine = QueryStateMachine.beginWithTicker(Optional.empty(), (String)QUERY, Optional.empty(), (Session)SessionTestUtils.TEST_SESSION, (URI)LOCATION, (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)transactionManager, (AccessControl)accessControl, (Executor)this.executor, (Ticker)ticker, (Metadata)metadata, (WarningCollector)WarningCollector.NOOP, QUERY_TYPE);
        stateMachine.setInputs(INPUTS);
        stateMachine.setOutput(OUTPUT);
        stateMachine.setColumns(OUTPUT_FIELD_NAMES, OUTPUT_FIELD_TYPES);
        stateMachine.setUpdateType(UPDATE_TYPE);
        for (Map.Entry<String, String> entry : SET_SESSION_PROPERTIES.entrySet()) {
            stateMachine.addSetSessionProperties(entry.getKey(), entry.getValue());
        }
        RESET_SESSION_PROPERTIES.forEach(arg_0 -> ((QueryStateMachine)stateMachine).addResetSessionProperties(arg_0));
        return stateMachine;
    }

    private static void assertEqualSessionsWithoutTransactionId(Session actual, Session expected) {
        Assert.assertEquals((Object)actual.getQueryId(), (Object)expected.getQueryId());
        Assert.assertEquals((Object)actual.getIdentity(), (Object)expected.getIdentity());
        Assert.assertEquals((Object)actual.getSource(), (Object)expected.getSource());
        Assert.assertEquals((Object)actual.getCatalog(), (Object)expected.getCatalog());
        Assert.assertEquals((Object)actual.getSchema(), (Object)expected.getSchema());
        Assert.assertEquals((Object)actual.getTimeZoneKey(), (Object)expected.getTimeZoneKey());
        Assert.assertEquals((Object)actual.getLocale(), (Object)expected.getLocale());
        Assert.assertEquals((Object)actual.getRemoteUserAddress(), (Object)expected.getRemoteUserAddress());
        Assert.assertEquals((Object)actual.getUserAgent(), (Object)expected.getUserAgent());
        Assert.assertEquals((Object)actual.getStart(), (Object)expected.getStart());
        Assert.assertEquals((Map)actual.getSystemProperties(), (Map)expected.getSystemProperties());
        Assert.assertEquals((Map)actual.getCatalogProperties(), (Map)expected.getCatalogProperties());
    }
}

