/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.SetPathTask;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.TrinoException;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.PathElement;
import io.trino.sql.tree.PathSpecification;
import io.trino.sql.tree.SetPath;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionManager;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestSetPathTask {
    private final TransactionManager transactionManager;
    private final AccessControl accessControl;
    private final Metadata metadata;
    private ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));

    public TestSetPathTask() {
        this.transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        this.accessControl = new AllowAllAccessControl();
        this.metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager(this.transactionManager).build();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.executor = null;
    }

    @Test
    public void testSetPath() {
        PathSpecification pathSpecification = new PathSpecification(Optional.empty(), (List)ImmutableList.of((Object)new PathElement(Optional.empty(), new Identifier("foo"))));
        QueryStateMachine stateMachine = this.createQueryStateMachine("SET PATH foo");
        this.executeSetPathTask(pathSpecification, stateMachine);
        Assert.assertEquals((String)stateMachine.getSetPath(), (String)"foo");
    }

    @Test
    public void testSetPathInvalidCatalog() {
        PathSpecification invalidPathSpecification = new PathSpecification(Optional.empty(), (List)ImmutableList.of((Object)new PathElement(Optional.of(new Identifier("invalidCatalog")), new Identifier("thisDoesNotMatter"))));
        QueryStateMachine stateMachine = this.createQueryStateMachine("SET PATH invalidCatalog.thisDoesNotMatter");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.executeSetPathTask(invalidPathSpecification, stateMachine)).isInstanceOf(TrinoException.class)).hasMessageMatching("Catalog '.*' does not exist");
    }

    private QueryStateMachine createQueryStateMachine(String query) {
        return QueryStateMachine.begin(Optional.empty(), (String)query, Optional.empty(), (Session)SessionTestUtils.TEST_SESSION, (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)this.transactionManager, (AccessControl)this.accessControl, (Executor)this.executor, (Metadata)this.metadata, (WarningCollector)WarningCollector.NOOP, Optional.empty());
    }

    private void executeSetPathTask(PathSpecification pathSpecification, QueryStateMachine stateMachine) {
        MoreFutures.getFutureValue((Future)new SetPathTask(this.metadata).execute(new SetPath(pathSpecification), stateMachine, Collections.emptyList(), WarningCollector.NOOP));
    }
}

