/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.base.MoreObjects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Streams;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.slice.SizeOf;
import io.airlift.units.DataSize;
import io.trino.client.NodeVersion;
import io.trino.execution.TableExecuteContextManager;
import io.trino.execution.scheduler.BucketNodeMap;
import io.trino.execution.scheduler.NodeRequirements;
import io.trino.execution.scheduler.StageTaskSourceFactory;
import io.trino.execution.scheduler.TaskDescriptor;
import io.trino.execution.scheduler.TaskSource;
import io.trino.execution.scheduler.TestingExchange;
import io.trino.execution.scheduler.TestingExchangeManager;
import io.trino.execution.scheduler.TestingSplitSource;
import io.trino.metadata.InternalNode;
import io.trino.metadata.Split;
import io.trino.spi.HostAddress;
import io.trino.spi.QueryId;
import io.trino.spi.SplitWeight;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.exchange.Exchange;
import io.trino.spi.exchange.ExchangeContext;
import io.trino.spi.exchange.ExchangeId;
import io.trino.spi.exchange.ExchangeSourceHandle;
import io.trino.split.SplitSource;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.TestingHandles;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.openjdk.jol.info.ClassLayout;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestStageTaskSourceFactory {
    private static final HostAddress NODE_ADDRESS = HostAddress.fromString((String)"testaddress");
    private static final PlanNodeId PLAN_NODE_1 = new PlanNodeId("planNode1");
    private static final PlanNodeId PLAN_NODE_2 = new PlanNodeId("planNode2");
    private static final PlanNodeId PLAN_NODE_3 = new PlanNodeId("planNode3");
    private static final PlanNodeId PLAN_NODE_4 = new PlanNodeId("planNode4");
    private static final PlanNodeId PLAN_NODE_5 = new PlanNodeId("planNode5");
    public static final long STANDARD_WEIGHT = SplitWeight.standard().getRawValue();

    @Test
    public void testSingleDistributionTaskSource() {
        ImmutableListMultimap sources = ImmutableListMultimap.builder().put((Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 123L)).put((Object)PLAN_NODE_2, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 321L)).put((Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 222L)).build();
        StageTaskSourceFactory.SingleDistributionTaskSource taskSource = new StageTaskSourceFactory.SingleDistributionTaskSource((ListMultimap)sources, DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        Assert.assertFalse((boolean)taskSource.isFinished());
        List tasks = (List)MoreFutures.getFutureValue((Future)taskSource.getMoreTasks());
        Assertions.assertThat((List)tasks).hasSize(1);
        Assert.assertTrue((boolean)taskSource.isFinished());
        TaskDescriptor task = (TaskDescriptor)tasks.get(0);
        Assertions.assertThat((Optional)task.getNodeRequirements().getCatalogHandle()).isEmpty();
        Assertions.assertThat((Iterable)task.getNodeRequirements().getAddresses()).isEmpty();
        Assert.assertEquals((int)task.getPartitionId(), (int)0);
        Assert.assertEquals((Object)task.getExchangeSourceHandles(), (Object)sources);
        Assert.assertEquals((Object)task.getSplits(), (Object)ImmutableListMultimap.of());
    }

    @Test
    public void testArbitraryDistributionTaskSource() {
        TestingExchangeManager splittingExchangeManager = new TestingExchangeManager(true);
        TestingExchangeManager nonSplittingExchangeManager = new TestingExchangeManager(false);
        StageTaskSourceFactory.ArbitraryDistributionTaskSource taskSource = new StageTaskSourceFactory.ArbitraryDistributionTaskSource(new IdentityHashMap(), (Multimap)ImmutableListMultimap.of(), (Multimap)ImmutableListMultimap.of(), DataSize.of((long)3L, (DataSize.Unit)DataSize.Unit.BYTE), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        Assert.assertFalse((boolean)taskSource.isFinished());
        List tasks = (List)MoreFutures.getFutureValue((Future)taskSource.getMoreTasks());
        Assertions.assertThat((List)tasks).isEmpty();
        Assert.assertTrue((boolean)taskSource.isFinished());
        TestingExchange.TestingExchangeSourceHandle sourceHandle1 = new TestingExchange.TestingExchangeSourceHandle(0, 1L);
        TestingExchange.TestingExchangeSourceHandle sourceHandle2 = new TestingExchange.TestingExchangeSourceHandle(0, 2L);
        TestingExchange.TestingExchangeSourceHandle sourceHandle3 = new TestingExchange.TestingExchangeSourceHandle(0, 3L);
        TestingExchange.TestingExchangeSourceHandle sourceHandle4 = new TestingExchange.TestingExchangeSourceHandle(0, 4L);
        TestingExchange.TestingExchangeSourceHandle sourceHandle123 = new TestingExchange.TestingExchangeSourceHandle(0, 123L);
        TestingExchange.TestingExchangeSourceHandle sourceHandle321 = new TestingExchange.TestingExchangeSourceHandle(0, 321L);
        ImmutableListMultimap nonReplicatedSources = ImmutableListMultimap.of((Object)PLAN_NODE_1, (Object)sourceHandle3);
        Exchange exchange = splittingExchangeManager.createExchange(new ExchangeContext(new QueryId("query"), ExchangeId.createRandomExchangeId()), 3);
        taskSource = new StageTaskSourceFactory.ArbitraryDistributionTaskSource(new IdentityHashMap(ImmutableMap.of((Object)sourceHandle3, (Object)exchange)), (Multimap)nonReplicatedSources, (Multimap)ImmutableListMultimap.of(), DataSize.of((long)3L, (DataSize.Unit)DataSize.Unit.BYTE), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        tasks = (List)MoreFutures.getFutureValue((Future)taskSource.getMoreTasks());
        Assert.assertTrue((boolean)taskSource.isFinished());
        Assertions.assertThat((List)tasks).hasSize(1);
        Assert.assertEquals((Collection)tasks, (Collection)ImmutableList.of((Object)new TaskDescriptor(0, (ListMultimap)ImmutableListMultimap.of(), (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 3L)), new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE)))));
        nonReplicatedSources = ImmutableListMultimap.of((Object)PLAN_NODE_1, (Object)sourceHandle123);
        exchange = nonSplittingExchangeManager.createExchange(new ExchangeContext(new QueryId("query"), ExchangeId.createRandomExchangeId()), 3);
        taskSource = new StageTaskSourceFactory.ArbitraryDistributionTaskSource(new IdentityHashMap(ImmutableMap.of((Object)sourceHandle123, (Object)exchange)), (Multimap)nonReplicatedSources, (Multimap)ImmutableListMultimap.of(), DataSize.of((long)3L, (DataSize.Unit)DataSize.Unit.BYTE), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        tasks = (List)MoreFutures.getFutureValue((Future)taskSource.getMoreTasks());
        Assert.assertEquals((Collection)tasks, (Collection)ImmutableList.of((Object)new TaskDescriptor(0, (ListMultimap)ImmutableListMultimap.of(), (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 123L)), new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE)))));
        nonReplicatedSources = ImmutableListMultimap.of((Object)PLAN_NODE_1, (Object)sourceHandle123, (Object)PLAN_NODE_2, (Object)sourceHandle321);
        exchange = nonSplittingExchangeManager.createExchange(new ExchangeContext(new QueryId("query"), ExchangeId.createRandomExchangeId()), 3);
        taskSource = new StageTaskSourceFactory.ArbitraryDistributionTaskSource(new IdentityHashMap(ImmutableMap.of((Object)sourceHandle123, (Object)exchange, (Object)sourceHandle321, (Object)exchange)), (Multimap)nonReplicatedSources, (Multimap)ImmutableListMultimap.of(), DataSize.of((long)3L, (DataSize.Unit)DataSize.Unit.BYTE), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        tasks = (List)MoreFutures.getFutureValue((Future)taskSource.getMoreTasks());
        Assert.assertEquals((Collection)tasks, (Collection)ImmutableList.of((Object)new TaskDescriptor(0, (ListMultimap)ImmutableListMultimap.of(), (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 123L)), new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE))), (Object)new TaskDescriptor(1, (ListMultimap)ImmutableListMultimap.of(), (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_2, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 321L)), new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE)))));
        nonReplicatedSources = ImmutableListMultimap.of((Object)PLAN_NODE_1, (Object)sourceHandle1, (Object)PLAN_NODE_1, (Object)sourceHandle2, (Object)PLAN_NODE_2, (Object)sourceHandle4);
        exchange = splittingExchangeManager.createExchange(new ExchangeContext(new QueryId("query"), ExchangeId.createRandomExchangeId()), 3);
        taskSource = new StageTaskSourceFactory.ArbitraryDistributionTaskSource(new IdentityHashMap(ImmutableMap.of((Object)sourceHandle1, (Object)exchange, (Object)sourceHandle2, (Object)exchange, (Object)sourceHandle4, (Object)exchange)), (Multimap)nonReplicatedSources, (Multimap)ImmutableListMultimap.of(), DataSize.of((long)3L, (DataSize.Unit)DataSize.Unit.BYTE), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        tasks = (List)MoreFutures.getFutureValue((Future)taskSource.getMoreTasks());
        Assert.assertEquals((Collection)tasks, (Collection)ImmutableList.of((Object)new TaskDescriptor(0, (ListMultimap)ImmutableListMultimap.of(), (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L), (Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 2L)), new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE))), (Object)new TaskDescriptor(1, (ListMultimap)ImmutableListMultimap.of(), (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_2, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 3L)), new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE))), (Object)new TaskDescriptor(2, (ListMultimap)ImmutableListMultimap.of(), (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_2, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L)), new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE)))));
        nonReplicatedSources = ImmutableListMultimap.of((Object)PLAN_NODE_1, (Object)sourceHandle1, (Object)PLAN_NODE_1, (Object)sourceHandle3, (Object)PLAN_NODE_2, (Object)sourceHandle4);
        exchange = splittingExchangeManager.createExchange(new ExchangeContext(new QueryId("query"), ExchangeId.createRandomExchangeId()), 3);
        taskSource = new StageTaskSourceFactory.ArbitraryDistributionTaskSource(new IdentityHashMap(ImmutableMap.of((Object)sourceHandle1, (Object)exchange, (Object)sourceHandle3, (Object)exchange, (Object)sourceHandle4, (Object)exchange)), (Multimap)nonReplicatedSources, (Multimap)ImmutableListMultimap.of(), DataSize.of((long)3L, (DataSize.Unit)DataSize.Unit.BYTE), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        tasks = (List)MoreFutures.getFutureValue((Future)taskSource.getMoreTasks());
        Assert.assertEquals((Collection)tasks, (Collection)ImmutableList.of((Object)new TaskDescriptor(0, (ListMultimap)ImmutableListMultimap.of(), (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L)), new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE))), (Object)new TaskDescriptor(1, (ListMultimap)ImmutableListMultimap.of(), (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 3L)), new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE))), (Object)new TaskDescriptor(2, (ListMultimap)ImmutableListMultimap.of(), (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_2, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 3L)), new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE))), (Object)new TaskDescriptor(3, (ListMultimap)ImmutableListMultimap.of(), (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_2, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L)), new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE)))));
        nonReplicatedSources = ImmutableListMultimap.of((Object)PLAN_NODE_1, (Object)sourceHandle1, (Object)PLAN_NODE_1, (Object)sourceHandle2, (Object)PLAN_NODE_1, (Object)sourceHandle4);
        ImmutableListMultimap replicatedSources = ImmutableListMultimap.of((Object)PLAN_NODE_2, (Object)sourceHandle321);
        exchange = splittingExchangeManager.createExchange(new ExchangeContext(new QueryId("query"), ExchangeId.createRandomExchangeId()), 3);
        taskSource = new StageTaskSourceFactory.ArbitraryDistributionTaskSource(new IdentityHashMap(ImmutableMap.of((Object)sourceHandle1, (Object)exchange, (Object)sourceHandle2, (Object)exchange, (Object)sourceHandle4, (Object)exchange, (Object)sourceHandle321, (Object)exchange)), (Multimap)nonReplicatedSources, (Multimap)replicatedSources, DataSize.of((long)3L, (DataSize.Unit)DataSize.Unit.BYTE), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        tasks = (List)MoreFutures.getFutureValue((Future)taskSource.getMoreTasks());
        Assert.assertEquals((Collection)tasks, (Collection)ImmutableList.of((Object)new TaskDescriptor(0, (ListMultimap)ImmutableListMultimap.of(), (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L), (Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 2L), (Object)PLAN_NODE_2, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 321L)), new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE))), (Object)new TaskDescriptor(1, (ListMultimap)ImmutableListMultimap.of(), (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 3L), (Object)PLAN_NODE_2, (Object)sourceHandle321), new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE))), (Object)new TaskDescriptor(2, (ListMultimap)ImmutableListMultimap.of(), (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L), (Object)PLAN_NODE_2, (Object)sourceHandle321), new NodeRequirements(Optional.empty(), (Set)ImmutableSet.of(), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE)))));
    }

    @Test
    public void testHashDistributionTaskSource() {
        StageTaskSourceFactory.HashDistributionTaskSource taskSource = TestStageTaskSourceFactory.createHashDistributionTaskSource((Map<PlanNodeId, SplitSource>)ImmutableMap.of(), (Multimap<PlanNodeId, ExchangeSourceHandle>)ImmutableListMultimap.of(), (Multimap<PlanNodeId, ExchangeSourceHandle>)ImmutableListMultimap.of(), 1, new int[]{0, 1, 2, 3}, Optional.empty(), 0L, DataSize.of((long)3L, (DataSize.Unit)DataSize.Unit.BYTE));
        Assert.assertFalse((boolean)taskSource.isFinished());
        Assert.assertEquals((Collection)((Collection)MoreFutures.getFutureValue((Future)taskSource.getMoreTasks())), (Collection)ImmutableList.of());
        Assert.assertTrue((boolean)taskSource.isFinished());
        taskSource = TestStageTaskSourceFactory.createHashDistributionTaskSource((Map<PlanNodeId, SplitSource>)ImmutableMap.of(), (Multimap<PlanNodeId, ExchangeSourceHandle>)ImmutableListMultimap.of((Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L), (Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(1, 1L), (Object)PLAN_NODE_2, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L), (Object)PLAN_NODE_2, (Object)new TestingExchange.TestingExchangeSourceHandle(3, 1L)), (Multimap<PlanNodeId, ExchangeSourceHandle>)ImmutableListMultimap.of((Object)PLAN_NODE_3, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L)), 1, new int[]{0, 1, 2, 3}, Optional.empty(), 0L, DataSize.of((long)0L, (DataSize.Unit)DataSize.Unit.BYTE));
        Assert.assertFalse((boolean)taskSource.isFinished());
        Assert.assertEquals((Collection)((Collection)MoreFutures.getFutureValue((Future)taskSource.getMoreTasks())), (Collection)ImmutableList.of((Object)new TaskDescriptor(0, (ListMultimap)ImmutableListMultimap.of(), (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L), (Object)PLAN_NODE_2, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L), (Object)PLAN_NODE_3, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L)), new NodeRequirements(Optional.of(TestingHandles.TEST_CATALOG_HANDLE), (Set)ImmutableSet.of(), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE))), (Object)new TaskDescriptor(1, (ListMultimap)ImmutableListMultimap.of(), (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(1, 1L), (Object)PLAN_NODE_3, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L)), new NodeRequirements(Optional.of(TestingHandles.TEST_CATALOG_HANDLE), (Set)ImmutableSet.of(), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE))), (Object)new TaskDescriptor(2, (ListMultimap)ImmutableListMultimap.of(), (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_2, (Object)new TestingExchange.TestingExchangeSourceHandle(3, 1L), (Object)PLAN_NODE_3, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L)), new NodeRequirements(Optional.of(TestingHandles.TEST_CATALOG_HANDLE), (Set)ImmutableSet.of(), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE)))));
        Assert.assertTrue((boolean)taskSource.isFinished());
        Split bucketedSplit1 = TestStageTaskSourceFactory.createBucketedSplit(0, 0);
        Split bucketedSplit2 = TestStageTaskSourceFactory.createBucketedSplit(0, 2);
        Split bucketedSplit3 = TestStageTaskSourceFactory.createBucketedSplit(0, 3);
        Split bucketedSplit4 = TestStageTaskSourceFactory.createBucketedSplit(0, 1);
        taskSource = TestStageTaskSourceFactory.createHashDistributionTaskSource((Map<PlanNodeId, SplitSource>)ImmutableMap.of((Object)PLAN_NODE_4, (Object)new TestingSplitSource(TestingHandles.TEST_CATALOG_HANDLE, (List<Split>)ImmutableList.of((Object)bucketedSplit1, (Object)bucketedSplit2, (Object)bucketedSplit3)), (Object)PLAN_NODE_5, (Object)new TestingSplitSource(TestingHandles.TEST_CATALOG_HANDLE, (List<Split>)ImmutableList.of((Object)bucketedSplit4))), (Multimap<PlanNodeId, ExchangeSourceHandle>)ImmutableListMultimap.of(), (Multimap<PlanNodeId, ExchangeSourceHandle>)ImmutableListMultimap.of((Object)PLAN_NODE_3, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L)), 1, new int[]{0, 1, 2, 3}, Optional.of(TestStageTaskSourceFactory.getTestingBucketNodeMap(4)), 0L, DataSize.of((long)0L, (DataSize.Unit)DataSize.Unit.BYTE));
        Assert.assertFalse((boolean)taskSource.isFinished());
        Assert.assertEquals((Collection)((Collection)MoreFutures.getFutureValue((Future)taskSource.getMoreTasks())), (Collection)ImmutableList.of((Object)new TaskDescriptor(0, (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_4, (Object)bucketedSplit1), (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_3, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L)), new NodeRequirements(Optional.of(TestingHandles.TEST_CATALOG_HANDLE), (Set)ImmutableSet.of((Object)NODE_ADDRESS), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE))), (Object)new TaskDescriptor(1, (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_5, (Object)bucketedSplit4), (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_3, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L)), new NodeRequirements(Optional.of(TestingHandles.TEST_CATALOG_HANDLE), (Set)ImmutableSet.of((Object)NODE_ADDRESS), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE))), (Object)new TaskDescriptor(2, (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_4, (Object)bucketedSplit2), (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_3, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L)), new NodeRequirements(Optional.of(TestingHandles.TEST_CATALOG_HANDLE), (Set)ImmutableSet.of((Object)NODE_ADDRESS), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE))), (Object)new TaskDescriptor(3, (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_4, (Object)bucketedSplit3), (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_3, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L)), new NodeRequirements(Optional.of(TestingHandles.TEST_CATALOG_HANDLE), (Set)ImmutableSet.of((Object)NODE_ADDRESS), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE)))));
        Assert.assertTrue((boolean)taskSource.isFinished());
        taskSource = TestStageTaskSourceFactory.createHashDistributionTaskSource((Map<PlanNodeId, SplitSource>)ImmutableMap.of((Object)PLAN_NODE_4, (Object)new TestingSplitSource(TestingHandles.TEST_CATALOG_HANDLE, (List<Split>)ImmutableList.of((Object)bucketedSplit1, (Object)bucketedSplit2, (Object)bucketedSplit3)), (Object)PLAN_NODE_5, (Object)new TestingSplitSource(TestingHandles.TEST_CATALOG_HANDLE, (List<Split>)ImmutableList.of((Object)bucketedSplit4))), (Multimap<PlanNodeId, ExchangeSourceHandle>)ImmutableListMultimap.of((Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L), (Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(1, 1L), (Object)PLAN_NODE_2, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L), (Object)PLAN_NODE_2, (Object)new TestingExchange.TestingExchangeSourceHandle(3, 1L)), (Multimap<PlanNodeId, ExchangeSourceHandle>)ImmutableListMultimap.of((Object)PLAN_NODE_3, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L)), 1, new int[]{0, 1, 2, 3}, Optional.of(TestStageTaskSourceFactory.getTestingBucketNodeMap(4)), 0L, DataSize.of((long)0L, (DataSize.Unit)DataSize.Unit.BYTE));
        Assert.assertFalse((boolean)taskSource.isFinished());
        Assert.assertEquals((Collection)((Collection)MoreFutures.getFutureValue((Future)taskSource.getMoreTasks())), (Collection)ImmutableList.of((Object)new TaskDescriptor(0, (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_4, (Object)bucketedSplit1), (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L), (Object)PLAN_NODE_2, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L), (Object)PLAN_NODE_3, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L)), new NodeRequirements(Optional.of(TestingHandles.TEST_CATALOG_HANDLE), (Set)ImmutableSet.of((Object)NODE_ADDRESS), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE))), (Object)new TaskDescriptor(1, (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_5, (Object)bucketedSplit4), (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(1, 1L), (Object)PLAN_NODE_3, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L)), new NodeRequirements(Optional.of(TestingHandles.TEST_CATALOG_HANDLE), (Set)ImmutableSet.of((Object)NODE_ADDRESS), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE))), (Object)new TaskDescriptor(2, (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_4, (Object)bucketedSplit2), (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_3, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L)), new NodeRequirements(Optional.of(TestingHandles.TEST_CATALOG_HANDLE), (Set)ImmutableSet.of((Object)NODE_ADDRESS), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE))), (Object)new TaskDescriptor(3, (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_4, (Object)bucketedSplit3), (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_2, (Object)new TestingExchange.TestingExchangeSourceHandle(3, 1L), (Object)PLAN_NODE_3, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L)), new NodeRequirements(Optional.of(TestingHandles.TEST_CATALOG_HANDLE), (Set)ImmutableSet.of((Object)NODE_ADDRESS), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE)))));
        Assert.assertTrue((boolean)taskSource.isFinished());
        taskSource = TestStageTaskSourceFactory.createHashDistributionTaskSource((Map<PlanNodeId, SplitSource>)ImmutableMap.of((Object)PLAN_NODE_4, (Object)new TestingSplitSource(TestingHandles.TEST_CATALOG_HANDLE, (List<Split>)ImmutableList.of((Object)bucketedSplit1, (Object)bucketedSplit2, (Object)bucketedSplit3)), (Object)PLAN_NODE_5, (Object)new TestingSplitSource(TestingHandles.TEST_CATALOG_HANDLE, (List<Split>)ImmutableList.of((Object)bucketedSplit4))), (Multimap<PlanNodeId, ExchangeSourceHandle>)ImmutableListMultimap.of((Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L), (Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(1, 1L), (Object)PLAN_NODE_2, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L)), (Multimap<PlanNodeId, ExchangeSourceHandle>)ImmutableListMultimap.of((Object)PLAN_NODE_3, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L)), 2, new int[]{0, 1, 0, 1}, Optional.of(TestStageTaskSourceFactory.getTestingBucketNodeMap(4)), 0L, DataSize.of((long)0L, (DataSize.Unit)DataSize.Unit.BYTE));
        Assert.assertFalse((boolean)taskSource.isFinished());
        Assert.assertEquals((Collection)((Collection)MoreFutures.getFutureValue((Future)taskSource.getMoreTasks())), (Collection)ImmutableList.of((Object)new TaskDescriptor(0, (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_4, (Object)bucketedSplit1, (Object)PLAN_NODE_4, (Object)bucketedSplit2), (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L), (Object)PLAN_NODE_2, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L), (Object)PLAN_NODE_3, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L)), new NodeRequirements(Optional.of(TestingHandles.TEST_CATALOG_HANDLE), (Set)ImmutableSet.of((Object)NODE_ADDRESS), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE))), (Object)new TaskDescriptor(1, (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_4, (Object)bucketedSplit3, (Object)PLAN_NODE_5, (Object)bucketedSplit4), (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(1, 1L), (Object)PLAN_NODE_3, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L)), new NodeRequirements(Optional.of(TestingHandles.TEST_CATALOG_HANDLE), (Set)ImmutableSet.of((Object)NODE_ADDRESS), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE)))));
        Assert.assertTrue((boolean)taskSource.isFinished());
        taskSource = TestStageTaskSourceFactory.createHashDistributionTaskSource((Map<PlanNodeId, SplitSource>)ImmutableMap.of((Object)PLAN_NODE_4, (Object)new TestingSplitSource(TestingHandles.TEST_CATALOG_HANDLE, (List<Split>)ImmutableList.of((Object)bucketedSplit1, (Object)bucketedSplit2, (Object)bucketedSplit3)), (Object)PLAN_NODE_5, (Object)new TestingSplitSource(TestingHandles.TEST_CATALOG_HANDLE, (List<Split>)ImmutableList.of((Object)bucketedSplit4))), (Multimap<PlanNodeId, ExchangeSourceHandle>)ImmutableListMultimap.of((Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L), (Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(1, 1L), (Object)PLAN_NODE_2, (Object)new TestingExchange.TestingExchangeSourceHandle(1, 1L), (Object)PLAN_NODE_2, (Object)new TestingExchange.TestingExchangeSourceHandle(2, 1L), (Object)PLAN_NODE_2, (Object)new TestingExchange.TestingExchangeSourceHandle(3, 1L)), (Multimap<PlanNodeId, ExchangeSourceHandle>)ImmutableListMultimap.of((Object)PLAN_NODE_3, (Object)new TestingExchange.TestingExchangeSourceHandle(17, 1L)), 2, new int[]{0, 1, 2, 3}, Optional.of(TestStageTaskSourceFactory.getTestingBucketNodeMap(4)), 2L * STANDARD_WEIGHT, DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        Assert.assertFalse((boolean)taskSource.isFinished());
        Assert.assertEquals((Collection)((Collection)MoreFutures.getFutureValue((Future)taskSource.getMoreTasks())), (Collection)ImmutableList.of((Object)new TaskDescriptor(0, (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_4, (Object)bucketedSplit1, (Object)PLAN_NODE_5, (Object)bucketedSplit4), (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L), (Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(1, 1L), (Object)PLAN_NODE_2, (Object)new TestingExchange.TestingExchangeSourceHandle(1, 1L), (Object)PLAN_NODE_3, (Object)new TestingExchange.TestingExchangeSourceHandle(17, 1L)), new NodeRequirements(Optional.of(TestingHandles.TEST_CATALOG_HANDLE), (Set)ImmutableSet.of((Object)NODE_ADDRESS), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE))), (Object)new TaskDescriptor(1, (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_4, (Object)bucketedSplit2, (Object)PLAN_NODE_4, (Object)bucketedSplit3), (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_2, (Object)new TestingExchange.TestingExchangeSourceHandle(2, 1L), (Object)PLAN_NODE_2, (Object)new TestingExchange.TestingExchangeSourceHandle(3, 1L), (Object)PLAN_NODE_3, (Object)new TestingExchange.TestingExchangeSourceHandle(17, 1L)), new NodeRequirements(Optional.of(TestingHandles.TEST_CATALOG_HANDLE), (Set)ImmutableSet.of((Object)NODE_ADDRESS), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE)))));
        Assert.assertTrue((boolean)taskSource.isFinished());
        taskSource = TestStageTaskSourceFactory.createHashDistributionTaskSource((Map<PlanNodeId, SplitSource>)ImmutableMap.of((Object)PLAN_NODE_4, (Object)new TestingSplitSource(TestingHandles.TEST_CATALOG_HANDLE, (List<Split>)ImmutableList.of((Object)bucketedSplit1, (Object)bucketedSplit2, (Object)bucketedSplit3)), (Object)PLAN_NODE_5, (Object)new TestingSplitSource(TestingHandles.TEST_CATALOG_HANDLE, (List<Split>)ImmutableList.of((Object)bucketedSplit4))), (Multimap<PlanNodeId, ExchangeSourceHandle>)ImmutableListMultimap.of((Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 20L), (Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(1, 30L), (Object)PLAN_NODE_2, (Object)new TestingExchange.TestingExchangeSourceHandle(1, 20L), (Object)PLAN_NODE_2, (Object)new TestingExchange.TestingExchangeSourceHandle(2, 99L), (Object)PLAN_NODE_2, (Object)new TestingExchange.TestingExchangeSourceHandle(3, 30L)), (Multimap<PlanNodeId, ExchangeSourceHandle>)ImmutableListMultimap.of((Object)PLAN_NODE_3, (Object)new TestingExchange.TestingExchangeSourceHandle(17, 1L)), 2, new int[]{0, 1, 2, 3}, Optional.of(TestStageTaskSourceFactory.getTestingBucketNodeMap(4)), 100L * STANDARD_WEIGHT, DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.BYTE));
        Assert.assertFalse((boolean)taskSource.isFinished());
        Assert.assertEquals((Collection)((Collection)MoreFutures.getFutureValue((Future)taskSource.getMoreTasks())), (Collection)ImmutableList.of((Object)new TaskDescriptor(0, (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_4, (Object)bucketedSplit1, (Object)PLAN_NODE_5, (Object)bucketedSplit4), (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 20L), (Object)PLAN_NODE_1, (Object)new TestingExchange.TestingExchangeSourceHandle(1, 30L), (Object)PLAN_NODE_2, (Object)new TestingExchange.TestingExchangeSourceHandle(1, 20L), (Object)PLAN_NODE_3, (Object)new TestingExchange.TestingExchangeSourceHandle(17, 1L)), new NodeRequirements(Optional.of(TestingHandles.TEST_CATALOG_HANDLE), (Set)ImmutableSet.of((Object)NODE_ADDRESS), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE))), (Object)new TaskDescriptor(1, (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_4, (Object)bucketedSplit2), (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_2, (Object)new TestingExchange.TestingExchangeSourceHandle(2, 99L), (Object)PLAN_NODE_3, (Object)new TestingExchange.TestingExchangeSourceHandle(17, 1L)), new NodeRequirements(Optional.of(TestingHandles.TEST_CATALOG_HANDLE), (Set)ImmutableSet.of((Object)NODE_ADDRESS), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE))), (Object)new TaskDescriptor(2, (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_4, (Object)bucketedSplit3), (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_2, (Object)new TestingExchange.TestingExchangeSourceHandle(3, 30L), (Object)PLAN_NODE_3, (Object)new TestingExchange.TestingExchangeSourceHandle(17, 1L)), new NodeRequirements(Optional.of(TestingHandles.TEST_CATALOG_HANDLE), (Set)ImmutableSet.of((Object)NODE_ADDRESS), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE)))));
        Assert.assertTrue((boolean)taskSource.isFinished());
    }

    private static StageTaskSourceFactory.HashDistributionTaskSource createHashDistributionTaskSource(Map<PlanNodeId, SplitSource> splitSources, Multimap<PlanNodeId, ExchangeSourceHandle> partitionedExchangeSources, Multimap<PlanNodeId, ExchangeSourceHandle> replicatedExchangeSources, int splitBatchSize, int[] bucketToPartitionMap, Optional<BucketNodeMap> bucketNodeMap, long targetPartitionSplitWeight, DataSize targetPartitionSourceSize) {
        TestingExchange exchage = new TestingExchange(false);
        IdentityHashMap exchangeForHandleMap = new IdentityHashMap();
        partitionedExchangeSources.values().forEach(handle -> exchangeForHandleMap.put(handle, exchage));
        replicatedExchangeSources.values().forEach(handle -> exchangeForHandleMap.put(handle, exchage));
        return new StageTaskSourceFactory.HashDistributionTaskSource(splitSources, exchangeForHandleMap, partitionedExchangeSources, replicatedExchangeSources, splitBatchSize, getSplitsTime -> {}, bucketToPartitionMap, bucketNodeMap, Optional.of(TestingHandles.TEST_CATALOG_HANDLE), targetPartitionSplitWeight, targetPartitionSourceSize, DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE), MoreExecutors.directExecutor());
    }

    @Test
    public void testSourceDistributionTaskSource() {
        StageTaskSourceFactory.SourceDistributionTaskSource taskSource = TestStageTaskSourceFactory.createSourceDistributionTaskSource((List<Split>)ImmutableList.of(), (ListMultimap<PlanNodeId, ExchangeSourceHandle>)ImmutableListMultimap.of(), 2, 0, 3L * STANDARD_WEIGHT, 1000);
        Assert.assertFalse((boolean)taskSource.isFinished());
        Assert.assertEquals((Collection)((Collection)MoreFutures.getFutureValue((Future)taskSource.getMoreTasks())), (Collection)ImmutableList.of());
        Assert.assertTrue((boolean)taskSource.isFinished());
        Split split1 = TestStageTaskSourceFactory.createSplit(1, new String[0]);
        Split split2 = TestStageTaskSourceFactory.createSplit(2, new String[0]);
        Split split3 = TestStageTaskSourceFactory.createSplit(3, new String[0]);
        taskSource = TestStageTaskSourceFactory.createSourceDistributionTaskSource((List<Split>)ImmutableList.of((Object)split1), (ListMultimap<PlanNodeId, ExchangeSourceHandle>)ImmutableListMultimap.of(), 2, 0, 2L * STANDARD_WEIGHT, 1000);
        Assert.assertEquals((Collection)((Collection)MoreFutures.getFutureValue((Future)taskSource.getMoreTasks())), (Collection)ImmutableList.of((Object)new TaskDescriptor(0, (ListMultimap)ImmutableListMultimap.of((Object)PLAN_NODE_1, (Object)split1), (ListMultimap)ImmutableListMultimap.of(), new NodeRequirements(Optional.of(TestingHandles.TEST_CATALOG_HANDLE), (Set)ImmutableSet.of(), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE)))));
        Assert.assertTrue((boolean)taskSource.isFinished());
        taskSource = TestStageTaskSourceFactory.createSourceDistributionTaskSource((List<Split>)ImmutableList.of((Object)split1, (Object)split2, (Object)split3), (ListMultimap<PlanNodeId, ExchangeSourceHandle>)ImmutableListMultimap.of(), 3, 0, 2L * STANDARD_WEIGHT, 1000);
        List<TaskDescriptor> tasks = this.readAllTasks((TaskSource)taskSource);
        Assertions.assertThat(tasks).hasSize(2);
        Assertions.assertThat((Iterable)tasks.get(0).getSplits().values()).hasSize(2);
        Assertions.assertThat((Iterable)tasks.get(1).getSplits().values()).hasSize(1);
        Assertions.assertThat(tasks).allMatch(taskDescriptor -> taskDescriptor.getNodeRequirements().equals((Object)new NodeRequirements(Optional.of(TestingHandles.TEST_CATALOG_HANDLE), (Set)ImmutableSet.of(), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE))));
        Assertions.assertThat(tasks).allMatch(taskDescriptor -> taskDescriptor.getExchangeSourceHandles().isEmpty());
        org.assertj.guava.api.Assertions.assertThat(this.flattenSplits(tasks)).hasSameEntriesAs((Multimap)ImmutableMultimap.of((Object)PLAN_NODE_1, (Object)split1, (Object)PLAN_NODE_1, (Object)split2, (Object)PLAN_NODE_1, (Object)split3));
        Assert.assertTrue((boolean)taskSource.isFinished());
        ImmutableListMultimap replicatedSources = ImmutableListMultimap.of((Object)PLAN_NODE_2, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L));
        taskSource = TestStageTaskSourceFactory.createSourceDistributionTaskSource((List<Split>)ImmutableList.of((Object)split1, (Object)split2, (Object)split3), (ListMultimap<PlanNodeId, ExchangeSourceHandle>)replicatedSources, 2, 0, 2L * STANDARD_WEIGHT, 1000);
        tasks = this.readAllTasks((TaskSource)taskSource);
        Assertions.assertThat(tasks).hasSize(2);
        Assertions.assertThat((Iterable)tasks.get(0).getSplits().values()).hasSize(2);
        Assertions.assertThat((Iterable)tasks.get(1).getSplits().values()).hasSize(1);
        Assertions.assertThat(tasks).allMatch(taskDescriptor -> taskDescriptor.getNodeRequirements().equals((Object)new NodeRequirements(Optional.of(TestingHandles.TEST_CATALOG_HANDLE), (Set)ImmutableSet.of(), DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE))));
        Assertions.assertThat(tasks).allMatch(taskDescriptor -> taskDescriptor.getExchangeSourceHandles().equals((Object)replicatedSources));
        org.assertj.guava.api.Assertions.assertThat(this.flattenSplits(tasks)).hasSameEntriesAs((Multimap)ImmutableMultimap.of((Object)PLAN_NODE_1, (Object)split1, (Object)PLAN_NODE_1, (Object)split2, (Object)PLAN_NODE_1, (Object)split3));
        Assert.assertTrue((boolean)taskSource.isFinished());
        ImmutableList splits = ImmutableList.of((Object)TestStageTaskSourceFactory.createSplit(1, "host1:8080", "host2:8080"), (Object)TestStageTaskSourceFactory.createSplit(2, "host2:8080"), (Object)TestStageTaskSourceFactory.createSplit(3, "host1:8080", "host3:8080"), (Object)TestStageTaskSourceFactory.createSplit(4, "host3:8080", "host1:8080"), (Object)TestStageTaskSourceFactory.createSplit(5, "host1:8080", "host2:8080"), (Object)TestStageTaskSourceFactory.createSplit(6, "host2:8080", "host3:8080"), (Object)TestStageTaskSourceFactory.createSplit(7, "host3:8080", "host4:8080"));
        taskSource = TestStageTaskSourceFactory.createSourceDistributionTaskSource((List<Split>)splits, (ListMultimap<PlanNodeId, ExchangeSourceHandle>)ImmutableListMultimap.of(), 3, 0, 2L * STANDARD_WEIGHT, 1000);
        tasks = this.readAllTasks((TaskSource)taskSource);
        Assertions.assertThat(tasks).hasSize(4);
        Assertions.assertThat(tasks.stream()).allMatch(taskDescriptor -> taskDescriptor.getExchangeSourceHandles().isEmpty());
        org.assertj.guava.api.Assertions.assertThat(this.flattenSplits(tasks)).hasSameEntriesAs((Multimap)Multimaps.index((Iterable)splits, split -> PLAN_NODE_1));
        Assertions.assertThat(tasks).allMatch(task -> task.getSplits().values().stream().allMatch(split -> {
            HostAddress requiredAddress = (HostAddress)Iterables.getOnlyElement((Iterable)task.getNodeRequirements().getAddresses());
            return split.getAddresses().contains(requiredAddress);
        }));
        Assert.assertTrue((boolean)taskSource.isFinished());
    }

    @Test
    public void testSourceDistributionTaskSourceWithWeights() {
        Split split1 = TestStageTaskSourceFactory.createWeightedSplit(1, STANDARD_WEIGHT, new String[0]);
        long heavyWeight = 2L * STANDARD_WEIGHT;
        Split heavySplit1 = TestStageTaskSourceFactory.createWeightedSplit(11, heavyWeight, new String[0]);
        Split heavySplit2 = TestStageTaskSourceFactory.createWeightedSplit(12, heavyWeight, new String[0]);
        Split heavySplit3 = TestStageTaskSourceFactory.createWeightedSplit(13, heavyWeight, new String[0]);
        long lightWeight = (long)(0.5 * (double)STANDARD_WEIGHT);
        Split lightSplit1 = TestStageTaskSourceFactory.createWeightedSplit(21, lightWeight, new String[0]);
        Split lightSplit2 = TestStageTaskSourceFactory.createWeightedSplit(22, lightWeight, new String[0]);
        Split lightSplit3 = TestStageTaskSourceFactory.createWeightedSplit(23, lightWeight, new String[0]);
        Split lightSplit4 = TestStageTaskSourceFactory.createWeightedSplit(24, lightWeight, new String[0]);
        StageTaskSourceFactory.SourceDistributionTaskSource taskSource = TestStageTaskSourceFactory.createSourceDistributionTaskSource((List<Split>)ImmutableList.of((Object)lightSplit1, (Object)lightSplit2, (Object)split1, (Object)heavySplit1, (Object)heavySplit2, (Object)lightSplit4), (ListMultimap<PlanNodeId, ExchangeSourceHandle>)ImmutableListMultimap.of(), 1, 0, (long)(1.9 * (double)STANDARD_WEIGHT), 1000);
        List<TaskDescriptor> tasks = this.readAllTasks((TaskSource)taskSource);
        Assertions.assertThat(tasks).hasSize(4);
        Assertions.assertThat(tasks).allMatch(task -> ((PlanNodeId)Iterables.getOnlyElement((Iterable)task.getSplits().keySet())).equals((Object)PLAN_NODE_1));
        Assertions.assertThat((Iterable)tasks.get(0).getSplits().values()).containsExactlyInAnyOrder((Object[])new Split[]{lightSplit1, lightSplit2, split1});
        Assertions.assertThat((Iterable)tasks.get(1).getSplits().values()).containsExactlyInAnyOrder((Object[])new Split[]{heavySplit1});
        Assertions.assertThat((Iterable)tasks.get(2).getSplits().values()).containsExactlyInAnyOrder((Object[])new Split[]{heavySplit2});
        Assertions.assertThat((Iterable)tasks.get(3).getSplits().values()).containsExactlyInAnyOrder((Object[])new Split[]{lightSplit4});
        Assert.assertTrue((boolean)taskSource.isFinished());
        taskSource = TestStageTaskSourceFactory.createSourceDistributionTaskSource((List<Split>)ImmutableList.of((Object)heavySplit1, (Object)heavySplit2, (Object)heavySplit3, (Object)lightSplit1, (Object)lightSplit2, (Object)lightSplit3, (Object)lightSplit4), (ListMultimap<PlanNodeId, ExchangeSourceHandle>)ImmutableListMultimap.of(), 1, 2, 2L * STANDARD_WEIGHT, 1000);
        tasks = this.readAllTasks((TaskSource)taskSource);
        Assertions.assertThat(tasks).hasSize(3);
        Assertions.assertThat(tasks).allMatch(task -> ((PlanNodeId)Iterables.getOnlyElement((Iterable)task.getSplits().keySet())).equals((Object)PLAN_NODE_1));
        Assertions.assertThat((Iterable)tasks.get(0).getSplits().values()).containsExactlyInAnyOrder((Object[])new Split[]{heavySplit1, heavySplit2});
        Assertions.assertThat((Iterable)tasks.get(1).getSplits().values()).containsExactlyInAnyOrder((Object[])new Split[]{heavySplit3, lightSplit1});
        Assertions.assertThat((Iterable)tasks.get(2).getSplits().values()).containsExactlyInAnyOrder((Object[])new Split[]{lightSplit2, lightSplit3, lightSplit4});
        Assert.assertTrue((boolean)taskSource.isFinished());
        taskSource = TestStageTaskSourceFactory.createSourceDistributionTaskSource((List<Split>)ImmutableList.of((Object)lightSplit1, (Object)lightSplit2, (Object)lightSplit3, (Object)heavySplit1, (Object)lightSplit4), (ListMultimap<PlanNodeId, ExchangeSourceHandle>)ImmutableListMultimap.of(), 1, 0, 2L * STANDARD_WEIGHT, 3);
        tasks = this.readAllTasks((TaskSource)taskSource);
        Assertions.assertThat(tasks).hasSize(3);
        Assertions.assertThat(tasks).allMatch(task -> ((PlanNodeId)Iterables.getOnlyElement((Iterable)task.getSplits().keySet())).equals((Object)PLAN_NODE_1));
        Assertions.assertThat((Iterable)tasks.get(0).getSplits().values()).containsExactlyInAnyOrder((Object[])new Split[]{lightSplit1, lightSplit2, lightSplit3});
        Assertions.assertThat((Iterable)tasks.get(1).getSplits().values()).containsExactlyInAnyOrder((Object[])new Split[]{heavySplit1});
        Assertions.assertThat((Iterable)tasks.get(2).getSplits().values()).containsExactlyInAnyOrder((Object[])new Split[]{lightSplit4});
        Assert.assertTrue((boolean)taskSource.isFinished());
        Split split1a1 = TestStageTaskSourceFactory.createWeightedSplit(1, STANDARD_WEIGHT, "host1:8080");
        Split split2a2 = TestStageTaskSourceFactory.createWeightedSplit(2, STANDARD_WEIGHT, "host2:8080");
        Split split3a1 = TestStageTaskSourceFactory.createWeightedSplit(3, STANDARD_WEIGHT, "host1:8080");
        Split split3a12 = TestStageTaskSourceFactory.createWeightedSplit(3, STANDARD_WEIGHT, "host1:8080", "host2:8080");
        Split heavySplit2a2 = TestStageTaskSourceFactory.createWeightedSplit(12, heavyWeight, "host2:8080");
        Split lightSplit1a1 = TestStageTaskSourceFactory.createWeightedSplit(21, lightWeight, "host1:8080");
        taskSource = TestStageTaskSourceFactory.createSourceDistributionTaskSource((List<Split>)ImmutableList.of((Object)split1a1, (Object)heavySplit2a2, (Object)split3a1, (Object)lightSplit1a1), (ListMultimap<PlanNodeId, ExchangeSourceHandle>)ImmutableListMultimap.of(), 1, 0, 2L * STANDARD_WEIGHT, 3);
        tasks = this.readAllTasks((TaskSource)taskSource);
        Assertions.assertThat(tasks).hasSize(3);
        Assertions.assertThat(tasks).allMatch(task -> ((PlanNodeId)Iterables.getOnlyElement((Iterable)task.getSplits().keySet())).equals((Object)PLAN_NODE_1));
        Assertions.assertThat((Iterable)tasks.get(0).getSplits().values()).containsExactlyInAnyOrder((Object[])new Split[]{heavySplit2a2});
        Assertions.assertThat((Iterable)tasks.get(1).getSplits().values()).containsExactlyInAnyOrder((Object[])new Split[]{split1a1, split3a1});
        Assertions.assertThat((Iterable)tasks.get(2).getSplits().values()).containsExactlyInAnyOrder((Object[])new Split[]{lightSplit1a1});
        Assert.assertTrue((boolean)taskSource.isFinished());
        taskSource = TestStageTaskSourceFactory.createSourceDistributionTaskSource((List<Split>)ImmutableList.of((Object)split1a1, (Object)split3a12, (Object)split2a2), (ListMultimap<PlanNodeId, ExchangeSourceHandle>)ImmutableListMultimap.of(), 1, 0, 2L * STANDARD_WEIGHT, 3);
        tasks = this.readAllTasks((TaskSource)taskSource);
        Assertions.assertThat(tasks).hasSize(2);
        Assertions.assertThat(tasks).allMatch(task -> ((PlanNodeId)Iterables.getOnlyElement((Iterable)task.getSplits().keySet())).equals((Object)PLAN_NODE_1));
        Assertions.assertThat((Iterable)tasks.get(0).getSplits().values()).containsExactlyInAnyOrder((Object[])new Split[]{split1a1, split3a12});
        Assertions.assertThat((Iterable)tasks.get(1).getSplits().values()).containsExactlyInAnyOrder((Object[])new Split[]{split2a2});
        Assert.assertTrue((boolean)taskSource.isFinished());
    }

    @Test
    public void testSourceDistributionTaskSourceLastIncompleteTaskAlwaysCreated() {
        for (int targetSplitsPerTask = 1; targetSplitsPerTask <= 21; ++targetSplitsPerTask) {
            ArrayList<Split> splits = new ArrayList<Split>();
            for (int i = 0; i < targetSplitsPerTask + 1; ++i) {
                splits.add(TestStageTaskSourceFactory.createWeightedSplit(i, STANDARD_WEIGHT, new String[0]));
            }
            for (int finishDelayIterations = 1; finishDelayIterations < 20; ++finishDelayIterations) {
                for (int splitBatchSize = 1; splitBatchSize <= 5; ++splitBatchSize) {
                    StageTaskSourceFactory.SourceDistributionTaskSource taskSource = TestStageTaskSourceFactory.createSourceDistributionTaskSource(new TestingSplitSource(TestingHandles.TEST_CATALOG_HANDLE, splits, finishDelayIterations), (ListMultimap<PlanNodeId, ExchangeSourceHandle>)ImmutableListMultimap.of(), splitBatchSize, targetSplitsPerTask, STANDARD_WEIGHT * (long)targetSplitsPerTask, targetSplitsPerTask);
                    List<TaskDescriptor> tasks = this.readAllTasks((TaskSource)taskSource);
                    Assertions.assertThat(tasks).hasSize(2);
                    TaskDescriptor lastTask = (TaskDescriptor)Streams.findLast(tasks.stream()).orElseThrow();
                    org.assertj.guava.api.Assertions.assertThat((Multimap)lastTask.getSplits()).hasSize(1);
                }
            }
        }
    }

    @Test
    public void testSourceDistributionTaskSourceWithAsyncSplitSource() {
        SettableFuture splitsFuture = SettableFuture.create();
        StageTaskSourceFactory.SourceDistributionTaskSource taskSource = TestStageTaskSourceFactory.createSourceDistributionTaskSource(new TestingSplitSource(TestingHandles.TEST_CATALOG_HANDLE, (ListenableFuture<List<Split>>)splitsFuture, 0), (ListMultimap<PlanNodeId, ExchangeSourceHandle>)ImmutableListMultimap.of(), 2, 0, 2L * STANDARD_WEIGHT, 1000);
        ListenableFuture tasksFuture = taskSource.getMoreTasks();
        Assertions.assertThat((Future)tasksFuture).isNotDone();
        splitsFuture.set((Object)ImmutableList.of((Object)TestStageTaskSourceFactory.createSplit(1, new String[0]), (Object)TestStageTaskSourceFactory.createSplit(2, new String[0]), (Object)TestStageTaskSourceFactory.createSplit(3, new String[0])));
        List tasks = (List)MoreFutures.getDone((Future)tasksFuture);
        Assertions.assertThat((List)tasks).hasSize(1);
        org.assertj.guava.api.Assertions.assertThat((Multimap)((TaskDescriptor)tasks.get(0)).getSplits()).hasSize(2);
        tasksFuture = taskSource.getMoreTasks();
        Assertions.assertThat((Future)tasksFuture).isDone();
        tasks = (List)MoreFutures.getDone((Future)tasksFuture);
        Assertions.assertThat((List)tasks).hasSize(1);
        org.assertj.guava.api.Assertions.assertThat((Multimap)((TaskDescriptor)tasks.get(0)).getSplits()).hasSize(1);
        Assertions.assertThat((boolean)taskSource.isFinished()).isTrue();
    }

    @Test
    public void testHashDistributionTaskSourceWithAsyncSplitSource() {
        SettableFuture splitsFuture1 = SettableFuture.create();
        SettableFuture splitsFuture2 = SettableFuture.create();
        StageTaskSourceFactory.HashDistributionTaskSource taskSource = TestStageTaskSourceFactory.createHashDistributionTaskSource((Map<PlanNodeId, SplitSource>)ImmutableMap.of((Object)PLAN_NODE_1, (Object)new TestingSplitSource(TestingHandles.TEST_CATALOG_HANDLE, (ListenableFuture<List<Split>>)splitsFuture1, 0), (Object)PLAN_NODE_2, (Object)new TestingSplitSource(TestingHandles.TEST_CATALOG_HANDLE, (ListenableFuture<List<Split>>)splitsFuture2, 0)), (Multimap<PlanNodeId, ExchangeSourceHandle>)ImmutableListMultimap.of(), (Multimap<PlanNodeId, ExchangeSourceHandle>)ImmutableListMultimap.of((Object)PLAN_NODE_3, (Object)new TestingExchange.TestingExchangeSourceHandle(0, 1L)), 1, new int[]{0, 1, 2, 3}, Optional.of(TestStageTaskSourceFactory.getTestingBucketNodeMap(4)), 0L, DataSize.of((long)0L, (DataSize.Unit)DataSize.Unit.BYTE));
        ListenableFuture tasksFuture = taskSource.getMoreTasks();
        Assertions.assertThat((Future)tasksFuture).isNotDone();
        Split bucketedSplit1 = TestStageTaskSourceFactory.createBucketedSplit(0, 0);
        Split bucketedSplit2 = TestStageTaskSourceFactory.createBucketedSplit(0, 2);
        Split bucketedSplit3 = TestStageTaskSourceFactory.createBucketedSplit(0, 3);
        splitsFuture1.set((Object)ImmutableList.of((Object)bucketedSplit1, (Object)bucketedSplit2, (Object)bucketedSplit3));
        Assertions.assertThat((Future)tasksFuture).isNotDone();
        Split bucketedSplit4 = TestStageTaskSourceFactory.createBucketedSplit(0, 1);
        splitsFuture2.set((Object)ImmutableList.of((Object)bucketedSplit4));
        List tasks = (List)MoreFutures.getDone((Future)tasksFuture);
        Assertions.assertThat((List)tasks).hasSize(4);
        tasks.forEach(task -> org.assertj.guava.api.Assertions.assertThat((Multimap)task.getSplits()).hasSize(1));
        Assertions.assertThat((boolean)taskSource.isFinished()).isTrue();
    }

    private static StageTaskSourceFactory.SourceDistributionTaskSource createSourceDistributionTaskSource(List<Split> splits, ListMultimap<PlanNodeId, ExchangeSourceHandle> replicatedSources, int splitBatchSize, int minSplitsPerTask, long splitWeightPerTask, int maxSplitsPerTask) {
        return TestStageTaskSourceFactory.createSourceDistributionTaskSource(new TestingSplitSource(TestingHandles.TEST_CATALOG_HANDLE, splits), replicatedSources, splitBatchSize, minSplitsPerTask, splitWeightPerTask, maxSplitsPerTask);
    }

    private static StageTaskSourceFactory.SourceDistributionTaskSource createSourceDistributionTaskSource(SplitSource splitSource, ListMultimap<PlanNodeId, ExchangeSourceHandle> replicatedSources, int splitBatchSize, int minSplitsPerTask, long splitWeightPerTask, int maxSplitsPerTask) {
        return new StageTaskSourceFactory.SourceDistributionTaskSource(new QueryId("query"), PLAN_NODE_1, new TableExecuteContextManager(), splitSource, replicatedSources, splitBatchSize, getSplitsTime -> {}, Optional.of(TestingHandles.TEST_CATALOG_HANDLE), minSplitsPerTask, splitWeightPerTask, maxSplitsPerTask, DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE), MoreExecutors.directExecutor());
    }

    private static Split createSplit(int id, String ... addresses) {
        return new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestingConnectorSplit(id, OptionalInt.empty(), TestStageTaskSourceFactory.addressesList(addresses)));
    }

    private static Split createWeightedSplit(int id, long weight, String ... addresses) {
        return new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestingConnectorSplit(id, OptionalInt.empty(), TestStageTaskSourceFactory.addressesList(addresses), weight));
    }

    private static Split createBucketedSplit(int id, int bucket) {
        return new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestingConnectorSplit(id, OptionalInt.of(bucket), Optional.empty()));
    }

    private List<TaskDescriptor> readAllTasks(TaskSource taskSource) {
        ImmutableList.Builder tasks = ImmutableList.builder();
        while (!taskSource.isFinished()) {
            tasks.addAll((Iterable)MoreFutures.getFutureValue((Future)taskSource.getMoreTasks()));
        }
        return tasks.build();
    }

    private Multimap<PlanNodeId, Split> flattenSplits(List<TaskDescriptor> tasks) {
        return (Multimap)tasks.stream().flatMap(taskDescriptor -> taskDescriptor.getSplits().entries().stream()).collect(Multimaps.toMultimap(Map.Entry::getKey, Map.Entry::getValue, HashMultimap::create));
    }

    private static Optional<List<HostAddress>> addressesList(String ... addresses) {
        Objects.requireNonNull(addresses, "addresses is null");
        if (addresses.length == 0) {
            return Optional.empty();
        }
        return Optional.of((List)Arrays.stream(addresses).map(HostAddress::fromString).collect(ImmutableList.toImmutableList()));
    }

    private static BucketNodeMap getTestingBucketNodeMap(int bucketCount) {
        return new BucketNodeMap(split -> ((TestingConnectorSplit)split.getConnectorSplit()).getBucket().orElseThrow(), Collections.nCopies(bucketCount, new InternalNode("local", URI.create("local://" + NODE_ADDRESS), NodeVersion.UNKNOWN, true)));
    }

    private static class TestingConnectorSplit
    implements ConnectorSplit {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(TestingConnectorSplit.class).instanceSize();
        private final int id;
        private final OptionalInt bucket;
        private final Optional<List<HostAddress>> addresses;
        private final SplitWeight weight;

        public TestingConnectorSplit(int id, OptionalInt bucket, Optional<List<HostAddress>> addresses) {
            this(id, bucket, addresses, SplitWeight.standard().getRawValue());
        }

        public TestingConnectorSplit(int id, OptionalInt bucket, Optional<List<HostAddress>> addresses, long weight) {
            this.id = id;
            this.bucket = Objects.requireNonNull(bucket, "bucket is null");
            this.addresses = Objects.requireNonNull(addresses, "addresses is null").map(ImmutableList::copyOf);
            this.weight = SplitWeight.fromRawValue((long)weight);
        }

        public int getId() {
            return this.id;
        }

        public OptionalInt getBucket() {
            return this.bucket;
        }

        public boolean isRemotelyAccessible() {
            return this.addresses.isEmpty();
        }

        public List<HostAddress> getAddresses() {
            return this.addresses.orElse((List<HostAddress>)ImmutableList.of());
        }

        public SplitWeight getSplitWeight() {
            return this.weight;
        }

        public Object getInfo() {
            return null;
        }

        public long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + SizeOf.sizeOf((OptionalInt)this.bucket) + SizeOf.sizeOf(this.addresses, value -> SizeOf.estimatedSizeOf((List)value, HostAddress::getRetainedSizeInBytes));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestingConnectorSplit that = (TestingConnectorSplit)o;
            return this.id == that.id && this.weight == that.weight && Objects.equals(this.bucket, that.bucket) && Objects.equals(this.addresses, that.addresses);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.bucket, this.addresses, this.weight);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("bucket", (Object)this.bucket).add("addresses", this.addresses).add("weight", (Object)this.weight).toString();
        }
    }
}

